#define  GLOBALS_API_ATD
#include "../App_Headers/includes.h"


/*-------------------------------------------------------------------------
* Function Name  : ATD_INIT
* Description    : ADתʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_ATD_Init(void)
{   
    ATDCTL0 = Disable;
    ATDCTL1_ETRIGSEL = Disable;
    ATDCTL1_SRES     = True;     //10λ
    ATDCTL1_SMP_DIS  = Disable;  //
    ATDCTL1_ETRIGCH  = 0;        //תͨʼ
                                
    ATDCTL2_AFFC     = Disable;  //ֱÿһ CCFX־λд1ķʽ
    ATDCTL2_ICLKSTP  = Enable;   //ʹֹͣģʽ
    ATDCTL2_ETRIGE   = Disable;  //ⲿֹ
    ATDCTL2_ASCIE    = Disable;  //ֹתж
    ATDCTL2_ACMPIE   = Disable;  //ֹȽж
    
    ATDCTL3_DJM      = Enable;   //Ҷ
    ATDCTL3_S1C      = 1;        //ת3
    ATDCTL3_S2C      = 0;
    ATDCTL3_S4C      = 0;
    ATDCTL3_S8C      = 0;
    ATDCTL3_FIFO     = Disable;  //FIFOģʽ ҸԵĽڸԵļĴ ATDDRx
    ATDCTL3_FRZ      = Disable;  //ģʽ
    
    ATDCTL4_SMP      = SMP_TIME;  //ʱ 4 CYCLE
    ATDCTL4_PRS      = SMP_PRE;   //
    
    ATDCTL5_SC       = Disable;   //
    ATDCTL5_Cx       = CHNAL7;
    
    ATDDIEN = 0x0C;     //ƸADܽΪͨùܽ
    ATDCTL5_SCAN     = Enable;   //
    ATDCTL5_MULT     = 0;    //   


}
/*-------------------------------------------------------------------------
* Function Name  : Api_ADDelay
* Description    : 
* Input          : 
* Output         : None
* Return         : None
* onther         : Delay1ms
--------------------------------------------------------------------------*/
INT8U Api_ADDelay(INT16U time)
{
    INT16U i,b;

    b = time;
    for(i = 0;i<= b;i++)
    {
        asm(NOP;);
        _FEED_COP();
    } 
    return True;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_GetSensorAD                          glz--20170519
* Description    : ȡADֵ                                 24v
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_GetSensorAD(void)
{
    INT8U   AD_STATUS;
    
    AD_STATUS = ATDSTAT0;
    if((AD_STATUS & 0x80) == 0x80)
    {
        ATDSTAT0_SCF = ClearFlag;
        switch (ATDCTL5_Cx)
        {
          case CHNAL7:    
              if(ADEveArry.pKey > ADEveLen -1)
              {
                  ADEveArry.pKey = null;
              }  
              w = ATDDR0;
              wVcc = ATDDR0;
              ADEveArry.KeyEven[ADEveArry.pKey] = (INT16U)w;
              ADEveArry.pKey ++;
              App_SortNByte((INT16U *)ADEveArry.KeyEven,ADEveLen);
                           
              if (w > 184) //6.5V 420) //16.6v 
              {                  
                  ATDCTL5_Cx = CHNAL4;
                  ADEveArry.KeyOffCn = null;
                  
                  if (ADEveArry.KeyOnCn < 20)
                  {
                      if(Api_ADDelay(Delay1ms))
                      {                  
                          ADEveArry.KeyOnCn ++;
                      }                   
                  }
                  
                  if (ADEveArry.KeyOnCn >= 0)
                  {
                      Curkeyinput = KeyON; 
                  }                   
              }
              else
              {
                  ADEveArry.KeyOnCn = null;
                  if (ADEveArry.KeyOffCn < 100)
                  {              
                      if(Api_ADDelay(Delay1ms))
                      {                  
                          ADEveArry.KeyOffCn ++;
                      }
                  }
                  
                  if (ADEveArry.KeyOffCn >= 30)
                  {
                      Curkeyinput = KeyOFF;   
                  } 
                  
                  ATDCTL5_Cx = CHNAL7;                           
              }
              break;
          case CHNAL4:
              if (Curkeyinput == KeyON)
              {                  
                  if(ADEveArry.pFuel > ADEveLen-1)
                  {
                      ADEveArry.pFuel = null;
                  } 
                  ADEveArry.FuelEven[ADEveArry.pFuel] = ATDDR0;
                  ADEveArry.pFuel ++;
                  if(ADEveArry.pFuel % 2 == null)
                  {
                      ATDCTL5_Cx = CHNAL5;                      
                  }
                  else
                  {
                      ATDCTL5_Cx = CHNAL4;
                  } 
                  App_SortNByte((INT16U *)ADEveArry.FuelEven,ADEveLen);                                    
              }
              else
              {
                  w = ATDDR0;
                  ATDCTL5_Cx = CHNAL7;
              }                          
              break;
            case CHNAL5:
              if (Curkeyinput == KeyON)
              {                  
                  if(ADEveArry.pQY2 > ADEveLen-1)
                  {
                      ADEveArry.pQY2 = null;
                  } 
                  ADEveArry.QY2Even[ADEveArry.pQY2] = ATDDR0;
                  ADEveArry.pQY2 ++;
                  if(ADEveArry.pQY2 % 2 == null)
                  {
                      ATDCTL5_Cx = CHNAL6;                      
                  }
                  else
                  {
                      ATDCTL5_Cx = CHNAL5;
                  } 
                  App_SortNByte((INT16U *)ADEveArry.QY1Even,ADEveLen);                                    
              }
              else
              {
                  w = ATDDR0;
                  ATDCTL5_Cx = CHNAL7;
              }                          
              break;
             case CHNAL6:
              if(Curkeyinput == KeyON)
              {                  
                  if(ADEveArry.pQY1 > ADEveLen-1)
                  {
                      ADEveArry.pQY1 = null;
                  } 
                  ADEveArry.QY1Even[ADEveArry.pQY1] = ATDDR0;
                  ADEveArry.pQY1 ++;
                  if(ADEveArry.pQY1 % 2 == null)
                  {
                      ATDCTL5_Cx = CHNAL0;                      
                  }
                  else
                  {
                      ATDCTL5_Cx = CHNAL6;
                  } 
                  App_SortNByte((INT16U *)ADEveArry.QY1Even,ADEveLen);                                    
              }
              else
              {
                  w = ATDDR0;
                  ATDCTL5_Cx = CHNAL7;
              }                          
              break;
             //̤1 
             case CHNAL0:
              if(Curkeyinput == KeyON)
              {                  
                  if(ADEveArry.pClutch1 > ADEveLen-1)
                  {
                      ADEveArry.pClutch1 = null;
                  } 
                  ADEveArry.ClutchEven1[ADEveArry.pClutch1] = ATDDR0;
                  ADEveArry.pClutch1 ++;
                  if(ADEveArry.pClutch1 % 2 == null)
                  {
                      ATDCTL5_Cx = CHNAL1;                      
                  }
                  else
                  {
                      ATDCTL5_Cx = CHNAL0;
                  } 
                  App_SortNByte((INT16U *)ADEveArry.ClutchEven1,ADEveLen);                                    
              }
              else
              {
                  w = ATDDR0;
                  ATDCTL5_Cx = CHNAL7;
              }                          
              break;
             //̤2 
             case CHNAL1:
              if(Curkeyinput == KeyON)
              {                  
                  if(ADEveArry.pClutch2 > ADEveLen-1)
                  {
                      ADEveArry.pClutch2 = null;
                  } 
                  ADEveArry.ClutchEven2[ADEveArry.pClutch2] = ATDDR0;
                  ADEveArry.pClutch2 ++;
                  if(ADEveArry.pClutch2 % 2 == null)
                  {
                      ATDCTL5_Cx = CHNAL7;                      
                  }
                  else
                  {
                      ATDCTL5_Cx = CHNAL1;
                  } 
                  App_SortNByte((INT16U *)ADEveArry.ClutchEven2,ADEveLen);                                    
              }
              else
              {
                  w = ATDDR0;
                  ATDCTL5_Cx = CHNAL7;
              }                          
              break;
          default:
              ATDCTL5_Cx = CHNAL7;
                      
        }
    }       
}