#define GLOBALS_API_CAN /****  250kps  no resistor  ****/
#include "../App_Headers/includes.h"

/*-------------------------------------------------------------------------
ƣApi_CAN_Init
    ܣCANʼ
    None
ֵNone
ʹ˵
--------------------------------------------------------------------------*/
void Api_CAN_Init(void)
{
  INT16U b = null;
  CANCTL0_INITRQ = Enable; //׼ʼ

  while (!CANCTL1_INITAK)
    ; //ȴʼģʽ

  CANCTL1 = CANCTL1_CANE_MASK | CANCTL1_BORM_MASK;
  CANCTL1_WUPM = Disable; //Ի
  /*
  SYNC_SEG + (PROP_SEG + PHASE_SEG1) + (PHASE_SEG2)
  1 Tq         4--16  Tq                  2--8  Tq
  */

  // 8M
  CANBTR1_TSEG_10 = Seg1_12Tq; // 351page  75<= sp<=83
  CANBTR1_TSEG_20 = Seg2_3Tq;
  CANBTR1_SAMP = SAMP_1;
  CANBTR0_SJW = SJW_1Tq; //ͬ
  CANBTR0_BRP = 1;

  CANIDAC_IDAM = IDAM_4_16Bit;
  CANIDAC_IDHIT = IDHIT0; //˲ 0 Ч

  CANIDAR0 = null; //
  CANIDAR1 = null;
  CANIDAR2 = null;
  CANIDAR3 = null;
  CANIDAR4 = null;
  CANIDAR5 = null;
  CANIDAR6 = null;
  CANIDAR7 = null;

  CANIDMR0 = 0xFF;
  CANIDMR1 = 0xFF;
  CANIDMR2 = 0xFF;
  CANIDMR3 = 0xFF;
  CANIDMR4 = 0xFF;
  CANIDMR5 = 0xFF;
  CANIDMR6 = 0xFF;
  CANIDMR7 = 0xFF;
  //
  CANTIER = null;
  CANCTL0_INITRQ = Disable; //ɳʼ
  while (CANCTL1_INITAK)
    ; //ȴȷ
  while (!CANCTL0_SYNCH)
  {
    b++;
    if (b > WaitOverTime)
    {
      break;
    }
  }
  CANRFLG_RXF = ClearFlag;
  CANRIER_RXFIE = Enable;  //ʹܽж
  CANTIER_TXEIE = Disable; //ֹж
  CANRIER_WUPIE = Enable;

  CANCTL0_TIME = Enable;   //ʹʱ
  CANCTL0_CSWAI = WaitRun; //ȴģʽ¿
  CANCTL0_WUPE = Enable;
}
/*-------------------------------------------------------------------------
ƣApi_CAN_Wakep_isr
    ܣ
    None
ֵdwPGN
ʹ˵
--------------------------------------------------------------------------*/
interrupt void Api_CAN_Wakep_isr(void)
{
  bCanDropTimes = 30;
  TJA1040_STB = LOW;
  bsp_CAN_SleepRelease();
  CANRFLG_WUPIF = ClearFlag;
}
/*-------------------------------------------------------------------------
ƣEXT_ID_TO_PGN
    ܣչIDתΪPGN
    IDR0_Add          -> ӦIDR0ĵַ
ֵdwPGN
ʹ˵
--------------------------------------------------------------------------*/
INT32U Api_EXT_ID_TO_PGN(INT8U *IDR0_Add)
{
  INT32U dwPGN;
  INT8U *bp;

  bp = (INT8U *)&dwPGN;

  *(bp) = *(IDR0_Add);
  *(bp + 1) = *(IDR0_Add + 1);
  *(bp + 2) = *(IDR0_Add + 2);
  *(bp + 3) = *(IDR0_Add + 3);

  dwPGN = ((dwPGN & 0x7FFFF) >> 1) | ((dwPGN & 0xFFE00000) >> 3);

  return (GET_EXTPGN(dwPGN)); //PGN
}
/*-------------------------------------------------------------------------
ƣbsp_GET_EXTEND_ID
    ܣȡչID
    IDR0_Add          -> ӦIDR0ĵַ
ֵdwPGN
ʹ˵
--------------------------------------------------------------------------*/
INT32U bsp_GET_EXTEND_ID(INT8U *IDR0_Add)
{
  INT32U dwPGN = 0;
  INT8U *bp;

  bp = (INT8U *)&dwPGN;

  *(bp) = *(IDR0_Add);
  *(bp + 1) = *(IDR0_Add + 1);
  *(bp + 2) = *(IDR0_Add + 2);
  *(bp + 3) = *(IDR0_Add + 3);

  dwPGN = ((dwPGN & 0x7FFFF) >> 1) | ((dwPGN & 0xFFE00000) >> 3);

  return (dwPGN);
}
/*-------------------------------------------------------------------------
ƣGET_EXTID_SA
    ܣȡԴַ
    IDR3_Add          -> ӦIDR3ĵַ
ֵdwPGN
ʹ˵
--------------------------------------------------------------------------*/
INT8U Api_GET_EXTID_SA(INT8U *IDR3_Add)
{
  INT8U SA;

  SA = *(IDR3_Add - 1);
  SA = SA & 0x01;
  SA = SA << 7;
  SA = (*IDR3_Add >> 1) | SA;
  return (SA);
}
/*-------------------------------------------------------------------------
ƣGET_STAND_ID
    ܣȡ׼ID
    IDR0_Add          -> ӦIDR0ĵַ
ֵdwPGN
ʹ˵
--------------------------------------------------------------------------*/
INT16U Api_GET_STAND_ID(INT8U *IDR0_Add)
{
  INT16U dwPGN;
  INT8U *bp;

  bp = (INT8U *)&dwPGN;

  *(bp) = *(IDR0_Add);
  *(bp + 1) = *(IDR0_Add + 1);

  dwPGN = dwPGN >> 5;

  return (dwPGN);
}
/*-------------------------------------------------------------------------
ƣApi_CAN_Rev_isr
    ܣձġ
    None
ֵdwPGN
ʹ˵
--------------------------------------------------------------------------*/

interrupt void Api_CAN_Rev_isr(void)
{
  INT32U extend_pgn;
  INT8U m_dlc;
  INT8U check;
  INT16U MULPGN;

  INT8U SA;
  INT8U PS;
  INT8U PF;
  INT8U PRIO; //----hyq--20180317

  m_dlc = CANRXDLR_DLC;
  
  if (CANRXIDR1_IDE == 0u)
  {
    ext_id = ((INT16U)(CANRXIDR0 << 3)) | ((INT16U)(CANRXIDR1 >> 5)); 
    
    if (ext_id == 0x5F2)
    {
      if (CanMsg5F2.ProceF == empoty)
      {
        if (m_dlc == 8)
        {
          //if (CanClk.Signal.Exist5F2 == Disable)
          //{
            //CanClk.ID5F2Cn++;
          //}
          
          //if (CanClk.ID5F2Cn > 2)
          {
            CanMsg5F2.ProceF = msg_full;
            CanMsg5F2.Data[7].bbyte = CANRXDSR7;
            CanClk.Signal.Exist5F2 = Enable;
            CanClk.ID5F2Cn = 100;
          }
        }
      }
    }
  } 
  else
  {
    extend_pgn = Api_EXT_ID_TO_PGN((INT8U *)&CANRXIDR0);
    ext_id = bsp_GET_EXTEND_ID((INT8U *)&CANRXIDR0);
    SA = (INT8U)(ext_id & 0x000000ff);
    PS = (INT8U)((ext_id & 0x0000ff00) >> 8);

    PRIO = (INT8U)(ext_id >> 26);
    
    if (Curkeyinput == KeyON)
    {
      // glz--20170519  ſ
      if (ext_id == ID0CF00300)
      {
        if (CanMsg0CF00300.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.Exist0CF00300 == Disable)
            {
              CanClk.ID0CF00300Cn++;
            }
            if (CanClk.ID0CF00300Cn > 2)
            {
              CanMsg0CF00300.ProceF = msg_full;
              //   CanMsg0CF00300.Data[0].bbyte  = CANRXDSR0;
              CanMsg0CF00300.Data[1].bbyte = CANRXDSR1;
              //   CanMsg0CF00300.Data[2].bbyte  = CANRXDSR2;
              //   CanMsg0CF00300.Data[3].bbyte  = CANRXDSR3;
              //   CanMsg0CF00300.Data[4].bbyte  = CANRXDSR4;
              //   CanMsg0CF00300.Data[5].bbyte  = CANRXDSR5;
              //   CanMsg0CF00300.Data[6].bbyte  = CANRXDSR6;
              //   CanMsg0CF00300.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.Exist0CF00300 = Enable;
              CanClk.ID0CF00300Cn = 25;
              b0CF00300Flag = 1;
            }
          }
        }
      }
      //Һ00
      if (ext_id == ID18FE5600)
      {
        if (CanMsgFE5600.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFE5600 == Disable)
            {
              CanClk.IDFE5600Cn++;
            }
            if (CanClk.IDFE5600Cn > 2)
            {
              CanMsgFE5600.ProceF = msg_full;
              CanMsgFE5600.Data[0].bbyte = CANRXDSR0;
              //   CanMsgFE5600.Data[1].bbyte  = CANRXDSR1;
              //   CanMsgFE5600.Data[2].bbyte  = CANRXDSR2;
              //   CanMsgFE5600.Data[3].bbyte  = CANRXDSR3;
              //   CanMsgFE5600.Data[4].bbyte  = CANRXDSR4;
              //   CanMsgFE5600.Data[5].bbyte  = CANRXDSR5;
              //   CanMsgFE5600.Data[6].bbyte  = CANRXDSR6;
              //   CanMsgFE5600.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFE5600 = Enable;
              CanClk.IDFE5600Cn = 25;
              bFE5600Flag = 1;
            }
          }
        }
      }
      //Һ3D
      if (ext_id == ID18FE563D)
      {
        if (CanMsgFE563D.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFE563D == Disable)
            {
              CanClk.IDFE5600Cn++;
            }
            if (CanClk.IDFE5600Cn > 2)
            {
              CanMsgFE563D.ProceF = msg_full;
              CanMsgFE563D.Data[0].bbyte = CANRXDSR0;
              //   CanMsgFE563D.Data[1].bbyte  = CANRXDSR1;
              //   CanMsgFE563D.Data[2].bbyte  = CANRXDSR2;
              //   CanMsgFE563D.Data[3].bbyte  = CANRXDSR3;
              //   CanMsgFE563D.Data[4].bbyte  = CANRXDSR4;
              //   CanMsgFE563D.Data[5].bbyte  = CANRXDSR5;
              //   CanMsgFE563D.Data[6].bbyte  = CANRXDSR6;
              //   CanMsgFE563D.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFE563D = Enable;
              CanClk.IDFE563DCn = 25;
              bFE563DFlag = 1;
            }
          }
        }
      }
      //
      if (ext_id == ID18EECA00)
      {
        if (CanMsgEECA00.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFECA00 == Disable)
            {
              CanClk.IDFECA00Cn++;
            }
            if (CanClk.IDFECA00Cn > 0)
            {
              CanMsgEECA00.ProceF = msg_full;
              CanMsgEECA00.Data[0].bbyte = CANRXDSR0;
              CanMsgEECA00.Data[1].bbyte = CANRXDSR1;
              //  CanMsgEECA00.Data[2].bbyte  = CANRXDSR2;
              //  CanMsgEECA00.Data[3].bbyte  = CANRXDSR3;
              //  CanMsgEECA00.Data[4].bbyte  = CANRXDSR4;
              //  CanMsgEECA00.Data[5].bbyte  = CANRXDSR5;
              //  CanMsgEECA00.Data[6].bbyte  = CANRXDSR6;
              //  CanMsgEECA00.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFECA00 = Enable;
              CanClk.IDFECA00Cn = 20; // T,1000ms Drop,10s
              bFECA00Flag = 1;
            }
          }
        }
      }
      //
      /* if(ext_id==ID18EECA3D)
       {
         if(CanMsgEECA3D.ProceF == empoty)
         {
           if(CANRXDLR_DLC == 8)
           {
             if(CanClk.Signal.ExistFECA3D == Disable)
             {
               CanClk.IDFECA3DCn ++;
             }
             if(CanClk.IDFECA3DCn > 2)
             {
               CanMsgEECA3D.ProceF = msg_full;
               CanMsgEECA3D.Data[0].bbyte  = CANRXDSR0;
               CanMsgEECA3D.Data[1].bbyte  = CANRXDSR1;
               CanMsgEECA3D.Data[2].bbyte  = CANRXDSR2;
               CanMsgEECA3D.Data[3].bbyte  = CANRXDSR3;
               CanMsgEECA3D.Data[4].bbyte  = CANRXDSR4;
               CanMsgEECA3D.Data[5].bbyte  = CANRXDSR5;
               CanMsgEECA3D.Data[6].bbyte  = CANRXDSR6;
               CanMsgEECA3D.Data[7].bbyte  = CANRXDSR7;
               CanClk.Signal.ExistFECA3D = Enable;
               CanClk.IDFECA3DCn = 25;
               bFECA3DFlag=1;
             }
           }
         }
       }   */

      //
      if (ext_id == ID18FEF100)
      {
        if (CanMsg18FEF100.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFEF1 == Disable)
            {
              CanClk.IDFEF1Cn++;
            }
            if (CanClk.IDFEF1Cn > 2)
            {
              CanMsg18FEF100.ProceF = msg_full;
              //  CanMsg18FEF100.Data[0].bbyte  = CANRXDSR0;
              //  CanMsg18FEF100.Data[1].bbyte  = CANRXDSR1;
              //  CanMsg18FEF100.Data[2].bbyte  = CANRXDSR2;
              CanMsg18FEF100.Data[3].bbyte = CANRXDSR3;
              //  CanMsg18FEF100.Data[4].bbyte  = CANRXDSR4;
              //  CanMsg18FEF100.Data[5].bbyte  = CANRXDSR5;
              //  CanMsg18FEF100.Data[6].bbyte  = CANRXDSR6;
              //  CanMsg18FEF100.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFEF1 = Enable;
              CanClk.IDFEF1Cn = 25;
              bFEF1lag = 1;
            }
          }
        }
      }
      //
      if (ext_id == ID18FD7C00)
      {
        if (CanMsg18FD7C00.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFD7C == Disable)
            {
              CanClk.IDFD7CCn++;
            }
            if (CanClk.IDFD7CCn > 2)
            {
              CanMsg18FD7C00.ProceF = msg_full;
              CanMsg18FD7C00.Data[0].bbyte = CANRXDSR0;
              //  CanMsg18FD7C00.Data[1].bbyte  = CANRXDSR1;
              CanMsg18FD7C00.Data[2].bbyte = CANRXDSR2;
              //  CanMsg18FD7C00.Data[3].bbyte  = CANRXDSR3;
              //  CanMsg18FD7C00.Data[4].bbyte  = CANRXDSR4;
              //  CanMsg18FD7C00.Data[5].bbyte  = CANRXDSR5;
              CanMsg18FD7C00.Data[6].bbyte = CANRXDSR6;
              //  CanMsg18FD7C00.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFD7C = Enable;
              CanClk.IDFD7CCn = 25;
              bFD7Clag = 1;
            }
          }
        }
      }
      //
      if (ext_id == ID18E0FF00)
      {
        if (CanMsg18E0FF00.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistE0FF00 == Disable)
            {
              CanClk.IDE0FF00Cn++;
            }
            if (CanClk.IDE0FF00Cn > 2)
            {
              CanMsg18E0FF00.ProceF = msg_full;
              // CanMsg18E0FF00.Data[0].bbyte  = CANRXDSR0;
              //  CanMsg18E0FF00.Data[1].bbyte  = CANRXDSR1;
              //  CanMsg18E0FF00.Data[2].bbyte  = CANRXDSR2;
              //  CanMsg18E0FF00.Data[3].bbyte  = CANRXDSR3;
              //  CanMsg18E0FF00.Data[4].bbyte  = CANRXDSR4;
              CanMsg18E0FF00.Data[5].bbyte = CANRXDSR5;
              //  CanMsg18E0FF00.Data[6].bbyte  = CANRXDSR6;
              //  CanMsg18E0FF00.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistE0FF00 = Enable;
              CanClk.IDE0FF00Cn = 25;
              bE0FF00Flag = 1;
            }
          }
        }
      }
      //
      if (ext_id == ID18FEF200)
      {
        if (CanMsg18FEF200.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFEF200 == Disable)
            {
              CanClk.IDFEF200Cn++;
            }
            if (CanClk.IDFEF200Cn > 2)
            {
              CanMsg18FEF200.ProceF = msg_full;
              //  CanMsg18FEF200.Data[0].bbyte  = CANRXDSR0;
              //  CanMsg18FEF200.Data[1].bbyte  = CANRXDSR1;
              CanMsg18FEF200.Data[2].bbyte = CANRXDSR2;
              CanMsg18FEF200.Data[3].bbyte = CANRXDSR3;
              CanMsg18FEF200.Data[4].bbyte = CANRXDSR4;
              CanMsg18FEF200.Data[5].bbyte = CANRXDSR5;
              //  CanMsg18FEF200.Data[6].bbyte  = CANRXDSR6;
              //  CanMsg18FEF200.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFEF200 = Enable;
              CanClk.IDFEF200Cn = 25;
              bFEF200Flag = 1;
            }
          }
        }
      }
      //
      if (ext_id == ID18FEBF0B)
      {
        if (CanMsgFEBF0B.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFEBF0B == Disable)
            {
              CanClk.IDFEBF0BCn++;
            }
            if (CanClk.IDFEBF0BCn > 2)
            {
              CanMsgFEBF0B.ProceF = msg_full;
              //  CanMsgFEBF0B.Data[0].bbyte  = CANRXDSR0;
              CanMsgFEBF0B.Data[1].bbyte = CANRXDSR1;
              //  CanMsgFEBF0B.Data[2].bbyte  = CANRXDSR2;
              //  CanMsgFEBF0B.Data[3].bbyte  = CANRXDSR3;
              //  CanMsgFEBF0B.Data[4].bbyte  = CANRXDSR4;
              //  CanMsgFEBF0B.Data[5].bbyte  = CANRXDSR5;
              //  CanMsgFEBF0B.Data[6].bbyte  = CANRXDSR6;
              //  CanMsgFEBF0B.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFEBF0B = Enable;
              CanClk.IDFEBF0BCn = 20; // T,100ms
            }
          }
        }
      }
      ////ʻԱ--ڱġ
      if (ext_id == ID18FD0700)
      {
        if (CanMsgFD0700.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.ExistFD0700 == Disable)
            {
              CanClk.IDFD0700Cn++;
            }
            if (CanClk.IDFD0700Cn > 0)
            {
              CanMsgFD0700.ProceF = msg_full;
              CanMsgFD0700.Data[0].bbyte = CANRXDSR0;
              CanMsgFD0700.Data[1].bbyte = CANRXDSR1;
              // CanMsgFD0700.Data[2].bbyte  = CANRXDSR2;
              // CanMsgFD0700.Data[3].bbyte  = CANRXDSR3;
              //  CanMsgFD0700.Data[4].bbyte  = CANRXDSR4;
              //  CanMsgFD0700.Data[5].bbyte  = CANRXDSR5;
              //  CanMsgFD0700.Data[6].bbyte  = CANRXDSR6;
              //  CanMsgFD0700.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.ExistFD0700 = Enable;
              CanClk.IDFD0700Cn = 100; // T,1000ms Drop,10s
            }
          }
        }
      }
      //--lzs--jia--ʻԱ--Ϋ-----------------
      if (ext_id == ID18FEFF00)
      {
        if (CanMsg18FEFF00.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.Exist18FEFF00 == Disable)
            {
              CanClk.ID18FEFF00Cn++;
            }
            if (CanClk.ID18FEFF00Cn > 0)
            {
              CanMsg18FEFF00.ProceF = msg_full;
              //  CanMsg18FEFF00.Data[0].bbyte  = CANRXDSR0;
              CanMsg18FEFF00.Data[1].bbyte = CANRXDSR1;
              //  CanMsg18FEFF00.Data[2].bbyte  = CANRXDSR2;
              //  CanMsg18FEFF00.Data[3].bbyte  = CANRXDSR3;
              //  CanMsg18FEFF00.Data[4].bbyte  = CANRXDSR4;
              //  CanMsg18FEFF00.Data[5].bbyte  = CANRXDSR5;
              //  CanMsg18FEFF00.Data[6].bbyte  = CANRXDSR6;
              //  CanMsg18FEFF00.Data[7].bbyte  = CANRXDSR7;

              CanClk.Signal.Exist18FEFF00 = Enable;
              CanClk.ID18FEFF00Cn = 100;
            }
          }
        }
      }
      //
      if (ext_id == ID1CFFBE18) /*????1CFFBE18*********************************************************************************/
      {      
        if (CanMsg1CFFBE18.ProceF == empoty)
        {
          if (CANRXDLR_DLC == 8)
          {
            if (CanClk.Signal.Exist1CFFBE18 == Disable)
            {
              CanClk.ID1CFFBE18Cn++;
            }
            if (CanClk.ID1CFFBE18Cn > 0)
            {
              CanMsg1CFFBE18.ProceF = msg_full;
              //  CanMsg1CFFBE18.Data[0].bbyte  = CANRXDSR0;
              //  CanMsg1CFFBE18.Data[1].bbyte  = CANRXDSR1;
              CanMsg1CFFBE18.Data[2].bbyte = CANRXDSR2;
              //  CanMsg1CFFBE18.Data[3].bbyte  = CANRXDSR3;
              //  CanMsg1CFFBE18.Data[4].bbyte  = CANRXDSR4;
              //  CanMsg1CFFBE18.Data[5].bbyte  = CANRXDSR5;
              //  CanMsg1CFFBE18.Data[6].bbyte  = CANRXDSR6;
              //  CanMsg1CFFBE18.Data[7].bbyte  = CANRXDSR7;
              CanClk.Signal.Exist1CFFBE18 = Enable;
              CanClk.ID1CFFBE18Cn = 100;
            }
          }
        }
      }
      //
      //--lzs--jia--ʻԱ--ġ
      /*  if(ext_id==ID18FECA10)
        {
          if(CanMsg18FECA10.ProceF == empoty)
          {
            if(CANRXDLR_DLC == 8)
            {
              if(CanClk.Signal.Exist18FECA10 == Disable)
              {
                CanClk.ID18FECA10Cn ++;
              }
              if(CanClk.ID18FECA10Cn > 0)
              {
                CanMsg18FECA10.ProceF = msg_full;
              //  CanMsg18FECA10.Data[0].bbyte  = CANRXDSR0;
                CanMsg18FECA10.Data[1].bbyte  = CANRXDSR1;
              //  CanMsg18FECA10.Data[2].bbyte  = CANRXDSR2;
              //  CanMsg18FECA10.Data[3].bbyte  = CANRXDSR3;
              //  CanMsg18FECA10.Data[4].bbyte  = CANRXDSR4;
              //  CanMsg18FECA10.Data[5].bbyte  = CANRXDSR5;
              //  CanMsg18FECA10.Data[6].bbyte  = CANRXDSR6;
              //  CanMsg18FECA10.Data[7].bbyte  = CANRXDSR7;
                CanClk.Signal.Exist18FECA10 = Enable;
                CanClk.ID18FECA10Cn = 100;
              }
            }
          }
        } */

      //--lzs--jia--
    }

    //
    switch (extend_pgn)
    {
    case IDF004:
      if (CanMsgF004.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistF004 == Disable)
          {
            CanClk.IDF004Cn++;
          }
          if (CanClk.IDF004Cn > 2)
          {
            CanMsgF004.ProceF = msg_full;
            //  CanMsgF004.Data[0].bbyte  = CANRXDSR0;
            //  CanMsgF004.Data[1].bbyte  = CANRXDSR1;
            //  CanMsgF004.Data[2].bbyte  = CANRXDSR2;
            CanMsgF004.Data[3].bbyte = CANRXDSR3;
            CanMsgF004.Data[4].bbyte = CANRXDSR4;
            //  CanMsgF004.Data[5].bbyte  = CANRXDSR5;
            //  CanMsgF004.Data[6].bbyte  = CANRXDSR6;
            //  CanMsgF004.Data[7].bbyte  = CANRXDSR7;
            CanClk.Signal.ExistF004 = Enable;
            CanClk.IDF004Cn = 25;
            bF004Flag = 1;
          }
        }
      }
      break;
    case IDFEEE:
      if (CanMsgFEEE.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistFEEE == Disable)
          {
            CanClk.IDFEEECn++;
          }
          if (CanClk.IDFEEECn > 2)
          {
            CanMsgFEEE.ProceF = msg_full;
            CanMsgFEEE.Data[0].bbyte = CANRXDSR0;
            //  CanMsgFEEE.Data[1].bbyte  = CANRXDSR1;
            //  CanMsgFEEE.Data[2].bbyte  = CANRXDSR2;
            //  CanMsgFEEE.Data[3].bbyte  = CANRXDSR3;
            //  CanMsgFEEE.Data[4].bbyte  = CANRXDSR4;
            //  CanMsgFEEE.Data[5].bbyte  = CANRXDSR5;
            //  CanMsgFEEE.Data[6].bbyte  = CANRXDSR6;
            //  CanMsgFEEE.Data[7].bbyte  = CANRXDSR7;
            CanClk.Signal.ExistFEEE = Enable;
            CanClk.IDFEEECn = 20;
            bFEEEFlag = 1;
          }
        }
      }
      break;
    case IDFEFF:
      if (CanMsgFEFF.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistFEFF == Disable)
          {
            CanClk.IDFEFFCn++;
          }
          if (CanClk.IDFEFFCn > 0)
          {
            CanMsgFEFF.ProceF = msg_full;
            CanMsgFEFF.Data[0].bbyte = CANRXDSR0;
            CanMsgFEFF.Data[1].bbyte = CANRXDSR1;
            //   CanMsgFEFF.Data[2].bbyte  = CANRXDSR2;
            //   CanMsgFEFF.Data[3].bbyte  = CANRXDSR3;
            //   CanMsgFEFF.Data[4].bbyte  = CANRXDSR4;
            //   CanMsgFEFF.Data[5].bbyte  = CANRXDSR5;
            //   CanMsgFEFF.Data[6].bbyte  = CANRXDSR6;
            //   CanMsgFEFF.Data[7].bbyte  = CANRXDSR7;
            CanClk.Signal.ExistFEFF = Enable;
            CanClk.IDFEFFCn = 1000; // T,10s Drop,100s
            bFEFFFlag = 1;
          }
        }
      }
      break;
    case IDFEE4:
      if (CanMsgFEE4.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistFEE4 == Disable)
          {
            CanClk.IDFEE4Cn++;
          }
          if (CanClk.IDFEE4Cn > 2)
          {
            CanMsgFEE4.ProceF = msg_full;
            //   CanMsgFEE4.Data[0].bbyte  = CANRXDSR0;
            //   CanMsgFEE4.Data[1].bbyte  = CANRXDSR1;
            //   CanMsgFEE4.Data[2].bbyte  = CANRXDSR2;
            CanMsgFEE4.Data[3].bbyte = CANRXDSR3;
            //   CanMsgFEE4.Data[4].bbyte  = CANRXDSR4;
            //   CanMsgFEE4.Data[5].bbyte  = CANRXDSR5;
            //   CanMsgFEE4.Data[6].bbyte = CANRXDSR6;
            //   CanMsgFEE4.Data[7].bbyte = CANRXDSR7;
            CanClk.Signal.ExistFEE4 = Enable;
            CanClk.IDFEE4Cn = 30;
            bFEE4Flag = 1;
          }
        }
      }
      break;
    case IDFF08:
      if (CanMsgFF08.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistFF08 == Disable)
          {
            CanClk.IDFF08Cn++;
          }
          if (CanClk.IDFF08Cn > 2)
          {
            CanMsgFF08.ProceF = msg_full;
            //  CanMsgFF08.Data[0].bbyte  = CANRXDSR0;
            //  CanMsgFF08.Data[1].bbyte  = CANRXDSR1;
            //  CanMsgFF08.Data[2].bbyte  = CANRXDSR2;
            CanMsgFF08.Data[3].bbyte = CANRXDSR3;
            //  CanMsgFF08.Data[4].bbyte  = CANRXDSR4;
            //  CanMsgFF08.Data[5].bbyte  = CANRXDSR5;
            //  CanMsgFF08.Data[6].bbyte  = CANRXDSR6;
            //  CanMsgFF08.Data[7].bbyte  = CANRXDSR7;
            CanClk.Signal.ExistFF08 = Enable;
            CanClk.IDFF08Cn = 25;
            bFF08Flag = 1;
          }
        }
      }
      break;
    case IDFE40:
      if (CanMsgFE40.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistFE40 == Disable)
          {
            CanClk.IDFE40Cn++;
          }
          if (CanClk.IDFE40Cn > 2)
          {
            CanMsgFE40.ProceF = msg_full;
            //  CanMsgFE40.Data[0].bbyte  = CANRXDSR0;
            CanMsgFE40.Data[1].bbyte = CANRXDSR1;
            //  CanMsgFE40.Data[2].bbyte  = CANRXDSR2;
            //  CanMsgFE40.Data[3].bbyte  = CANRXDSR3;
            CanMsgFE40.Data[4].bbyte = CANRXDSR4;
            //  CanMsgFE40.Data[5].bbyte  = CANRXDSR5;
            //  CanMsgFE40.Data[6].bbyte  = CANRXDSR6;
            //  CanMsgFE40.Data[7].bbyte  = CANRXDSR7;
            CanClk.Signal.ExistFE40 = Enable;
            CanClk.IDFE40Cn = 25;
            bFE40Flag = 1;
          }
        }
      }
      break;
      /*  case IDFF0A:
          if(CanMsgFF0A.ProceF == empoty)
          {
            if(CANRXDLR_DLC == 8)
            {
              if(CanClk.Signal.ExistFF0A == Disable)
              {
                CanClk.IDFF0ACn ++;
              }
              if(CanClk.IDFF0ACn > 2)
              {
                CanMsgFF0A.ProceF = msg_full;

                CanMsgFF0A.ProceF = msg_full;
                CanMsgFF0A.Data[0].bbyte  = CANRXDSR0;
                CanMsgFF0A.Data[1].bbyte  = CANRXDSR1;
                CanMsgFF0A.Data[2].bbyte  = CANRXDSR2;
                CanMsgFF0A.Data[3].bbyte  = CANRXDSR3;
                CanMsgFF0A.Data[4].bbyte  = CANRXDSR4;
                CanMsgFF0A.Data[5].bbyte  = CANRXDSR5;
                CanMsgFF0A.Data[6].bbyte  = CANRXDSR6;
                CanMsgFF0A.Data[7].bbyte  = CANRXDSR7;

                CanClk.Signal.ExistFF0A = Enable;
                CanClk.IDFF0ACn = 30;
                bFF0AFlag=1;
              }
            }
          }
          break;
        case IDFF0A:
          if(CanMsgFF04.ProceF == empoty)
          {
            if(CANRXDLR_DLC == 8)
            {
              if(CanClk.Signal.ExistFF04 == Disable)
              {
                CanClk.IDFF04Cn ++;
              }
              if(CanClk.IDFF04Cn > 2)
              {
                CanMsgFF04.ProceF = msg_full;

                CanMsgFF04.ProceF = msg_full;
                CanMsgFF04.Data[0].bbyte  = CANRXDSR0;
                CanMsgFF04.Data[1].bbyte  = CANRXDSR1;
                CanMsgFF04.Data[2].bbyte  = CANRXDSR2;
                CanMsgFF04.Data[3].bbyte  = CANRXDSR3;
                CanMsgFF04.Data[4].bbyte  = CANRXDSR4;
                CanMsgFF04.Data[5].bbyte  = CANRXDSR5;
                CanMsgFF04.Data[6].bbyte  = CANRXDSR6;
                CanMsgFF04.Data[7].bbyte  = CANRXDSR7;

                CanClk.Signal.ExistFF04 = Enable;
                CanClk.IDFF04Cn = 25;
                bFF04Flag=1;
              }
            }
          }        */
    // glz--20170524
    case IDF001:
      if (CanMsgF001.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistF001 == Disable)
          {
            CanClk.IDF001Cn++;
          }
          if (CanClk.IDF001Cn > 2)
          {
            CanMsgF001.ProceF = msg_full;

            CanMsgF001.ProceF = msg_full;
            //  CanMsgF001.Data[0].bbyte  = CANRXDSR0;
            //  CanMsgF001.Data[1].bbyte  = CANRXDSR1;
            //  CanMsgF001.Data[2].bbyte  = CANRXDSR2;
            //  CanMsgF001.Data[3].bbyte  = CANRXDSR3;
            //  CanMsgF001.Data[4].bbyte  = CANRXDSR4;
            CanMsgF001.Data[5].bbyte = CANRXDSR5;
            //  CanMsgF001.Data[6].bbyte  = CANRXDSR6;
            //  CanMsgF001.Data[7].bbyte  = CANRXDSR7;

            CanClk.Signal.ExistF001 = Enable;
            CanClk.IDF001Cn = 25;
            bF001Flag = 1;
          }
        }
      }
      break;
      //
    case IDFEEF:
      if (CanMsgFEEF.ProceF == empoty)
      {
        if (CANRXDLR_DLC == 8)
        {
          if (CanClk.Signal.ExistFEEF == Disable)
          {
            CanClk.IDFEEFCn++;
          }
          if (CanClk.IDFEEFCn > 2)
          {
            CanMsgFEEF.ProceF = msg_full;

            CanMsgFEEF.ProceF = msg_full;
            //  CanMsgFEEF.Data[0].bbyte  = CANRXDSR0;
            //  CanMsgFEEF.Data[1].bbyte  = CANRXDSR1;
            //  CanMsgFEEF.Data[2].bbyte  = CANRXDSR2;
            CanMsgFEEF.Data[3].bbyte = CANRXDSR3;
            //  CanMsgFEEF.Data[4].bbyte  = CANRXDSR4;
            //  CanMsgFEEF.Data[5].bbyte  = CANRXDSR5;
            //  CanMsgFEEF.Data[6].bbyte  = CANRXDSR6;
            //  CanMsgFEEF.Data[7].bbyte  = CANRXDSR7;

            CanClk.Signal.ExistFEEF = Enable;
            CanClk.IDFEEFCn = 50;
            bFEEFlag = 1;
          }
        }
      }
      break;
      /* case PGN60416:           //EC00
         if(PRIO == 6)
         {
           if(PS==0XFF&&SA==0)
           {
             if(CanMsg18ECFF00.ProceF == EMPTY)
             {
               if(m_dlc == 8)
               {
                 CanMsg18ECFF00.ProceF = FULL;
                 CanMsg18ECFF00.Data[0].bbyte  = CANRXDSR0;
                 CanMsg18ECFF00.Data[1].bbyte  = CANRXDSR1;
                 CanMsg18ECFF00.Data[2].bbyte  = CANRXDSR2;
                 CanMsg18ECFF00.Data[3].bbyte  = CANRXDSR3;
                 CanMsg18ECFF00.Data[4].bbyte  = CANRXDSR4;
                 CanMsg18ECFF00.Data[5].bbyte  = CANRXDSR5;
                 CanMsg18ECFF00.Data[6].bbyte  = CANRXDSR6;
                 CanMsg18ECFF00.Data[7].bbyte  = CANRXDSR7;
                 MULPGN=(((INT16U)CanMsg18ECFF00.Data[6].bbyte)<<8)|CanMsg18ECFF00.Data[5].bbyte;
                 if(MULPGN==65226)
                 {
                   Enable_signal(CanClk.Signal.Exist18ECFF00);
                   CanClk.ID18ECFF00Cn = 100;
                 }
               }
             }
           }
         }
         break;
       case PGN60160:                    //EB00
         if(PRIO == 6)             //0x18
         {
           if(PS==0XFF&&SA==0)
           {
             if(CanMsg18EBFF00.ProceF == EMPTY)
             {
               if(m_dlc == 8)
               {
                 CanMsg18EBFF00.ProceF = FULL;
                 CanMsg18EBFF00.Data[0].bbyte  = CANRXDSR0;
                 CanMsg18EBFF00.Data[1].bbyte  = CANRXDSR1;
                 CanMsg18EBFF00.Data[2].bbyte  = CANRXDSR2;
                 CanMsg18EBFF00.Data[3].bbyte  = CANRXDSR3;
                 CanMsg18EBFF00.Data[4].bbyte  = CANRXDSR4;
                 CanMsg18EBFF00.Data[5].bbyte  = CANRXDSR5;
                 CanMsg18EBFF00.Data[6].bbyte  = CANRXDSR6;
                 CanMsg18EBFF00.Data[7].bbyte  = CANRXDSR7;
                 Enable_signal(CanClk.Signal.Exist18EBFF00);

                 CanClk.ID18EBFF00Cn = 100;
               }
             }
           }
         }
         break;  */
      //
    default:;
    }
  }
  
  bCanDropTimes = 30;
  /////////////////////////
  CANRFLG_RXF = ClearFlag;
}
