#define  GLOBALS_APP_DFLASH
#include "../App_Headers/includes.h"



//-----------------------------------------------------------------------------
// ��������   :    App_CopyRam(INT8U *Dp,INT8U *Sp,INT8U Nub)
// ��������   :    RAM ����
// ����       :    *Dp       -> Ŀ�ĵ�ַ
//                 *Sp       -> ԭ��ַ
//                 Nub       -> �����ֽ�����
// ���       :    ��
// ����ֵ     :    ��
// ����       :    ��
//-----------------------------------------------------------------------------
void App_CopyRam(INT8U *Dp,INT8U *Sp,INT8U Nub)
{
    INT8U b;
    
    for(b = 0;b < Nub;b++)
    {
         *Dp++ = *Sp++;           
    }
}
//-----------------------------------------------------------------------------
// ��������   :    App_ClrRam
// ��������   :    RAM ����
// ����       :    *Dp       -> Ŀ�ĵ�ַ
//                 *Sp       -> ԭ��ַ
//                 Nub       -> �����ֽ�����
// ���       :    ��
// ����ֵ     :    ��
// ����       :    ��
//-----------------------------------------------------------------------------
void App_ClrRam(INT8U *Sp,INT8U Nub)
{
    INT8U b;
    
    for(b = 0;b < Nub;b++)
    {
         *Sp = null;
         Sp++;           
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_ComputeCheckSum
* Description    : ����У��
* Input          : INT8U *p ,INT8U Nub
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
INT8U App_ComputeCheckSum(INT8U *p ,INT8U Nub)
{
    INT8U bCheckSun;
    INT8U i;
    bCheckSun = null;
    while(Nub--)
    {
       bCheckSun ^= *p++;
       for(i = 0;i < 8;i++)
       {
           if(bCheckSun & 0x01)
           {
               bCheckSun = (bCheckSun >> 1) ^ 0x8C;
           }
           else 
               bCheckSun >>= 1;
       }
    }
    return(bCheckSun);   
}
/*-------------------------------------------------------------------------
* Function Name  : App_Read_EE_Memory
* Description    : ��ȡEEPROM������
* Input          : INT32U addr,INT8U *DestStr,INT16U len
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void App_Read_EE_Memory(INT16U ReadAddr,INT8U *DestStr,INT16U len)
{
    INT16U i;
    for(i= 0;i<len;i++)
    {
        *(DestStr + i) = Api_Flash_byte_read(ReadAddr + i);
    } 
}
/*-------------------------------------------------------------------------
* Function Name  : App_ReadAccKm
* Description    : ��ȡ�ۼ����
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_ReadAccKm(void)
{
    INT8U   check1 = null;
    INT8U   check2 = null;
   
    AccAddr.CurEEAccddr = EEACC_START;
    _FEED_COP();

    for(;AccAddr.CurEEAccddr < EEACC_END;)
    {
  	   bsp_IIC_ReadPage(0xa2,AccAddr.CurEEAccddr,(INT8U*) &AccKm,   Register_Len);
  	   
  	   check1 = App_ComputeCheckSum((INT8U*) &AccKm,Register_Len-2);
  	   
  	   if((check1 != AccKm.bCheckSun) || (AccKm.Checkflag != CheckFlag) || (AccKm.LongAccKm > 10000000))
  	   {
             AccAddr.CurEEAccddr += Register_Len;
  	   }
  	   else
  	   {
             break;
  	   }
  	   _FEED_COP();
    }
	
    for(;AccAddr.CurEEAccddr <= (EEACC_END - Register_Len);)
    {
        bsp_IIC_ReadPage(0xa2,AccAddr.CurEEAccddr,(INT8U*) &AccKm,   Register_Len);
        bsp_IIC_ReadPage(0xa2,AccAddr.CurEEAccddr + Register_Len,(INT8U*) &OldAccKm,Register_Len);
	   
        _FEED_COP();
	   
        if((AccKm.Checkflag == CheckFlag) && (OldAccKm.Checkflag == CheckFlag) &&\
           (AccKm.LongAccKm <= 10000000)  && (OldAccKm.LongAccKm <= 10000000))
        {
            check1 = App_ComputeCheckSum((INT8U*) &AccKm,   Register_Len-2);
            check2 = App_ComputeCheckSum((INT8U*) &OldAccKm,Register_Len-2);
           
            if((check1 == AccKm.bCheckSun) && (check2 == OldAccKm.bCheckSun)) 
            {
                if(AccKm.LongAccKm <= OldAccKm.LongAccKm)
                {
                    if((AccKm.LongAccKm +100) > OldAccKm.LongAccKm)
                    {
                        AccAddr.CurEEAccddr += Register_Len;
                    }
                    else
                    {
                        break;
                    }
                 }
                 else
                 {
            	     break;
                 }
             }
             else
             {
                 break;
             }
         }
         else
         {
    	     break;
         }
         _FEED_COP(); 
    } 
    
    ReadState = bsp_IIC_ReadPage(0xa2,AccAddr.CurEEAccddr,(INT8U*) &AccKm,   Register_Len);
    check1 = App_ComputeCheckSum((INT8U*) &AccKm,   Register_Len-2);

    if((AccKm.Checkflag != CheckFlag) || (AccKm.LongAccKm > 10000000) || (check1 != AccKm.bCheckSun))
    {
        ReadState = bsp_IIC_ReadPage(0xa2,EEBAKACC,(INT8U*) &AccKm,   Register_Len);
        check1 = App_ComputeCheckSum((INT8U*) &AccKm,   Register_Len-2);
        if((AccKm.Checkflag != CheckFlag) || (AccKm.LongAccKm > 10000000) || (check1 != AccKm.bCheckSun))
        {
            AccKm.Checkflag = CheckFlag;
            AccKm.LongAccKm = null;
            AccKm.ShortAccKm = null;
            AccKm.RemnantPulse = null;
            AccKm.ClrCnt = null;
            AccKm.FuelPulse = null;
            AccKm.bCheckSun = App_ComputeCheckSum((INT8U*) &AccKm,Register_Len-2);
        }
    }
    
    App_CopyRam((INT8U*)&OldAccKm,(INT8U*)&AccKm,Register_Len);
    AccPulse = AccKm.RemnantPulse;
    
    CarFlag.FlagBits.AccSaveState = Enable;      
}

/*-------------------------------------------------------------------------
�������ƣ�App_ClearAccStock
��    �ܣ�����ۻ����
��    ����None
������ֵ��None
ʹ��˵����
--------------------------------------------------------------------------*/
void App_ClearAccStock(void)
{
  static INT8U step = 0;
        
  _FEED_COP();
  DisableInterrupts;     
  if(CarFlag.FlagBits.AccSaveState)
  {        
    AccKm.Checkflag = CheckFlag;
    AccKm.LongAccKm = null;
    AccKm.ShortAccKm = null;        
    AccKm.FuelPulse = null; 
    AccKm.RemnantPulse = null;                        
    AccKm.bCheckSun  = App_ComputeCheckSum((INT8U *)&AccKm,Register_Len - 2); 

    step ++;
        
    switch(step)
    {
      case 1:
        bReturn = bsp_IIC_WritePage(0xa2,EEACC_START + 0,(INT8U*)&AccKm,Register_Len);
        break;
      case 2:
        bReturn = bsp_IIC_WritePage(0xa2,EEACC_START + 16,(INT8U*)&AccKm,Register_Len);
        break;
      case 3:
        bReturn = bsp_IIC_WritePage(0xa2,EEACC_START + 32,(INT8U*)&AccKm,Register_Len);
        break;
      case 4:
        bReturn = bsp_IIC_WritePage(0xa2,EEACC_START + 48,(INT8U*)&AccKm,Register_Len);
        break;
      case 5:
        bReturn = bsp_IIC_WritePage(0xa2,EEACC_START + 64,(INT8U*)&AccKm,Register_Len);
        break;              
      case 6:
        bReturn = bsp_IIC_WritePage(0xa2,EEBAKACC,(INT8U*)&AccKm,Register_Len);
        SevKm.Checkflag = CheckFlag;
        SevKm.Count = (INT8U)(AccKm.LongAccKm/50000);
        SevKm.bCheckSun  = App_ComputeCheckSum((INT8U *)&SevKm,2); 
        bReturn = Api_DFlashEraseSector(DFLASH_SERKM_ADDR);
        bReturn = Api_DFalshProgram(DFLASH_SERKM_ADDR,Register_Len,(INT16U*)&SevKm);
              
        ClrEn = Disable;
                                          
        CarFlag.FlagBits.AccSaveState = Disable;
        step = 0;
        break;                                                                                  
    }                                        
    _FEED_COP();  
    App_CopyRam((INT8U *)&OldAccKm,(INT8U *)&AccKm,Register_Len);        
  }
  EnableInterrupts; 
}
/*-------------------------------------------------------------------------
* Function Name  : App_WriteAccReg
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_WriteAccReg(void)
{
    if((AccKm.LongAccKm <= 10000000) && (ReadState == RunComplete))
    {
    	  AccKm.Checkflag = CheckFlag;
    	  AccKm.RemnantPulse = AccPulse;
    	  AccKm.bCheckSun = App_ComputeCheckSum((INT8U*)&AccKm,Register_Len-2);
    	
        bReturn = bsp_IIC_WritePage(0xa2,AccAddr.CurEEAccddr,(INT8U*) &AccKm,Register_Len);
        
        if(AccAddr.CurEEAccddr >= EEACC_END)
        {
            AccAddr.CurEEAccddr = EEACC_START;
        }
        else
        {
            AccAddr.CurEEAccddr += Register_Len; 
        }
        App_CopyRam((INT8U*)&OldAccKm,(INT8U*)&AccKm,Register_Len);
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalAccKm
* Description    : �ۻ���̼���
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/ 
void App_CalAccKm(void)
{    
    INT8U temp[16] = {0};
      
    if((CarFlag.FlagBits.AccSaveState) && (!CarFlag.FlagBits.AdjEnable))
    {          
        if((Radio.VehRadio >null)&&(Radio.VehRadio <65535))           
        {
            if((AccPulse *10) > (Radio.VehRadio * Radio.VehNum)) //ʮ��֮һ������ʾˢ��
            {
                if(AccPulse > (Radio.VehRadio * Radio.VehNum)/10)
                {
                   AccPulse -= (Radio.VehRadio * Radio.VehNum)/10; 
                }
                if(AccPulse > (Radio.VehRadio * Radio.VehNum)/10)
                {
                   AccPulse = null; 
                }
                AccKm.ShortAccKm ++;
                AccKm.LongAccKm ++;
                //AccKm.LongAccKm=AccKm.LongAccKm+100;//百倍速
            }
            
            if(AccKm.ShortAccKm > 9999)
            {
                AccKm.ShortAccKm = null;
            }
            if(AccKm.LongAccKm > 9999999)
            {
                AccKm.LongAccKm = null;
            }
            
            if(AccKm.LongAccKm > OldAccKm.LongAccKm)
            {
                if((OldAccKm.LongAccKm + 10) >= AccKm.LongAccKm)
                {
                    if((AccKm.LongAccKm % 2) == null)
                    {
                        App_WriteAccReg();
                    }
                     
                    if((AccKm.ShortAccKm % 15) == null)
                    {
                        AccKm.Checkflag = CheckFlag;
                        AccKm.bCheckSun = App_ComputeCheckSum((INT8U*)&AccKm,Register_Len-2);
                        bReturn = bsp_IIC_WritePage(0xa2,EEBAKACC,(INT8U*) &AccKm,Register_Len);
                    }                   
                }                                
            }
            if(AccKm.LongAccKm < OldAccKm.LongAccKm)
            {
                check = App_ComputeCheckSum((INT8U*) &OldAccKm,Register_Len-2);
                if(check == OldAccKm.bCheckSun)
                {
                    if((AccKm.LongAccKm + 10) > OldAccKm.LongAccKm)
                    {
                        App_CopyRam((INT8U*)&AccKm,(INT8U*)&OldAccKm,Register_Len-2);
                    }                           
                }
            }           
        }
    }
    
    if ((VehMeter.CurBoardVal >= VehMeterParamer.Resistor[VehMeterParamer.bVirtualVal - 1] - 3) &&\
        (RevMeter.CurBoardVal >= RevMeterParamer.Resistor[RevMeterParamer.bVirtualVal - 1] - 200) && (Key1Input == PushDown))
    {          
        if (G_Button.PushTime >= T_1s)
        {
            AccKm.ClrCnt = null;
            AccPulse = null; 
            
            do
            {
                App_ClearAccStock();
            } 
            while (CarFlag.FlagBits.AccSaveState == Enable);
            
            if (OUT_2000km_Clear)
            {
                OUT_2000km_Clear = null;
                bsp_IIC_WritePage(0xa2, 256, (INT8U *)&temp, Register_Len);
            }
        }             
    }

    /*OUT 2000km Clear*/
  #if 0
    if((G_Button.PushTime >= T_20s)&&(AccKm.LongAccKm < 20000)) 
    {
      bsp_IIC_ReadPage(0xa2, 256,(INT8U*) &OUT_2000km_Clear,Register_Len);
      if (OUT_2000km_Clear != one)
      {
        OUT_2000km_Clear = one;
        bsp_IIC_WritePage(0xa2, 256, (INT8U *)&OUT_2000km_Clear, Register_Len);
        do
        {
          App_ClearAccStock();
        } 
        while (CarFlag.FlagBits.AccSaveState == Enable);
		
	    	CarFlag.FlagBits.AccSaveState = Enable;
      }      
    }
  #endif  
}

/*-------------------------------------------------------------------------
* Function Name  : App_CalAccKmCan
* Description    : �ۻ���̼���
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_CalAccKmCan(void)
{    
  INT8U check;
  //ÿ100ms��������ۼ�
  
  if((g_accTime>=T_100ms) && (CarFlag.FlagBits.AccSaveState))
  {       
    if(VehMeter.CurBoardVal > null)
    {   
      //��һ��ʣ���Ҫ����      //100ms*Veh
      AccKm.RemnantPulse += VehMeter.CurBoardVal;  //1KM���ϴ�    0.2ms����
      g_accTime = null;
      if(AccKm.RemnantPulse >= 3530) //100ms * 1km/h = 1/3600(0.1km)
      {
        //���С�ƶ���0.1km
        AccKm.LongAccKm++;
        AccKm.ShortAccKm++;
        ///  	          
        AccKm.RemnantPulse = AccKm.RemnantPulse - 3530;              
        /////////////////////����һ�ε� �ܼ���� �� ///////////////////////////////
        if(AccKm.LongAccKm > OldAccKm.LongAccKm)
        {
          if((OldAccKm.LongAccKm + 10) > AccKm.LongAccKm)
          {                    
            if((AccKm.LongAccKm % 2) == null)//ÿ0.2km �洢һ�� ���С��
            {
              App_WriteAccReg(); //�洢���С��
            } 
            if((AccKm.ShortAccKm % 15) == null)
            {
              AccKm.Checkflag = CheckFlag; //ʼ�ն��� 0X55                                  
              AccKm.bCheckSun = App_ComputeCheckSum((INT8U*)&AccKm,Register_Len-2);
              // EEBAKACC ���߸��ط�
              g_bReturn = bsp_IIC_WritePage(0xa0,EEBAKACC,(INT8U*) &AccKm,Register_Len);
            }                                                  
          }
        } 
        ///////////////////////����һ�ε� �ܼ���� С ///////////////////////////////     
        if(AccKm.LongAccKm < OldAccKm.LongAccKm)
        {
          check = App_ComputeCheckSum((INT8U*) &OldAccKm,Register_Len-2);
          if(check == OldAccKm.bCheckSun)
          {
            if((AccKm.LongAccKm + 10) > OldAccKm.LongAccKm)
            {
              //��g_oldAccKm ���Ƹ���ǰ��g_accKm
              App_CopyRam((INT8U*)&AccKm,(INT8U*)&OldAccKm,Register_Len-2);
            }                           
          }
        } 
        //////////////////////////////////////////////////////////////////////////           
      }            
      ///��������
      if(AccKm.ShortAccKm > 9999)
      {
        AccKm.ShortAccKm = null;
      }
      ///��������
      if(AccKm.LongAccKm > 9999999)
      {
        AccKm.LongAccKm = null;
      }                 
    }
  }
    
  //glz--20170504
  if((VehMeter.CurBoardVal >= VehMeterParamer.Resistor[VehMeterParamer.bVirtualVal-1]-3)&&\
     (RevMeter.CurBoardVal >= RevMeterParamer.Resistor[RevMeterParamer.bVirtualVal-1]-200)&&(Key1Input == PushDown))
  {          
    if(G_Button.PushTime >= T_1s)
    {
      AccKm.ClrCnt = null;
      App_ClearAccStock();                     
    }             
  }                             
}

/*-------------------------------------------------------------------------
* Function Name  : App_Load_Data
* Description    : ��������
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void App_Load_Data(void)
{
      bsp_IIC_ReadPage(0xa0,EE_RADIO_ADDR,(INT8U*) &Radio,8);
	    check = App_CreateCheckSun((INT8U*)&Radio.VehRadio,Radio.bFlag,6);  
    
    if((Radio.bFlag != 0x55)||(check != Radio.bCheckSun))
    { 
        Radio.RevRadio = 40; 
        Radio.VehRadio = 560;
        Radio.VehNum = 8;
    }     
    
    App_Read_EE_Memory(DFLASH_VEH_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&VehMeterParamer,Meter_EE_Len);   
    check = App_CreateCheckSun((INT8U*)&VehMeterParamer.bVirtualVal,VehMeterParamer.bFlag,33);
    //if((VehMeterParamer.bFlag != 0x55)||(check != VehMeterParamer.bCheckSun))
    {                          
        VehMeterParamer.bVirtualVal = 5;           
        VehMeterParamer.Resistor[0] = 0;
        VehMeterParamer.Resistor[1] = 40;
        VehMeterParamer.Resistor[2] = 80;
        VehMeterParamer.Resistor[3] = 120;
        VehMeterParamer.Resistor[4] = 160;
        VehMeterParamer.Resistor[5] = 0;
        VehMeterParamer.Resistor[6] = 0;
        VehMeterParamer.Resistor[7] = 0;
        
        VehMeterParamer.DashStep[0] = 0;       
        VehMeterParamer.DashStep[1] = 690; 
        VehMeterParamer.DashStep[2] = 1380; 
        VehMeterParamer.DashStep[3] = 2070;  
        VehMeterParamer.DashStep[4] = 2760;  
        VehMeterParamer.DashStep[5] = 0;  //
        VehMeterParamer.DashStep[6] = 0;  //
        VehMeterParamer.DashStep[7] = 0;  //             
    }
    
    //
    App_Read_EE_Memory(DFLASH_REV_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&RevMeterParamer,Meter_EE_Len);
    check = App_CreateCheckSun((INT8U*)&RevMeterParamer.bVirtualVal,RevMeterParamer.bFlag,33);     
    //if((RevMeterParamer.bFlag != 0x55)||(check != RevMeterParamer.bCheckSun))
    {        
        RevMeterParamer.bVirtualVal = 6;           
        RevMeterParamer.Resistor[0] = 0;
        RevMeterParamer.Resistor[1] = 1000;
        RevMeterParamer.Resistor[2] = 2000;
        RevMeterParamer.Resistor[3] = 3000;
        RevMeterParamer.Resistor[4] = 4000;
        RevMeterParamer.Resistor[5] = 5000;
        RevMeterParamer.Resistor[6] = 0;
        RevMeterParamer.Resistor[7] = 0;
                 
        RevMeterParamer.DashStep[0] = 0;   
        RevMeterParamer.DashStep[1] = 552;  //   
        RevMeterParamer.DashStep[2] = 1100;  //
        RevMeterParamer.DashStep[3] = 1600;  //
        RevMeterParamer.DashStep[4] = 2150;  //
        RevMeterParamer.DashStep[5] = 2700;  //
        RevMeterParamer.DashStep[6] = 0;  //
        RevMeterParamer.DashStep[7] = 0;  //
    }
    //
    App_Read_EE_Memory(DFLASH_TMP_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&TempMeterParamer,Meter_EE_Len);
    check = App_CreateCheckSun((INT8U*)&TempMeterParamer.bVirtualVal,TempMeterParamer.bFlag,33); 
   // if((TempMeterParamer.bFlag != 0x55)||(check != TempMeterParamer.bCheckSun))
    {         
        TempMeterParamer.bVirtualVal = 7; 
     
        TempMeterParamer.Resistor[0] = 50;    
        TempMeterParamer.Resistor[1] = 60;
        TempMeterParamer.Resistor[2] = 75;
        TempMeterParamer.Resistor[3] = 90;  
        TempMeterParamer.Resistor[4] = 95; 
        TempMeterParamer.Resistor[5] = 100;  
        TempMeterParamer.Resistor[6] = 115;  
        TempMeterParamer.Resistor[7] = 0;           

        TempMeterParamer.DashStep[0] = 60;
        TempMeterParamer.DashStep[1] = 360; 
        TempMeterParamer.DashStep[2] = 600; 
        TempMeterParamer.DashStep[3] = 602;   
        TempMeterParamer.DashStep[4] = 800;
        TempMeterParamer.DashStep[5] = 960;
        TempMeterParamer.DashStep[6] = 1110;
        TempMeterParamer.DashStep[7] = 0;
    }

    //    
    App_Read_EE_Memory(DFLASH_FUEL_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&FuelMeterParamer,Meter_EE_Len);
    check = App_CreateCheckSun((INT8U*)&FuelMeterParamer.bVirtualVal,FuelMeterParamer.bFlag,33); 
    
   // if((FuelMeterParamer.bFlag != 0x55)||(check != FuelMeterParamer.bCheckSun))
    {               
        FuelMeterParamer.bVirtualVal = 5;           
                    
        FuelMeterParamer.Resistor[0] = 1100;       
        FuelMeterParamer.Resistor[1] = 620; 
        FuelMeterParamer.Resistor[2] = 325;
        FuelMeterParamer.Resistor[3] = 177; 
        FuelMeterParamer.Resistor[4] = 30; 
        FuelMeterParamer.Resistor[5] = 0;  
        FuelMeterParamer.Resistor[6] = 0;  
        FuelMeterParamer.Resistor[7] = 0;  
        
        FuelMeterParamer.DashStep[0] = 60;
        FuelMeterParamer.DashStep[1] = 318;
        FuelMeterParamer.DashStep[2] = 570;   
        FuelMeterParamer.DashStep[3] = 836;
        FuelMeterParamer.DashStep[4] = 1095;
        FuelMeterParamer.DashStep[5] = 0;
        FuelMeterParamer.DashStep[6] = 0;
        FuelMeterParamer.DashStep[7] = 0;
    }
    
     ///////////////  Adbule  ///////////////////////////
        AdbuleMeterParamer.bVirtualVal = 8;           
                    
        AdbuleMeterParamer.Resistor[0] = 0;       
        AdbuleMeterParamer.Resistor[1] = 6; 
        AdbuleMeterParamer.Resistor[2] = 26;
        AdbuleMeterParamer.Resistor[3] = 38; 
        AdbuleMeterParamer.Resistor[4] = 51; 
        AdbuleMeterParamer.Resistor[5] = 63;  
        AdbuleMeterParamer.Resistor[6] = 76;  
        AdbuleMeterParamer.Resistor[7] = 87;  
        
        AdbuleMeterParamer.DashStep[0] = 0;
        AdbuleMeterParamer.DashStep[1] = 20;
        AdbuleMeterParamer.DashStep[2] = 60;   
        AdbuleMeterParamer.DashStep[3] = 80;
        AdbuleMeterParamer.DashStep[4] = 100;
        AdbuleMeterParamer.DashStep[5] = 120;
        AdbuleMeterParamer.DashStep[6] = 140;
        AdbuleMeterParamer.DashStep[7] = 165;
        
        ////////////// QY1 ///////////////
        QY1MeterParamer.bVirtualVal = 8;           
                    
        QY1MeterParamer.Resistor[0] = 63;  //0.3v      
        QY1MeterParamer.Resistor[1] = 102; //0.5v  
        QY1MeterParamer.Resistor[2] = 244; //1.2v  
        QY1MeterParamer.Resistor[3] = 375; //1.8v  
        QY1MeterParamer.Resistor[4] = 529; //2.5v  
        QY1MeterParamer.Resistor[5] = 657; //3.2v  
        QY1MeterParamer.Resistor[6] = 789; //3.8v 
        QY1MeterParamer.Resistor[7] = 872; //4.2v

        QY1MeterParamer.DashStep[0] = 0;
        QY1MeterParamer.DashStep[1] = 20;
        QY1MeterParamer.DashStep[2] = 60;   
        QY1MeterParamer.DashStep[3] = 100;
        QY1MeterParamer.DashStep[4] = 140;
        QY1MeterParamer.DashStep[5] = 180;
        QY1MeterParamer.DashStep[6] = 220;
        QY1MeterParamer.DashStep[7] = 245;
                
        ////////////// QY2 ///////////////
        QY2MeterParamer.bVirtualVal = 8;           
                    
        QY2MeterParamer.Resistor[0] = 63;  //0.3v      
        QY2MeterParamer.Resistor[1] = 102; //0.5v  
        QY2MeterParamer.Resistor[2] = 244; //1.2v  
        QY2MeterParamer.Resistor[3] = 375; //1.8v  
        QY2MeterParamer.Resistor[4] = 529; //2.5v  
        QY2MeterParamer.Resistor[5] = 657; //3.2v  
        QY2MeterParamer.Resistor[6] = 789; //3.8v 
        QY2MeterParamer.Resistor[7] = 872; //4.2v

        QY2MeterParamer.DashStep[0] = 0;
        QY2MeterParamer.DashStep[1] = 20;
        QY2MeterParamer.DashStep[2] = 60;   
        QY2MeterParamer.DashStep[3] = 100;
        QY2MeterParamer.DashStep[4] = 140;
        QY2MeterParamer.DashStep[5] = 180;
        QY2MeterParamer.DashStep[6] = 220;
        QY2MeterParamer.DashStep[7] = 245;
   
   //     
    App_Read_EE_Memory(DFLASH_SERKM_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&SevKm,4);
    check = App_ComputeCheckSum((INT8U*)&SevKm,2);
    
    if((SevKm.Checkflag != 0x55)||(check != SevKm.bCheckSun))
    {
        SevKm.Checkflag = CheckFlag;
        SevKm.Count = (INT8U)(AccKm.LongAccKm/50000);
        SevKm.bCheckSun  = App_ComputeCheckSum((INT8U *)&SevKm,2);
        bReturn = Api_DFlashEraseSector(DFLASH_SERKM_ADDR);
        bReturn = Api_DFalshProgram(DFLASH_SERKM_ADDR,Register_Len,(INT16U*)&SevKm);         
    }
    
    w = TPM0Clock;
    w1 = VehMeterParamer.Resistor[VehMeterParamer.bVirtualVal-1];
    VehFreLimit = (INT16U)(w/(w1 * Radio.VehRadio * Radio.VehNum /3600)/3);
         
    w = TPM0Clock;
    w1 = RevMeterParamer.Resistor[RevMeterParamer.bVirtualVal-1];
    RevFreLimit = (INT16U)(w/(w1 * Radio.RevRadio  /1200)/4);  
                                
}



