#define GLOBALS_API_HT1621
#include "../App_Headers/includes.h"



/*-------------------------------------------------------------------------
* Function Name  : Api_HT1621_SendBit
* Description    : 
* Input          : 
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_HT1621_SendBit(INT8U data,INT8U len)
{
    INT8U i = null;
    INT8U w;
    w = data;
    for(i = 0;i<len;i++)
    {
        HT1621_WR = 0;
        asm(NOP;);
        asm(NOP;); 
        asm(NOP;);
        asm(NOP;);

        if(w & 0x80)
        {
            HT1621_DATA = 1;

        }
        else
        {
            HT1621_DATA = 0;
        }
        asm(NOP;);
        asm(NOP;); 
        asm(NOP;);
        asm(NOP;);
        asm(NOP;);

        HT1621_WR = 1;

        asm(NOP;);
        asm(NOP;); 

        w = w <<1;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Api_HT1621_Write
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_HT1621_Write(INT8U addr,INT8U sdata) 
{ 
    addr<<=2; 
    HT1621_CS = 0; 

    Api_HT1621_SendBit(0xa0,3);   //д־롰101 
    Api_HT1621_SendBit(addr,6);   //дaddr ĸ6λ 
    Api_HT1621_SendBit(sdata,4);  //дdata 8λ 
    
    HT1621_CS = 1;

} 


/*-------------------------------------------------------------------------
* Function Name  : Api_HT1621_CMD
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_HT1621_CMD(INT8U CmdType,INT8U cmd)
{
    HT1621_CS =0; 
 
    Api_HT1621_SendBit(CmdType,4);  //д־롰1009 λcommand  
    Api_HT1621_SendBit(cmd,8); //ûʹеʱΪ˱̷ 
    HT1621_CS =1;           //ֱӽcommand λд0 

}
/*-------------------------------------------------------------------------
* Function Name  : Api_HT1621_Init
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_HT1621_Init(void)
{        
    Api_HT1621_CMD(0x80,0x02); //ϵͳ                 SYS EN
    Api_HT1621_CMD(0x80,0x30); //RC 256K
    Api_HT1621_CMD(0x80,0x52); //ƫѹ  1/3                    BIAS 1/3 
    Api_HT1621_CMD(0x80,0x06); //  LCD ƫѹ     LCD ON
}


















