/*
 * API_EEPROM.h
 *
 *  Created on: 2012-3-24
 *      Author: qitiancun
 */
#ifdef        GLOBALS_API_EE
    #define   EXTERN_API_EE
 
    /* ===================================================================*/
    // Array of opcode instructions of the Erase/Program function in 
    // the HCS08 family 
    // size = 40 bytes + 2 bytes           
    const INT8U ROM_PGM[] = 
    {
      0x9E, 0xFE, 0x03, // LDHX 3,SP   ; get the target address '_addr'
    /* PC is pushed when calling, 2 bytes used (SP is decreased by 2)
    ** SP is now pointing to the next available unit
    ** thus '_addr' is at [SP+3]
    */  
      0xF7,	            // STA ,X		   ; store 'data' to 'addr' 
      0xA6, 0x20,	      // LDA #$20    ; load FCMD, CMD should be changed before calling
      0xC7, 0x18, 0x26,	// STA $1826	 ; FCMD
      0x45, 0x18, 0x25,	// LDHX #$1825 ; address of FSTAT
      0xF6,           	// LDA ,X      ; load FSTAT to A
      0xAA, 0x80,     	// ORA #$80    ; set FCBEF to lunch the command
      0xF7,    	        // STA ,X      ; store back to FSTAT
      0x9D,           	// NOP         ; wait for 4 cycles
      0x9D,            	// NOP
      0x9D,           	// NOP
      0x9D,           	// NOP
      0x45, 0x18, 0x25,	// LDHX #$1825 ; check FACCERR and FPVIOL
      0xF6,    	        // LDA ,X
      0xA5, 0x30,      	// BIT #$30
      0x27, 0x04,     	// BEQ *+6     ; branch to label_1
      0xA6, 0xFF,     	// LDA #$FF    ; return 0xFF if flag error
      0x20, 0x07,     	// BRA *+9     ; branch to label_2
    //label_1:  
      0xC6, 0x18, 0x25, // LDA $1825   ; wait for command to be completed
      0xA5, 0x40,   	  // BIT #$40
      0x27, 0xF9,     	// BEQ *-5     ; branch to label_1
    //label_2:  
      0x81    	        // RTS         ; return
    };
    
    
#else
    #define   EXTERN_API_EE     extern
#endif

#ifndef API_EEPROM_H_
#define API_EEPROM_H_

    #define  FLASH_PROTECTION    0xFF   //ݱ


    #define  FLASH_CMD_BYTEPROG  0x20  //д
    #define  FLASH_CMD_PAGEERASE 0x40  //  

    #define  EEPROM_START        0x9800   //EEPROMʼַ
    #define  Meter_EE_Len        43       //ÿǱEEPROMݳ
    #define  Alrt_EE_Len         22       //
    #define  PAGE_LEN            512 
    #define  Register_Len        16
    #define  ACC_STAR_ADDR       0x8000 
    #define  ACC_END_ADDR        0x9800 
       
    EXTERN_API_EE  void         Read_EE_Memory(INT32U ReadAddr,INT8U *DestStr,INT16U len);
    EXTERN_API_EE  void         Write_EE_Memory(INT16U WriteAddr,INT8U *SourceStr,INT16U len);
    EXTERN_API_EE  INT8U        Flash_byte_read(INT16U _addr);
    EXTERN_API_EE  void         Flash_byte_prog(INT16U _addr, INT8U _data);
    EXTERN_API_EE  void         Flash_page_erase(INT16U _addr);
    
#endif /* API_EEPROM_H_ */
