/*
 * APP_Data_Process.c
 *
 *  Created on: 2012-6-17
 *      Author: qitiancun
 */
#define GLOBALS_APP_PROCESS
#include "../App_Headers/includes.h"

#pragma CODE_SEG OTHER_ROM



/*-------------------------------------------------------------------------
* Function Name  : App_CalFre
* Description    : 频率计算
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void far App_CalFre(FreType *Veh,FreType *Rev)
{        
    if(CurRevCnt.dw32 > 0xffff0000)
    {
        CurRevCnt.dw32 = null;
    }
    if(CurVehCnt.dw32 > 0xffff0000)
    {
        CurVehCnt.dw32 = null;
    }   
    if(Veh->Cycl > VehFreLimit)
    {        

        Veh->Cycle[Veh->pCycle] = Veh->Cycl; 
        Veh->pCycle ++; 
        if(Veh->pCycle >= 4)
        {
            Veh->pCycle = null;
            App_SortNWord((INT32U *)Veh->Cycle,4);
            VehCycl = (Veh->Cycle[1] + Veh->Cycle[2])/2; 
            w = TPM0Clock;        
            if(VehCycl > VehFreLimit)
            {
                Veh->Frequency  = (INT16U)(w/VehCycl);
            }                                  
        } 
    
        API_SetTimer1(T_500ms,(ClockType*)&Clock);
        Veh->Cycl = null;
    }
      
    if(API_TimerOver1((ClockType*)&Clock))
    {
        Veh->Frequency = null;
        Veh->CyclH = null;
        Veh->CyclL = null;                     
    }         

    if(Rev->Cycl > RevFreLimit)
    {
        Rev->Cycle[Rev->pCycle] = Rev->Cycl;            
        if(Rev->pCycle >= FreEveLen-1)
        {
            Rev->pCycle = null;
            App_SortNWord((INT32U *)Rev->Cycle,FreEveLen);
            w = TPM0Clock;  
            RevCycl = (Rev->Cycle[1] + Rev->Cycle[2])/2;   
            if(RevCycl > RevFreLimit)
            {
                Rev->Frequency = (INT16U)(w/RevCycl); 
            }                
        }
        else
        {
            Rev->pCycle ++; 
        }
            
        Rev->Cycl = null;
        API_SetTimer2(T_300ms,(ClockType*)&Clock);             
    }
    if(API_TimerOver2((ClockType*)&Clock))
    {
        Rev->Frequency = null;     
    } 
}

/*-------------------------------------------------------------------------
函数名称：App_CalBorad                               glz--20170704
功    能：仪表计算
参    数：None
返回数值：None
使用说明：
--------------------------------------------------------------------------*/
void far App_CalBorad (void)
{
  if(CarFlag.FlagBits.AdjEnable == Disable)
  {
    App_CalVehBoard();
    App_CalRevBoard();
    App_CalCluchBoard();
    if(InitAdblueTime>=T_1s) 
    {
      App_CalAdBlueBoard();
    }
    //
    if(InitQy1Time > T_1s) 
    {
      App_CalGsPrs1Board();
    }
    //
    if(InitQy2Time > T_1s) 
    {
      App_CalGsPrs2Board();
    }        
    //
    if(FuelTime>=T_1s) 
    {
      FuelTime=0; 
      App_CalTmpBoard();
      App_CalFuelBoard();
    }
  }
}
 /*------------------------------------------------------------------------
* Function Name  : App_CalVehSpdFromCap
* Description    : 气压1处理
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
//void  App_CalGsPrs1FromCap(MeterPos *Meter,ADEve* Ade)
//{
// Meter->CurBoardVal= (INT16U)(((Meter->CurBoardVal * 7) + (Ade->QY1Even[2] * 3))/10);  
//}
 /*------------------------------------------------------------------------
* Function Name  : App_CalVehSpdFromCap
* Description    : 气压1处理
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
//void  App_CalGsPrs2FromCap(MeterPos *Meter,ADEve* Ade)
//{
// Meter->CurBoardVal= (INT16U)(((Meter->CurBoardVal * 7) + (Ade->QY2Even[2] * 3))/10);  
//}
/*------------------------------------------------------------------------
* Function Name  : App_CalVehSpdFromCap
* Description    : 液晶显示
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void far App_CalVehSpdFromCap(MeterPos *Meter,FreType *Veh)
{
    INT32U   CalVehSpd = null,VehSpd = null;
    two_int8u  EveVehSpd; 
    static INT8U  div =1,divcn = null;             
    w = Veh->Frequency;
    ADEveArry.VehEven[ADEveArry.pVeh] = (INT16U)((w * 3600) / (Radio.VehRadio * Radio.VehNum));
    if(ADEveArry.pVeh >= ADEveLen -1)
    {
       ADEveArry.pVeh = null; 
    } 
    else
    {
       ADEveArry.pVeh++;
    }
    App_SortNByte((INT16U*)ADEveArry.VehEven,ADEveLen -1);     
    CalVehSpd = ADEveArry.VehEven[3]; 
    EveVehSpd.di = (INT16U)CalVehSpd;            
    if(EveVehSpd.di > Meter->CurBoardVal)
    {
       	VehSpd = EveVehSpd.di16.d8H;
    	 	VehSpd /= ADEveLen-1;
    	 	CalVehSpd =  Meter->CurBoardVal;
    	 	CalVehSpd =  CalVehSpd * VehSpd;
    	 	CalVehSpd += EveVehSpd.di;
    	  VehSpd++;
    	 	CalVehSpd /= VehSpd;
    }
    
    if(CalVehSpd > 4)
    {
       div = 1;
       divcn = null;
    }
    if(CalVehSpd > 10)
    {
        CalVehSpd += 1;
    } 
    Meter->CurBoardVal = (INT16U)CalVehSpd;   
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalGsPrs1Board                         
* Description    : 气压1
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void  far App_CalGsPrs1Board(void)
{ 
  QY1Meter.CurBoardVal = ADEveArry.QY1Even[2];
  QY1Meter.DestPosition = App_CalMicroStep((INT32U)QY1Meter.CurBoardVal,(EE_MeterType *)&QY1MeterParamer);
  QY1SendVaule = QY1Meter.CurBoardVal; 
  if(QY1SendVaule > 60)
  { 
    QY1SendVaule = (QY1SendVaule*5 - 512)*37/1024; 
  } 
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalGsPrs2Board                         
* Description    : 气压2
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void far App_CalGsPrs2Board(void)
{ 
  QY2Meter.CurBoardVal = ADEveArry.QY2Even[2];
  QY2Meter.DestPosition = App_CalMicroStep((INT32U)QY2Meter.CurBoardVal,(EE_MeterType *)&QY2MeterParamer);
  QY2SendVaule = QY2Meter.CurBoardVal; 
  if(QY2SendVaule > 60)
  { 
    QY2SendVaule = (QY2SendVaule*5 - 512)*37/1024; 
  }  
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalVehBoard                             
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void far App_CalVehBoard(void)
{
    App_CalVehSpdFromCap((MeterPos *)&VehMeter,(FreType *)&VehFre); 
    VehMeter.DestPosition = App_CalMicroStep((INT32U)VehMeter.CurBoardVal,(EE_MeterType *)&VehMeterParamer);
   
   //输出高电平
   if(VehMeter.CurBoardVal > 40)
   {
     PTR_PTR6 = 1;
   }
   else
   {
     PTR_PTR6 = 0;
   }
   
    //
    CansendVeh = VehMeter.CurBoardVal;
    CansendVeh = (CansendVeh * 10000) / 39;     
       
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalRevSpdFromCap
* Description    : 转速计算
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void far App_CalRevSpdFromCap(MeterPos *Meter,FreType *Rev)
{
    INT32U   CalRevSpd = null,RevSpd = null;
    two_int8u  EveRevSpd;             

    w = Rev->Frequency;
    ADEveArry.RevEven[ADEveArry.pRev] = (INT16U) ((w * 1200)/Radio.RevRadio);
    if(ADEveArry.pRev >= ADEveLen -1)
    {                
       ADEveArry.pRev = null; 
    } 
    else
    {
       ADEveArry.pRev++;
    }
    App_SortNByte((INT16U*)ADEveArry.RevEven,ADEveLen -1);     
    CalRevSpd = ADEveArry.RevEven[3]; 
    EveRevSpd.di = (INT16U)CalRevSpd;            
    if(EveRevSpd.di > Meter->CurBoardVal)
    {
       	RevSpd = EveRevSpd.di16.d8H;
    	 	RevSpd /= 5;
    	 	CalRevSpd =  Meter->CurBoardVal;
    	 	CalRevSpd =  CalRevSpd * RevSpd;
    	 	CalRevSpd += EveRevSpd.di;
    	  RevSpd++;
    	 	CalRevSpd /= RevSpd;
    }

    Meter->CurBoardVal = (INT16U)CalRevSpd;
}    
/*--------------------------------------------------------------------------
* Function Name  : App_CalRevBoard
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void far App_CalRevBoard(void)
{ 
  RevMeter.DestPosition = App_CalMicroStep((INT32U)RevMeter.CurBoardVal,(EE_MeterType *)&RevMeterParamer);     
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalCluchBoard                           glz--20170721
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void far App_CalCluchBoard(void)
{
  INT32U  CalCluchV = null;
  INT32U   Scale = null;
  
  CalCluchV = ADEveArry.ClutchEven1[3];
  CalCluchV = (CalCluchV * 500) / 1024;
  Cluch1_V = CalCluchV;
  
  CalCluchV = ADEveArry.ClutchEven2[3];
  CalCluchV = (CalCluchV * 500) / 1024;
  Cluch2_V = CalCluchV;
   
  if(Cluch1_V > Cluch2_V)
  {
      Scale = (Cluch1_V * 10) / Cluch2_V;
      if((Scale>=16)&&(Scale<=24)) 
      {
        if((Cluch2_V>44)&&(Cluch2_V<215))
        {
          CluchScaleFlag = 1;
          CluchScaleVaule = (Cluch2_V * 10000 - 440000) / (21500 - 4400);        
        }  
      } 
      else
      {
        CluchScaleFlag = 0;
        CluchScaleVaule = 0;
      }
  }
  else if(Cluch1_V < Cluch2_V)
  {
      Scale = (Cluch2_V * 10) / Cluch1_V;
      if((Scale>=16)&&(Scale<=24)) 
      {
        if((Cluch1_V>44)&&(Cluch1_V<215))
        {
          CluchScaleFlag = 1;
          CluchScaleVaule = (Cluch1_V * 10000 - 440000) / (21500 - 4400);
        }
      }
      else
      {
        CluchScaleFlag = 0;
        CluchScaleVaule = 0;
      }
  }
 
}

/*--------------------------------------------------------------------------
函数名称：App_CalFuelBoard
功    能：
参    数：None
返回数值：None
使用说明：
--------------------------------------------------------------------------*/
void  far App_CalFuelBoard(void)
{   
  INT8U   n = null;
  INT32U  temp2;
  INT32U  temp1;
	INT32U  R1;
	INT32U  R2;
	 
	INT32U  VR1;
	INT32U  VR2;
  R1 = 30;
  R2 = 430;
  VR1=33000;
  VR2=4700;
  temp2 = (ADEveArry.FuelEven[3] + ADEveArry.FuelEven[4] + ADEveArry.FuelEven[5])*10/3;
  //temp *= 500;  	
  //if((temp % 1024) >= 512)
  //{
  //  temp += 512;
  //}  	
  //Vcpu = temp/1024;	  	
  temp1 = (ADEveArry.KeyEven[3] + ADEveArry.KeyEven[4] + ADEveArry.KeyEven[5])*10/3;
  temp1= (temp1*5*(VR1+VR2))/(1024*VR2);
  Vcc =temp1 ;

  FuelMeter.CurBoardVal=(INT16U)((430*temp2-3072*Vcc )/(102*Vcc-temp2)*10);
  if(FuelMeter.CurBoardVal>2000)
  {
    FuelMeterParamer.DashStep[0]=0;
  }
  else
  {
    FuelMeterParamer.DashStep[0]=60;
  }
  
  if(FuleShowFlag==1) 
  {  
    if(Fuelnum<3) 
    { 
      Fuelnum++;
    } 
    else
    {  
      FuleShowFlag=0;
    }
    FuleSpeed=10;
    FuelTime=0; 
  }
  else if(VehMeter.CurBoardVal==0&&FuelMeter.CurBoardVal!=0)//
  {
    FuleSpeed=500;
  }
  else if(VehMeter.CurBoardVal>2)
  {            
    FuleSpeed=12000;       
  }
   
  if((Vcc-OldVcc)<30)     
    FuelMeter.DestPosition = App_CalMicroStep((INT32U)FuelMeter.CurBoardVal,(EE_MeterType *)&FuelMeterParamer);
  OldVcc=Vcc;
  FuelTime=0;
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalTempBoard
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void far App_CalTmpBoard(void)
{
       if(TempShowFlag==1) 
        {
         if(Tempnum<3) 
          { 
           Tempnum++;
          } 
          else
          {  
         TempShowFlag=0;
          }
          
          TempSpeed=10;
          
        }
       else if(bFEEEFlag==0)
        {
        TempSpeed=10;
         }
       else 
        {
         TempSpeed=170;
        }
  if (TempMeter.CurBoardVal != TempMeter_CurBoardVal)
  {
     TempMeter_DelayTime   = 0;
     TempMeter_CurBoardVal = TempMeter.CurBoardVal;
  }
  
  if (TempMeter_DelayTime == T_2s)
  {
      TempMeter.DestPosition = App_CalMicroStep((INT32U)TempMeter.CurBoardVal,(EE_MeterType *)&TempMeterParamer);
  }
    
  FuelTime=0; 
}

/*-------------------------------------------------------------------------
* Function Name  : App_Swap
* Description    : 交换
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void far App_Swap(INT16U *pData1,INT16U *pData2)
{
    INT16U psw;
    if((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SortNByte
* Description    : 数组排序
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void far App_SortNByte(INT16U *SortData,INT8U len)
{
    INT8U n=0,m;
    for(;n < len-1;n++)
    {
        for(m = n+1;m < len;m++)
        {
            App_Swap((SortData + n),(SortData + m));
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SwapWord
* Description    : 交换
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void far App_SwapWord(INT32U *pData1,INT32U *pData2)
{
    INT32U psw;
    if((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}


/*-------------------------------------------------------------------------
* Function Name  : App_SortNWord
* Description    : 数组排序
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void far App_SortNWord(INT32U *SortData,INT8U len)
{
    INT8U n=0,m;
    for(;n<len-1;n++)
    {
        for(m = n+1;m < len;m++)
        {
            App_SwapWord((SortData + n),(SortData + m));
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_State_Off                             glz--20170505
* Description    : 状态关闭
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void far App_State_Off(void)
{         
    INT8U n; 
    INT8U i;          
    CurRevCnt.dw32 = null;
    OldRevCnt.dw32 = null;
    CurVehCnt.dw32 = null;
    OldVehCnt.dw32 = null; 
    CurLightCnt.dw32 = null;
    OldLightCnt.dw32 = null;    
    CurTempCnt.dw32 = null;
    FuelTime=0;
    FuleSpeed=10;
    TempShowFlag=1;
    TempSpeed=10;
    Tempnum =0;
    //
    FuelMeter.DestPosition =FuelMeter.DestPosition;
    FuelMeter.OldBoardVal=FuelMeter.CurBoardVal;
    FuelMeter.CurBoardVal=0;
    FuelMeter.DestPosition=0;
    FuleShowFlag=1;          
    
    RevFre.Cycl = null;
    RevFre.Frequency = null;
    RevFre.pCycle = null; 
    RevMeter.CurBoardVal  = null;
    VehFre.Cycl = null;
    VehFre.Frequency = null; 
    VehFre.pCycle = null;  
    VehMeter.CurBoardVal  = null; 
       
    TempMeter.CurBoardVal = null;  
    TempMeter.DestPosition = null;
    
    AdbuleMeter.CurBoardVal = null;
    AdbuleMeter.CurPosition = null;
    AdbuleMeter.DestPosition = null;  

    for(i = 0; i < MAX_DS_ID; i++)
    {
       if((i==ID_LTRN)||(i==ID_FFOG)||(i==ID_RTRN))
	      {  
	        continue;
	      }
        bDSTable[i] = 0;

    }  
    if(TIM1_TIE_C7I)
    {
        TIM1_TIE_C7I = Disable; 
        VehFre.CyclH = null;
        VehFre.CyclL = null; 
        VehFre.Cycl  = null;       
    }
    bDSTable[ID_ADBLUE]&=(~(DS0_MASK|DS1_MASK));
    bDSTable[ID_ABS]&=(~(DS0_MASK|DS1_MASK));

    QY1Meter.CurBoardVal=0;
    QY2Meter.CurBoardVal=0;
    //glz--20170505
    FDJ1_LED_P = 0;
    FDJ2_LED_P = 1;
    //glz--20170518
    InitAdblueTime = 0;
    AdblueInitTime = 0;
    Adbule_Section = 0;
    InitAdblueFlag = 1;
    //glz--20170519
    CansendVeh = 0;
    LED.StopBreakTime = null;
    ParkIn_Flag = 0;
    LED.DangweiTime = null;
    Dangwei_Flag = 0;
    LED.StopScaleTime = null;
    StopScale_Flag = 0;
    CluchScaleFlag = 0;
    PackBroadFlag = 0;
    ZD_QIYA_OUT=0;
    CS_OUT =0;
    OILWATER_LED_P= OUT;
    ABS_LED_P=0;//
    YURE_LED_P=0;//
    ABS_LED_P=0;
    FDJ1_LED_P=0;//
    TLY_LED_P=0;//
    OBD_LED_P=1;//
    FDJ2_LED_P  =  OUT;//
    DPF_OUT = 0;//灭
    HOutputTempL_OUT = 0;//灭
    HOutputTempR_OUT =0;//灭 
    Cruise_OUT=0;//灭 
    Oil_LED_P = 0;//灭 
    DriverLamp_OUT = 0;//灭 
    DPFR_OUT = 0; //灭lzs--jia
    DPFForbit_LED_P = 0;//灭lzs--jia
    DriverRLamp_OUT = OFF; //灭lzs--jia
    RFUEL_LEVEL_LOW = OFF; 
    //
    G_Button.SET_TIME = 0;
    G_Button.JUMP = 0;    
    Charge_Timer = 0;
}
/*--------------------------------------------------------------------------
* Function Name  : App_FindSector
* Description    : 
* Input          : INT16U val,INT8U virlen,EE_MeterType *MParam
* Output         : None
* Return         : INT16U
* onther         : 查找AD值所在的区域
--------------------------------------------------------------------------*/
INT8U far App_FindSector(INT16U val,EE_MeterType *MParam)
{
    INT8U i,Order,SectorID = null;
    if(MParam->Resistor[0] > MParam->Resistor[MParam->bVirtualVal-1])
    {
        Order = 0;
    }
    else
    {
        Order = 1;
    }
    for(i=0;i<MParam->bVirtualVal-1;i++)
    {
        if(Order == 1) //升序
        {
            if(val>=MParam->Resistor[i])
            {
               SectorID++;
            }
        }
        if(Order == 0) //降序
        {
            if(val<=MParam->Resistor[i])
            {
               SectorID++;
            }
        }
    } 
    return SectorID;  
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalMicroStep
* Description    : 计算各表电机应走的步数
* Input          : INT16U ADVAL,DashBoardPoint MParam
* Output         : None
* Return         : INT16U
* onther         : 计算当前AD值应走到的位置 步数
--------------------------------------------------------------------------*/

INT16U far App_CalMicroStep(INT32U ADVAL,EE_MeterType *MParam)
{
    INT8U  SectorID     = null; //块ID
    INT32U PerCentum    = null; //ADVAL占所在块AD的百分数*100
    INT32U StepCn       = null;
    INT8U  ASCF         = null; //单调标志位
    
    /*例如:有效字节5
      10    20    50    60    75
      |     |     |     |     |
        块1   块2   块3   块4
    */
    
    if((MParam->bVirtualVal<2)||(MParam->bVirtualVal>10))   //如果有效值非法
    {
        return null; 
    }


    if(MParam->Resistor[1]>MParam->Resistor[0])   //上升
    {
         ASCF =1;
    }
    if(MParam->Resistor[1]<MParam->Resistor[0])   //下降
    {
         ASCF =2;
    }

    if(ASCF==1)
    {

        if(ADVAL>=MParam->Resistor[MParam->bVirtualVal-1])
        {
            ADVAL = MParam->Resistor[MParam->bVirtualVal-1]; 
        }
        if(ADVAL<=MParam->Resistor[0])
        {
            ADVAL = MParam->Resistor[0]; 
        } 
    }
    if(ASCF==2)
    {

        if(ADVAL<=MParam->Resistor[MParam->bVirtualVal-1])
        {
            ADVAL = MParam->Resistor[MParam->bVirtualVal-1]; 
        }
        if(ADVAL>=MParam->Resistor[0])
        {
            ADVAL = MParam->Resistor[0]; 
        } 
    }
    SectorID = App_FindSector((INT16U)ADVAL,MParam);

   
    if(SectorID>(MParam->bVirtualVal-1))     //如果AD值非法则退出
    {
         return null; 
    }
    switch(SectorID)
    {
        case 1:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[0])*100);
                    PerCentum = PerCentum/(MParam->Resistor[1]-MParam->Resistor[0]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[0]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[0]-MParam->Resistor[1]);
                }
                StepCn = (MParam->DashStep[1]-MParam->DashStep[0])*PerCentum/100+MParam->DashStep[0];
                break;
            }
        case 2:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[1])*100);
                    PerCentum = PerCentum/(MParam->Resistor[2]-MParam->Resistor[1]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[1]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[1]-MParam->Resistor[2]);
                }
                StepCn = (MParam->DashStep[2]-MParam->DashStep[1])*PerCentum/100+MParam->DashStep[1];
                break;
            }
        case 3:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[2])*100);
                    PerCentum = PerCentum/(MParam->Resistor[3]-MParam->Resistor[2]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[2]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[2]-MParam->Resistor[3]);
                }
                StepCn = (MParam->DashStep[3]-MParam->DashStep[2])*PerCentum/100+MParam->DashStep[2];
                break;
            }
        case 4:
            {
                if(ASCF ==1)
                {   
                    PerCentum = ((ADVAL-MParam->Resistor[3])*100);
                    PerCentum = PerCentum/(MParam->Resistor[4]-MParam->Resistor[3]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[3]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[3]-MParam->Resistor[4]);
                    
                }
                StepCn = (MParam->DashStep[4]-MParam->DashStep[3])*PerCentum/100+MParam->DashStep[3];
                break;
            }
        case 5:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[4])*100);
                    PerCentum = PerCentum/(MParam->Resistor[5]-MParam->Resistor[4]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[4]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[4]-MParam->Resistor[5]);
                    
                }
                StepCn = (MParam->DashStep[5]-MParam->DashStep[4])*PerCentum/100+MParam->DashStep[4];
                break;
            }
        case 6:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[5])*100);
                    PerCentum = PerCentum/(MParam->Resistor[6]-MParam->Resistor[5]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[5]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[5]-MParam->Resistor[6]);
                }
                StepCn = (MParam->DashStep[6]-MParam->DashStep[5])*PerCentum/100+MParam->DashStep[5];
                break;
            }
        case 7:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[6])*100);
                    PerCentum = PerCentum/(MParam->Resistor[7]-MParam->Resistor[6]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[6]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[6]-MParam->Resistor[7]);
                }
                StepCn = (MParam->DashStep[7]-MParam->DashStep[6])*PerCentum/100+MParam->DashStep[6];
                break;
            }
        case 8:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[7])*100);
                    PerCentum = PerCentum/(MParam->Resistor[8]-MParam->Resistor[7]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[7]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[7]-MParam->Resistor[8]);
                }
                StepCn = (MParam->DashStep[8]-MParam->DashStep[7])*PerCentum/100+MParam->DashStep[7];
                break;
            }
        case 9:
            {
                if(ASCF ==1)
                {
                    PerCentum = ((ADVAL-MParam->Resistor[8])*100);
                    PerCentum = PerCentum/(MParam->Resistor[9]-MParam->Resistor[8]);
                }
                if(ASCF ==2)
                {
                    PerCentum = ((MParam->Resistor[8]-ADVAL)*100);
                    PerCentum = PerCentum/(MParam->Resistor[8]-MParam->Resistor[9]);
                }
                StepCn = (MParam->DashStep[9]-MParam->DashStep[8])*PerCentum/100+MParam->DashStep[8];
                break;
            } 
        }

    return (INT16U)(StepCn);  
}

/*--------------------------------------------------------------------------
* Function Name  : App_CalMicroStep
* Description    : 计算各表电机应走的步数
* Input          : INT16U ADVAL,DashBoardPoint MParam
* Output         : None
* Return         : INT16U
* onther         : 计算当前AD值应走到的位置 步数
--------------------------------------------------------------------------*/

INT16U far App_CalGsPrsStep(INT32U ADVAL,EE_MeterType *MParam)
{
  INT16U uwTmp1= null;
  INT16U uwTmp2= null;   
  INT16U StepCn  = null;                                      
  static INT8U i=0;
  
  if(ADVAL>=MParam->Resistor[6]&&ADVAL<=950)
  {             
    StepCn=12;  
  } 
  else if(ADVAL>=MParam->Resistor[5]&&ADVAL<MParam->Resistor[6])
  { 
    uwTmp1 = (MParam->Resistor[6]-MParam->Resistor[5])/2;
    uwTmp2 = MParam->Resistor[5]+uwTmp1;          
   if(ADVAL>uwTmp2) 
    StepCn=11;
   else
    StepCn=10;   
  } 
  else if(ADVAL>=MParam->Resistor[4]&&ADVAL<MParam->Resistor[5])
  { 
    uwTmp1 = (MParam->Resistor[5]-MParam->Resistor[4])/2;
    uwTmp2 = MParam->Resistor[4]+uwTmp1;          
   if(ADVAL>uwTmp2) 
    StepCn=9;
   else
    StepCn=8;   
  } 
  else if(ADVAL>=MParam->Resistor[3]&&ADVAL<MParam->Resistor[4])
  { 
    uwTmp1 = (MParam->Resistor[4]-MParam->Resistor[3])/2;
    uwTmp2 = MParam->Resistor[3]+uwTmp1;          
   if(ADVAL>uwTmp2) 
    StepCn=7;
   else
    StepCn=6;   
  } 
  else if(ADVAL>=MParam->Resistor[2]&&ADVAL<MParam->Resistor[3])
  { 
    uwTmp1 = (MParam->Resistor[3]-MParam->Resistor[2])/2;
    uwTmp2 = MParam->Resistor[2]+uwTmp1;          
   if(ADVAL>uwTmp2) 
    StepCn=5;
   else
    StepCn=4;   
  } 
  else if(ADVAL>=MParam->Resistor[1]&&ADVAL<MParam->Resistor[2])
  { 
    uwTmp1 = (MParam->Resistor[2]-MParam->Resistor[1])/2;
    uwTmp2 = MParam->Resistor[1]+uwTmp1;          
   if(ADVAL>uwTmp2) 
    StepCn=3;
   else
    StepCn=2;   
  } 
  else if(ADVAL>=MParam->Resistor[0]&&ADVAL<MParam->Resistor[1])
  { 
    StepCn=1;   
  }
  else
  {
    StepCn=0;                       
  }
  i++;
   return (INT16U)(StepCn);  
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalAdBlueBoard                         glz--20170518
* Description    : 状态关闭
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void  far App_CalAdBlueBoard(void)
{
  AdbuleMeter.CurBoardVal = bCatalystLevel;
  AdbuleMeter.DestPosition = App_CalMicroStep((INT32U)AdbuleMeter.CurBoardVal,(EE_MeterType *)&AdbuleMeterParamer);
}
#pragma CODE_SEG DEFAULT


