#ifdef        GLOBALS_API_DEF
    #define   EXTERN_API_DEF
   
#else
    #define   EXTERN_API_DEF     extern
#endif

#ifndef API_DEF_H_
#define API_DEF_H_
  #define     EMPTY                   0
  #define     FULL                    1
  #define     Enable_signal(signal)       signal = Enable
  #define     Disable_signal(signal)      signal = Disable  
  #define     MAX_MULCANDATALEN       63  //7*9,最多能收9包   
  #define     DTCTBLLEN 3
  ////////////////////////// --sys-- ///////////////////////////////////////
  #define     NormalChip               0x80
  #define     SpecialChip              0x00
  #define     InitDIRECT               0          
  #define     InitIVBR                 0xFF
  #define     InitCPMUPROT             0x26
  #define     InitCPMUCLKS             0x8F
  #define     InitCPMUREFDIV           0x40
  #define     InitCPMUSYNR             0x43 //0X47 4M;  8M 0X43  16M  0X40
  #define     InitCPMUPOSTDIV          0x00
  #define     InitCPMUPLL              0
  #define     InitPUCR                 0x40
  #define     InitCPMUCOP              0x07 
  #define     WaitRun                  0
  #define     BusClock                 32000000

  #define     WaitOverTime            50000//(cBusClock / cIIC_Clk * cOverTime)
  #define     TPM0Clock                BusClock/8
  #define     TPM1Clock                BusClock/1
  /////////////////////// --motor-- /////////////////////////////////////  
  #define     EngineMotorNub           0    
  #define     VehMotorNub              1        
  #define     FuelMotorNub             2
  #define     TempMotorNub             3
  
  #define     clockwise                1
  #define     widdershins              0
  #define     keep_local               255 
  #define     reset                    0
  
  //常量
  #define     Fbus_8                   3              //电机时钟源选择
  #define     Fbus_4                   2              //电机时钟源选择
  #define     Fbus_2                   1 
  #define     Fbus                     0              //电机时钟源选择
  #define     FHBM                     2              //全H桥模式
  #define     MotorClk                 22000           //电机频率  
  #define     InitMCPER                (BusClock / MotorClk)
                   
  ////////////////////// --SCI-- ///////////////////////////////////
	#define     CH1                      1
	#define     CH2                      2
	#define     baud_9600                208
	#define     div4                     3
	
  #define     VehType                  1
  #define     RevType                  2  	
  #define     TmpType                  3
  #define     FueType                  4
  #define     VehStepType              5
  #define     RevStepType              6
  #define     TmpStepType              7
  #define     FuelStepType             8
  #define     RadioType                11
  #define     AccType                  13
  #define     DownLoad                 1
  #define     UpLoad                   2
  #define     SCI_LEN                  43
  #define     LIN_LEN                  15
  
  #define     COM                      0
  #define     LIN                      1  
  #define     BCM_ID                   0xf0
  #define     LRadar_ID                0xb1
  #define     CRadar_ID                0x32
  #define     RRadar_ID                0x73
  ////////////////////////// --ATD-- ///////////////////////////////////////
  #define     CHNAL0                   0
  #define     CHNAL1                   1
  #define     CHNAL3                   3
  #define     CHNAL4                   4
  #define     CHNAL5                   5
  #define     CHNAL6                   6
  #define     CHNAL7                   7	  
  #define     SMP_TIME                 6
  #define     SMP_PRE                  16
  #define     Delay1ms                 1330      
  /////////////////////////// --HT1621-- //////////////////////////////////////
  #define     HT1621_CS                 PT1AD_PT1AD4
  #define     HT1621_WR                 PT1AD_PT1AD3
  #define     HT1621_DATA               PT1AD_PT1AD2
  /////////////////////// --TPM-- ///////////////////////////////////
  #define     TPM_DIV8                  3
  #define     TPM_DIV4                  2
  #define     TPM_DIV2                  1
  #define     TPM_DIV1                  0
  #define     TPM_DIV128                7
  #define     RisingEdg                 1
  
  #define     TT_0ms                    0
  #define     TT_15ms                   2
  #define     TT_20ms                   3
  #define     TT_30ms                   TT_15ms*2
  #define     TT_50ms                   6 
  #define     TT_100ms                  12  
  #define     TT_125ms                  15   
  #define     TT_250ms                  30  
  #define     TT_300ms                  40
  #define     TT_350ms                  TT_300ms+TT_50ms 
  #define     TT_400ms                  TT_100ms*4
  #define     TT_500ms                  TT_100ms*5 
  #define     TT_600ms                  TT_100ms*6  
  #define     TT_750ms                  TT_100ms*7+TT_50ms 
  #define     TT_1s                     122
  #define     TT_1_9s                   TT_1s+TT_500ms+TT_400ms 
  #define     TT_2s                     TT_1s*2  
  #define     TT_2_5s                   TT_1s*2 + TT_500ms   
  //
  #define     TT1_0ms                  0
  #define     TT1_10ms                 5
  #define     TT1_15ms                 7
  #define     TT1_20ms                 8
  #define     TT1_30ms                 TT1_15ms *2
  #define     TT1_50ms                 24
  #define     TT1_65ms                 TT1_50ms + TT1_15ms
  #define     TT1_100ms                48 
  #define     TT1_125ms                61 
  #define     TT1_200ms                TT1_100ms*2
  #define     TT1_120ms                TT1_100ms+TT1_20ms  
  #define     TT1_180ms                87  
  #define     TT1_240ms                117 
  #define     TT1_250ms                122
  #define     TT1_300ms                146  
  #define     TT1_340ms                165 
  #define     TT1_350ms                170 
  #define     TT1_400ms                195 
  #define     TT1_500ms                244 
  #define     TT1_550ms                TT1_500ms + TT1_50ms   
  #define     TT1_600ms                TT1_500ms + TT1_100ms     
  #define     TT1_750ms                367 
  #define     TT1_1s                   490 
  #define     TT1_1_5s                 735 
  #define     TT1_1_9s                 TT1_750ms + TT1_340ms
  #define     TT1_2s                   980  
  #define     TT1_2_5s                 1225 
  #define     TT1_3s                   1465 
  #define     TT1_5s                   2440 
  #define     TT1_6s                   2930  
  #define     TT1_8s                   3904 
         
  ///////////////////////////// --EEPROM-- ////////////////////////////////////////
  #define   MaxDFlashCommandCounter           0x06
  #define   MaxDelayTime                      BusClock 
  #define   RunComplete                       0
  #define   RunErr                            1
  #define   RunParameterErr                   2
  #define   RunOverTimeErr                    3
  #define   RunErrACCERR                      4
  #define   RunErrFPVIOL                      5
  #define   RunErrMGSTAT1                     6
  #define   RunErrMGSTAT0                     7
  #define   RunErr                            1
  #define   WordSize                          0x02
                                               //字大小
  #define   GLOBAL_ADDRESS_DFLASH             0x0000
                                               //D Flash全局地址[17:16]
  #define   DFLASH_BLOCK_START_ADDR           0x004400
                                               // D Flash 起始地址                                            
  #define   DFLASH_VEH_ADDR                   DFLASH_BLOCK_START_ADDR                                                
  #define   DFLASH_REV_ADDR                   DFLASH_VEH_ADDR + 256                                                
  #define   DFLASH_TMP_ADDR                   DFLASH_REV_ADDR + 256                                                
  #define   DFLASH_FUEL_ADDR                  DFLASH_TMP_ADDR + 256
  #define   DFLASH_RADIO_ADDR                 DFLASH_FUEL_ADDR + 256
  #define   DFLASH_SERKM_ADDR                 DFLASH_RADIO_ADDR + 256
  #define   DFLASH_SERVEH_ADDR                DFLASH_SERKM_ADDR + 256
                                                                                                                                                                                                                                                                                                                                                                                                     
  #define   DFLASH_BLOCK_END_ADDR             0x0053FF  // D Flash 结束地址                                                 
  #define   DFLASH_SECTOR_SIZE                0x0100    // 256 字节数
                                                   
  #define   DFLASH_ACC_START_ADD              0x004B00  //D-Falsh里程累计起始地址                                                
  #define   DFLASH_ACC_END_ADD                0x0051FF  //D-Flash里程累计结束地址                                                
  #define   DFLASH_MAXIMUM_SIZE               0x00001000  //D Flash 最大尺寸 4 KB                                                 
  #define   DFLASH_ERASE_VERIFY               0x10      //D Flash 擦除验证命令                                                 
  #define   DFLASH_PROGRAM                    0x11      //D Falsh 编程命令                                                 
  #define   DFLASH_ERASE_SECTOR               0x12      //D Flash 擦除命令                                                 
  #define   DFLASH_ERASE_COM_LENGTH           0x01      //D Flash 擦除命令长度                                                 
  #define   DFLASH_ERASE_VERIFY_COM_LENGTH    0x02      //D Flash 擦除检验命令长度                                                  
  #define   DFLASH_PROGRAM_COM_LENGTH         0x04      //D Flash 最大编程字节长度                                                   
  #define   MaxProgramByteNumber              0x08      //最大编程字节数 
                                               
  #define   DFLASH_PROGRAM_OFFSET             0x4000 
  
  #define   DFlashAccReadStartAdd             (DFLASH_ACC_START_ADD - DFLASH_PROGRAM_OFFSET)
  #define   DFlashAccReadEndAdd               (DFLASH_ACC_END_ADD - DFLASH_PROGRAM_OFFSET)
  #define   DFlashAccBlockNumber              ((DFLASH_ACC_END_ADD - DFLASH_ACC_START_ADD + 1) / DFlashAccBlockLength)

  #define   DFlashAccBlockLength              16
  #define   Meter_EE_Len                      35       //每块仪表EEPROM数据长度
  #define   Radio_EE_Len                      8 
   // 第一页
  #define     EE_RADIO_ADDR			             	0  
  //第二页
  #define   PAGE_LEN                          256 
  #define   Register_Len                      16      
              
  #define     EEACC_START                       176
  #define     EEACC_END                         240
  #define     EEBAKACC                          160 
                  
  /////////////////////////////// --蜂鸣器-- //////////////////////////////////////////////
  #define     Channel_0                 1
  #define     Channel_1                 2
  #define     Channel_2                 4
  #define     Channel_3                 8
  #define     Channel_4                 16

  #define     PWM_CLK_32DIV             5
  #define     PWM_CLK_64DIV             6
  #define     PWM_CLK_128DIV            0x77
  #define     PWM_CTL                   4
  #define     PWM0_CYCLE                127
  #define     PWM1_CYCLE                127
  #define     PWM2_CYCLE                127
  #define     Clk_SA_DIV                6
  
  #define      BackUp                  1
  #define     GprsAlr                  2
  #define     TempAlr                  3
  #define     VehAlr                   4
  #define     FuelAlr                  5
  #define     RehAlr                   6
  #define     SafeAlr                  7
  #define     LampAlr                  8
  #define     BreakAlr                 9
  
  #define     DisAlr                    255
  #define     AlwaysBp                  255
  //////////////////////////// -- Key -- ////////////////////////////////////////    
  #define     Key1Input                 PTH_PTH1
  #define     Key2Input                 PTP_PTP2
  ////////////////////////// --IO-- ///////////////////////////////////////////                    
  #define     PushDown                  0
  #define     UpSpring                  1  
    
  #define  ID0CF00300                 0x0CF00300
  #define  ID18FEF100                 0x18FEF100
  #define  ID18FE5600                 0x18FE5600
  #define  ID18FE563D                 0x18FE563D 
  //#define  ID18ECFF00                 0x18ECFF00 
  //#define  ID18EBFF00                 0x18EBFF00 
  #define  ID18EECA00                 0x18FECA00 
 // #define  ID18EECA3D                 0x18FECA3D
  #define  ID18FD7C00                 0x18FD7C00
  #define  ID18E0FF00                 0x18E0FF00
  #define  ID18FEF200                 0x18FEF200
  #define  ID18FEBF0B                 0x18FEBF0B
  #define  ID18FD0700                 0x18FD0700 //驾驶员警告--云内报文。
  //---lzs--jia--
  #define  ID18FEFF00                 0x18FEFF00 //驾驶员警告--潍柴报文。
  #define  ID1CFFBE18                 0x1CFFBE18 //T-BOX
 // #define  ID18FECA10                 0x18FECA10 //驾驶员警告--玉柴报文。

  
  ///
  #define  FDJ1_LED_P               PTP_PTP5 //OBD(黄)
  #define  DIRC_FDJ1_LED_P          DDRP_DDRP5
  #define  FDJ2_LED_P               PTR_PTR7 //OBD(红)
  #define  DIRC_FDJ2_LED_P          DDRR_DDRR7  
  #define  OBD_LED_P                PORTB_PB3//OBD    //
  #define  DIRC_OBD_LED_P           DDRB_DDRB3
  #define  BACKFOG_LED_P            PORTB_PB4 //后雾灯+  LED  负控
  #define  DIRC_BACKFOG_LED_P       DDRB_DDRB4
  #define  OILWATER_LED_P           PORTB_PB2 //油水分离指示
  #define  DIRC_OILWATER_LED_P      DDRB_DDRB2//
  #define  RevZero                  PORTB_PB1 //转速零点
  #define  DIRC_RevZero_IN          DDRB_DDRB1
  #define  RFUEL_LEVEL_LOW          PORTB_PB0 //燃油灯输出
  #define  DIRC_RFUEL_LEVEL_LOW_OUT DDRB_DDRB0

  #define  ZZX_LED_P                PTH_PTH7 //左转向
  #define  DIRC_ZZX_LED_P           DDRH_DDRH7
  #define  YZX_LED_P                PTH_PTH6 //右转向
  #define  DIRC_YZX_LED_P           DDRH_DDRH6
  #define  ZZX_LED_IN               PORTA_PA1 //左转向输入
  #define  DIRC_ZZX_LED_IN          DDRA_DDRA1
  #define  YZX_LED_IN               PTH_PTH4 //右转向输入
  #define  DIRC_YZX_LED_IN          DDRH_DDRH4
  #define  DriverLamp_OUT           PT1AD_PT1AD3    //驾驶员灯(黄)
  #define  DIRC_DriverLamp_OUT      DDR1AD_DDR1AD3
  #define  DriverRLamp_OUT          PTP_PTP0    //驾驶员灯(红)
  #define  DIRC_DriverRLamp_OUT     DDRP_DDRP0  
  #define  Cruise_OUT               PT1AD_PT1AD1
  #define  DIRC_Cruise_OUT          DDR1AD_DDR1AD1
  #define  HOutputTempL_OUT         PT1AD_PT1AD0//高排温度报警灯(黄)
  #define  DIRC_HOutputTempL_OUT    DDR1AD_DDR1AD0
  #define  HOutputTempR_OUT         PORTB_PB5//高排温度报警灯(红)
  #define  DIRC_HOutputTempR_OUT    DDRB_DDRB5  
  #define  BACKFOG_LED_IN           PORTA_PA2 //后雾灯输入
  #define  DIRC_BACKFOG_LED_IN      DDRA_DDRA2
  #define  TLY_LED_P                PTH_PTH5 //天蓝液报警
  #define  DIRC_TLY_LED_P           DDRH_DDRH5
  #define  LCD_SDA                  PTR_PTR4  //段码屏 SDA
  #define  DIRC_LCD_SDA             DDRR_DDRR4
  #define  LCD_SCL                  PTT_PTT3  // 段码屏SCL
  #define  DIRC_LCD_SCL             DDRT_DDRT3
  #define  AQD_LED_IN               PTT_PTT2 //安全带
  #define  DIRC_AQD_LED_IN          DDRT_DDRT2
  #define  VehZero                  PTT_PTT1 //车速零点
  #define  DIRC_VehZero_IN          DDRT_DDRT1
  #define  YB_ZERO_IN               PTT_PTT0 //燃油零点
  #define  DIRC_YB_ZERO_IN          DDRT_DDRT0
  #define  Tem_ZERO_IN              PT1AD_PT1AD2 //水温表零点
  #define  DIRC_Tpm_ZERO_IN         DDR1AD_DDR1AD2
  #define  KEY2_IN                  PTP_PTP7 //按键2
  #define  DIRC_KEY2_IN             DDRP_DDRP7
  #define  KEY1_IN                  PTP_PTP6//按键1
  #define  DIRC_KEY1_IN             DDRP_DDRP6
  #define  KEY0_IN                  PTS_PTS6 //按键0
  #define  DIRC_KEY0_IN             DDRS_DDRS6
  #define  ABS_LED_P                PTP_PTP2// ABS
  #define  DIRC_ABS_LED_P           DDRP_DDRP2
  #define  YURE_LED_P               PTP_PTP1 //  预热
  #define  DIRC_YURE_LED_P          DDRP_DDRP1
  #define  CS_OUT                   PTR_PTR2  //车速in  IN  分压
  #define  DIRC_CS_OUT              DDRR_DDRR2
  #define  ZD_QIYA_OUT              PTR_PTR1
  #define  DIRC_ZD_QIYA_OUT         DDRR_DDRR1
  #define  TJA1040_STB              PTR_PTR0  //CAN_STB  OUT  负控   CAN_STB_OUT
  #define  DIRC_TJA1040_STB         DDRR_DDRR0
  #define  FMQ                      PTS_PTS5  //FQM-  PWM  PWME_PWME5=1
  #define  DIRC_FMQ                 DDRS_DDRS5
  #define  Park_In                  PTP_PTP4  //Park
  #define  DIRC_Park_In             DDRP_DDRP4
  #define  DPF_OUT                  PORTB_PB7 //DPF 灯 黄
  #define  DIRC_DPF_OUT             DDRB_DDRB7
  #define  DPFR_OUT                  PORTB_PB6 //DPF 灯  红
  #define  DIRC_DPFR_OUT             DDRB_DDRB6  
  #define  Oil_LED_P                PTR_PTR5 //机油压力
  #define  DIRC_Oil_LED_P           DDRR_DDRR5 
  #define  DPFForbit_LED_P               PTP_PTP3 //DPF禁止再生指示灯
  #define  DIRC_DPFForbit_LED_P          DDRP_DDRP3
  //----------lzs--jia-------------
  #define  OILWATER_In              PORTA_PA7
  /*20230918zkh*/
  #define Charge_In                 PORTA_PA6 // 充电输入80
  #define DIRC_Charge_LED_IN        DDRA_DDRA6
  #define Charge_OUT                PORTA_PA5 // 充电输出79
  #define DIRC_Charge_LED_OUT       DDRA_DDRA5

  //
  #define     OUT                      1
  #define     IN                       0     
  ////////////////////////// --app-- ///////////////////////////////////////////
  #define     Enable                    1
  #define     Disable                   0    
  #define     null                      0
  #define     one                       1
  #define     ClearFlag                 1
  #define     CheckFlag                 0x55    
  #define     clear                     0
  #define     True                      1
  #define     false                     0
  #define     HIGH                      1
  #define     LOW                       0    
  #define     LEDON                     1
  #define     LEDOFF                    0
  ///////////////////////// --GUI-- /////////////////////////////
  #define     SysInit_Proc             0
  #define     Out_Proc                 1
  #define     CAN_Proc                 2
  #define     SCI_Proc                 3
  #define     GUI_DispProc             4
  #define     CalAccKm_Proc            5
  #define     CalMeterProc             6
  #define     KeyON                    1
  #define     KeyOFF                   0
  #define     CanON                    1
  #define     CanOFF                   0
  
  #define     MainMeuDisp              0
  #define     RadioMenu                1
  //
  #define     ClearDisp                244 
  #define     CheckDisp                245
  #define     Disp0                    0
  #define     Disp1                    1
  #define     Disp2                    2
  #define     Disp3                    3
  #define     Disp4                    4    
  #define     Disp5                    5
  #define     Disp6                    6
  #define     Disp7                    7 
  #define     Disp8                    8 
  #define     Disp9                    9
  #define     Disp10                   10  
  /////////////////////// --LCD-- /////////////////////////////
  #define     Duty4                    0                   // 1/2 Duty
  #define     IRCCLK_1M                1                   // IRCCLK 1M
  ///////////////////////// --RTC-- ///////////////////////////////
  #define     T_100ms                  1                
  #define     T_200ms                  T_100ms*2
  #define     T_300ms                  T_100ms*3
  #define     T_400ms                  T_100ms*4
  #define     T_500ms                  T_100ms*5
  #define     T_600ms                  T_100ms*6
  #define     T_700ms                  T_100ms*7
  #define     T_800ms                  T_100ms*8
  #define     T_1s                     T_100ms*10 
  #define     T_1_5s                   T_100ms*15
  #define     T_2s                     T_1s*2
  #define     T_2_5s                   T_100ms*25
  #define     T_3s                     T_1s*3
  #define     T_4s                     T_1s*4
  #define     T_5s                     T_1s*5
  #define     T_6s                     T_1s*6
  #define     T_8s                     T_1s*8
  #define     T_9s                     T_1s*9
  #define     T_10s                    T_1s*10
  #define     T_15s                    T_1s*15
  #define     T_20s                    T_1s*20
  #define     T_40s                    T_1s*40
  #define     T_1min                   T_1s*60
  #define     T_2min                   T_1s*120
  #define     T_5min                   T_1s*300
  #define     T_6min                   T_1s*360  
    
  ///////////////////////// --CAN-- ///////////////////////////////
  #define     SJW_1Tq                  0
  #define     SJW_2Tq                  1
  #define     SJW_3Tq                  2
  #define     SAMP_1                   0
  #define     Seg1_11Tq                10
  #define     Seg1_12Tq                11
  #define     Seg1_8Tq                 7
  #define     Seg2_7Tq                 6
  #define     Seg2_8Tq                 7
  #define     Seg1_3Tq                 2
  #define     Seg1_4Tq                 3
  #define     Seg1_5Tq                 4
  #define     Seg1_6Tq                 5
  #define     Seg2_1Tq                 0
  #define     Seg2_2Tq                 1
  #define     Seg2_3Tq                 2
  #define     Seg2_4Tq                 3
  #define     IDAM_2_32Bit             0
  #define     IDAM_4_16Bit             1
  #define     IDHIT0                   0
  #define     empoty                   0
  #define     msg_full                 1
  #define     bit0_mask                1
  #define     bit1_mask                2
  #define     bit2_mask                4
  #define     bit3_mask                8
  #define     bit4_mask                16
  #define     bit5_mask                32
  #define     bit6_mask                64
  #define     bit7_mask                128
  #define     GET_EXTPGN(id)         (((((((INT32U)id&0xFF0000)>>16) >= 0xF0)?((INT32U)id & 0x00FF00):0)|((INT32U)id & 0x2FF0000)) >> 8)
  //    
  #define     success         1
  #define     failt           0 
  #define     ON                       1
  #define     OFF                      0
  //
  #define     IDF004                    0xF004
  #define     IDFEEE                    0xFEEE
 // #define     IDFECA                    0xFECA      lzs--ahan
  #define     IDFEFF                    0xFEFF
  #define     IDFEE4                    0xFEE4
  #define     IDFF08                    0xFF08
  #define     IDFE56                    0xFE56
  #define     IDFE40                    0xFE40
//  #define     IDFF0A                    0xFF0A       lzs--shan--
//  #define     IDFF04                    0xFF04       lzs--shan--
  #define     IDF001                    0xF001
  #define     IDFEEF                    0xFEEF
  #define     PGN60416                  60416
  #define     PGN60160                  60160 
  //  
  #define DS_MASK   0x03
  #define DS0_MASK	0x01
  #define DS1_MASK	0x02
  #define	LCD_MASK	0x04
  #define	YALM_MASK	0x08  
  #define MAX_DS_ID   50
  #define STATEMASK      0x03    //mask of bDSTable
  #define ID_WIF        0     //油水分离
  #define	ID_HEAT   		1     //预热
  #define	ID_EWLAMP		  2     //发动机黄灯
  #define	ID_EWLAMPBlink1		  31     //发动机黄灯 闪烁 1hz
  #define	ID_EWLAMPBlink2		  32     //发动机黄灯 闪烁 2hz
  #define	ID_EWLAMP1	  20    //OBD
  #define	ID_EWLAMP1Blink1	  29    //OBD 闪烁 1hz
  #define	ID_EWLAMP1Blink2	  30    //OBD 闪烁 2hz
  #define	ID_ESLAMP		  3     //发动机红灯
  #define	ID_LTRN	    	4		  //left turn
  #define	ID_RTRN		    5	  	//right turn
  #define	ID_FFOG		    6	  	//front fog 
  #define	ID_ABS		    7		  //
  #define	ID_SAFEBELT		8		  //
  #define	ID_OBDH		    9		  //
  #define	ID_OBDL   		10		  
  #define	ID_ADBLUE   	11    //尿素
  #define	ID_OBD      	12
  #define ID_GPRL1      13   //气压低
  #define ID_GPRL2      14   //气压低
  #define ID_GPRL       15   //气压低
  #define ID_CTMP       16   //水温
  #define ID_VEHSPD     17   //车速报警
  #define ID_MOTSPD     18   //转速速报警
  #define ID_FUELLOW    19   //燃油低报警
  #define ID_DRIVERLAMP  21   //驾驶员灯(黄)
  #define ID_DrivRLAMP  33   //驾驶员灯(红)
  #define ID_DrivR2hzLAMP  34   //驾驶员灯(红)
  #define ID_HOUTPUTTEMP 22   //高排温度报警
  #define ID_HOUTPUTTEMPBlink 23   //高排温度报警 闪
  #define ID_DPFLAMP     24   //DPF 灯
  #define ID_DPFRLAMP     35   //DPF 灯 红
  #define ID_CRUISELAMP  25   //巡航 灯
  #define ID_HOUTPUTTEMPRed  26   //高排温度报警 red
  #define ID_DPFLAMPBlink     27   //DPF 闪
  #define ID_DPFForbit     28   //DPF禁止再生
  #endif /* API_DEF_H_ */
