/*
 * Var_Type.h
 *
 *  Created on: 2012-3-23
 *      Author: qitiancun
 */

#ifndef VAR_TYPE_H_
#define VAR_TYPE_H_

    #define             ADEveLen        8
    #define             FreEveLen       8
    
    typedef             unsigned char   INT8U;
    typedef   volatile  unsigned char   VINT8U;
    typedef             unsigned int    INT16U;
    typedef   volatile  unsigned int    VINT16U;
    typedef             unsigned long   INT32U;
    
       
    typedef struct                               //AD值平滑数组
    {        
        INT16U      FuelEven[ADEveLen];
        INT16U      KeyEven[ADEveLen];
        INT16U      VehEven[ADEveLen];
        INT16U      RevEven[ADEveLen];
        INT16U      QY1Even[ADEveLen];
        INT16U      QY2Even[ADEveLen]; 
        INT16U      ClutchEven1[ADEveLen];//glz--20170519 
        INT16U      ClutchEven2[ADEveLen];//glz--20170519 
        INT16U      FuelCalEven[10];       
        //INT16U      FRecord[10]; 
        //INT8U       PosRecord[4];                 
        INT16U      FuelVal[10];
        INT8U       pFuelVal; 
        INT8U       pFuelCal;                   
        INT8U       pFuel;
        INT8U       pQY1;
        INT8U       pQY2;
        INT8U       pKey; 
        INT8U       pClutch1;//glz--20170519 
        INT8U       pClutch2;//glz--20170519
        INT8U       pRev;
        INT8U       pVeh;   
        INT8U       FuelCn; 
        INT8U       pPos;
        INT8U       FuelADTime;   
        INT8U       KeyOffCn; 
        INT8U       KeyOnCn;       
    }ADEve;
    
    typedef union 
    {
         struct
         {
              //1 word
              INT8U     AccSaveState:1;                                              
              INT8U     CheckState:1;                              
              INT8U     TempFlash:1;
              INT8U     RS232RV_Full:1;
              INT8U     TempFlashEn:1;              
              INT8U     TempLedEn:1;              
              INT8U     FuelLedEn:1;                           
              INT8U     FuelFlashEn:1;
              
              INT8U     TempMeterInit:1;
              INT8U     FuelMeterInit:1;
              INT8U     TempStar:1;
              INT8U     FuelStar:1;
              INT8U     AdjEnable:1;              
              INT8U     SysOffEn:1;              
              INT8U     SerClrEn:1;             
              INT8U     Reserved0:1;
              
              INT8U     Reserved1:1;
              INT8U     Reserved2:1;
              INT8U     Reserved3:1;
              INT8U     Reserved4:1;
              INT8U     RevStarEn:1;              
              INT8U     BeepProcEn:1;
              

         }FlagBits;
         INT8U FlagArry[3];
    }CarFlagType;
        
   	typedef struct
  	{
  		INT8U  Frame_Head[2];      //数据帧头
  		INT8U  Frame_Check;     //校验字
  		INT8U  Frame_Type;      //数据帧类型
  		INT8U  Dir;
  		INT8U  Bak2;
  		INT8U  Frame_Len;
  		INT8U  Frame_Data[33];
  		INT8U  Frame_CheckSun;
  		INT8U  Frame_END[2];
  	}SciFrameType;
 
    typedef struct  //                          
    {
        INT8U       bFlag;
        INT16U      VehRadio;    //
        INT16U      VehNum;    //
        INT16U      RevRadio;    //
        INT8U       bCheckSun;      
    }RadioMeter;
    
    typedef union 
    {
        struct
        {
            INT16U d16H;
            INT16U d16L; 
        }dw;
        INT32U dw32;
    }ULONG;           
      
    typedef struct  //35 byte                             
    {
        INT8U       bFlag;
        INT8U       bVirtualVal;     //有效刻度
        INT16U      Resistor[8];    //电阻值
        INT16U      DashStep[8];    //步数
        INT8U       bCheckSun;                    //44      校验字节    
    }EE_MeterType;
    
    typedef struct                             
    {
        INT8U       MotorReset;         //
        INT8U       ZeroStep;
        INT8U       Dir;             //方向
        INT8U       MakeZero;  
        INT8U       bPhase;                                                 
        INT16U      Time;
        INT16U      DelayTime;
        INT8U       CalTime;
        INT16U      BoardVal;     
        INT16U      CurBoardVal;     //当前实际值 
        INT16U      OldBoardVal;          
        INT16U      CurPosition;     //当前步数
        INT16U      DestPosition;    //目标地址
        INT16U      OldPosition;               
    }MeterPos;
    
    typedef struct                             
    {
		    INT16U         PushTime;    //清零按键时间判断
		    INT8U          OldMainMenu;   //按键事件
		    INT8U          MainMenu;   //按键事件 
		    INT8U          SubMenu0;
		    INT8U          SubMenu1;
		    INT8U          SubMenu2;
		    INT8U          SubMenu3;
		    INT8U          SubMenu4;
		    INT8U          Valid;		     
		    INT8U          Valid1;
		    INT8U          Valid2;
		    INT8U          Valid3;
		    INT8U          Valid4;
		    INT16U         PushTime1;
		    INT8U          SerKmTime;		    
		    INT8U          CheckDispOk;
		    INT8U          DelayTime; 
		    INT8U          FlashCn;
		    INT8U          FlashEn;
		    INT16U         PushTime2;
		    INT16U         PushTime3;
		    INT16U         PushTime4;
		    INT8U          SET_TIME;
		    INT8U          JUMP;
		    INT8U          button_up_flag;
    }KeyType;
        
    typedef struct                             
    {
        INT8U         InitTempTime;
        INT8U         InitFuelTime;
        INT8U         InitVehTime;
        INT8U         InitRevTime;   
        INT8U         InitDispTime;              
    }InitType;   
    
    typedef struct
    {
         INT8U     bDat[256];
         INT16U    wSectorStartAdd;
         INT16U    wBlockAdd;
    }tDFlashBuff;
    
    typedef struct
    {
         INT16U    wSectorStartAdd;
         INT16U    wBlockAdd;
    }tBuffAdd;
    
    
    typedef struct
    {
         INT8U    isFlash;  //是否闪烁
         INT8U    is2hzFlash;
         INT8U    isHFlash;  //闪烁
         INT8U    isMFlash;  //闪烁
         INT8U    DriverLampFlash;
         INT8U    FlashCn;  //
         INT8U    TEnable10;
         INT16U   OverTime10;    //定时极限
         INT16U   Time10;          
         INT8U    TEnable9;
         INT16U   OverTime9;    //定时极限
         INT16U   Time9;         
         INT8U    TEnable8;
         INT16U   OverTime8;    //定时极限
         INT16U   Time8;
         INT8U    TEnable7;
         INT16U   OverTime7;    //定时极限
         INT16U   Time7;
         INT8U    TFuel_1Enable;
         INT16U   OverFuel_1Time;    //定时极限
         INT16U   Fuel_1Time;
         
         INT8U    TFuelEnable;
         INT16U   OverFuelTime;    //定时极限
         INT16U   FuelTime;
                  
         INT8U    TEnable5;
         INT16U   OverTime5;    //定时极限
         INT16U   Time5;
         INT8U    TEnable4;
         INT16U   OverTime4;    //定时极限
         INT16U   Time4;
         INT8U    TEnable3;
         INT16U   OverTime3;    //定时极限
         INT16U   Time3;
         INT8U    TEnable2;
         INT16U   OverTime2;    //定时极限
         INT16U   Time2;
         INT8U    TEnable1;
         INT16U   OverTime1;    //定时极限
         INT16U   Time1;  
         INT8U    TEnable0;
         INT16U   OverTime0;    //定时极限
         INT16U   Time0;    
         INT8U    HalfSeconds; //1/10秒             
         INT8U    Seconds;
         INT8U    Minutes;
         INT8U    Hours;
    }ClockType;
    
    typedef struct 
    { 
        INT8U       Checkflag;   
        INT32U      LongAccKm;
        INT16U      ShortAccKm; 
        INT16U      RemnantPulse;    //剩余脉冲
        INT16U      ClrCnt;      //
        INT32U      FuelPulse;
        INT8U       bCheckSun;       //检查和 
        
    }RegisterType; 
       
    typedef struct 
    {
        INT8U       CurEEAccddr;       
        INT8U       bCheckSun;       //检查和 
    }AccddrType;
     
    typedef struct                             
    {
        INT32U         CyclH;
        INT32U         CyclL;
        INT32U         Cycl; 
        INT32U         Cycle[FreEveLen];
        INT8U          pCycle;
        INT16U         Frequency;
        INT16U         CurFre;           
    }FreType;  

    typedef union 
    {
        struct
        {
            INT8U d8H;
            INT8U d8L; 
        }di16;
        INT16U di;
    }two_int8u; 
    
    typedef struct                             
    { 
        INT16U         GearState;  
    }GearType;
    
    typedef struct                             
    {
        INT8U          AmendDir;
        INT32U         V0;    
    }AmendADType;
    typedef struct                             
    {
        INT8U          Prio;
        INT16U         OnTime;
        INT16U         OffTime;
        INT16U         SumTime;
        INT8U          BeepCn; 
        INT8U          CurBeepCn; 
        INT16U         BeepTime;  
        INT16U         BeepOK;          
    }BeepType;  
    
    
    typedef struct                             
    {
        INT8U      ReceiveType;
    }CommType; 
     
    typedef union                              
    {
        struct
        {                                                                            
           INT8U FL_Door_Ajar:1;
           INT8U FR_Door_Ajar:1;
           INT8U RL_Door_Ajar:1;
           INT8U RR_Door_Ajar:1; 
           INT8U Trunk_Release:1;  
           INT8U Position_Lamp:1;
           INT8U F_Fog:1; 
           INT8U High_Beam:1;
                                 
           INT8U R_Fog:1; 
           INT8U L_Trun:1; 
           INT8U R_Trun:1;          
           INT8U Blinking:1;
           INT8U Blink2hz:1;
           INT8U Reserved4:1;
           INT8U Reserved5:1;
           INT8U Reserved6:1;                     
                     
        }bits;
        INT8U  status[2];
    }BcmType;
    
    typedef struct                             
    {
        INT8U LValid;
        INT8U CValid;
        INT8U RValid;
            
        INT16U LData;
        INT16U CData;
        INT16U RData;
        INT16U LRange;
        INT16U CRange;
        INT16U RRange;
    }RadarType; 
    
    typedef struct                             
    {
        INT8U RevOk;
        INT8U sync;
        INT8U id;
        INT8U data[8];
        INT8U CheckSum;        
    }LinMsgType;
    
    typedef struct                             
    {
        INT32U CyclH;
        INT32U CyclL;
        INT16U Duty;
    }LightType;
    
    typedef struct                             
    {
        INT32U CyclH;
        INT32U CyclL;
        INT32U Cycl;
        INT16U Frequency;
    }TempType;
        
    typedef struct                             
    {
        INT16U AveFuel;
        INT16U CurFuel;
        INT16U DriKm;
        INT16U FreCnt;
        INT16U Frequency;
        INT8U  FreTime;
        INT8U  CurTime;
        INT8U  CurDispTime;
    }FuelType;
    
    typedef struct                             
    {
        INT8U    Checkflag;   
        INT8U    Count;
        INT8U    Reserved;
        INT8U    bCheckSun;       //检查和                         
    }SerKmType;
    
    typedef struct                             
    {

        INT8U    isFlash; 
        INT8U    LedTime;                  
        INT8U    CheckTime;     
        INT8U    OilLedTime; 
        INT8U    OilBzStTime; 
        INT8U    OilBzTime;
        INT8U    OilFlash;   
        INT8U    FuelCkOff;         
        INT8U    DoorFresh; 
        INT8U    StopBreakTime; 
        INT8U    DangweiTime;
        INT8U    StopScaleTime;               
    }LedType; 
       
    typedef struct 
    { 
        INT8U       Checkflag;   
        INT32U      VehLimit;
        INT16U      ShortAccKm; 
        INT16U      RemnantPulse;    //剩余脉冲
        INT16U      Dis100Km;      //发动机累计工作时间
        INT32U      FuelPulse;
        INT8U       bCheckSun;       //检查和 
        
    }VehAlrType;   
    
    typedef struct 
    {
        INT8U        LTrunTime;
        INT8U        RTrunTime; 
        INT8U        LTrunState;
        INT8U        RTrunState;
    }TrunType;
     
 typedef  union
 {
  INT8U bbyte; 
  struct 
  {
     INT8U bib0 :2;
     INT8U bib1 :2;
     INT8U bib2 :2;
     INT8U bib3 :2;
  } bbib;
} bINT8U;   
    typedef struct
    {
        INT8U ProceF;  //处理标志位
        bINT8U Data[8];
    }__RevCanMsg;
    
 typedef  union{
  byte bbyte; 
  struct {
     INT8U a0 :1;
     INT8U a1 :1;
     INT8U a2 :1;
     INT8U a3 :1;
     INT8U a4 :1;
     INT8U a5 :1;
     INT8U a6 :1;
     INT8U a7 :1;
  } bbit;
} LCD_RAMTYPE;
    typedef struct
    {
        INT8U   ExistF004 :1; 
        INT8U   ExistFEEE :1;
        INT8U   ExistFECA00 :1;
        INT8U   ExistFEFF :1;
        INT8U   ExistFEE4 :1;
        INT8U   ExistFF08 :1;
        INT8U   ExistFE5600 :1;
        INT8U   ExistFE563D :1;        
        
        INT8U   ExistFE40 :1;        
    //    INT8U   ExistFF0A :1;       lzs--shan--
    //    INT8U   ExistFF04 :1;       lzs--shan
        INT8U   Exist0CF00300 :1;
        INT8U   ExistF001 :1; 
        INT8U   ExistECFF00:1;
        INT8U   ExistEBFF00:1;
        INT8U   ExistFECA3D:1;
        INT8U   ExistFD7C:1; 
        INT8U   ExistE0FF00:1;
        
        INT8U   ExistFEF1:1; 
        INT8U   ExistFEF200:1; 
        INT8U   ExistFEEF:1; 
        //INT8U   Exist18ECFF00:1;
        //INT8U   Exist18EBFF00:1;         
        INT8U   ExistFEBF0B:1; 
        INT8U   ExistFD0700:1;
        
        //---lzs--jia--
        INT8U   Exist18FEFF00:1;  //--驾驶员警告--潍柴报文--   
       // INT8U   Exist18FECA10:1;  //--驾驶员警告--玉柴报文--  
        INT8U   Exist1CFFBE18:1;  //T-BOX
        INT8U   Exist5F2:1;       
    } __Signal;  
    
    typedef struct
    {      
        INT8U   Can452Time;
        INT8U   Can430Time;     
        INT8U   BusOffTime; 
        INT8U   BusOffCn;       
        INT8U   IDFEEETime;
        INT8U   IDFEEECn;         
        INT8U   IDFECA00Time;
        INT8U   IDFECA00Cn; 
        INT8U   IDFECA3DTime;
        INT8U   IDFECA3DCn;        
        INT8U   IDFEFFTime;
        INT16U  IDFEFFCn;        
        INT8U   IDFF08Time;
        INT8U   IDFF08Cn;
        INT8U   IDFE5600Time;
        INT8U   IDFE5600Cn;   
        INT8U   IDFE563DTime;
        INT8U   IDFE563DCn; 
        /*INT8U   ID18ECFF00Time;//多包广播
        INT8U   ID18ECFF00Cn;
        INT8U   ID18EBFF00Time;//多包广播数据
        INT8U   ID18EBFF00Cn;*/                            
        INT8U   IDF004Time;
        INT8U   IDF004Cn; 
        INT8U   IDFEE4Time;
        INT8U   IDFEE4Cn;               
        INT8U   IDFE40Time;
        INT8U   IDFE40Cn;
      // INT8U   IDFF0ATime;      lzs--shan
      // INT8U   IDFF0ACn;        lzs--shan
      // INT8U   IDFF04Time;      lzs--shan
      // INT8U   IDFF04Cn;        lzs--shan
        
        INT8U   ID0CF00300Time;
        INT8U   ID0CF00300Cn;
        INT8U   IDFEF200Time;
        INT8U   IDFEF200Cn;
        INT8U   IDFEEFTime;
        INT8U   IDFEEFCn;
        INT8U   IDFEBF0BTime;
        INT8U   IDFEBF0BCn;  
        INT8U   IDFD0700Time;      
        INT8U   IDFD0700Cn;         
        //
        INT8U   Can18FF4AEFTime;
        INT16U  Can18FEF117Time;
        INT8U   Can18FEAE17Time;
        INT8U   Can18FE6C17Time;
        INT8U   CanCFE6CEETime;
        INT8U   Can18FF0D17Time;
        INT16U  Can18FFB317Time;
        INT16U  Can49ETime;                                                           

        INT8U   IDF001Time;
        INT8U   IDF001Cn;
        INT8U   IDDropTime;
        INT8U   IDFD7CCn; 
        INT8U   IDE0FF00Cn;
        INT8U   IDFEF1Cn;   
        //--lzs--jia--
        INT8U   ID18FEFF00Cn;     //驾驶员警告灯--潍柴报文。
        INT8U   ID1CFFBE18Cn;
        
        INT8U   ID18FEFF00Time;
        INT8U   ID1CFFBE18Time;
   //     INT8U   ID18FECA10Cn;     //驾驶员警告灯--玉柴报文。
   //     INT8U   ID18FECA10Time;
        INT8U   ID5F2Cn;
        INT8U   ID5F2Time;   
        
        __Signal Signal;                                                                  
    } __CanClk;
      typedef struct
    {      
        INT8U   SetTime;
        INT8U   SetRatioTime;     
        INT8U   ClrTripTime;
        INT8U   ClrAdBlueTime; 
                                     
    }__MeuClk;
  typedef union
  {
      struct
      {
          INT8U bit0 :1;
          INT8U bit1 :1;
          INT8U bit2 :1;
          INT8U bit3 :1;
          INT8U bit4 :1;
          INT8U bit5 :1;
          INT8U bit6 :1;
          INT8U bit7 :1;
      }bits;
      INT8U data;
  }_byte;
    
  typedef struct
  {
      INT16U     duty;
      INT16U     cycle;      
      _byte      code;
      INT8U      AdjEn;
  }_Encode ;
  
   typedef struct                               
  {
     INT32U      id;
     INT8U       msg[8];
     INT8U       dlc;                    
  }_SendCanMsg;
  
  typedef struct
  {//7 bytes
    INT16U wPGN;      //打包消息的参数组编号
    INT8U  bPackage;  //全部数据包的数
    INT8U  bLength;   //整个消息大小的字节数
    INT8U  bCtrByte;  //控制字节
    INT8U  bRcvInfoFlg;   //有效接收标志，接收到该报文=1
    INT8U  bRcvBusy;    // 本标志位有效，表明正在接收多包信息。
    INT8U  bPrePckNum;   //上一个包序号
    INT8U  bBuf[MAX_MULCANDATALEN];//多包信息缓冲区
  } MULCANMSG;  
  typedef struct
  {//5 bytes
    INT8U   bFMI;
    INT32U  dwSPN;
    INT8U   Err;
  } DTC;  
        
        
        
        
        
        
                                               
#endif /* VAR_TYPE_H_ */
