#define       GLOBALS_MOTOR
#include "../App_Headers/includes.h"


//-----------------------------------------------------------------------------
//    :    Api_Motor_Init
//    :    ʼ
//        :    
//                 *Motor    ->   ṹָ
//        :    
// ֵ     :    ״̬
//        :        1280   жƵ25000
//-----------------------------------------------------------------------------
void  Api_Motor_Init(void)
{
    INT16U         *w;
    INT8U          Nub;

    MCCTL0_MCPRE        = Fbus;            //ʱΪߵ1Ƶ
    MCCTL0_MCSWAI       = Enable;          //ֹͣģʽֹͣ 
    MCCTL0_FAST         = Disable;         //11bitֱ
    MCCTL0_DITH         = Disable;         //PER-> P10-P0   0:P0
    MCCTL0_MCTOIF       = ClearFlag;       //жϱ־
    MCCTL1_RECIRC       = True;            //
    MCCTL1_MCTOIE       = Enable;          //ʹж
    MCPER               = InitMCPER;       //PWM
    //
    MCCC0_MCOM          = FHBM;            //˫ȫHģʽ
    MCCC0_MCAM          = Enable;          //
    MCCC0_CD            = Disable;         //ֹʱ
    MCCC1_MCOM          = FHBM;            //ȫHģʽ
    MCCC1_MCAM          = Enable;          //
    MCCC1_CD            = Disable;         //ֹʱ
    //
    MCCC2_MCOM          = FHBM;;            //˫ȫHģʽ
    MCCC2_MCAM          = Enable;          //
    MCCC2_CD            = Disable;         //ֹʱ
    MCCC3_MCOM          = FHBM;             //ȫHģʽ
    MCCC3_MCAM          = Enable;          //
    MCCC3_CD            = Disable;         //ֹʱ

    
    MCCC4_MCOM          = FHBM;         
    MCCC4_MCAM          = Enable;         
    MCCC4_CD            = Disable;         
    MCCC5_MCOM          = FHBM;          
    MCCC5_MCAM          = Enable;       
    MCCC5_CD            = Disable;       
    
    
    MCCC6_MCOM          = FHBM;            //˫ȫHģʽ
    MCCC6_MCAM          = Enable;          //
    MCCC6_CD            = Disable;         //ֹʱ
    MCCC7_MCOM          = FHBM;            //ȫHģʽ
    MCCC7_MCAM          = Enable;          //
    MCCC7_CD            = Disable;         //ֹʱ
    
    w = &MCDC0;                            //ʼMCOC 0-7
         
    for(Nub = 0;Nub < 8 ;Nub++)
    {
         *(w + Nub) = 0;         
    }
}
//-----------------------------------------------------------------------------
//    :    Api_Motor_Drive
//    :    
//        :    
//        :    
// ֵ     :    
//        :    
//-----------------------------------------------------------------------------
void Api_Motor_Drive(MeterPos *M,INT8U M_sel)
{    
    switch(M_sel)
    {
        case EngineMotorNub:
            if(M->Time > null)
                M->Time --;
            if(M->Time == null)
            {
                if(M->CurPosition > M->DestPosition)
                {
                    M->Time = 2000/(M->CurPosition - M->DestPosition);                    
                    M->Dir = widdershins; 
                }
                else if(M->CurPosition < M->DestPosition)
                {
                    M->Time = 2000/(M->DestPosition - M->CurPosition);
                    M->Dir = clockwise;
                }
                else
                {
                    M->Dir = keep_local;
                }
                if(M->MotorReset == Enable)
                {
                    M->Dir = widdershins;
                }
                if((M->Time <= 7)||(Curkeyinput == KeyOFF)||(M->MotorReset == Enable))
                    M->Time = 7; 
                
                if(M->Time >= 170)
                    M->Time = 170; 
                
                if(M->Dir == clockwise)
                {
                    if(M->CurPosition < M->DestPosition)
                    {
                        M->CurPosition++; 
                    }                         
                    M->bPhase ++;
                    if(M->bPhase >= TabNub)
                       M->bPhase = null;                                                 
                }
                else
                {
                    if(M->Dir == widdershins)
                    {
                        if(RevZero != reset)
                        {
                            if(M->bPhase == null)
                                M->bPhase = TabNub;
                            if(M->bPhase > null)
                                M->bPhase --;  
                        } 
                        if(M->CurPosition > M->DestPosition)
                            M->CurPosition--;                   
                    }                                                       
                }
                MCDC1 = Sin[M->bPhase];
                MCDC0 = Cos[M->bPhase];
             }
             break;
        case VehMotorNub:
            if(M->Time > null)
                M->Time --;
            if(M->Time == null)
            {
                if(M->CurPosition > M->DestPosition)
                {                                                            
                    if(M->CurBoardVal < 40)
                    {
                        M->Time = 2300/(M->CurPosition - M->DestPosition);
                    } 
                    else
                    {
                        M->Time = 3200/(M->CurPosition - M->DestPosition);
                    }
                    M->Dir = widdershins; 
                }
                else if(M->CurPosition < M->DestPosition)
                {
                    M->Time = 3800/(M->DestPosition - M->CurPosition);
                    M->Dir = clockwise;
                }
                else
                {
                    M->Dir = keep_local;
                }
                if(M->MotorReset == Enable)
                {
                    M->Dir = widdershins;
                }
              
                if((M->Time <= 7)||(Curkeyinput == KeyOFF)||(M->MotorReset == Enable))
                    M->Time = 7; 

                if(M->Time >= 185)
                    M->Time = 185;               

                if(M->Dir == clockwise)
                {
                    if(M->CurPosition < M->DestPosition)
                    {
                        M->CurPosition++; 
                    } 
                    M->bPhase ++;
                    if(M->bPhase >=TabNub)
                       M->bPhase = null;                                                 
                }
                else
                {
                    if(M->Dir == widdershins)
                    {
                        if(VehZero != reset)
                        {                        
                            if(M->bPhase == null)
                                M->bPhase = TabNub;
                            if(M->bPhase > null)
                                M->bPhase --;
                        }
                        if(M->CurPosition > M->DestPosition)
                            M->CurPosition--;                   
                    }                                                      
                }
                MCDC7 = Sin[M->bPhase];
                MCDC6 = Cos[M->bPhase];
             }
             break;

        case FuelMotorNub:
            if(M->Time > null)
                M->Time --;
            if(M->Time == null)
            {
                if(M->CurPosition > M->DestPosition)
                {
                    //M->Time = 9000/(M->CurPosition - M->DestPosition);
                    //M->Time = FuleSpeed;                    
                    M->Dir = widdershins; 
                }
                else if(M->CurPosition < M->DestPosition)
                {
                    //M->Time = 9000/(M->DestPosition - M->CurPosition);
                    //M->Time = FuleSpeed;
                    M->Dir = clockwise;
                }
                else
                {
                    M->Dir = keep_local;
                }
                if(M->MotorReset == Enable)
                {
                    M->Dir = widdershins;
                }
                if((M->Time <= 7)||(Curkeyinput == KeyOFF)||(M->MotorReset == Enable))
                    M->Time = 7; 
                
                //if(M->Time >= 170)
                    M->Time = FuleSpeed; 
                
                if(M->Dir == clockwise)
                {
                    if(M->CurPosition < M->DestPosition)
                    {
                        M->CurPosition++; 
                    }                         
                    M->bPhase ++;
                    if(M->bPhase >= TabNub)
                       M->bPhase = null;                                                 
                }
                else
                {
                    if(M->Dir == widdershins)
                    {
                        if(YB_ZERO_IN != reset)
                        {
                            if(M->bPhase == null)
                                M->bPhase = TabNub;
                            if(M->bPhase > null)
                                M->bPhase --;  
                        } 
                        if(M->CurPosition > M->DestPosition)
                            M->CurPosition--;                   
                    }                                                       
                }
                MCDC5 = Sin[M->bPhase];
                MCDC4 = Cos[M->bPhase];
             }
              break;
        case TempMotorNub:
            if(M->Time > null)
                M->Time --;
            if(M->Time == null)
            {
                if(M->CurPosition > M->DestPosition)
                {
                    //M->Time = 9000/(M->CurPosition - M->DestPosition); 
                    //M->Time = 170;                    
                    M->Dir = widdershins; 
                }
                else if(M->CurPosition < M->DestPosition)
                {
                    //M->Time = 9000/(M->DestPosition - M->CurPosition);
                    //M->Time = 170;
                    M->Dir = clockwise;
                }
                else
                {
                    M->Dir = keep_local;
                }
                if(M->MotorReset == Enable)
                {
                    M->Dir = widdershins;
                }
                if((M->Time <= 7)||(Curkeyinput == KeyOFF)||(M->MotorReset == Enable))
                    M->Time = 7; 
                
                //if(M->Time >= 170)
                    M->Time = TempSpeed; 
                
                if(M->Dir == clockwise)
                {
                    if(M->CurPosition < M->DestPosition)
                    {
                        M->CurPosition++; 
                    }                         
                    M->bPhase ++;
                    if(M->bPhase >= TabNub)
                       M->bPhase = null;                                                 
                }
                else
                {
                    if(M->Dir == widdershins)
                    {
                        if(Tem_ZERO_IN != reset)
                        {
                            if(M->bPhase == null)
                                M->bPhase = TabNub;
                            if(M->bPhase > null)
                                M->bPhase --;  
                        } 
                        if(M->CurPosition > M->DestPosition)
                            M->CurPosition--;                   
                    }                                                       
                }
                MCDC3 = Sin[M->bPhase];
                MCDC2 = Cos[M->bPhase];
             } 
              break;                                
        default:
             ;
    }
}
//-----------------------------------------------------------------------------
//    :    Api_Motor_isr
//    :    PWMж
//        :    
//        :    
// ֵ     :    
//        :    
//-----------------------------------------------------------------------------
#pragma CODE_SEG NON_BANKED 
interrupt void Api_Motor_isr(void)
{
    static    INT8U     bState;
    
    if(bState >  TempMotorNub)
    {
         bState = null;
    }
    
    switch(bState)
    {
                
         case VehMotorNub:
         {
              Api_Motor_Drive((MeterPos*)&VehMeter,VehMotorNub);
              break;
         }
              

         case EngineMotorNub:
         {
              Api_Motor_Drive((MeterPos*)&RevMeter,EngineMotorNub);
              break;
         }
         case FuelMotorNub:
         {
              Api_Motor_Drive((MeterPos*)&FuelMeter,FuelMotorNub);
              break;
         }
        case TempMotorNub:
         {
              Api_Motor_Drive((MeterPos*)&TempMeter,TempMotorNub);
              break;
         }
         default:
         ;
    }

    bState++;
    MCCTL0_MCTOIF       = ClearFlag;       //жϱ־
}
#pragma CODE_SEG DEFAULT 
