#define  GLOBALS_API_SCI
#include "../App_Headers/includes.h"

/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Init
* Description    : SCIģʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_SCI_Init(void)
{  
    SCISR2_AMAP = Disable;
    SCICR1_LOOPS   = Disable;   //ģʽ
    SCICR1_SCISWAI = Disable;    //ʹܵȴģʽ
    SCICR1_M       = Disable;   //8 byte ģʽ
    SCICR1_WAKE    = Enable;    //Adrress Wake
    SCICR1_PE      = Disable;   //ֹУ
    SCISR1_RDRF    = Disable;
    
    SCISR2_BRK13 = !Enable; //14bit break    
    SCISR2_AMAP = Disable;
                
    SCIBDH_TNP     = div4;
    SCIBDH_IREN    = Disable;   //ֹ
    SCIBD_SBR      = baud_9600;
    
    SCICR2_TIE  = Disable;
    SCICR2_TCIE = Disable;
    SCICR2_ILIE = Disable;
    SCICR2_RE  = Enable;    //ʹܽ
    SCICR2_TE  = Enable;    //ʹܷ
    SCICR2_RWU = Enable;
    SCICR2_SBK = Disable;   //
  
    SCICR2_RIE = Enable;    //ʹܽж
    
    SCISR2_AMAP = Enable;
    SCIACR2_BKDFE   = Enable;   //ʹܶϵ·
    SCIACR2_BERRM   = 0;    
    SCIACR1_BERRIE  = Disable;  //λ
    SCIACR1_RXEDGIE = Disable;  //
    SCIACR1_BKDIE   = Enable;   //ϵʹ
    SCIASR1_BKDIF = ClearFlag; 
   
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Trans_Bytes
* Description    : ڷ
* Input          : INT8U *str,INT16U len
* Output         : None
* Return         : None
* onther         : str:ַ   len:ݳ
--------------------------------------------------------------------------*/
void Api_SCI_Trans_Bytes(INT8U *str,INT8U len)
{
    INT8U i;    
    for(i=0;i<len;i++)
    {
       Api_SCI_Trans_Byte((*str));
       str++;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Trans_Byte
* Description    : ڷ
* Input          : INT8U data
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void  Api_SCI_Trans_Byte(INT8U data)
{
    while(SCISR1_TDRE == null);
    SCIDRL = data;
    while(!SCISR1_TC);    
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Rev_isr
* Description    : ڽж
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_SCI_Rev_isr(void)
{    
    //ϵж
    if(SCIASR1_BKDIF == Enable)
    {
        Comm.ReceiveType = LIN;   
        API_SetTimer9(T_3s,(ClockType*)&Clock);    
        rvcnt = null;            
    }     
    switch(Comm.ReceiveType)
    {
      case COM:
          if(SCISR1_RDRF == Enable)
          {      
              SCIRV[rvcnt] = SCIDRL;
              rvcnt ++;    
              if((SCIRV[0]==0xEB)&&(SCIRV[1]==0x90))
              {                    
                  if(SCIRV[rvcnt-1]==0xAA)
                  {   
                      if(SCIRV[rvcnt-2]==0x55)
                      {
                          rvcnt   = null;
                          CarFlag.FlagBits.RS232RV_Full = Enable;
                          CarFlag.FlagBits.AdjEnable = Enable;
                      }
                  }       
              }
          }
          if(SCIRV[0] != 0xEB)
          {
              rvcnt = null;
          }
          if(rvcnt >= SCI_LEN) 
          {
              rvcnt = null;
          }
          break;
      case LIN:
          if(SCISR1_RDRF == Enable)
          {                    
              SCIRV[rvcnt] = SCIDRL;
              rvcnt ++;    
          }

          if(SCIRV[0] == 0x55)
          {                  
              switch(SCIRV[1])
              {
                case BCM_ID:
                    if(rvcnt == 8) 
                    {                        
                        DropTime = null;
                        rvcnt = null;
                    }
                    break;                    
                default:
                    SCIRV[1] = 0;
                    SCIRV[2] = 0;
                    SCIRV[3] = 0;
              }             
          }
          else
          {
              rvcnt = null;
              SCIRV[0] = 0;
              SCIRV[1] = 0;
              SCIRV[2] = 0;
              SCIRV[3] = 0;              
          }
          break;
    }
    SCIASR1_BKDIF = ClearFlag;      
    SCISR1_RDRF = ClearFlag;
    
}
