#define GLOBALS_API_TPM
#include "../App_Headers/includes.h"


/*-------------------------------------------------------------------------
* Function Name  : Api_Timer0_Init
* Description    : ʱ0ʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_Timer0_Init(INT8U TPM_DIV)
{       
    TIM0_TSCR1_TSWAI = !WaitRun;  //timer 0 MCUȴģʽ²
    TIM0_TSCR1_TSFRZ = Enable;    //timer 0 ڶģʽ½ֹ
    TIM0_TSCR1_TFFCA = Disable;   //־λ
    TIM0_TSCR1_PRNT  = Disable;   // 
    TIM0_TSCR2_PR    = TPM_DIV;   //Bus Clock / X
    TIM0_TSCR2_TCRE  = Disable;
    TIM0_TTOV        = Disable;
   
    TIM0_TCTL1 = Disable;        //ֹȽϹ
    TIM0_TCTL2 = Disable;
    
    TIM0_TFLG2_TOF   = ClearFlag;
    TIM0_TSCR1_TEN   = Enable;   //ʹtimer 0 
    TIM0_TSCR2_TOI   = Enable;   //жʹ
      
    TIM0_PACTL_PAEN  = Disable;        
    //ӦͨΪ벶׽Ƚ   0:벶׽     
    TIM0_TIOS_IOS6   = 0;   
    //ò׽Ϊ 
    TIM0_TCTL3_EDG6A = 1;
    TIM0_TCTL3_EDG7A = 1;        
    
    TIM0_OCPD        = 0xFF;     //ֹȽ  
    TIM0_TC6         = null;               
    //жϱ־ 
    TIM0_TFLG1_C6F   = 1;     
    //ʹ벶׽ж   
    TIM0_TIE_C6I     = 1;          
    
    TIM0_PACTL       = Disable;  
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer1_Init
* Description    : ʱ1ʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_Timer1_Init(INT8U TPM_DIV)
{     
    TIM1_TSCR1_TSWAI = !WaitRun; //timer 0 MCUȴģʽ²
    TIM1_TSCR1_TSFRZ = Enable;   //timer 0 ڶģʽ½ֹ
    TIM1_TSCR1_TFFCA = Disable;  //־λ
    TIM1_TSCR1_PRNT  = Disable;  // 
    TIM1_TSCR2_PR    = TPM_DIV;  //Bus Clock / X
    TIM1_TSCR2_TCRE  = Disable;
    TIM1_TTOV        = Disable;
   
    TIM1_TCTL1 = Disable;        //ֹȽϹ
    TIM1_TCTL2 = Disable;
    
    TIM1_TFLG2_TOF   = ClearFlag;
    TIM1_TSCR1_TEN   = Enable;   //ʹtimer 0 
    TIM1_TSCR2_TOI   = Enable;   //жʹ  
    TIM1_PACTL_PAEN  = Disable; 
             
    TIM1_TIOS_IOS6   = 1;
    TIM1_TIOS_IOS7   = 0;
       
    TIM1_TCTL3_EDG7A = 1;
    TIM1_TCTL3_EDG7B = 0;
    
    TIM1_OCPD        = 0xFF;  //ֹȽ
    TIM1_TC7         = null;                  
    TIM1_TFLG1_C7F   = 1;                    
    TIM1_TIE_C7I     = 1;       
         
    TIM1_PACTL       = Disable;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer0_isr
* Description    : ʱж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_Timer0_isr(void)
{    
    if(pBeep->Prio != DisAlr)
    {
        if(pBeep->BeepTime < TT1_2_5s)
        {
            pBeep->BeepTime++;
        }
    }   
    GUI_BeepOut(); 
   
    CurLightCnt.dw.d16H++;   
    CurTempCnt.dw.d16H++;
    
    //
    if(AdblueInitTime <= 40)
    {
       AdblueInitTime ++;
    }
    
    if(QY1InitTime <= 40)
    {
       QY1InitTime ++;
    }    
    if(QY2InitTime <= 40)
    {
       QY2InitTime ++;
    }     
    if(CanClk.CanCFE6CEETime > null)
    {
       CanClk.CanCFE6CEETime --;
    }
    if (CanClk.Can49ETime > null)
    {
        CanClk.Can49ETime --;
    }  
    if(CanClk.Can18FEF117Time > null)
    {
      CanClk.Can18FEF117Time --;
    }
    if(CanClk.Can18FF0D17Time > null) 
    {
      CanClk.Can18FF0D17Time --;
    }
    if(CanClk.Can18FFB317Time > null)
    {
      CanClk.Can18FFB317Time --;
    }
    //2hz
    Clock.is2hzFlash++;
    if((Clock.is2hzFlash == TT1_250ms) || (Clock.is2hzFlash == TT1_500ms))
    {
        BcmModel.bits.Blink2hz = !BcmModel.bits.Blink2hz;
    }    
       
    ///  
    TIM0_TFLG2_TOF = ClearFlag;  //жϱ־λ
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer1_isr
* Description    : ʱж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_Timer1_isr(void)
{
    CurVehCnt.dw.d16H++;     
    TIM1_TFLG2_TOF = ClearFlag;  //жϱ־λ 
}
/*-------------------------------------------------------------------------
* Function Name  : Api_LinCap_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_LinCap_isr(void)
{
    API_SetTimer9(T_3s,(ClockType*)&Clock);
    TIM0_TFLG1_C2F = ClearFlag;        
}
/*-------------------------------------------------------------------------
* Function Name  : Api_TempCap_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_TempCap_isr(void)
{
    CurTempCnt.dw.d16L = TIM1_TC7;
    
    if(TIM1_TCTL3_EDG7B) 
    {
        if(CurTempCnt.dw32 > OldTempCnt.dw32)
        {
            TempSignal.CyclH = CurTempCnt.dw32 - OldTempCnt.dw32; 
            TempSignal.Cycl = TempSignal.CyclH + TempSignal.CyclL;
        }

        TIM1_TCTL3_EDG7B = 0;
        TIM1_TCTL3_EDG7A = 1;       
    }    
    else
    {
        if(CurTempCnt.dw32 > OldTempCnt.dw32)
        {
            TempSignal.CyclL = CurTempCnt.dw32 - OldTempCnt.dw32;
        }        
        TIM1_TCTL3_EDG7B = 1;
        TIM1_TCTL3_EDG7A = 0;        
    }

    OldTempCnt.dw32 = CurTempCnt.dw32;
    TIM1_TFLG1_C7F = ClearFlag;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_FuelCap_isr
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_FuelCap_isr(void)
{
    if(VehMeter.CurBoardVal > null)
    {
        AccKm.FuelPulse ++;
    }

    TIM1_TFLG1_C6F = ClearFlag;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_RevCap_isr
* Description    : תٲ׽ж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_RevCap_isr(void)
{
    CurRevCnt.dw.d16L = TIM0_TC7;
    
    if(CurRevCnt.dw32 > OldRevCnt.dw32)
    {
        RevFre.Cycl = CurRevCnt.dw32 - OldRevCnt.dw32;                     
    }  

    OldRevCnt.dw32 = CurRevCnt.dw32;
    TIM0_TFLG1_C7F = ClearFlag;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_VehCap_isr
* Description    : תٲ׽ж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_VehCap_isr(void)
{
    CurVehCnt.dw.d16L = TIM1_TC7;

    if(CurVehCnt.dw32 > OldVehCnt.dw32)
    {
        VehFre.Cycl = CurVehCnt.dw32 - OldVehCnt.dw32; 
    }    
    if (VehFre.Cycl > VehFreLimit)
    {                                                 
        AccPulse++;
        FreDiv4Pulse++;
    } 
   // pECU_OUT = !pECU_OUT;  
   if(2==FreDiv4Pulse)
    {
    CS_OUT=!CS_OUT;
    FreDiv4Pulse=0;
    }
    
    OldVehCnt.dw32 = CurVehCnt.dw32;
    
    TIM1_TFLG1_C7F = ClearFlag;
}