#define GLOBALS_GUI_DISP
#include "../App_Headers/includes.h"

/*-------------------------------------------------------------------------
* Function Name  : GUI_Light_Out
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_Light_Out(void)
{
    //
    if ((bDSTable[ID_LTRN] & STATEMASK) == 0x01)
    {
        ZZX_LED_P = 0;
    }
    else
    {
        ZZX_LED_P = 1;
    }
    //
    if ((bDSTable[ID_RTRN] & STATEMASK) == 0x01)
    {
        YZX_LED_P = 0;
    }
    else
    {
        YZX_LED_P = 1;
    }
    //
    if ((bDSTable[ID_FFOG] & STATEMASK) == 0x01)
    {
        BACKFOG_LED_P = 0;
    }
    else
    {
        BACKFOG_LED_P = 1;
    }

    if (Curkeyinput == KeyON)
    {
        if (Charge_CheckTimer >= 30)
        {
          if (Charge_In == 0) // 充电
          {
            if (Charge_Timer == 2)
            {
              Charge_Timer = 0;
              Charge_OUT = 1;
            }
          }
          else
          {
            Charge_OUT = 0;
            Charge_Timer = 0;
          }
        }
        else
        {
          Charge_OUT = 0;
          Charge_Timer = 0;
        }
    }
    else
    {
        Charge_Timer = 0;
        Charge_OUT = 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_LedRandomDisplay
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_LedRandomDisplay(void)
{
    GUI_LTRN_QDDPRG();
    GUI_RTRN_QDDPRG();
    GUI_FFOG_QDDPRG();
    GUI_OBDH_QDDPRG();
    GUI_OBDL_QDDPRG();
}
/*-------------------------------------------------------------------------
函数名称：GUI_LedNormalDisplay
功    能：
参    数：None
返回数值：None
使用说明：
--------------------------------------------------------------------------*/
INT8U T_BOX_Status;
INT8U T_BOX_lost;
INT16U T_BOX_time=0;
INT8U Fuel_State_keep=0;
void GUI_LedNormalDisplay(void)
{
    GUI_ZAQD_QDDPRG();
    GUI_ABS_QDDPRG();
    if (OBD_CheckTime < T_3s)
    {
        RFUEL_LEVEL_LOW = LEDON;
    }
    else
    {
        if (FuelMeter.CurPosition <= 155)
        {
            Fuel_State_keep = 1;
        }
        if (FuelMeter.CurPosition >= 189)
        {
            Fuel_State_keep = 0;
        }
        
        if (Fuel_State_keep == 1)
        {
            RFUEL_LEVEL_LOW = LEDON;
        }
        else
        {
            RFUEL_LEVEL_LOW = LEDOFF;
        }      
    }
    
    
    //气压1
    if ((QY1Meter.CurBoardVal > 10) && (QY1Meter.CurBoardVal < 950))
    {
        if ((QY1_Section >= 1) && (QY1_Section <= 5) && (InitQYFlag1 == 0))
        {
            bDSTable[ID_GPRL1] |= DS0_MASK;
            bDSTable[ID_GPRL1] &= (~DS1_MASK);
        }
        else
        {
            bDSTable[ID_GPRL1] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
        }
    }
    else
    {
        bDSTable[ID_GPRL1] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
    }
    //气压2
    if ((QY2Meter.CurBoardVal > 10) && (QY2Meter.CurBoardVal < 950))
    {
        if ((QY2_Section >= 1) && (QY2_Section <= 5) && (InitQYFlag2 == 0))
        {
            bDSTable[ID_GPRL2] |= DS0_MASK;
            bDSTable[ID_GPRL2] &= (~DS1_MASK);
        }
        else
        {
            bDSTable[ID_GPRL2] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
        }
    }
    else
    {
        bDSTable[ID_GPRL2] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
    }

    //气压报警
    if (((bDSTable[ID_GPRL1] & STATEMASK) == 0x01) || ((bDSTable[ID_GPRL2] & STATEMASK) == 0x01))
    {
        bDSTable[ID_GPRL] |= DS0_MASK;
        bDSTable[ID_GPRL] &= (~DS1_MASK);
        ZD_QIYA_OUT = 1;
    }
    else
    {
        bDSTable[ID_GPRL] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
        ZD_QIYA_OUT = 0;
    }

    //尿素
    if (bCatalystLevel > 5 && bCatalystLevel < 30)
    {
        bDSTable[ID_ADBLUE] |= DS0_MASK;
        bDSTable[ID_ADBLUE] &= (~DS1_MASK);
    }
    else
    {
        bDSTable[ID_ADBLUE] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
    }
    //
    if (((bDSTable[ID_WIF] & STATEMASK) == 0x01) || (OILWATER_In == LOW))
    {
        OILWATER_LED_P = 0;
    }
    else
    {
        OILWATER_LED_P = 1;
    }
    //
    if ((bDSTable[ID_HEAT] & STATEMASK) == 0x01)
    {
        YURE_LED_P = 1;
    }
    else
    {
        YURE_LED_P = 0;
    }

    //
    if ((bDSTable[ID_ABS] & STATEMASK) == 0x01)
    {
        ABS_LED_P = 1;
    }
    else
    {
        ABS_LED_P = 0;
    }

    //
    if ((CanClk.Signal.ExistFE563D == Enable) || (CanClk.Signal.ExistFE5600 == Enable))
    {
        if ((Adbule_Section <= 2) && (InitAdblueFlag == 0))
        {
            TLY_LED_P = 1;
        }
        else
        {
            TLY_LED_P = 0;
        }
    }
    // glz--20170519
    if ((Park_In == 0) && (LED.StopBreakTime >= T_300ms))
    {
        ParkIn_Flag = 1;
    }
    else
    {
        ParkIn_Flag = 0;
    }

    // DPF
    if ((bDSTable[ID_DPFLAMP] & STATEMASK) == 0x01)
    {
        DPF_OUT = LEDON;
    }
    else if ((bDSTable[ID_DPFLAMPBlink] & STATEMASK) == 0x01)
    {
        DPF_OUT = BcmModel.bits.Blinking;
    }
    else
    {
        DPF_OUT = LEDOFF;
    }
    // DPF红
    if ((bDSTable[ID_DPFRLAMP] & STATEMASK) == 0x01)
    {
        DPFR_OUT = LEDON;
    }
    else
    {
        DPFR_OUT = LEDOFF;
    }

    // DPF禁止再生
    if ((bDSTable[ID_DPFForbit] & STATEMASK) == 0x01)
    {
        DPFForbit_LED_P = LEDON;
    }
    else
    {
        DPFForbit_LED_P = LEDOFF;
    }
    //
    if ((bDSTable[ID_HOUTPUTTEMP] & STATEMASK) == 0x01)
    {
        HOutputTempL_OUT = 1;
    }
    /*  else if((bDSTable[ID_HOUTPUTTEMPBlink ]&STATEMASK) == 0x01)
      {

          HOutputTempL_OUT=BcmModel.bits.Blinking ;
      }   */
    else
    {

        HOutputTempL_OUT = 0;
    }
    //
    /*  if((bDSTable[ID_HOUTPUTTEMPRed ]&STATEMASK) == 0x01)
      {

          HOutputTempR_OUT = 1;
      }
      else
      {

          HOutputTempR_OUT = 0;
      } */
    //
    if ((bDSTable[ID_CRUISELAMP] & STATEMASK) == 0x01)
    {

        Cruise_OUT = 1;
    }
    else
    {

        Cruise_OUT = 0;
    }
    //
    if (OilPressure < 60)
    {
        Oil_LED_P = 1;
    }
    else
    {
        Oil_LED_P = 0; //灭
    }
    /*-----------------------------
    if(API_TimerOver3((ClockType*)&Clock))
    {
      FDJ1_LED_P = 0;
    }
    else
    {
      FDJ1_LED_P = 1;
    }
    ----------------------------*/
    if (OBD_CheckTime > T_2s)
    {
        // OBD 黄
        if ((bDSTable[ID_EWLAMP] & STATEMASK) == 0x01)
        {
            FDJ1_LED_P = LEDON;
        }
        else if (((bDSTable[ID_ESLAMP] & STATEMASK) == 0x01))
        {
            FDJ1_LED_P = LEDON;
            // FDJ2_LED_P =0;
        }

        /*  else if((bDSTable[ID_EWLAMPBlink1]&STATEMASK) == 0x01)//1hz
          {
            FDJ1_LED_P = BcmModel.bits.Blinking;
          }
          else if((bDSTable[ID_EWLAMPBlink2]&STATEMASK) == 0x01)//2hz
          {
            FDJ1_LED_P = BcmModel.bits.Blink2hz;
          } */
        else
        {
            FDJ1_LED_P = LEDOFF;
        }
        //  FDJ1_LED_P = LEDOFF;
        if (RevMeter.CurBoardVal > 400)
        {
            OBD_CheckOneFlag = 0;
        }
        // if(OBD_CheckOneFlag==0)
        // {
        // OBD
        if ((bDSTable[ID_EWLAMP1] & STATEMASK) == 0x01)
        {
            OBD_LED_P = 0; // on
        }
        else if ((bDSTable[ID_EWLAMP1Blink1] & STATEMASK) == 0x01) // 1hz
        {
            OBD_LED_P = !BcmModel.bits.Blinking;
        }
        else if ((bDSTable[ID_EWLAMP1Blink2] & STATEMASK) == 0x01) // 2hz
        {
            OBD_LED_P = BcmModel.bits.Blink2hz;
        }
        else
        {
            OBD_LED_P = 1; // off
        }
        //}
    }
    else
    {
        FDJ1_LED_P = 1;
    }
    // OBD 红 lzs--shan---

    //驾驶员灯 黄
    /* if((CanMsgFEFF.Data[1].bbyte&0x07)==0x01)
     {
         DriverLamp_OUT = LEDON;
     }
     else if((CanMsgFD0700.Data[0].bbyte&0x0c)==0x04)
     {
         DriverLamp_OUT = LEDON;
     }
     else if((CanMsgFEFF.Data[1].bbyte&0x07)==0x04)
     {
         DriverLamp_OUT = BcmModel.bits.Blinking;//1hz
     }
     else if((CanMsgEECA00.Data[1].bbyte&0x0c)==0x00)
     {
         DriverLamp_OUT = BcmModel.bits.Blinking;//1hz
     }
     else if((CanMsgEECA00.Data[1].bbyte&0x0c)==0x04)
     {
         DriverLamp_OUT = BcmModel.bits.Blink2hz;//2hz
     }                                                               
     else
     {
         DriverLamp_OUT = LEDOFF;
     }  */
    T_BOX_lost = 0; //
    if (Curkeyinput == KeyON)
    {
        if (T_BOX_time >= T_40s)
        {
            if (CanMsg1CFFBE18_On == 1)
            {
                T_BOX_lost = 0; // T-BOX:F01
            }
            else
            {
                T_BOX_lost = 1;
            }
        }
        else
        {}
    }
    
    T_BOX_Status = 0;
    if (((CanMsg18FEFF00.Data[1].bbyte & 0x38) == 0x18) || ((CanMsg18FEFF00.Data[1].bbyte & 0x38) == 0x28))
    {
        DriverLamp_OUT = LEDOFF;
        if ((CanMsg18FEFF00.Data[1].bbyte & 0x38) == 0x18) //?????? ??
            {
                DriverRLamp_OUT = LEDON;
            }
        else if ((CanMsg18FEFF00.Data[1].bbyte & 0x38) == 0x28)
            {
                DriverRLamp_OUT = BcmModel.bits.Blink2hz; // 2hz
            }
    }
    else if (((CanMsg18FEFF00.Data[1].bbyte & 0x07) == 0x01) || ((CanMsg18FEFF00.Data[1].bbyte & 0x07) == 0x04) || ((CanMsgFD0700.Data[0].bbyte & 0x0c) == 0x04)) // ?????? ??
    {
        DriverRLamp_OUT = LEDOFF;
        if (((CanMsg18FEFF00.Data[1].bbyte & 0x07) == 0x01) || ((CanMsgFD0700.Data[0].bbyte & 0x0c) == 0x04))
        {
            DriverLamp_OUT = LEDON;
        }
        else if ((CanMsg18FEFF00.Data[1].bbyte & 0x07) == 0x04)
        {
            DriverLamp_OUT = BcmModel.bits.Blinking; // 1hz
        }
    }
    else
    {
        if (T_BOX_lost == 1)
        {
            DriverRLamp_OUT = LEDOFF;
            DriverLamp_OUT = LEDON;
            T_BOX_Status = 2;
        }
        else
        {
            if (((CanMsg1CFFBE18.Data[2].bbyte & 0x07) >= 0x01) && ((CanMsg1CFFBE18.Data[2].bbyte & 0x07) <= 0x04))
            {
                DriverRLamp_OUT = LEDOFF;
                DriverLamp_OUT = LEDON;
                T_BOX_Status = 1;
            }
            else
            {
                DriverLamp_OUT = LEDOFF;
                DriverRLamp_OUT = LEDOFF;
                T_BOX_Status = 0;
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_ZAQD_QDDPRG(void)
{

    if (AQD_LED_IN == 0)

    {
        if (++TIME_ZAQD >= 6) //
        {
            TIME_ZAQD = 0;

            bDSTable[ID_SAFEBELT] |= DS0_MASK;
            bDSTable[ID_SAFEBELT] &= (~DS1_MASK);
        }
    }
    else
    {
        TIME_ZAQD = 0;
        bDSTable[ID_SAFEBELT] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_LTRN_QDDPRG(void)
{
    if (bFE40Flag == 0)
    {
        if ((ZZX_LED_IN == 1))
        {
            if (++TIME_LTRN >= 6) //
            {
                TIME_LTRN = 0;
                bDSTable[ID_LTRN] |= DS0_MASK;
                bDSTable[ID_LTRN] &= (~DS1_MASK);
            }
        }
        else
        {
            TIME_LTRN = 0;
            bDSTable[ID_LTRN] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_RTRN_QDDPRG(void)
{

    if (bFE40Flag == 0)
    {

        if ((YZX_LED_IN == 1))

        {
            if (++TIME_RTRN >= 6) //
            {
                TIME_RTRN = 0;

                bDSTable[ID_RTRN] |= DS0_MASK;
                bDSTable[ID_RTRN] &= (~DS1_MASK);
            }
        }
        else
        {
            TIME_RTRN = 0;
            bDSTable[ID_RTRN] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_ABS_QDDPRG(void)
{

    /*if(bF001Flag==0)
    {
        if((ABS_IN==0))

        {
            if(++TIME_ABS>=6)			//
            {
                TIME_ABS=0;

                bDSTable[ID_ABS]|=DS0_MASK;
                bDSTable[ID_ABS]&=(~DS1_MASK);
            }
        }
        else
        {
            TIME_ABS=0;
            bDSTable[ID_ABS]&=(~(DS0_MASK|DS1_MASK));	//clear DS0 & DS1

        }
    } */
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_OBDH_QDDPRG(void)
{

    /*if(bFF08Flag==0)
    {
        if((OBDH_IN==1))

        {
            if(++TIME_OBDH>=6)			//
            {
                TIME_OBDH=0;

                bDSTable[ID_OBDH]|=DS0_MASK;
                bDSTable[ID_OBDH]&=(~DS1_MASK);
            }
        }
        else
        {
            TIME_OBDH=0;
            bDSTable[ID_OBDH]&=(~(DS0_MASK|DS1_MASK));	//clear DS0 & DS1

        }
    } */
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_OBDL_QDDPRG(void)
{

    /*if(bFF08Flag==0)
    {

        if((OBDL_IN==0))

        {
            if(++TIME_OBDL>=6)			//
            {
                TIME_OBDL=0;

                bDSTable[ID_OBDL]|=DS0_MASK;
                bDSTable[ID_OBDL]&=(~DS1_MASK);
            }
        }
        else
        {
            TIME_OBDL=0;
            bDSTable[ID_OBDL]&=(~(DS0_MASK|DS1_MASK));	//clear DS0 & DS1

        }
    }*/
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_PinProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_FFOG_QDDPRG(void)
{
    if (bFE40Flag == 0)
    {
        if (BACKFOG_LED_IN == 1)

        {
            if (++TIME_FFOG >= 6) //
            {
                TIME_FFOG = 0;

                bDSTable[ID_FFOG] |= DS0_MASK;
                bDSTable[ID_FFOG] &= (~DS1_MASK);
            }
        }
        else
        {
            TIME_FFOG = 0;
            bDSTable[ID_FFOG] &= (~(DS0_MASK | DS1_MASK)); // clear DS0 & DS1
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_BeepProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
#pragma CODE_SEG OTHER_ROM
extern INT8U temp_State_keep;
void GUI_BeepProc(BeepType *Bp)
{
    if (CarFlag.FlagBits.BeepProcEn)
    {
        if (Curkeyinput == KeyON)
        { //安全带报警
            if (((bDSTable[ID_SAFEBELT] & STATEMASK) == 0x01) && (VehMeter.CurBoardVal > 20))
            {
                Bp[3].Prio = SafeAlr;
                Bp[3].OnTime = TT1_500ms;
                Bp[3].OffTime = TT1_500ms;
                Bp[3].SumTime = Bp[3].OnTime + Bp[3].OffTime;
                Bp[3].BeepCn = 90;
            }

            else if (((bDSTable[ID_SAFEBELT] & STATEMASK) == 0x00) || (VehMeter.CurBoardVal == 0))
            {
                Bp[3].Prio = DisAlr;
                Bp[3].BeepTime = null;
                Bp[3].OnTime = null;
                Bp[3].OffTime = null;
                Bp[3].BeepCn = null;
                Bp[3].CurBeepCn = null;
            }

            //气压报警
            if ((bDSTable[ID_GPRL] & STATEMASK) == 0x01)
            {
                Bp[1].Prio = GprsAlr;
                Bp[1].OnTime = TT1_500ms;
                Bp[1].OffTime = TT1_500ms;
                Bp[1].SumTime = Bp[1].OnTime + Bp[1].OffTime;
                Bp[1].BeepCn = 90;
            }
            else if ((bDSTable[ID_GPRL] & STATEMASK) == 0x00)
            {
                Bp[1].Prio = DisAlr;
                Bp[1].BeepTime = null;
                Bp[1].OnTime = null;
                Bp[1].OffTime = null;
                Bp[1].BeepCn = null;
                Bp[1].CurBeepCn = null;
            }
            //水温报警
            // if((bDSTable[ID_CTMP]&STATEMASK) == 0x01)
            if (temp_State_keep == 1)
            {
                Bp[2].Prio = TempAlr;
                Bp[2].OnTime = TT1_600ms;
                Bp[2].OffTime = TT1_400ms;
                Bp[2].SumTime = Bp[2].OnTime + Bp[2].OffTime;
                Bp[2].BeepCn = 3;
            }
            // else if((bDSTable[ID_CTMP]&STATEMASK) == 0x00)
            else // if(temp_State_keep==0)
            {
                Bp[2].Prio = DisAlr;
                Bp[2].BeepTime = null;
                Bp[2].OnTime = null;
                Bp[2].OffTime = null;
                Bp[2].BeepCn = null;
                Bp[2].CurBeepCn = null;
            }
            //超速报警
            if ((bDSTable[ID_VEHSPD] & STATEMASK) == 0x01)
            {
                Bp[4].Prio = VehAlr;
                Bp[4].OnTime = TT1_600ms;
                Bp[4].OffTime = TT1_400ms;
                Bp[4].SumTime = Bp[4].OnTime + Bp[4].OffTime;
                Bp[4].BeepCn = AlwaysBp;
            }
            else if ((bDSTable[ID_VEHSPD] & STATEMASK) == 0x00)
            {
                Bp[4].Prio = DisAlr;
                Bp[4].BeepTime = null;
                Bp[4].OnTime = null;
                Bp[4].OffTime = null;
                Bp[4].BeepCn = null;
                Bp[4].CurBeepCn = null;
            }

            //燃油低报警
            if ((bDSTable[ID_FUELLOW] & STATEMASK) == 0x01)
            {
                Bp[5].Prio = FuelAlr;
                Bp[5].OnTime = TT1_500ms;
                Bp[5].OffTime = TT1_500ms;
                Bp[5].SumTime = Bp[5].OnTime + Bp[5].OffTime;
                Bp[5].BeepCn = AlwaysBp;
            }
            else if ((bDSTable[ID_FUELLOW] & STATEMASK) == 0x00)
            {
                Bp[5].Prio = DisAlr;
                Bp[5].OnTime = null;
                Bp[5].OffTime = null;
                Bp[5].BeepCn = null;
                Bp[5].BeepTime = null;
                Bp[5].CurBeepCn = null;
            }
        }
        CarFlag.FlagBits.BeepProcEn = Disable;
    }
    //转速报警
    if ((bDSTable[ID_MOTSPD] & STATEMASK) == 0x01)
    {

        Bp[6].Prio = RehAlr;
        Bp[6].OnTime = TT1_500ms;
        Bp[6].OffTime = TT1_500ms;
        Bp[6].SumTime = Bp[6].OnTime + Bp[6].OffTime;
        Bp[6].BeepCn = AlwaysBp;
    }
    else if ((bDSTable[ID_MOTSPD] & STATEMASK) == 0x00)
    {
        Bp[6].Prio = DisAlr;
        Bp[6].BeepTime = null;
        Bp[6].OnTime = null;
        Bp[6].OffTime = null;
        Bp[6].BeepCn = null;
        Bp[6].CurBeepCn = null;
    }

    if ((Bp[1].Prio == GprsAlr) && (Bp[1].CurBeepCn < Bp[1].BeepCn))
    {
        pBeep = (BeepType *)&Bp[1];
    }
    else if (Bp[2].Prio == TempAlr)
    {
        pBeep = (BeepType *)&Bp[2];
    }
    else if (Bp[3].Prio == SafeAlr && (Bp[3].CurBeepCn <= Bp[3].BeepCn))
    {
        pBeep = (BeepType *)&Bp[3];
    }
    else if ((Bp[4].Prio == VehAlr))
    {
        pBeep = (BeepType *)&Bp[4];
    }
    else if ((Bp[5].Prio == FuelAlr))
    {
        pBeep = (BeepType *)&Bp[5];
    }
    else if ((Bp[6].Prio == RehAlr))
    {
        pBeep = (BeepType *)&Bp[6];
    }
    else
    {
        pBeep->BeepTime = null;
        CarFlag.FlagBits.BeepProcEn = Enable;
        pBeep = &NopBeep;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_BeepProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_BeepPicoProc(BeepType *Bp)
{
    INT8U i, j;

    if (Bp->Prio != DisAlr)
    {
        for (i = 0; i <= 6; i++)
        {
            if ((Bp->Prio <= BeepBuf[i]->Prio) || (BeepBuf[i]->Prio == null))
            {
                break;
            }
        }
        j = i;
        if (j == 0)
        {
            if (Bp->Prio < BeepBuf[j]->Prio)
            {
                for (; i <= 5; i++)
                {
                    BeepBuf[i]->CurBeepCn = null;
                    BeepBuf[i]->BeepTime = null;
                    BeepBuf[i + 1] = BeepBuf[i];
                }
                BeepBuf[0] = Bp;
            }
        }
    }
    if ((BeepBuf[0]->CurBeepCn >= BeepBuf[0]->BeepCn) && (BeepBuf[0]->CurBeepCn > null))
    {
        BeepBuf[0]->Prio = DisAlr;
        BeepBuf[0]->BeepTime = null;
    }
    if (BeepBuf[0]->Prio == DisAlr)
    {
        for (i = 0; i <= 5; i++)
        {
            BeepBuf[i] = BeepBuf[i + 1];
        }
        BeepBuf[0]->BeepTime = null;
        Bp = (BeepType *)BeepBuf[0];
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_BeepProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
#pragma CODE_SEG OTHER_ROM
void far GUI_BeepOut(void)
{
    switch (pBeep->Prio)
    {
    case GprsAlr:
        if (pBeep->CurBeepCn < pBeep->BeepCn)
        {
            if (pBeep->BeepTime < 3)
            {
                Api_BeepCtl(0, 120, 120);
                pBeep->BeepOK = Disable;
            }
            if ((pBeep->BeepTime > pBeep->OnTime) && (pBeep->BeepTime < pBeep->OnTime + 2))
            {
                Api_BeepCtl(120, 60, 120);
            }
            if (pBeep->BeepTime > pBeep->SumTime)
            {
                pBeep->BeepTime = clear;
                if (pBeep->BeepOK == Disable)
                {
                    pBeep->CurBeepCn++;
                }
                pBeep->BeepOK = Enable;
                CarFlag.FlagBits.BeepProcEn = Enable;
            }
        }
        break;
    case TempAlr:
        if (pBeep->CurBeepCn < pBeep->BeepCn)
        {
            if (pBeep->BeepTime < 3)
            {
                Api_BeepCtl(0, 120, 129);
                pBeep->BeepOK = Disable;
            }
            if ((pBeep->BeepTime > pBeep->OnTime) && (pBeep->BeepTime < pBeep->OnTime + 2))
            {

                Api_BeepCtl(120, 60, 120);
            }
            if (pBeep->BeepTime > pBeep->SumTime)
            {
                pBeep->BeepTime = clear;
                if (pBeep->BeepOK == Disable)
                {
                    pBeep->CurBeepCn++;
                }
                pBeep->BeepOK = Enable;
                // CarFlag.FlagBits.BeepProcEn = Enable;
            }
        }
        CarFlag.FlagBits.BeepProcEn = Enable;
        break;
    case VehAlr:
        if (pBeep->OnTime > null)
        {
            if (pBeep->BeepTime < 3)
            {
                Api_BeepCtl(120, 20, 120);
            }
            if ((pBeep->BeepTime > pBeep->OnTime) && (pBeep->BeepTime < pBeep->OnTime + 2))
            {
                Api_BeepCtl(0, 40, 120);
            }
            if (pBeep->BeepTime > pBeep->SumTime)
            {
                pBeep->BeepTime = clear;
                pBeep->BeepOK = Enable;
            }
        }
        else
        {
            // Api_BeepCtl(40,43,120);
        }
        CarFlag.FlagBits.BeepProcEn = Enable;

        break;
    case FuelAlr:
        if (pBeep->OnTime > null)
        {
            if (pBeep->BeepTime < 3)
            {
                Api_BeepCtl(120, 20, 120);
            }
            if ((pBeep->BeepTime > pBeep->OnTime) && (pBeep->BeepTime < pBeep->OnTime + 2))
            {
                Api_BeepCtl(0, 40, 120);
            }
            if (pBeep->BeepTime > pBeep->SumTime)
            {
                pBeep->BeepTime = clear;
                pBeep->BeepOK = Enable;
            }
        }
        else
        {
            // Api_BeepCtl(40,43,120);
        }
        CarFlag.FlagBits.BeepProcEn = Enable;

        break;
    case RehAlr:
        if (pBeep->OnTime > null)
        {
            if (pBeep->BeepTime < 3)
            {
                Api_BeepCtl(120, 20, 120);
            }
            if ((pBeep->BeepTime > pBeep->OnTime) && (pBeep->BeepTime < pBeep->OnTime + 2))
            {
                Api_BeepCtl(0, 40, 120);
            }
            if (pBeep->BeepTime > pBeep->SumTime)
            {
                pBeep->BeepTime = clear;
                pBeep->BeepOK = Enable;
            }
        }
        else
        {
            // Api_BeepCtl(40,43,120);
        }
        CarFlag.FlagBits.BeepProcEn = Enable;

        break;

    case SafeAlr:
        if (pBeep->CurBeepCn < pBeep->BeepCn)
        {
            if (pBeep->BeepTime < 3)
            {
                Api_BeepCtl(0, 120, 120);
                pBeep->BeepOK = Disable;
            }
            if ((pBeep->BeepTime > pBeep->OnTime) && (pBeep->BeepTime < pBeep->OnTime + 2))
            {
                Api_BeepCtl(120, 60, 120);
            }
            if (pBeep->BeepTime > pBeep->SumTime)
            {
                pBeep->BeepTime = clear;
                if (pBeep->BeepOK == Disable)
                {
                    pBeep->CurBeepCn++;
                }
                pBeep->BeepOK = Enable;
                CarFlag.FlagBits.BeepProcEn = Enable;
            }
        }

        break;
    case DisAlr:
        if (Curkeyinput == KeyON)
        {
            // Api_BeepCtl(0,120,120);
        }
        else
        {
            PWME_PWME1 = Disable;
            // PWME_PWME2 = Disable;
            PTS_PTS5 = LOW;
            // PTS_PTS6 = LOW;
        }

    default:
        PWME_PWME1 = Disable;
        // PWME_PWME2 = Disable;
        PTS_PTS5 = LOW;
        // PTS_PTS6 = LOW;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : GUI_CheckKeyProc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_CheckKeyProc(KeyType *KeyMenu)
{
    if (Curkeyinput == KeyON)
    {
        if (((KeyMenu->PushTime >= T_20s) || (ClearOdoCanTimes >= 10)) && (AccKm.LongAccKm < 20000) && (AccKm.LongAccKm > 0))
        {
            if (OUT_2000km_Clear != one)
            {
                ClearOdoCanOut = 30;
                OUT_2000km_Clear = one;
                bsp_IIC_WritePage(0xa2, 256, (INT8U *)&OUT_2000km_Clear, Register_Len);
                do
                {
                    App_ClearAccStock();
                } 
                while (CarFlag.FlagBits.AccSaveState == Enable);

  	            CarFlag.FlagBits.AccSaveState = Enable;
            
                ClearOdoCanTimes = 0;
                                
                AccPulse = 0;
            }
        }
       
        ////////////////////////D 短按 ///////////////////////////////////////
        if (KEY1_IN == HIGH)
        {
            if ((KeyMenu->PushTime >= T_100ms) && (KeyMenu->PushTime < T_2s))
            {
                if (G_Button.MainMenu == MainMeuDisp)
                {
                    if (KeyMenu->SET_TIME == 0)
                    {
                        G_Button.SubMenu0++;
                        if (G_Button.SubMenu0 >= 2)
                        {
                            G_Button.SubMenu0 = 0;
                        }
                    }
                    else
                    {
                        G_Button.JUMP = !G_Button.JUMP;
                    }
                }
                else if (G_Button.MainMenu == RadioMenu)
                {
                    SetRadioWei++;
                    if (SetRadioWei >= 4)
                    {
                        SetRadioWei = 0;
                    }
                }

                KeyMenu->PushTime = null;
            }
        }

        ///////////////////////D 长按  /////////////////////////////////
        if ((KEY1_IN == LOW) && (KeyMenu->PushTime >= T_2s))
        {
            if ((G_Button.SubMenu0 == 0) && (G_Button.MainMenu == MainMeuDisp))
            {
                AccKm.ShortAccKm = null;
                App_WriteAccReg();
            }
            //
            if ((G_Button.SubMenu0 != 0) && (KeyMenu->button_up_flag == 1) && (G_Button.MainMenu == MainMeuDisp))
            {
                KeyMenu->button_up_flag = 0;
                if (KeyMenu->SET_TIME == 0)
                {
                    KeyMenu->SET_TIME = 1;
                }
                else
                {
                    KeyMenu->SET_TIME = 0;
                    Clock.HalfSeconds = 0;
                    Clock.Seconds = 0;
                }
            }
            //长按退出设置速比
            if (G_Button.MainMenu == RadioMenu)
            {
                G_Button.MainMenu = MainMeuDisp;

                Radio.bFlag = 0x55;
                Radio.bCheckSun = App_CreateCheckSun((INT8U *)&Radio.VehRadio, Radio.bFlag, 6);
                bReturn = bsp_IIC_WritePage(0xa0, EE_RADIO_ADDR, (INT8U *)&Radio, 8);
            }
        }

        ////////////////////////抬起
        if (KEY1_IN == HIGH)
        {
            KeyMenu->button_up_flag = 1;
            KeyMenu->PushTime = null;
            KeyMenu->Valid = Enable;
        }
    }
    //
    if (Curkeyinput == KeyOFF)
    {
        //设置速比
        if ((KeyMenu->Valid == Enable) && (KeyMenu->PushTime >= T_6s) && (AccKm.LongAccKm < 1000))
        {
            if (OldRadioKeyDUpState == 1)
            {
                OldRadioKeyDUpState = 0;
                RadioKeyDUpState = 1;
            }

            KeyMenu->Valid = Disable;
        }
        ///////抬起
        if (KEY1_IN == HIGH)
        {
            KeyMenu->button_up_flag = 1;
            KeyMenu->PushTime = null;
            KeyMenu->Valid = Enable;
            OldRadioKeyDUpState = 1;
            if ((RadioKeyDUpState == 1) && (Curkeyinput == KeyOFF) && (AccKm.LongAccKm < 1000))
            {
                KeyMenu->MainMenu = RadioMenu;
                RadioKeyDUpState = 0;
            }
        }
    }
    //速比设置无效情况
    if ((KEY1_IN == UpSpring) && (Curkeyinput == KeyOFF) && (CancelRadioTime >= T_3s))
    {
        KeyMenu->MainMenu = MainMeuDisp;
    }

    //
    Gui_Encoded_Proc();
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_Encoded_Proc
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_Encoded_Proc(void)
{
    if ((!KEY0_IN) && (!KEY2_IN))
    {
        m_Encoded.code.data = 0xc0;
        m_Encoded.AdjEn = Enable;
    }
    else
    {
        if (m_Encoded.code.data == 0xc0)
        {
            if ((!KEY2_IN) && (KEY0_IN)) //+
            {
                m_Encoded.code.bits.bit5 = 1;
                m_Encoded.code.bits.bit4 = 0;
            }
            if ((KEY2_IN) && (!KEY0_IN)) //-
            {
                m_Encoded.code.bits.bit5 = 0;
                m_Encoded.code.bits.bit4 = 1;
            }
        }
        else if ((m_Encoded.code.data == 0xd0) || (m_Encoded.code.data == 0xe0))
        {
            if ((KEY2_IN) && (KEY0_IN))
            {
                m_Encoded.code.bits.bit3 = 0;
                m_Encoded.code.bits.bit2 = 0;
            }
            else if ((KEY2_IN) && (!KEY0_IN)) //+
            {
                m_Encoded.code.bits.bit1 = 0;
                m_Encoded.code.bits.bit0 = 1;
            }
            else if ((!KEY2_IN) && (KEY0_IN)) //+
            {
                m_Encoded.code.bits.bit1 = 1;
                m_Encoded.code.bits.bit0 = 0;
            }
            if (m_Encoded.AdjEn)
            {
                m_Encoded.AdjEn = Disable;
                if (m_Encoded.code.data == 0xe2) //-
                {
                    G_Button.PushTime4 = 0;
                    //
                    if (G_Button.SET_TIME == 1)
                    {
                        if (G_Button.JUMP == 1)
                        {
                            Clock.Minutes++;
                            if (Clock.Minutes > 59)
                            {
                                Clock.Minutes = 0;
                            }
                        }
                        if (G_Button.JUMP == 0)
                        {
                            Clock.Hours++;
                            if (Clock.Hours > 23)
                            {
                                Clock.Hours = 0;
                            }
                        }
                    }
                    //
                    if (G_Button.MainMenu == RadioMenu)
                    {
                        if (SetRadioWei == 0)
                        {

                            if ((Radio.VehRadio % 10) < 9)
                            {
                                Radio.VehRadio++;
                            }
                            else
                                Radio.VehRadio -= 9;
                        }
                        else if (SetRadioWei == 1)
                        {
                            if (((Radio.VehRadio / 10) % 10) < 9)
                            {
                                Radio.VehRadio += 10;
                            }
                            else
                                Radio.VehRadio -= 90;
                        }
                        else if (SetRadioWei == 2)
                        {
                            if ((Radio.VehRadio / 100) < 9)
                            {
                                Radio.VehRadio += 100;
                            }
                            else
                                Radio.VehRadio -= 900;
                        }
                        else if (SetRadioWei == 3)
                        {
                            if ((Radio.VehRadio / 1000) < 9)
                            {
                                Radio.VehRadio += 1000;
                            }
                            else
                                Radio.VehRadio -= 9000;
                        }
                    }
                }
                else if (m_Encoded.code.data == 0xd1) //+
                {
                    G_Button.PushTime4 = 0;
                    //
                    if (G_Button.SET_TIME == 1)
                    {
                        if (G_Button.JUMP == 1)
                        {
                            Clock.Minutes--;
                            if (Clock.Minutes == 255)
                            {
                                Clock.Minutes = 59;
                            }
                        }
                        if (G_Button.JUMP == 0)
                        {
                            Clock.Hours--;
                            if (Clock.Hours == 255)
                            {
                                Clock.Hours = 23;
                            }
                        }
                    }
                }
            }
        }
    }
}
#pragma CODE_SEG OTHER_ROM
/*-------------------------------------------------------------------------
* Function Name  : GUI_LCD_Display
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_LCD_Display(void)
{
    if (G_Button.MainMenu == RadioMenu)
    {
        Gui_SetRadio();
    }
    else if (G_Button.MainMenu == MainMeuDisp)
    {
        if (G_Button.SubMenu0 == 0)
        {
            T_BOX_Disp();
        }
        else if (G_Button.SubMenu0 == 1)
        {
            Gui_ODO_Disp();
        }
        //
        Gui_time_Disp();
        //
        QY1_Disp();
        QY2_Disp();
        //
        Show_TLY(bAdBlueStep);

        //////////////////////////////////////
        Gui_Icon(); //图标
    }
    I2C_senddat(ADD_ORIG); //刷屏
}
/*-------------------------------------------------------------------------

* Function Name  : GUI_Motor_Reset
* Description    : 仪表复位
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
#pragma CODE_SEG OTHER_ROM
void GUI_Motor_Start(void)
{
    VehMeter.MotorReset = Enable;
    RevMeter.MotorReset = Enable;
    FuelMeter.MotorReset = Enable;
    TempMeter.MotorReset = Enable;
    VehMeter.DestPosition = null;
    RevMeter.DestPosition = null;

    FuelMeter.DestPosition = null; //
    TempMeter.DestPosition = null; //
    if ((RevMeter.MakeZero == Enable) && (VehMeter.MakeZero == Enable) && (FuelMeter.MakeZero == Enable) && (TempMeter.MakeZero == Enable))
    {
        API_SetTimer3(T_1s, (ClockType *)&Clock);
    }
    else
    {
        VehMeter.CurPosition = 3360;
        RevMeter.CurPosition = 3360;
        FuelMeter.CurPosition = 3360; // add by ty
        TempMeter.CurPosition = 3360; //
        API_SetTimer3(T_3s, (ClockType *)&Clock);
        for (;;)
        {
            _FEED_COP();
            API_ClockGenerate();
            Api_GetSensorAD();
            // if(InitQy1Time > T_1s)
            // {
            App_CalGsPrs1Board();
            // }
            //
            //  if(InitQy2Time > T_1s)
            // {
            App_CalGsPrs2Board();
            //  }
            GUI_LCD_Display(); // lzs--gai

            if ((VehMeter.DestPosition == VehMeter.CurPosition) && (RevMeter.DestPosition == RevMeter.CurPosition) && (FuelMeter.DestPosition == FuelMeter.CurPosition) && (TempMeter.DestPosition == TempMeter.CurPosition) && (FDJ1_LED_P == 0))
            {
                break;
            }
            if ((RevZero == reset) && (VehZero == reset) && (YB_ZERO_IN == reset) && (Tem_ZERO_IN == reset)) //&&(FDJ1_LED_P == 0))
            {
                VehMeter.CurPosition = null;
                RevMeter.CurPosition = null;
                FuelMeter.CurPosition = null;
                TempMeter.CurPosition = null;
                break;
            }
        }
        //  API_SetTimer3(T_4s,(ClockType*)&Clock);     lzs--shan
        //  InitQYFlag1 = 0;   //lzs--jia
        //  InitQYFlag2 = 0;   //lzs--jia
    }

    VehMeter.MotorReset = Disable;
    RevMeter.MotorReset = Disable;
    FuelMeter.MotorReset = Disable;
    TempMeter.MotorReset = Disable;

    CarFlag.FlagBits.TempStar = Disable;
    CarFlag.FlagBits.FuelStar = Disable;
    VehMeter.DestPosition = null;
    RevMeter.DestPosition = null;

    VehMeter.CurPosition = null;
    RevMeter.CurPosition = null;
    FuelMeter.CurPosition = null;
    TempMeter.CurPosition = null;
}
#pragma CODE_SEG DEFAULT
/*-------------------------------------------------------------------------
* Function Name  : GUI_Motor_Reset
* Description    : 仪表复位
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
#pragma CODE_SEG OTHER_ROM
void GUI_Motor_Reset(void)
{
    VehMeter.MotorReset = Enable;
    RevMeter.MotorReset = Enable;

    VehMeter.CurPosition += 30;
    RevMeter.CurPosition += 30;
    FuelMeter.CurPosition += 30;
    TempMeter.CurPosition += 30;

    for (;;)
    {
        _FEED_COP();

        VehMeter.DestPosition = null;
        RevMeter.DestPosition = null;
        FuelMeter.DestPosition = null;
        TempMeter.DestPosition = null;

        if (((VehZero == reset) && (RevZero == reset) && (YB_ZERO_IN == reset) && (Tem_ZERO_IN == reset)) ||
            ((VehMeter.DestPosition == VehMeter.CurPosition) && (RevMeter.DestPosition == RevMeter.CurPosition) && (FuelMeter.DestPosition == FuelMeter.CurPosition) && (TempMeter.DestPosition == TempMeter.CurPosition)))
        {
            break;
        }
    }
    VehMeter.MotorReset = Disable;
    RevMeter.MotorReset = Disable;
    FuelMeter.MotorReset = Disable;
    TempMeter.MotorReset = Disable;

    VehMeter.CurPosition = null;
    RevMeter.CurPosition = null;
    FuelMeter.CurPosition = null;
    TempMeter.CurPosition = null;
}
#pragma CODE_SEG DEFAULT
/*-------------------------------------------------------------------------
* Function Name  : GUI_LCD_Clear
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GUI_LCD_Clear(void)
{
    INT8U i;
    for (i = 0; i < 22; i++)
    {
        tb_add[i].bbyte = 0;
    }
    I2C_senddat(ADD_ORIG);        //刷屏
    I2C_sendcmd(0x90);              //关闭
}
