
#include "SEG_LCD.h"
#include "LED.h"
#include "Flash_synchronizer.h"
SEGLCDBackupStruct   SEGLCDBackup;

uint8_t   SEGLCDIconLeftStatus;
uint8_t   SEGLCDIconParkStatus;
uint8_t   SEGLCDIconAirbagStatus;
uint8_t   SEGLCDIconMILStatus;
uint8_t   SEGLCDIconLoOilPressureStatus;
uint8_t   SEGLCDIconRightStatus;
uint8_t   SEGLCDIconFOGFStatus;
uint8_t   SEGLCDIconFOGRStatus;
uint8_t   SEGLCDIconPositionStatus;
uint8_t   SEGLCDIconHiBeamStatus;
   
#include "SEG_LCD.h"

SEGLCDBackupStruct   SEGLCDBackup;

uint8_t   SEGLCDIconLeftStatus;
uint8_t   SEGLCDIconParkStatus;
uint8_t   SEGLCDIconAirbagStatus;
uint8_t   SEGLCDIconMILStatus;
uint8_t   SEGLCDIconLoOilPressureStatus;
uint8_t   SEGLCDIconRightStatus;
uint8_t   SEGLCDIconFOGFStatus;
uint8_t   SEGLCDIconFOGRStatus;
uint8_t   SEGLCDIconPositionStatus;
uint8_t   SEGLCDIconHiBeamStatus;


uint8_t   LED_ODO_TRIP_FLAG_OLD;   //TRIPA = 1  TRIPB = 2 ODO = 3

void SEG_LCD_Init(void)
{
  SEGLCDBackup.Brightness = 0x00;
  SEGLCDBackup.Window     = 0x00;
  SEGLCDBackup.VSpeedSeg  = 0xFF;
  SEGLCDBackup.ESpeedSeg  = 0xFF;
  SEGLCDBackup.VSpeed     = 0xFFFF;
  SEGLCDBackup.ESpeed     = 0xFFFF;
  SEGLCDBackup.ODONum    = 0xFFFFFFFF;
  SEGLCDBackup.Power     = 0xFFFF;
  SEGLCDBackup.Voltage     = 0xFFFF;
  SEGLCDBackup.Current     = 0xFFFF;
  SEGLCDBackup.Mileage     = 0xFFFF;
  SEGLCDBackup.SOCSeg     = 0xFF;
  SEGLCDBackup.InitPowerSeg     = 0xFF;
  SEGLCDBackup.RePowerSeg     = 0xFF;
  SEGLCDBackup.TotalPowerSeg     = 0xFF;
  SEGLCDIconLeftStatus          = 0x00;
  SEGLCDIconParkStatus          = 0x00;
  SEGLCDIconAirbagStatus        = 0x00;
  SEGLCDIconMILStatus           = 0x00;
  SEGLCDIconLoOilPressureStatus = 0x00;
  SEGLCDIconRightStatus         = 0x00;
  SEGLCDIconFOGFStatus          = 0x00;
  SEGLCDIconFOGRStatus          = 0x00;
  SEGLCDIconPositionStatus      = 0x00;
  SEGLCDIconHiBeamStatus        = 0x00;
  
  SEG_LCD_WINDOW_P = 0;
  SEG_LCD_WINDOW_M = 0;
  
  LED_LEFT_G             = 0;
 // LED_PARK_R             = 0;
  LED_AIRBAG_R           = 0;
 // LED_MIL_Y              = 0;
 // LED_LOW_OIL_PRESSURE_R = 0;
  LED_RIGHT_G            = 0;
  LED_FOG_F_G            = 0;
  LED_FOG_R_Y            = 0;
 // LED_POSITION_G         = 0;
  LED_HI_BEAM_B          = 0;
  
  //----hyq--20180913
  LED_ODO_TRIP_FLAG_OLD = 0;      //TRIPA = 1  TRIPB = 2 ODO = 3
  
  /*
  PWM_Channel_Init(2, PWM_CLOCK_SA, PWM_POL_POS, PWM_LEFT_ALIGN, PWM2_PS6);
  PWM_Channel_Set_Freq(2, 769);
  PWM_Channel_Set_Duty_Cycle(2, 0);   //ʼΪر,ɺӦó
  PWM_Channel_Start(2);
  */
  BU98R10_Init();
}

void SEG_LCD_Shutdown(void)
{
  BU98R10_Shutdown();
  
  SEG_LCD_WINDOW_P = 0;
  SEG_LCD_WINDOW_M = 0;
  
  SEGLCDBackup.Brightness = 0x00;
  SEGLCDBackup.Window     = 0x00;
  
  PWM_Channel_Stop(2);
  PWM_BL = 0;
  
  LED_LEFT_G             = 0;
 // LED_PARK_R             = 0;
  LED_AIRBAG_R           = 0;
 // LED_MIL_Y              = 0;
  //LED_LOW_OIL_PRESSURE_R = 0;
  LED_RIGHT_G            = 0;
  LED_FOG_F_G            = 0;
  LED_FOG_R_Y            = 0;
 //LED_POSITION_G         = 0;
  LED_HI_BEAM_B          = 0;
}

void SEG_LCD_Set_Brightness(uint8_t Br)
{
  if (Br > 100)
    Br = 100;
  
  if (Br != SEGLCDBackup.Brightness)
  {
    SEGLCDBackup.Brightness = Br;
    PWM_Channel_Set_Duty_Cycle(2, Br);
  }
}

void SEG_LCD_Window_Switch(uint8_t Sw)
{
  if (Sw == SEGLCDBackup.Window)
    return;
  
  SEGLCDBackup.Window = Sw;
  
  if (Sw)
  {
    SEG_LCD_WINDOW_P = 1;
    SEG_LCD_WINDOW_M = 0;
  }
  else
  {
    SEG_LCD_WINDOW_P = 0;
    SEG_LCD_WINDOW_M = 0;
  }
}

//10ms
void SEG_LCD_Window_Control_Service(void)
{
  if (SEGLCDBackup.Window)
  {
    SEG_LCD_WINDOW_P = ~SEG_LCD_WINDOW_P;
    SEG_LCD_WINDOW_M = ~SEG_LCD_WINDOW_M;
  }
}

/******************************************************************************
SEG_LCD_Vehicle_Speed_ON_Display
  : 복ʾ    
  : SegNumٱĶ
ֵ                               
******************************************************************************/
void SEG_LCD_Vehicle_Speed_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 45)
    SegNum =45;

  if (SEGLCDBackup.VSpeedSeg != SegNum)
  {
    SEGLCDBackup.VSpeedSeg = SegNum;
    
    //----hyq--ʾ
    SEG_Blue_Veh_Q13  =  SEG_LCD_LIGHT ; 
      
    SEG_Blue_Veh_Q14  =  SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q15  =  SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q16  =  SEG_LCD_LIGHT ;  
    SEG_Blue_Veh_Q17  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q18  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q19  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q20  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q21  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q22  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q23  =  SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q24  =  SEG_LCD_LIGHT ;  
    SEG_Blue_Veh_Q25  =  SEG_LCD_LIGHT ;
      
    SEG_Blue_Veh_Q26  =  SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q27  =  SEG_LCD_LIGHT ;  
    SEG_Blue_Veh_Q28  =  SEG_LCD_LIGHT ;  
    SEG_Blue_Veh_Q29  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q30  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q31  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q32  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q33  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q34  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q35  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q36  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q37  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q38  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q39  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q40  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q41  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q42  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q43  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q44  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q45  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q46  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q47  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q48  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q49  =  SEG_LCD_LIGHT ;
    
    SEG_Blue_Veh_Q50  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q51  =  SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q52  =  SEG_LCD_LIGHT ;      
    SEG_Blue_Veh_Q53  =  SEG_LCD_LIGHT ;
          
    SEG_Blue_Veh_Q54  =  SEG_LCD_LIGHT ;      
    SEG_Blue_Veh_Q55  =  SEG_LCD_LIGHT ;      
    SEG_Blue_Veh_Q56  =  SEG_LCD_LIGHT ;      
    SEG_Blue_Veh_Q57  =  SEG_LCD_LIGHT ;
          
    SEG_Blue_Veh_Q58  =  SEG_LCD_LIGHT ;     
                      
    //----hyq--          
    SEG_Blue_Veh_Q1  =   SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q2  =   SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q3  =   SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q4  =   SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q5  =   SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q6  =   SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q7  =   SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q8  =   SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q9  =   SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q10 =   SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q11 =   SEG_LCD_LIGHT ; 
    SEG_Blue_Veh_Q12 =   SEG_LCD_LIGHT ; 
    
    //----hyq--Ȧ  
    SEG_Blue_Veh_Q59   = SEG_LCD_LIGHT ;
    SEG_Blue_Veh_Q59_1 = SEG_LCD_LIGHT ;       
    SEG_Blue_Veh_Q60   = SEG_LCD_LIGHT ;
      
    switch (SegNum)
    {
      //case 0  : ;
                //SEG_Blue_Veh_Q1   = SEG_LCD_GRAY;     
      case 0  : SEG_Blue_Veh_Q14  = SEG_LCD_GRAY;     
      case 1  : SEG_Blue_Veh_Q15  = SEG_LCD_GRAY;     
      case 2  : SEG_Blue_Veh_Q16  = SEG_LCD_GRAY;     
      case 3  : SEG_Blue_Veh_Q17  = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q2   = SEG_LCD_GRAY;      
      case 4  : SEG_Blue_Veh_Q18  = SEG_LCD_GRAY;     
      case 5  : SEG_Blue_Veh_Q19  = SEG_LCD_GRAY;     
      case 6  : SEG_Blue_Veh_Q20  = SEG_LCD_GRAY;     
      case 7  : SEG_Blue_Veh_Q21  = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q3   = SEG_LCD_GRAY; 
      case 8  : SEG_Blue_Veh_Q22 = SEG_LCD_GRAY;       
      case 9 : SEG_Blue_Veh_Q23 = SEG_LCD_GRAY;        
      case 10 : SEG_Blue_Veh_Q24 = SEG_LCD_GRAY;        
      case 11 : SEG_Blue_Veh_Q25 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q4   = SEG_LCD_GRAY;         
      case 12 : SEG_Blue_Veh_Q26 = SEG_LCD_GRAY;        
      case 13 : SEG_Blue_Veh_Q27 = SEG_LCD_GRAY;        
      case 14 : SEG_Blue_Veh_Q28 = SEG_LCD_GRAY;        
      case 15 : SEG_Blue_Veh_Q29 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q5   = SEG_LCD_GRAY;         
      case 16 : SEG_Blue_Veh_Q30 = SEG_LCD_GRAY;        
      case 17 : SEG_Blue_Veh_Q31 = SEG_LCD_GRAY;
      case 18 : SEG_Blue_Veh_Q32 = SEG_LCD_GRAY;        
      case 19 : SEG_Blue_Veh_Q33 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q6   = SEG_LCD_GRAY;         
      case 20 : SEG_Blue_Veh_Q34 = SEG_LCD_GRAY;        
      case 21 : SEG_Blue_Veh_Q35 = SEG_LCD_GRAY;        
      case 22 : SEG_Blue_Veh_Q36 = SEG_LCD_GRAY;        
      case 23 : SEG_Blue_Veh_Q37 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q7   = SEG_LCD_GRAY;         
      case 24 : SEG_Blue_Veh_Q38 = SEG_LCD_GRAY;        
      case 25 : SEG_Blue_Veh_Q39 = SEG_LCD_GRAY;        
      case 26 : SEG_Blue_Veh_Q40 = SEG_LCD_GRAY;        
      case 27 : SEG_Blue_Veh_Q41 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q8   = SEG_LCD_GRAY; 
      case 28 : SEG_Blue_Veh_Q42 = SEG_LCD_GRAY;        
      case 29 : SEG_Blue_Veh_Q43 = SEG_LCD_GRAY;        
      case 30 : SEG_Blue_Veh_Q44 = SEG_LCD_GRAY;        
      case 31 : SEG_Blue_Veh_Q45 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q9   = SEG_LCD_GRAY;         
      case 32 : SEG_Blue_Veh_Q46 = SEG_LCD_GRAY;        
      case 33 : SEG_Blue_Veh_Q47 = SEG_LCD_GRAY;        
      case 34 : SEG_Blue_Veh_Q48 = SEG_LCD_GRAY;        
      case 35 : SEG_Blue_Veh_Q49 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q10   = SEG_LCD_GRAY; 
      case 36 : SEG_Blue_Veh_Q50 = SEG_LCD_GRAY;        
      case 37 : SEG_Blue_Veh_Q51 = SEG_LCD_GRAY;        
      case 38 : SEG_Blue_Veh_Q52 = SEG_LCD_GRAY;        
      case 39 : SEG_Blue_Veh_Q53 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q11   = SEG_LCD_GRAY; 
      case 40 : SEG_Blue_Veh_Q54 = SEG_LCD_GRAY;        
      case 41 : SEG_Blue_Veh_Q55 = SEG_LCD_GRAY;        
      case 42 : SEG_Blue_Veh_Q56 = SEG_LCD_GRAY;        
      case 43 : SEG_Blue_Veh_Q57 = SEG_LCD_GRAY;
                //SEG_Blue_Veh_Q12   = SEG_LCD_GRAY; 
      case 44 : SEG_Blue_Veh_Q58 = SEG_LCD_GRAY;        
      default : break;
    }
  }
}

/******************************************************************************
SEG_LCD_Vehicle_Speed_All_Off_Display    
  : 복ȫر 
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_Vehicle_Speed_Seg_Off(void)
{
  //----hyq--ʾ
  SEG_Blue_Veh_Q13  =  SEG_LCD_OFF ;   
  SEG_Blue_Veh_Q14  =  SEG_LCD_OFF ; 
  SEG_Blue_Veh_Q15  =  SEG_LCD_OFF ; 
  SEG_Blue_Veh_Q16  =  SEG_LCD_OFF ;  
  SEG_Blue_Veh_Q17  =  SEG_LCD_OFF ; 
  SEG_Blue_Veh_Q18  =  SEG_LCD_OFF ;  
  SEG_Blue_Veh_Q19  =  SEG_LCD_OFF ;  
  SEG_Blue_Veh_Q20  =  SEG_LCD_OFF ;  
  SEG_Blue_Veh_Q21  =  SEG_LCD_OFF ;   
  SEG_Blue_Veh_Q22  =  SEG_LCD_OFF ;
  SEG_Blue_Veh_Q23  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q24  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q25  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q26  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q27  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q28  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q29  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q30  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q31  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q32  =  SEG_LCD_OFF ;
  SEG_Blue_Veh_Q33  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q34  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q35  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q36  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q37  =  SEG_LCD_OFF ;     
  SEG_Blue_Veh_Q38  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q39  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q40  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q41  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q42  =  SEG_LCD_OFF ;
  SEG_Blue_Veh_Q43  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q44  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q45  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q46  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q47  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q48  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q49  =  SEG_LCD_OFF ;    
  SEG_Blue_Veh_Q50  =  SEG_LCD_OFF ;
  SEG_Blue_Veh_Q51  =  SEG_LCD_OFF ;
  SEG_Blue_Veh_Q52  =  SEG_LCD_OFF ;      
  SEG_Blue_Veh_Q53  =  SEG_LCD_OFF ;      
  SEG_Blue_Veh_Q54  =  SEG_LCD_OFF ;      
  SEG_Blue_Veh_Q55  =  SEG_LCD_OFF ;      
  SEG_Blue_Veh_Q56  =  SEG_LCD_OFF ;      
  SEG_Blue_Veh_Q57  =  SEG_LCD_OFF ;      
  SEG_Blue_Veh_Q58  =  SEG_LCD_OFF ;     
                    
  //----hyq--          
  SEG_Blue_Veh_Q1  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q2  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q3  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q4  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q5  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q6  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q7  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q8  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q9  =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q10 =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q11 =   SEG_LCD_OFF ;
  SEG_Blue_Veh_Q12 =   SEG_LCD_OFF ; 
  
  //----hyq--Ȧ  
  SEG_Blue_Veh_Q59   = SEG_LCD_OFF ;
  SEG_Blue_Veh_Q59_1 = SEG_LCD_OFF ;       
  SEG_Blue_Veh_Q60   = SEG_LCD_OFF ;
  
  SEGLCDBackup.VSpeedSeg = 0xFF; 
}

/******************************************************************************
SEG_LCD_Vehicle_Speed_Num_Display
  : 복ʾ   
  : VspeedԶֵ
ֵ                               
******************************************************************************/
void SEG_LCD_Vehicle_Speed_Num_Display(uint16_t Vspeed)
{
  uint8_t Dig[3];
  
  if (SEGLCDBackup.VSpeed != Vspeed)
  {
    SEGLCDBackup.VSpeed = Vspeed;
    
    if (Vspeed > 2200)
      Vspeed = 2200;
    
    Vspeed /= 10;  
    Dig[0] = Vspeed % 10;
    Vspeed /= 10;
    Dig[1] = Vspeed % 10; 
    Dig[2] = Vspeed / 10;
    
    if (Dig[2] == 0)
    {
      Dig[2] = 0x0F;
      
      if (Dig[1] == 0)
        Dig[1] = 0x0F;
    }
    
    switch (Dig[2])
    {
      case 1  : SEG_Endurance_4ADEG   = SEG_LCD_GRAY_light;
                SEG_Endurance_4B      = SEG_LCD_LIGHT;
                SEG_Endurance_4C      = SEG_LCD_LIGHT;
                break;
                
      case 2  : SEG_Endurance_4ADEG   = SEG_LCD_LIGHT;  
                SEG_Endurance_4B      = SEG_LCD_LIGHT;
                SEG_Endurance_4C      = SEG_LCD_GRAY_light;
                break;
                
      default : SEG_Endurance_4ADEG   = SEG_LCD_GRAY_light;
                SEG_Endurance_4C      = SEG_LCD_GRAY_light;   
                SEG_Endurance_4B      = SEG_LCD_GRAY_light;   
                break;
    }
    
    switch (Dig[1])
    {
    	case 0  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_LIGHT;
                SEG_Endurance_5F  = SEG_LCD_LIGHT;
                SEG_Endurance_5G  = SEG_LCD_GRAY_light;
      			    break;
      			    
      case 1  : SEG_Endurance_5A  = SEG_LCD_GRAY_light;
      		      SEG_Endurance_5B  = SEG_LCD_LIGHT;
      		      SEG_Endurance_5C  = SEG_LCD_LIGHT;
      		      SEG_Endurance_5D  = SEG_LCD_GRAY_light;
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;
                SEG_Endurance_5F  = SEG_LCD_GRAY_light;
                SEG_Endurance_5G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_GRAY_light;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_LIGHT;
                SEG_Endurance_5F  = SEG_LCD_GRAY_light;
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5F  = SEG_LCD_GRAY_light;   
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Endurance_5A  = SEG_LCD_GRAY_light;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_GRAY_light;   
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;
                SEG_Endurance_5F  = SEG_LCD_LIGHT;
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_GRAY_light; 
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;
                SEG_Endurance_5F  = SEG_LCD_LIGHT;
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_GRAY_light;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_LIGHT;
                SEG_Endurance_5F  = SEG_LCD_LIGHT;
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5F  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_LIGHT;
                SEG_Endurance_5F  = SEG_LCD_LIGHT;
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Endurance_5A  = SEG_LCD_LIGHT;
                SEG_Endurance_5B  = SEG_LCD_LIGHT;
                SEG_Endurance_5C  = SEG_LCD_LIGHT;
                SEG_Endurance_5D  = SEG_LCD_LIGHT;
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;
                SEG_Endurance_5F  = SEG_LCD_LIGHT;
                SEG_Endurance_5G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Endurance_5A  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5B  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5C  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5D  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5E  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5F  = SEG_LCD_GRAY_light;  
                SEG_Endurance_5G  = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[0])
    {
    	case 0  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_LIGHT;
                SEG_Endurance_6F = SEG_LCD_LIGHT;
                SEG_Endurance_6G = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_Endurance_6A = SEG_LCD_GRAY_light;
      		      SEG_Endurance_6B = SEG_LCD_LIGHT;
      		      SEG_Endurance_6C = SEG_LCD_LIGHT;
      		      SEG_Endurance_6D = SEG_LCD_GRAY_light;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_GRAY_light;
                SEG_Endurance_6G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_GRAY_light;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_LIGHT;
                SEG_Endurance_6F = SEG_LCD_GRAY_light;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_GRAY_light;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Endurance_6A = SEG_LCD_GRAY_light;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_GRAY_light;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_LIGHT;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_GRAY_light;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_LIGHT;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_GRAY_light;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_LIGHT;
                SEG_Endurance_6F = SEG_LCD_LIGHT;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_GRAY_light;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_GRAY_light;
                SEG_Endurance_6G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_LIGHT;
                SEG_Endurance_6F = SEG_LCD_LIGHT;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Endurance_6A = SEG_LCD_LIGHT;
                SEG_Endurance_6B = SEG_LCD_LIGHT;
                SEG_Endurance_6C = SEG_LCD_LIGHT;
                SEG_Endurance_6D = SEG_LCD_LIGHT;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_LIGHT;
                SEG_Endurance_6G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Endurance_6A = SEG_LCD_GRAY_light;
                SEG_Endurance_6B = SEG_LCD_GRAY_light;
                SEG_Endurance_6C = SEG_LCD_GRAY_light;
                SEG_Endurance_6D = SEG_LCD_GRAY_light;
                SEG_Endurance_6E = SEG_LCD_GRAY_light;
                SEG_Endurance_6F = SEG_LCD_GRAY_light;
                SEG_Endurance_6G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    //---hyq--km/h
    SEG_Endurance_W38 = SEG_LCD_LIGHT;
  } 
}
/******************************************************************************
SEG_LCD_Vehicle_Speed_Num_Off
  : 복ʾر   
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_Vehicle_Speed_Num_Off(void)
{
  SEG_Endurance_4B     =  SEG_LCD_OFF ;
  SEG_Endurance_4C     =  SEG_LCD_OFF ;
  SEG_Endurance_4ADEG  =  SEG_LCD_OFF ;
  
  SEG_Endurance_5A     =  SEG_LCD_OFF ;
  SEG_Endurance_5B     =  SEG_LCD_OFF ;
  SEG_Endurance_5C     =  SEG_LCD_OFF ;
  SEG_Endurance_5D     =  SEG_LCD_OFF ;
  SEG_Endurance_5E     =  SEG_LCD_OFF ;
  SEG_Endurance_5F     =  SEG_LCD_OFF ;
  SEG_Endurance_5G     =  SEG_LCD_OFF ;
  
  SEG_Endurance_6A     =  SEG_LCD_OFF ;
  SEG_Endurance_6B     =  SEG_LCD_OFF ;
  SEG_Endurance_6C     =  SEG_LCD_OFF ;
  SEG_Endurance_6D     =  SEG_LCD_OFF ;
  SEG_Endurance_6E     =  SEG_LCD_OFF ;
  SEG_Endurance_6F     =  SEG_LCD_OFF ;
  SEG_Endurance_6G     =  SEG_LCD_OFF ;
                       
  SEG_Endurance_W38    =  SEG_LCD_OFF ;
  
  SEGLCDBackup.VSpeed = 0xFFFF;
}
uint8_t SegFlashNum=0;
uint8_t SegFlashFlag=0;
uint8_t SegFlashFlag1=0;
uint8_t SegFlashFlag2=0;

/******************************************************************************
SEG_LCD_SOC_Seg_Display
  : صʾ 
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_SOC_Speed_Seg_Display(uint8_t SegNum)
{
if (SegNum > 33)
SegNum = 33;

//if (SEGLCDBackup.SOCSeg != SegNum)
{
	SEGLCDBackup.SOCSeg = SegNum;
	if (SegNum==1)
	{ 
	  	if(FlashTimer==10)
		{
			SegFlashFlag2=1;
		} 
		if(SegFlashFlag2==1)
		SEG_Electric_D1   =  LED_ConTrol_Out(LED_SEG_ON,LED_1HZ); 
	}
	else
	{
		SEG_Electric_D1   =  SEG_LCD_LIGHT ;
		SegFlashFlag2=0;
	}
	if (SegNum==2)
	{ 
		if(FlashTimer==10)
		{
			SegFlashFlag1=1;
		}
		if(SegFlashFlag1==1)
		{
			
			if(SegFlashNum<3) 
			{
				SEG_Electric_D2   =  LED_ConTrol_Out(LED_SEG_ON,LED_1HZ);
			}
			else
			SEG_Electric_D2   =  SEG_LCD_LIGHT ;
			if(SEG_Electric_D2==7)
			{
				if(SegFlashFlag==0)
				{
					SegFlashFlag=1;
					if(SegFlashNum<3) 
					SegFlashNum++;
				}
			}
			else
			{

				SegFlashFlag=0;
			}
		}

	}
	else
	{
		SegFlashNum=0;
		SEG_Electric_D2   =  SEG_LCD_LIGHT ;
		SegFlashFlag1=0;
		SegFlashFlag=0;
	}
	
	SEG_Electric_D3   =  SEG_LCD_LIGHT ;
	SEG_Electric_D4   =  SEG_LCD_LIGHT ;
	SEG_Electric_D5   =  SEG_LCD_LIGHT ;
	SEG_Electric_D6   =  SEG_LCD_LIGHT ;
	SEG_Electric_D7   =  SEG_LCD_LIGHT ;
	SEG_Electric_D8   =  SEG_LCD_LIGHT ;
	SEG_Electric_D9   =  SEG_LCD_LIGHT ;
	SEG_Electric_D10  =  SEG_LCD_LIGHT ;
	
	SEG_Electric_D11  =  SEG_LCD_LIGHT ;
	
	switch (SegNum)
	{

	case 0  : SEG_Electric_D1  = SEG_LCD_GRAY;
		
	case 1  : SEG_Electric_D2  = SEG_LCD_GRAY;
	case 2  : SEG_Electric_D3  = SEG_LCD_GRAY;
	case 3  : SEG_Electric_D4  = SEG_LCD_GRAY;
	case 4  : SEG_Electric_D5  = SEG_LCD_GRAY;
		
	case 5  : SEG_Electric_D6  = SEG_LCD_GRAY;
	case 6  : SEG_Electric_D7  = SEG_LCD_GRAY;
	case 7  : SEG_Electric_D8  = SEG_LCD_GRAY;
	case 8  : SEG_Electric_D9  = SEG_LCD_GRAY;
		
	case 9  : SEG_Electric_D10 = SEG_LCD_GRAY;
		default : break;
	}
}  
}
/******************************************************************************
SEG_LCD_SOC_Seg_Off
  : תٶιرʾ
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_SOC_Speed_Seg_Off(void)
{
  SEG_Electric_D1  =  SEG_LCD_OFF ;
	SEG_Electric_D2  =  SEG_LCD_OFF ;
	SEG_Electric_D3  =  SEG_LCD_OFF ;
	SEG_Electric_D4  =  SEG_LCD_OFF ;
	SEG_Electric_D5  =  SEG_LCD_OFF ;
	SEG_Electric_D6  =  SEG_LCD_OFF ;
	SEG_Electric_D7  =  SEG_LCD_OFF ;
	SEG_Electric_D8  =  SEG_LCD_OFF ;
	SEG_Electric_D9  =  SEG_LCD_OFF ;
	SEG_Electric_D10 =  SEG_LCD_OFF ;
	
	SEG_Electric_D11 =  SEG_LCD_OFF ;
	
  SEGLCDBackup.SOCSeg = 0xFF;
}
/******************************************************************************
SEG_LCD_Engine_Speed_Seg_Display
  : תٶʾ  
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_Engine_Speed_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 15)
    SegNum = 15;
  
  if (SEGLCDBackup.ESpeedSeg != SegNum)
  {
    SEGLCDBackup.ESpeedSeg = SegNum;
    
    SEG_Blue_Rev_F1  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F2  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F3  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F4  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F5  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F6  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F7  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F8  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F9  =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F10 =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F11 =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F12 =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F13 =  SEG_LCD_LIGHT ;
	  SEG_Blue_Rev_F14 =  SEG_LCD_LIGHT ;
	  
	  SEG_Blue_Rev_F15 =  SEG_LCD_LIGHT ;
    
    switch (SegNum)
    {

      case 0  : SEG_Blue_Rev_F1  = SEG_LCD_GRAY;
                
			case 1  : SEG_Blue_Rev_F2  = SEG_LCD_GRAY;
			case 2  : SEG_Blue_Rev_F3  = SEG_LCD_GRAY;
			case 3  : SEG_Blue_Rev_F4  = SEG_LCD_GRAY;
			case 4  : SEG_Blue_Rev_F5  = SEG_LCD_GRAY;
		           
			case 5  : SEG_Blue_Rev_F6  = SEG_LCD_GRAY;
			case 6  : SEG_Blue_Rev_F7  = SEG_LCD_GRAY;
			case 7  : SEG_Blue_Rev_F8  = SEG_LCD_GRAY;
			case 8  : SEG_Blue_Rev_F9  = SEG_LCD_GRAY;
			          
			case 9  : SEG_Blue_Rev_F10 = SEG_LCD_GRAY;
			case 10 : SEG_Blue_Rev_F11 = SEG_LCD_GRAY;
			case 11 : SEG_Blue_Rev_F12 = SEG_LCD_GRAY;
			case 12 : SEG_Blue_Rev_F13 = SEG_LCD_GRAY;
			          
			case 13 : SEG_Blue_Rev_F14 = SEG_LCD_GRAY;
      default : break;
    }
  }  
}
/******************************************************************************
SEG_LCD_Engine_Speed_Seg_Off
  : תٶιرʾ
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_Engine_Speed_Seg_Off(void)
{
  SEG_Blue_Rev_F1  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F2  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F3  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F4  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F5  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F6  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F7  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F8  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F9  =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F10 =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F11 =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F12 =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F13 =  SEG_LCD_OFF ;
	SEG_Blue_Rev_F14 =  SEG_LCD_OFF ;
	
	SEG_Blue_Rev_F15 =  SEG_LCD_OFF ;
	
  SEGLCDBackup.ESpeedSeg = 0xFF;
}

/******************************************************************************
SEG_LCD_InstPower_Speed_Num_Display
  : ˲ʱʾ
  : Power ֵ
ֵ                               
******************************************************************************/
void SEG_LCD_InstPower_Speed_Num_Display(uint16_t Power)
{
  uint8_t Dig[3];
  
  if (SEGLCDBackup.Power != Power)
  {
    SEGLCDBackup.Power = Power;
    
    if (Power > 199)
      Power = 199;

   // Power /= 10;  
    Dig[0] = Power % 10;
    Power /= 10;
    Dig[1] = Power % 10; 
    Dig[2] = Power/10;
    
    if (Dig[2] == 0)
    {
      Dig[2] = 0x0F;
      
      if (Dig[1] == 0)
        Dig[1] = 0x0F;
    }
    switch (Dig[2])
    {
      case 1  : SEG_Power_1BC =  SEG_LCD_LIGHT ;
                break;
      
      default : SEG_Power_1BC =  SEG_LCD_GRAY_light ;
                break;
    }
    switch (Dig[1])
    {
    	case 0  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_LIGHT;
                SEG_Power_2F = SEG_LCD_LIGHT;
                SEG_Power_2G = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_Power_2A = SEG_LCD_GRAY_light;
      		      SEG_Power_2B = SEG_LCD_LIGHT;
      		      SEG_Power_2C = SEG_LCD_LIGHT;
      		      SEG_Power_2D = SEG_LCD_GRAY_light;  
                SEG_Power_2E = SEG_LCD_GRAY_light;  
                SEG_Power_2F = SEG_LCD_GRAY_light;  
                SEG_Power_2G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_GRAY_light;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_LIGHT;
                SEG_Power_2F = SEG_LCD_GRAY_light;
                SEG_Power_2G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_GRAY_light;   
                SEG_Power_2F = SEG_LCD_GRAY_light;    
                SEG_Power_2G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Power_2A = SEG_LCD_GRAY_light;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_GRAY_light;   
                SEG_Power_2E = SEG_LCD_GRAY_light;
                SEG_Power_2F = SEG_LCD_LIGHT;
                SEG_Power_2G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_GRAY_light;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_GRAY_light;
                SEG_Power_2F = SEG_LCD_LIGHT;
                SEG_Power_2G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_GRAY_light;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_LIGHT;
                SEG_Power_2F = SEG_LCD_LIGHT;
                SEG_Power_2G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_GRAY_light;
                SEG_Power_2E = SEG_LCD_GRAY_light;
                SEG_Power_2F = SEG_LCD_GRAY_light;
                SEG_Power_2G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_LIGHT;
                SEG_Power_2F = SEG_LCD_LIGHT;
                SEG_Power_2G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Power_2A = SEG_LCD_LIGHT;
                SEG_Power_2B = SEG_LCD_LIGHT;
                SEG_Power_2C = SEG_LCD_LIGHT;
                SEG_Power_2D = SEG_LCD_LIGHT;
                SEG_Power_2E = SEG_LCD_GRAY_light;
                SEG_Power_2F = SEG_LCD_LIGHT;
                SEG_Power_2G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Power_2A = SEG_LCD_GRAY_light;  
                SEG_Power_2B = SEG_LCD_GRAY_light;  
                SEG_Power_2C = SEG_LCD_GRAY_light;  
                SEG_Power_2D = SEG_LCD_GRAY_light;  
                SEG_Power_2E = SEG_LCD_GRAY_light;  
                SEG_Power_2F = SEG_LCD_GRAY_light;  
                SEG_Power_2G = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[0])
    {
    	case 0  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_LIGHT;
                SEG_Power_3F  = SEG_LCD_LIGHT;
                SEG_Power_3G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_Power_3A  = SEG_LCD_GRAY_light;
      		      SEG_Power_3B  = SEG_LCD_LIGHT;
      		      SEG_Power_3C  = SEG_LCD_LIGHT;
      		      SEG_Power_3D  = SEG_LCD_GRAY_light; 
                SEG_Power_3E  = SEG_LCD_GRAY_light; 
                SEG_Power_3F  = SEG_LCD_GRAY_light; 
                SEG_Power_3G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_GRAY_light;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_LIGHT;
                SEG_Power_3F  = SEG_LCD_GRAY_light;
                SEG_Power_3G  = SEG_LCD_LIGHT;
      			    break;
      			
      case 3  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_GRAY_light;   
                SEG_Power_3F  = SEG_LCD_GRAY_light;    
                SEG_Power_3G  = SEG_LCD_LIGHT;
      		    	break;
      		    	
      case 4  : SEG_Power_3A  = SEG_LCD_GRAY_light;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_GRAY_light; 
                SEG_Power_3E  = SEG_LCD_GRAY_light;
                SEG_Power_3F  = SEG_LCD_LIGHT;
                SEG_Power_3G  = SEG_LCD_LIGHT;
     			      break;
     			      
      case 5  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_GRAY_light; 
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_GRAY_light;
                SEG_Power_3F  = SEG_LCD_LIGHT;
                SEG_Power_3G  = SEG_LCD_LIGHT;
      			    break;
      			    
      case 6  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_GRAY_light;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_LIGHT;
                SEG_Power_3F  = SEG_LCD_LIGHT;
                SEG_Power_3G  = SEG_LCD_LIGHT;
      		    	break;
      		    	
      case 7  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_GRAY_light;  
                SEG_Power_3E  = SEG_LCD_GRAY_light;  
                SEG_Power_3F  = SEG_LCD_GRAY_light;  
                SEG_Power_3G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 8  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_LIGHT;
                SEG_Power_3F  = SEG_LCD_LIGHT;
                SEG_Power_3G  = SEG_LCD_LIGHT;
      		    	break;
      		    	
      case 9  : SEG_Power_3A  = SEG_LCD_LIGHT;
                SEG_Power_3B  = SEG_LCD_LIGHT;
                SEG_Power_3C  = SEG_LCD_LIGHT;
                SEG_Power_3D  = SEG_LCD_LIGHT;
                SEG_Power_3E  = SEG_LCD_GRAY_light;
                SEG_Power_3F  = SEG_LCD_LIGHT;
                SEG_Power_3G  = SEG_LCD_LIGHT;
                break;
                
      default : SEG_Power_3A  = SEG_LCD_GRAY_light;
                SEG_Power_3B  = SEG_LCD_GRAY_light;
                SEG_Power_3C  = SEG_LCD_GRAY_light;
                SEG_Power_3D  = SEG_LCD_GRAY_light;
                SEG_Power_3E  = SEG_LCD_GRAY_light;
                SEG_Power_3F  = SEG_LCD_GRAY_light;
                SEG_Power_3G  = SEG_LCD_GRAY_light;
      		    	break;
    }
    
    SEG_Power_W9 = SEG_LCD_LIGHT; 
  }
}
/******************************************************************************
SEG_LCD_InstPower_Speed_Num_Off
  : ˲ʱʾر
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_InstPower_Speed_Num_Off(void)
{
  SEG_Power_1BC =  SEG_LCD_OFF ;
                
  SEG_Power_2A  =  SEG_LCD_OFF ;
  SEG_Power_2B  =  SEG_LCD_OFF ;
  SEG_Power_2C  =  SEG_LCD_OFF ;
  SEG_Power_2D  =  SEG_LCD_OFF ;
  SEG_Power_2E  =  SEG_LCD_OFF ;
  SEG_Power_2F  =  SEG_LCD_OFF ;
  SEG_Power_2G  =  SEG_LCD_OFF ;
  
  SEG_Power_3A  =  SEG_LCD_OFF ;
  SEG_Power_3B  =  SEG_LCD_OFF ;
  SEG_Power_3C  =  SEG_LCD_OFF ;
  SEG_Power_3D  =  SEG_LCD_OFF ;
  SEG_Power_3E  =  SEG_LCD_OFF ;
  SEG_Power_3F  =  SEG_LCD_OFF ;
  SEG_Power_3G  =  SEG_LCD_OFF ;
  
  SEG_Power_W9  =  SEG_LCD_OFF ;

  SEGLCDBackup.Power = 0xFFFF;        //ʧЧֵ
}

/******************************************************************************
SEG_LCD_InstPower_Speed_Seg_Display
  : ˲ʱʾر
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_InstPower_Speed_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 26)
    SegNum = 26;
  
  if (SEGLCDBackup.InitPowerSeg != SegNum)
  {
   SEGLCDBackup.InitPowerSeg = SegNum;
    
    //----hyq--˲ʱʶ
    SEG_Blue_Z20  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z21  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z22  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z23  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z24  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z25  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z26  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z27  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z28  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z29  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z30  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z31  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z32  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z33  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z34  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z35  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z36  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z37  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z38  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z39  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z40  =  SEG_LCD_LIGHT ;
    SEG_Blue_Z41  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z42  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z43  =  SEG_LCD_LIGHT ;
    SEG_Blue_Z44  =  SEG_LCD_LIGHT ;
  	SEG_Blue_Z45  =  SEG_LCD_LIGHT ;

  	//----hyq--̶
  	SEG_Frame_Z3  =  SEG_LCD_LIGHT ;
  	SEG_Frame_Z4  =  SEG_LCD_LIGHT ;
  	SEG_Frame_Z5  =  SEG_LCD_LIGHT ;
  	SEG_Frame_Z6  =  SEG_LCD_LIGHT ;
  	SEG_Frame_Z7  =  SEG_LCD_LIGHT ;
  	SEG_Frame_Z8  =  SEG_LCD_LIGHT ;  
  	          
  	SEG_Frame_Z73  =  SEG_LCD_LIGHT ;
	  
    switch (SegNum)
    {
      case 0  : SEG_Blue_Z20 = SEG_LCD_GRAY;
      case 1  : SEG_Blue_Z21 = SEG_LCD_GRAY;
			case 2  : SEG_Blue_Z22 = SEG_LCD_GRAY;
			case 3  : SEG_Blue_Z23 = SEG_LCD_GRAY;
			case 4  : SEG_Blue_Z24 = SEG_LCD_GRAY;
			
			case 5  : SEG_Blue_Z25 = SEG_LCD_GRAY;
		  case 6  : SEG_Blue_Z26 = SEG_LCD_GRAY;
			case 7  : SEG_Blue_Z27 = SEG_LCD_GRAY;
			case 8  : SEG_Blue_Z28 = SEG_LCD_GRAY;
			case 9 : SEG_Blue_Z29 = SEG_LCD_GRAY;
			
			case 10 : SEG_Blue_Z30 = SEG_LCD_GRAY;
			case 11 : SEG_Blue_Z31 = SEG_LCD_GRAY;
			case 12 : SEG_Blue_Z32 = SEG_LCD_GRAY;
			case 13 : SEG_Blue_Z33 = SEG_LCD_GRAY;
			case 14 : SEG_Blue_Z34 = SEG_LCD_GRAY;
			
			case 15 : SEG_Blue_Z35 = SEG_LCD_GRAY;
			case 16 : SEG_Blue_Z36 = SEG_LCD_GRAY;
			case 17 : SEG_Blue_Z37 = SEG_LCD_GRAY;
			case 18 : SEG_Blue_Z38 = SEG_LCD_GRAY;
			case 19 : SEG_Blue_Z39 = SEG_LCD_GRAY;
			
			case 20 : SEG_Blue_Z40 = SEG_LCD_GRAY;
			case 21 : SEG_Blue_Z41 = SEG_LCD_GRAY;
			case 22 : SEG_Blue_Z42 = SEG_LCD_GRAY;
			case 23 : SEG_Blue_Z43 = SEG_LCD_GRAY;
			case 24 : SEG_Blue_Z44 = SEG_LCD_GRAY;
			
			case 25 : SEG_Blue_Z45 = SEG_LCD_GRAY;
		
      default : break;
    }
  }  
}
/******************************************************************************
SEG_LCD_InstPower_Speed_Seg_Off
  : ˲ʱʶιر
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_InstPower_Speed_Seg_Off(void)
{
  //˲ʱ
  SEG_Blue_Z20 =  SEG_LCD_OFF ;
	SEG_Blue_Z21 =  SEG_LCD_OFF ;
	SEG_Blue_Z22 =  SEG_LCD_OFF ;
	SEG_Blue_Z23 =  SEG_LCD_OFF ;
	SEG_Blue_Z24 =  SEG_LCD_OFF ;
	SEG_Blue_Z25 =  SEG_LCD_OFF ;
	SEG_Blue_Z26 =  SEG_LCD_OFF ;
	SEG_Blue_Z27 =  SEG_LCD_OFF ;
	SEG_Blue_Z28 =  SEG_LCD_OFF ;
	SEG_Blue_Z29 =  SEG_LCD_OFF ;
	SEG_Blue_Z30 =  SEG_LCD_OFF ;
	SEG_Blue_Z31 =  SEG_LCD_OFF ;
	SEG_Blue_Z32 =  SEG_LCD_OFF ;
	SEG_Blue_Z33 =  SEG_LCD_OFF ;
	SEG_Blue_Z34 =  SEG_LCD_OFF ;
	SEG_Blue_Z35 =  SEG_LCD_OFF ;
	SEG_Blue_Z36 =  SEG_LCD_OFF ;
	SEG_Blue_Z37 =  SEG_LCD_OFF ;
	SEG_Blue_Z38 =  SEG_LCD_OFF ;
	SEG_Blue_Z39 =  SEG_LCD_OFF ;
	SEG_Blue_Z40 =  SEG_LCD_OFF ;
	SEG_Blue_Z41 =  SEG_LCD_OFF ;
	SEG_Blue_Z42 =  SEG_LCD_OFF ;
	SEG_Blue_Z43 =  SEG_LCD_OFF ;
	SEG_Blue_Z44 =  SEG_LCD_OFF ;
	SEG_Blue_Z45 =  SEG_LCD_OFF ;
	
	//̶
	SEG_Frame_Z3 =  SEG_LCD_OFF ;
	SEG_Frame_Z4 =  SEG_LCD_OFF ;
	SEG_Frame_Z5 =  SEG_LCD_OFF ;
	SEG_Frame_Z6 =  SEG_LCD_OFF ;
	SEG_Frame_Z7 =  SEG_LCD_OFF ;
	SEG_Frame_Z8 =  SEG_LCD_OFF ;
	            
	SEG_Frame_Z73=  SEG_LCD_OFF ;	
  SEGLCDBackup.InitPowerSeg = 0xFF;  //ʧЧֵ
}

/******************************************************************************
SEG_LCD_RecPower_Speed_Seg_Display
  : ʾر
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_RecPower_Speed_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 11)
    SegNum = 11;
  
  if (SEGLCDBackup.RePowerSeg != SegNum)
  {
   SEGLCDBackup.RePowerSeg = SegNum;
  	//----hyq--ն
  	SEG_Green_Z9   =  SEG_LCD_LIGHT ;
  	SEG_Green_Z10  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z11  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z12  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z13  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z14  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z15  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z16  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z17  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z18  =  SEG_LCD_LIGHT ;
  	SEG_Green_Z19  =  SEG_LCD_LIGHT ;
  
    //̶
  	SEG_Frame_Z2  =  SEG_LCD_LIGHT ;
  	SEG_Frame_Z1  =  SEG_LCD_LIGHT ;
  		
  	
    switch (SegNum)
    {
      case 0  : SEG_Green_Z19 = SEG_LCD_GRAY;
      case 1  : SEG_Green_Z18 = SEG_LCD_GRAY;
			case 2  : SEG_Green_Z17 = SEG_LCD_GRAY;
			case 3  : SEG_Green_Z16 = SEG_LCD_GRAY;
			case 4  : SEG_Green_Z15 = SEG_LCD_GRAY;
			
			case 5  : SEG_Green_Z14 = SEG_LCD_GRAY;
		  case 6  : SEG_Green_Z13 = SEG_LCD_GRAY;
			case 7  : SEG_Green_Z12 = SEG_LCD_GRAY;
			case 8  : SEG_Green_Z11 = SEG_LCD_GRAY;
			case 9 : SEG_Green_Z10 = SEG_LCD_GRAY;
			
			case 10 : SEG_Green_Z9 = SEG_LCD_GRAY;
			
      default : break;
    }	
   }
 }
  	
/******************************************************************************
SEG_LCD_RecPower_Speed_Seg_Off
  : չʶιر
  : 
ֵ                               
******************************************************************************/
 void SEG_LCD_RecPower_Speed_Seg_Off(void)
{
  //
	SEG_Green_Z19 =  SEG_LCD_OFF ;
	SEG_Green_Z18 =  SEG_LCD_OFF ;
	SEG_Green_Z17 =  SEG_LCD_OFF ;
	SEG_Green_Z16 =  SEG_LCD_OFF ;
	SEG_Green_Z15 =  SEG_LCD_OFF ;
	              
	SEG_Green_Z14 =  SEG_LCD_OFF ;
	SEG_Green_Z13 =  SEG_LCD_OFF ;
	SEG_Green_Z12 =  SEG_LCD_OFF ;
	SEG_Green_Z11 =  SEG_LCD_OFF ;
	SEG_Green_Z10 =  SEG_LCD_OFF ;
	             
	SEG_Green_Z9  =  SEG_LCD_OFF ;
	
	SEG_Green_Z46 =  SEG_LCD_OFF ;
		
	//̶
	SEG_Frame_Z2  =  SEG_LCD_OFF ;
	SEG_Frame_Z1  =  SEG_LCD_OFF ;
  SEGLCDBackup.RePowerSeg = 0xFF;  //ʧЧֵ
}

/******************************************************************************
SEG_LCD_TotalPower_Speed_Seg_Display
  : ܹʾر
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_TotalPower_Speed_Seg_Display(uint8_t SegNum)
{
  if (SegNum > 26)
    SegNum = 26;
  
  if (SEGLCDBackup.TotalPowerSeg != SegNum)
  {
    SEGLCDBackup.TotalPowerSeg = SegNum;
  	//----hyq--ܹʾ
  	SEG_Yellow_Z47  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z48  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z49  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z50  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z51  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z52  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z53  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z54  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z55  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z56  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z57  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z58  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z59  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z60  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z61  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z62  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z63  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z64  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z65  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z66  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z67  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z68  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z69  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z70  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z71  =  SEG_LCD_LIGHT ;
  	SEG_Yellow_Z72  =  SEG_LCD_LIGHT ;
  	
    switch (SegNum)
    {
      case 0  : SEG_Yellow_Z47 = SEG_LCD_GRAY;
      case 1  : SEG_Yellow_Z48 = SEG_LCD_GRAY;
			case 2  : SEG_Yellow_Z49 = SEG_LCD_GRAY;
			case 3  : SEG_Yellow_Z50 = SEG_LCD_GRAY;
			case 4  : SEG_Yellow_Z51 = SEG_LCD_GRAY;
			
			case 5  : SEG_Yellow_Z52 = SEG_LCD_GRAY;
		  case 6  : SEG_Yellow_Z53 = SEG_LCD_GRAY;
			case 7  : SEG_Yellow_Z54 = SEG_LCD_GRAY;
			case 8  : SEG_Yellow_Z55 = SEG_LCD_GRAY;
			case 9 : SEG_Yellow_Z56 = SEG_LCD_GRAY;
			
			case 10 : SEG_Yellow_Z57 = SEG_LCD_GRAY;
			case 11 : SEG_Yellow_Z58 = SEG_LCD_GRAY;
			case 12 : SEG_Yellow_Z59 = SEG_LCD_GRAY;
			case 13 : SEG_Yellow_Z60 = SEG_LCD_GRAY;
			case 14 : SEG_Yellow_Z61 = SEG_LCD_GRAY;
			
			case 15 : SEG_Yellow_Z62 = SEG_LCD_GRAY;
			case 16 : SEG_Yellow_Z63 = SEG_LCD_GRAY;
			case 17 : SEG_Yellow_Z64 = SEG_LCD_GRAY;
			case 18 : SEG_Yellow_Z65 = SEG_LCD_GRAY;
			case 19 : SEG_Yellow_Z66 = SEG_LCD_GRAY;
			
			case 20 : SEG_Yellow_Z67 = SEG_LCD_GRAY;
			case 21 : SEG_Yellow_Z68 = SEG_LCD_GRAY;
			case 22 : SEG_Yellow_Z69 = SEG_LCD_GRAY;
			case 23 : SEG_Yellow_Z70 = SEG_LCD_GRAY;
			case 24 : SEG_Yellow_Z71 = SEG_LCD_GRAY;
			
			case 25 : SEG_Yellow_Z72 = SEG_LCD_GRAY;			
      default : break;
    }	
   }
   SEG_Green_Z46  =  SEG_LCD_LIGHT ;      
 }
 /******************************************************************************
SEG_LCD_TotalPower_Speed_Seg_Off
  : ܹʶر
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_TotalPower_Speed_Seg_Off(void)
{
  //ܹ
	SEG_Yellow_Z47  =  SEG_LCD_OFF ;
	SEG_Yellow_Z48  =  SEG_LCD_OFF ;
	SEG_Yellow_Z49  =  SEG_LCD_OFF ;
	SEG_Yellow_Z50  =  SEG_LCD_OFF ;
	SEG_Yellow_Z51  =  SEG_LCD_OFF ;
	SEG_Yellow_Z52  =  SEG_LCD_OFF ;
	SEG_Yellow_Z53  =  SEG_LCD_OFF ;
	SEG_Yellow_Z54  =  SEG_LCD_OFF ;
	SEG_Yellow_Z55  =  SEG_LCD_OFF ;
	SEG_Yellow_Z56  =  SEG_LCD_OFF ;
	SEG_Yellow_Z57  =  SEG_LCD_OFF ;
	SEG_Yellow_Z58  =  SEG_LCD_OFF ;
	SEG_Yellow_Z59  =  SEG_LCD_OFF ;
	SEG_Yellow_Z60  =  SEG_LCD_OFF ;
	SEG_Yellow_Z61  =  SEG_LCD_OFF ;
	SEG_Yellow_Z62  =  SEG_LCD_OFF ;
	SEG_Yellow_Z63  =  SEG_LCD_OFF ;
	SEG_Yellow_Z64  =  SEG_LCD_OFF ;
	SEG_Yellow_Z65  =  SEG_LCD_OFF ;
	SEG_Yellow_Z66  =  SEG_LCD_OFF ;
	SEG_Yellow_Z67  =  SEG_LCD_OFF ;
	SEG_Yellow_Z68  =  SEG_LCD_OFF ;
	SEG_Yellow_Z69  =  SEG_LCD_OFF ;
	SEG_Yellow_Z70  =  SEG_LCD_OFF ;
	SEG_Yellow_Z71  =  SEG_LCD_OFF ;
	SEG_Yellow_Z72  =  SEG_LCD_OFF ;
	SEG_Green_Z46  =  SEG_LCD_OFF ; 
	
  SEGLCDBackup.TotalPowerSeg = 0xFF;  //ʧЧֵ
}

/******************************************************************************
SEG_LCD_Volt_Speed_Num_Display
  : ѹʾ
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_Volt_Speed_Num_Display(uint16_t Voltage)
{
 
  uint8_t Dig[3];
  
  if (SEGLCDBackup.Voltage != Voltage)
  {
    SEGLCDBackup.Voltage = Voltage;
    
    if (Voltage > 999)
      Voltage = 999;
    
   // Vspeed /= 10;  
    Dig[0] = Voltage % 10;
    Voltage /= 10;
    Dig[1] = Voltage % 10; 
    Dig[2] = Voltage / 10;
    
    if (Dig[2] == 0)
    {
      Dig[2] = 0x0F;
      
      if (Dig[1] == 0)
        Dig[1] = 0x0F;
    }
    
    switch (Dig[2])
    {
      case 0  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_LIGHT;
                SEG_Endurance_10F   = SEG_LCD_LIGHT;
                SEG_Endurance_10G   = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_Endurance_10A   = SEG_LCD_GRAY_light;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_GRAY_light;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_GRAY_light;
                SEG_Endurance_10G   = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_GRAY_light;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_LIGHT;
                SEG_Endurance_10F   = SEG_LCD_GRAY_light;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_GRAY_light;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_Endurance_10A   = SEG_LCD_GRAY_light;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_GRAY_light;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_LIGHT;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_GRAY_light;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_LIGHT;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_GRAY_light;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_LIGHT;
                SEG_Endurance_10F   = SEG_LCD_LIGHT;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_GRAY_light;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_GRAY_light;
                SEG_Endurance_10G   = SEG_LCD_GRAY_light;
                break;               
                      
      case 8  : SEG_Endurance_10A   = SEG_LCD_LIGHT;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_LIGHT;
                SEG_Endurance_10F   = SEG_LCD_LIGHT;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_Endurance_10A   = SEG_LCD_LIGHT;;
                SEG_Endurance_10B   = SEG_LCD_LIGHT;
                SEG_Endurance_10C   = SEG_LCD_LIGHT;
                SEG_Endurance_10D   = SEG_LCD_LIGHT;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_LIGHT;
                SEG_Endurance_10G   = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_Endurance_10A   = SEG_LCD_GRAY_light;;
                SEG_Endurance_10B   = SEG_LCD_GRAY_light;
                SEG_Endurance_10C   = SEG_LCD_GRAY_light;
                SEG_Endurance_10D   = SEG_LCD_GRAY_light;
                SEG_Endurance_10E   = SEG_LCD_GRAY_light;
                SEG_Endurance_10F   = SEG_LCD_GRAY_light;
                SEG_Endurance_10G   = SEG_LCD_GRAY_light;        
                break;
    }
    
    switch (Dig[1])
    {
    	case 0  : SEG_Endurance_11A   = SEG_LCD_LIGHT;
                SEG_Endurance_11B   = SEG_LCD_LIGHT;
                SEG_Endurance_11C   = SEG_LCD_LIGHT;
                SEG_Endurance_11D   = SEG_LCD_LIGHT;
                SEG_Endurance_11E   = SEG_LCD_LIGHT;
                SEG_Endurance_11F   = SEG_LCD_LIGHT;
                SEG_Endurance_11G   = SEG_LCD_GRAY_light;
      			    break;
      			    
      case 1  : SEG_Endurance_11A   = SEG_LCD_GRAY_light;
      		      SEG_Endurance_11B   = SEG_LCD_LIGHT;
      		      SEG_Endurance_11C   = SEG_LCD_LIGHT;
      		      SEG_Endurance_11D   = SEG_LCD_GRAY_light;
                SEG_Endurance_11E   = SEG_LCD_GRAY_light;
                SEG_Endurance_11F   = SEG_LCD_GRAY_light;
                SEG_Endurance_11G   = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_Endurance_11A  = SEG_LCD_LIGHT;
                SEG_Endurance_11B  = SEG_LCD_LIGHT;
                SEG_Endurance_11C  = SEG_LCD_GRAY_light;
                SEG_Endurance_11D  = SEG_LCD_LIGHT;
                SEG_Endurance_11E  = SEG_LCD_LIGHT;
                SEG_Endurance_11F  = SEG_LCD_GRAY_light;
                SEG_Endurance_11G  = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Endurance_11A   = SEG_LCD_LIGHT;
                SEG_Endurance_11B   = SEG_LCD_LIGHT;
                SEG_Endurance_11C   = SEG_LCD_LIGHT;
                SEG_Endurance_11D   = SEG_LCD_LIGHT;
                SEG_Endurance_11E   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11F   = SEG_LCD_GRAY_light;   
                SEG_Endurance_11G   = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Endurance_11A   = SEG_LCD_GRAY_light;
                SEG_Endurance_11B   = SEG_LCD_LIGHT;
                SEG_Endurance_11C   = SEG_LCD_LIGHT;
                SEG_Endurance_11D   = SEG_LCD_GRAY_light;   
                SEG_Endurance_11E   = SEG_LCD_GRAY_light;
                SEG_Endurance_11F   = SEG_LCD_LIGHT;
                SEG_Endurance_11G   = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Endurance_11A   = SEG_LCD_LIGHT;
                SEG_Endurance_11B   = SEG_LCD_GRAY_light; 
                SEG_Endurance_11C   = SEG_LCD_LIGHT;
                SEG_Endurance_11D   = SEG_LCD_LIGHT;
                SEG_Endurance_11E   = SEG_LCD_GRAY_light;
                SEG_Endurance_11F   = SEG_LCD_LIGHT;
                SEG_Endurance_11G   = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Endurance_11A  = SEG_LCD_LIGHT;
                SEG_Endurance_11B  = SEG_LCD_GRAY_light;
                SEG_Endurance_11C  = SEG_LCD_LIGHT;
                SEG_Endurance_11D  = SEG_LCD_LIGHT;
                SEG_Endurance_11E  = SEG_LCD_LIGHT;
                SEG_Endurance_11F  = SEG_LCD_LIGHT;
                SEG_Endurance_11G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Endurance_11A  = SEG_LCD_LIGHT;
                SEG_Endurance_11B  = SEG_LCD_LIGHT;
                SEG_Endurance_11C  = SEG_LCD_LIGHT;
                SEG_Endurance_11D  = SEG_LCD_GRAY_light;  
                SEG_Endurance_11E  = SEG_LCD_GRAY_light;  
                SEG_Endurance_11F  = SEG_LCD_GRAY_light;  
                SEG_Endurance_11G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Endurance_11A   = SEG_LCD_LIGHT;
                SEG_Endurance_11B   = SEG_LCD_LIGHT;
                SEG_Endurance_11C   = SEG_LCD_LIGHT;
                SEG_Endurance_11D   = SEG_LCD_LIGHT;
                SEG_Endurance_11E   = SEG_LCD_LIGHT;
                SEG_Endurance_11F   = SEG_LCD_LIGHT;
                SEG_Endurance_11G   = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Endurance_11A   = SEG_LCD_LIGHT;
                SEG_Endurance_11B   = SEG_LCD_LIGHT;
                SEG_Endurance_11C   = SEG_LCD_LIGHT;
                SEG_Endurance_11D   = SEG_LCD_LIGHT;
                SEG_Endurance_11E   = SEG_LCD_GRAY_light;
                SEG_Endurance_11F   = SEG_LCD_LIGHT;
                SEG_Endurance_11G   = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Endurance_11A   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11B   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11C   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11D   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11E   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11F   = SEG_LCD_GRAY_light;  
                SEG_Endurance_11G   = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[0])
    {
    	case 0  : SEG_Endurance_12A  = SEG_LCD_LIGHT;
                SEG_Endurance_12B  = SEG_LCD_LIGHT;
                SEG_Endurance_12C  = SEG_LCD_LIGHT;
                SEG_Endurance_12D  = SEG_LCD_LIGHT;
                SEG_Endurance_12E  = SEG_LCD_LIGHT;
                SEG_Endurance_12F  = SEG_LCD_LIGHT;
                SEG_Endurance_12G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_Endurance_12A  = SEG_LCD_GRAY_light;
      		      SEG_Endurance_12B  = SEG_LCD_LIGHT;
      		      SEG_Endurance_12C  = SEG_LCD_LIGHT;
      		      SEG_Endurance_12D  = SEG_LCD_GRAY_light;
                SEG_Endurance_12E  = SEG_LCD_GRAY_light;
                SEG_Endurance_12F  = SEG_LCD_GRAY_light;
                SEG_Endurance_12G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_Endurance_12A  = SEG_LCD_LIGHT;
                SEG_Endurance_12B  = SEG_LCD_LIGHT;
                SEG_Endurance_12C  = SEG_LCD_GRAY_light;
                SEG_Endurance_12D  = SEG_LCD_LIGHT;
                SEG_Endurance_12E  = SEG_LCD_LIGHT;
                SEG_Endurance_12F  = SEG_LCD_GRAY_light;
                SEG_Endurance_12G  = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Endurance_12A = SEG_LCD_LIGHT;
                SEG_Endurance_12B = SEG_LCD_LIGHT;
                SEG_Endurance_12C = SEG_LCD_LIGHT;
                SEG_Endurance_12D = SEG_LCD_LIGHT;
                SEG_Endurance_12E = SEG_LCD_GRAY_light;
                SEG_Endurance_12F = SEG_LCD_GRAY_light;
                SEG_Endurance_12G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Endurance_12A  = SEG_LCD_GRAY_light;
                SEG_Endurance_12B  = SEG_LCD_LIGHT;
                SEG_Endurance_12C  = SEG_LCD_LIGHT;
                SEG_Endurance_12D  = SEG_LCD_GRAY_light;
                SEG_Endurance_12E  = SEG_LCD_GRAY_light;
                SEG_Endurance_12F  = SEG_LCD_LIGHT;
                SEG_Endurance_12G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Endurance_12A = SEG_LCD_LIGHT;
                SEG_Endurance_12B = SEG_LCD_GRAY_light;
                SEG_Endurance_12C = SEG_LCD_LIGHT;
                SEG_Endurance_12D = SEG_LCD_LIGHT;
                SEG_Endurance_12E = SEG_LCD_GRAY_light;
                SEG_Endurance_12F = SEG_LCD_LIGHT;
                SEG_Endurance_12G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Endurance_12A  = SEG_LCD_LIGHT;
                SEG_Endurance_12B  = SEG_LCD_GRAY_light;
                SEG_Endurance_12C  = SEG_LCD_LIGHT;
                SEG_Endurance_12D  = SEG_LCD_LIGHT;
                SEG_Endurance_12E  = SEG_LCD_LIGHT;
                SEG_Endurance_12F  = SEG_LCD_LIGHT;
                SEG_Endurance_12G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Endurance_12A  = SEG_LCD_LIGHT;
                SEG_Endurance_12B  = SEG_LCD_LIGHT;
                SEG_Endurance_12C  = SEG_LCD_LIGHT;
                SEG_Endurance_12D  = SEG_LCD_GRAY_light;
                SEG_Endurance_12E  = SEG_LCD_GRAY_light;
                SEG_Endurance_12F  = SEG_LCD_GRAY_light;
                SEG_Endurance_12G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Endurance_12A  = SEG_LCD_LIGHT;
                SEG_Endurance_12B  = SEG_LCD_LIGHT;
                SEG_Endurance_12C  = SEG_LCD_LIGHT;
                SEG_Endurance_12D  = SEG_LCD_LIGHT;
                SEG_Endurance_12E  = SEG_LCD_LIGHT;
                SEG_Endurance_12F  = SEG_LCD_LIGHT;
                SEG_Endurance_12G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Endurance_12A  = SEG_LCD_LIGHT;
                SEG_Endurance_12B  = SEG_LCD_LIGHT;
                SEG_Endurance_12C  = SEG_LCD_LIGHT;
                SEG_Endurance_12D  = SEG_LCD_LIGHT;
                SEG_Endurance_12E  = SEG_LCD_GRAY_light;
                SEG_Endurance_12F  = SEG_LCD_LIGHT;
                SEG_Endurance_12G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Endurance_12A  = SEG_LCD_GRAY_light;
                SEG_Endurance_12B  = SEG_LCD_GRAY_light;
                SEG_Endurance_12C  = SEG_LCD_GRAY_light;
                SEG_Endurance_12D  = SEG_LCD_GRAY_light;
                SEG_Endurance_12E  = SEG_LCD_GRAY_light;
                SEG_Endurance_12F  = SEG_LCD_GRAY_light;
                SEG_Endurance_12G  = SEG_LCD_GRAY_light; 
      		    	break;
    }
    
    SEG_Endurance_W46 = SEG_LCD_LIGHT;
  }  
}

/******************************************************************************
SEG_LCD_Volt_Speed_Num_Off
  : ѹֹر  
  : 
ֵ                               
******************************************************************************/
void SEG_LCD_Volt_Speed_Num_Off(void)
{
  SEG_Endurance_10A   =  SEG_LCD_OFF ;
  SEG_Endurance_10B   =  SEG_LCD_OFF ;
  SEG_Endurance_10C   =  SEG_LCD_OFF ;
  SEG_Endurance_10D   =  SEG_LCD_OFF ;
  SEG_Endurance_10E   =  SEG_LCD_OFF ;
  SEG_Endurance_10F   =  SEG_LCD_OFF ;
  SEG_Endurance_10G   =  SEG_LCD_OFF ;
    
  SEG_Endurance_11A   =  SEG_LCD_OFF ;
  SEG_Endurance_11B   =  SEG_LCD_OFF ;
  SEG_Endurance_11C   =  SEG_LCD_OFF ;
  SEG_Endurance_11D   =  SEG_LCD_OFF ;
  SEG_Endurance_11E   =  SEG_LCD_OFF ;
  SEG_Endurance_11F   =  SEG_LCD_OFF ;
  SEG_Endurance_11G   =  SEG_LCD_OFF ;
    
  SEG_Endurance_12A   =  SEG_LCD_OFF ;
  SEG_Endurance_12B   =  SEG_LCD_OFF ;
  SEG_Endurance_12C   =  SEG_LCD_OFF ;
  SEG_Endurance_12D   =  SEG_LCD_OFF ;
  SEG_Endurance_12E   =  SEG_LCD_OFF ;
  SEG_Endurance_12F   =  SEG_LCD_OFF ;
  SEG_Endurance_12G   =  SEG_LCD_OFF ;
     
  SEG_Endurance_W46   =  SEG_LCD_OFF ;
  
  SEGLCDBackup.Voltage = 0xFFFF;
}

/******************************************************************************
SEG_LCD_Curr_Speed_Num_Display
  : ʾ
  : 
ֵ
˵  ʾ߼δ ----hyq--20180428                               
******************************************************************************/
void SEG_LCD_Curr_Speed_Num_Display(uint16_t Current)
{ 
  uint8_t Dig[3];
  
  if (SEGLCDBackup.Current != Current)
  {
    SEGLCDBackup.Current = Current;
   
    
   
    
   // Vspeed /= 10;  
    Dig[0] = Current % 10;
    Current /= 10;
    Dig[1] = Current % 10; 
    Dig[2] = Current / 10;
    
    if (Dig[2] == 0)
    {
      Dig[2] = 0x0F;
      
      if (Dig[1] == 0)
        Dig[1] = 0x0F;
    }
    
    if((((uint16_t)BMS_BattCurrDisp)/20)>1600)
    {
      
       //  '|'
    SEG_Current_W20 =  SEG_LCD_LIGHT;
    }
    else if((((uint16_t)BMS_BattCurrDisp)/20)<1600)
    {
      
      //ź  '-'
      SEG_Current_W19 =  SEG_LCD_LIGHT;
       SEG_Current_W20 =  SEG_LCD_GRAY_light;
    }
    else
    {
      SEG_Current_W19 =  SEG_LCD_GRAY_light;
      SEG_Current_W20 =  SEG_LCD_GRAY_light;
    }
    
 
    
    
    switch (Dig[2])
    {
      case 0  : SEG_Current_7A  = SEG_LCD_LIGHT;
                SEG_Current_7B  = SEG_LCD_LIGHT;
                SEG_Current_7C  = SEG_LCD_LIGHT;
                SEG_Current_7D  = SEG_LCD_LIGHT;
                SEG_Current_7E  = SEG_LCD_LIGHT;
                SEG_Current_7F  = SEG_LCD_LIGHT;
                SEG_Current_7G  = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_Current_7A    = SEG_LCD_GRAY_light;
                SEG_Current_7B    = SEG_LCD_LIGHT;
                SEG_Current_7C    = SEG_LCD_LIGHT;
                SEG_Current_7D    = SEG_LCD_GRAY_light;
                SEG_Current_7E    = SEG_LCD_GRAY_light;
                SEG_Current_7F    = SEG_LCD_GRAY_light;
                SEG_Current_7G    = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_Current_7A    = SEG_LCD_LIGHT;
                SEG_Current_7B    = SEG_LCD_LIGHT;
                SEG_Current_7C    = SEG_LCD_GRAY_light;
                SEG_Current_7D    = SEG_LCD_LIGHT;
                SEG_Current_7E    = SEG_LCD_LIGHT;
                SEG_Current_7F    = SEG_LCD_GRAY_light;
                SEG_Current_7G    = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_Current_7A    = SEG_LCD_LIGHT;
                SEG_Current_7B    = SEG_LCD_LIGHT;
                SEG_Current_7C    = SEG_LCD_LIGHT;
                SEG_Current_7D    = SEG_LCD_LIGHT;
                SEG_Current_7E    = SEG_LCD_GRAY_light;
                SEG_Current_7F    = SEG_LCD_GRAY_light;
                SEG_Current_7G    = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_Current_7A    = SEG_LCD_GRAY_light;
                SEG_Current_7B    = SEG_LCD_LIGHT;
                SEG_Current_7C    = SEG_LCD_LIGHT;
                SEG_Current_7D    = SEG_LCD_GRAY_light;
                SEG_Current_7E    = SEG_LCD_GRAY_light;
                SEG_Current_7F    = SEG_LCD_LIGHT;
                SEG_Current_7G    = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_Current_7A   = SEG_LCD_LIGHT;
                SEG_Current_7B   = SEG_LCD_GRAY_light;
                SEG_Current_7C   = SEG_LCD_LIGHT;
                SEG_Current_7D   = SEG_LCD_LIGHT;
                SEG_Current_7E   = SEG_LCD_GRAY_light;
                SEG_Current_7F   = SEG_LCD_LIGHT;
                SEG_Current_7G   = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_Current_7A   = SEG_LCD_LIGHT;
                SEG_Current_7B   = SEG_LCD_GRAY_light;
                SEG_Current_7C   = SEG_LCD_LIGHT;
                SEG_Current_7D   = SEG_LCD_LIGHT;
                SEG_Current_7E   = SEG_LCD_LIGHT;
                SEG_Current_7F   = SEG_LCD_LIGHT;
                SEG_Current_7G   = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_Current_7A   = SEG_LCD_LIGHT;
                SEG_Current_7B   = SEG_LCD_LIGHT;
                SEG_Current_7C   = SEG_LCD_LIGHT;
                SEG_Current_7D   = SEG_LCD_GRAY_light;
                SEG_Current_7E   = SEG_LCD_GRAY_light;
                SEG_Current_7F   = SEG_LCD_GRAY_light;
                SEG_Current_7G   = SEG_LCD_GRAY_light;
                break;               
                      
      case 8  : SEG_Current_7A   = SEG_LCD_LIGHT;
                SEG_Current_7B   = SEG_LCD_LIGHT;
                SEG_Current_7C   = SEG_LCD_LIGHT;
                SEG_Current_7D   = SEG_LCD_LIGHT;
                SEG_Current_7E   = SEG_LCD_LIGHT;
                SEG_Current_7F   = SEG_LCD_LIGHT;
                SEG_Current_7G   = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_Current_7A   = SEG_LCD_LIGHT;;
                SEG_Current_7B   = SEG_LCD_LIGHT;
                SEG_Current_7C   = SEG_LCD_LIGHT;
                SEG_Current_7D   = SEG_LCD_LIGHT;
                SEG_Current_7E   = SEG_LCD_GRAY_light;
                SEG_Current_7F   = SEG_LCD_LIGHT;
                SEG_Current_7G   = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_Current_7A   = SEG_LCD_GRAY_light;;
                SEG_Current_7B   = SEG_LCD_GRAY_light;
                SEG_Current_7C   = SEG_LCD_GRAY_light;
                SEG_Current_7D   = SEG_LCD_GRAY_light;
                SEG_Current_7E   = SEG_LCD_GRAY_light;
                SEG_Current_7F   = SEG_LCD_GRAY_light;
                SEG_Current_7G   = SEG_LCD_GRAY_light;        
                break;
    }
    
    switch (Dig[1])
    {
    	case 0  : SEG_Current_8A  = SEG_LCD_LIGHT;
                SEG_Current_8B  = SEG_LCD_LIGHT;
                SEG_Current_8C  = SEG_LCD_LIGHT;
                SEG_Current_8D  = SEG_LCD_LIGHT;
                SEG_Current_8E  = SEG_LCD_LIGHT;
                SEG_Current_8F  = SEG_LCD_LIGHT;
                SEG_Current_8G  = SEG_LCD_GRAY_light;
      			    break;
      			    
      case 1  : SEG_Current_8A  = SEG_LCD_GRAY_light;
      		      SEG_Current_8B  = SEG_LCD_LIGHT;
      		      SEG_Current_8C  = SEG_LCD_LIGHT;
      		      SEG_Current_8D  = SEG_LCD_GRAY_light;
                SEG_Current_8E  = SEG_LCD_GRAY_light;
                SEG_Current_8F  = SEG_LCD_GRAY_light;
                SEG_Current_8G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_Current_8A = SEG_LCD_LIGHT;
                SEG_Current_8B = SEG_LCD_LIGHT;
                SEG_Current_8C = SEG_LCD_GRAY_light;
                SEG_Current_8D = SEG_LCD_LIGHT;
                SEG_Current_8E = SEG_LCD_LIGHT;
                SEG_Current_8F = SEG_LCD_GRAY_light;
                SEG_Current_8G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Current_8A  = SEG_LCD_LIGHT;
                SEG_Current_8B  = SEG_LCD_LIGHT;
                SEG_Current_8C  = SEG_LCD_LIGHT;
                SEG_Current_8D  = SEG_LCD_LIGHT;
                SEG_Current_8E  = SEG_LCD_GRAY_light;  
                SEG_Current_8F  = SEG_LCD_GRAY_light;   
                SEG_Current_8G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Current_8A  = SEG_LCD_GRAY_light;
                SEG_Current_8B  = SEG_LCD_LIGHT;
                SEG_Current_8C  = SEG_LCD_LIGHT;
                SEG_Current_8D  = SEG_LCD_GRAY_light;   
                SEG_Current_8E  = SEG_LCD_GRAY_light;
                SEG_Current_8F  = SEG_LCD_LIGHT;
                SEG_Current_8G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Current_8A  = SEG_LCD_LIGHT;
                SEG_Current_8B  = SEG_LCD_GRAY_light; 
                SEG_Current_8C  = SEG_LCD_LIGHT;
                SEG_Current_8D  = SEG_LCD_LIGHT;
                SEG_Current_8E  = SEG_LCD_GRAY_light;
                SEG_Current_8F  = SEG_LCD_LIGHT;
                SEG_Current_8G  = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Current_8A = SEG_LCD_LIGHT;
                SEG_Current_8B = SEG_LCD_GRAY_light;
                SEG_Current_8C = SEG_LCD_LIGHT;
                SEG_Current_8D = SEG_LCD_LIGHT;
                SEG_Current_8E = SEG_LCD_LIGHT;
                SEG_Current_8F = SEG_LCD_LIGHT;
                SEG_Current_8G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Current_8A = SEG_LCD_LIGHT;
                SEG_Current_8B = SEG_LCD_LIGHT;
                SEG_Current_8C = SEG_LCD_LIGHT;
                SEG_Current_8D = SEG_LCD_GRAY_light;  
                SEG_Current_8E = SEG_LCD_GRAY_light;  
                SEG_Current_8F = SEG_LCD_GRAY_light;  
                SEG_Current_8G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Current_8A  = SEG_LCD_LIGHT;
                SEG_Current_8B  = SEG_LCD_LIGHT;
                SEG_Current_8C  = SEG_LCD_LIGHT;
                SEG_Current_8D  = SEG_LCD_LIGHT;
                SEG_Current_8E  = SEG_LCD_LIGHT;
                SEG_Current_8F  = SEG_LCD_LIGHT;
                SEG_Current_8G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Current_8A  = SEG_LCD_LIGHT;
                SEG_Current_8B  = SEG_LCD_LIGHT;
                SEG_Current_8C  = SEG_LCD_LIGHT;
                SEG_Current_8D  = SEG_LCD_LIGHT;
                SEG_Current_8E  = SEG_LCD_GRAY_light;
                SEG_Current_8F  = SEG_LCD_LIGHT;
                SEG_Current_8G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Current_8A = SEG_LCD_GRAY_light;  
                SEG_Current_8B = SEG_LCD_GRAY_light;  
                SEG_Current_8C = SEG_LCD_GRAY_light;  
                SEG_Current_8D = SEG_LCD_GRAY_light;  
                SEG_Current_8E = SEG_LCD_GRAY_light;  
                SEG_Current_8F = SEG_LCD_GRAY_light;  
                SEG_Current_8G = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[0])
    {
    	case 0  : SEG_Current_9A  = SEG_LCD_LIGHT;
                SEG_Current_9B  = SEG_LCD_LIGHT;
                SEG_Current_9C  = SEG_LCD_LIGHT;
                SEG_Current_9D  = SEG_LCD_LIGHT;
                SEG_Current_9E  = SEG_LCD_LIGHT;
                SEG_Current_9F  = SEG_LCD_LIGHT;
                SEG_Current_9G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_Current_9A  = SEG_LCD_GRAY_light;
      		      SEG_Current_9B  = SEG_LCD_LIGHT;
      		      SEG_Current_9C  = SEG_LCD_LIGHT;
      		      SEG_Current_9D  = SEG_LCD_GRAY_light;
                SEG_Current_9E  = SEG_LCD_GRAY_light;
                SEG_Current_9F  = SEG_LCD_GRAY_light;
                SEG_Current_9G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_Current_9A = SEG_LCD_LIGHT;
                SEG_Current_9B = SEG_LCD_LIGHT;
                SEG_Current_9C = SEG_LCD_GRAY_light;
                SEG_Current_9D = SEG_LCD_LIGHT;
                SEG_Current_9E = SEG_LCD_LIGHT;
                SEG_Current_9F = SEG_LCD_GRAY_light;
                SEG_Current_9G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Current_9A = SEG_LCD_LIGHT;
                SEG_Current_9B = SEG_LCD_LIGHT;
                SEG_Current_9C = SEG_LCD_LIGHT;
                SEG_Current_9D = SEG_LCD_LIGHT;
                SEG_Current_9E = SEG_LCD_GRAY_light;
                SEG_Current_9F = SEG_LCD_GRAY_light;
                SEG_Current_9G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Current_9A  = SEG_LCD_GRAY_light;
                SEG_Current_9B  = SEG_LCD_LIGHT;
                SEG_Current_9C  = SEG_LCD_LIGHT;
                SEG_Current_9D  = SEG_LCD_GRAY_light;
                SEG_Current_9E  = SEG_LCD_GRAY_light;
                SEG_Current_9F  = SEG_LCD_LIGHT;
                SEG_Current_9G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Current_9A = SEG_LCD_LIGHT;
                SEG_Current_9B = SEG_LCD_GRAY_light;
                SEG_Current_9C = SEG_LCD_LIGHT;
                SEG_Current_9D = SEG_LCD_LIGHT;
                SEG_Current_9E = SEG_LCD_GRAY_light;
                SEG_Current_9F = SEG_LCD_LIGHT;
                SEG_Current_9G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Current_9A  = SEG_LCD_LIGHT;
                SEG_Current_9B  = SEG_LCD_GRAY_light;
                SEG_Current_9C  = SEG_LCD_LIGHT;
                SEG_Current_9D  = SEG_LCD_LIGHT;
                SEG_Current_9E  = SEG_LCD_LIGHT;
                SEG_Current_9F  = SEG_LCD_LIGHT;
                SEG_Current_9G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Current_9A  = SEG_LCD_LIGHT;
                SEG_Current_9B  = SEG_LCD_LIGHT;
                SEG_Current_9C  = SEG_LCD_LIGHT;
                SEG_Current_9D  = SEG_LCD_GRAY_light;
                SEG_Current_9E  = SEG_LCD_GRAY_light;
                SEG_Current_9F  = SEG_LCD_GRAY_light;
                SEG_Current_9G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Current_9A  = SEG_LCD_LIGHT;
                SEG_Current_9B  = SEG_LCD_LIGHT;
                SEG_Current_9C  = SEG_LCD_LIGHT;
                SEG_Current_9D  = SEG_LCD_LIGHT;
                SEG_Current_9E  = SEG_LCD_LIGHT;
                SEG_Current_9F  = SEG_LCD_LIGHT;
                SEG_Current_9G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Current_9A  = SEG_LCD_LIGHT;
                SEG_Current_9B  = SEG_LCD_LIGHT;
                SEG_Current_9C  = SEG_LCD_LIGHT;
                SEG_Current_9D  = SEG_LCD_LIGHT;
                SEG_Current_9E  = SEG_LCD_GRAY_light;
                SEG_Current_9F  = SEG_LCD_LIGHT;
                SEG_Current_9G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Current_9A = SEG_LCD_GRAY_light;
                SEG_Current_9B = SEG_LCD_GRAY_light;
                SEG_Current_9C = SEG_LCD_GRAY_light;
                SEG_Current_9D = SEG_LCD_GRAY_light;
                SEG_Current_9E = SEG_LCD_GRAY_light;
                SEG_Current_9F = SEG_LCD_GRAY_light;
                SEG_Current_9G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    
    SEG_Current_W21 = SEG_LCD_LIGHT;
  }  
}

/******************************************************************************
SEG_LCD_Curr_Speed_Num_Off
  : ʾ
  : 
ֵ
˵                                
******************************************************************************/
void SEG_LCD_Curr_Speed_Num_Off(void)
{ 
  SEG_Current_7A  =  SEG_LCD_OFF ;
  SEG_Current_7B  =  SEG_LCD_OFF ;
  SEG_Current_7C  =  SEG_LCD_OFF ;
  SEG_Current_7D  =  SEG_LCD_OFF ;
  SEG_Current_7E  =  SEG_LCD_OFF ;
  SEG_Current_7F  =  SEG_LCD_OFF ;
  SEG_Current_7G  =  SEG_LCD_OFF ;

  SEG_Current_8A  =  SEG_LCD_OFF ;
  SEG_Current_8B  =  SEG_LCD_OFF ;
  SEG_Current_8C  =  SEG_LCD_OFF ;
  SEG_Current_8D  =  SEG_LCD_OFF ;
  SEG_Current_8E  =  SEG_LCD_OFF ;
  SEG_Current_8F  =  SEG_LCD_OFF ;
  SEG_Current_8G  =  SEG_LCD_OFF ;

  SEG_Current_9A   =  SEG_LCD_OFF ;
  SEG_Current_9B   =  SEG_LCD_OFF ;
  SEG_Current_9C   =  SEG_LCD_OFF ;
  SEG_Current_9D   =  SEG_LCD_OFF ;
  SEG_Current_9E   =  SEG_LCD_OFF ;
  SEG_Current_9F   =  SEG_LCD_OFF ;
  SEG_Current_9G   =  SEG_LCD_OFF ;
  
  //
  SEG_Current_W19  =  SEG_LCD_OFF ;
  SEG_Current_W20  =  SEG_LCD_OFF ;
  
  //λ
  SEG_Current_W21  =  SEG_LCD_OFF ;

  SEGLCDBackup.Current = 0xFFFF; 
}                   
                    
/******************************************************************************
SEG_LCD_Mileage_Speed_Num_Display
  : ʾ
  : 
ֵ
˵                              
******************************************************************************/
void SEG_LCD_Mileage_Speed_Num_Display(uint16_t Vspeed)
{ 
  uint8_t Dig[3];
  
   if (SEGLCDBackup.Mileage != Vspeed)
  {
    SEGLCDBackup.Mileage = Vspeed;
  
   
    
    if (Vspeed > 2200)
      Vspeed = 2200;
    
    //Vspeed /= 10;  
    Dig[0] = Vspeed % 10;
    Vspeed /= 10;
    Dig[1] = Vspeed % 10; 
    Dig[2] = Vspeed / 10;
    
    if (Dig[2] == 0)
    {
      Dig[2] = 0x0F;
      
      if (Dig[1] == 0)
        Dig[1] = 0x0F;
    }
    
    switch (Dig[2])
    {
      case 0  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_LIGHT;
                SEG_Endurance_19F  = SEG_LCD_LIGHT;
                SEG_Endurance_19G  = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_Endurance_19A  = SEG_LCD_GRAY_light;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_GRAY_light;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_GRAY_light;
                SEG_Endurance_19G  = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_GRAY_light;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_LIGHT;
                SEG_Endurance_19F  = SEG_LCD_GRAY_light;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_GRAY_light;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_Endurance_19A  = SEG_LCD_GRAY_light;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_GRAY_light;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_LIGHT;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_GRAY_light;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_LIGHT;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_GRAY_light;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_LIGHT;
                SEG_Endurance_19F  = SEG_LCD_LIGHT;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_GRAY_light;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_GRAY_light;
                SEG_Endurance_19G  = SEG_LCD_GRAY_light;
                break;              
                      
      case 8  : SEG_Endurance_19A  = SEG_LCD_LIGHT;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_LIGHT;
                SEG_Endurance_19F  = SEG_LCD_LIGHT;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_Endurance_19A  = SEG_LCD_LIGHT;;
                SEG_Endurance_19B  = SEG_LCD_LIGHT;
                SEG_Endurance_19C  = SEG_LCD_LIGHT;
                SEG_Endurance_19D  = SEG_LCD_LIGHT;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_LIGHT;
                SEG_Endurance_19G  = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_Endurance_19A  = SEG_LCD_GRAY_light;;
                SEG_Endurance_19B  = SEG_LCD_GRAY_light;
                SEG_Endurance_19C  = SEG_LCD_GRAY_light;
                SEG_Endurance_19D  = SEG_LCD_GRAY_light;
                SEG_Endurance_19E  = SEG_LCD_GRAY_light;
                SEG_Endurance_19F  = SEG_LCD_GRAY_light;
                SEG_Endurance_19G  = SEG_LCD_GRAY_light;        
                break;
    }
    
    switch (Dig[1])
    {
    	case 0  : SEG_Endurance_20A  = SEG_LCD_LIGHT;
                SEG_Endurance_20B  = SEG_LCD_LIGHT;
                SEG_Endurance_20C  = SEG_LCD_LIGHT;
                SEG_Endurance_20D  = SEG_LCD_LIGHT;
                SEG_Endurance_20E  = SEG_LCD_LIGHT;
                SEG_Endurance_20F  = SEG_LCD_LIGHT;
                SEG_Endurance_20G  = SEG_LCD_GRAY_light;
      			    break;
      			    
      case 1  : SEG_Endurance_20A  = SEG_LCD_GRAY_light;
      		      SEG_Endurance_20B  = SEG_LCD_LIGHT;
      		      SEG_Endurance_20C  = SEG_LCD_LIGHT;
      		      SEG_Endurance_20D  = SEG_LCD_GRAY_light;
                SEG_Endurance_20E  = SEG_LCD_GRAY_light;
                SEG_Endurance_20F  = SEG_LCD_GRAY_light;
                SEG_Endurance_20G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_Endurance_20A = SEG_LCD_LIGHT;
                SEG_Endurance_20B = SEG_LCD_LIGHT;
                SEG_Endurance_20C = SEG_LCD_GRAY_light;
                SEG_Endurance_20D = SEG_LCD_LIGHT;
                SEG_Endurance_20E = SEG_LCD_LIGHT;
                SEG_Endurance_20F = SEG_LCD_GRAY_light;
                SEG_Endurance_20G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Endurance_20A  = SEG_LCD_LIGHT;
                SEG_Endurance_20B  = SEG_LCD_LIGHT;
                SEG_Endurance_20C  = SEG_LCD_LIGHT;
                SEG_Endurance_20D  = SEG_LCD_LIGHT;
                SEG_Endurance_20E  = SEG_LCD_GRAY_light;  
                SEG_Endurance_20F  = SEG_LCD_GRAY_light;   
                SEG_Endurance_20G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Endurance_20A  = SEG_LCD_GRAY_light;
                SEG_Endurance_20B  = SEG_LCD_LIGHT;
                SEG_Endurance_20C  = SEG_LCD_LIGHT;
                SEG_Endurance_20D  = SEG_LCD_GRAY_light;   
                SEG_Endurance_20E  = SEG_LCD_GRAY_light;
                SEG_Endurance_20F  = SEG_LCD_LIGHT;
                SEG_Endurance_20G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Endurance_20A = SEG_LCD_LIGHT;
                SEG_Endurance_20B = SEG_LCD_GRAY_light; 
                SEG_Endurance_20C = SEG_LCD_LIGHT;
                SEG_Endurance_20D = SEG_LCD_LIGHT;
                SEG_Endurance_20E = SEG_LCD_GRAY_light;
                SEG_Endurance_20F = SEG_LCD_LIGHT;
                SEG_Endurance_20G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Endurance_20A = SEG_LCD_LIGHT;
                SEG_Endurance_20B = SEG_LCD_GRAY_light;
                SEG_Endurance_20C = SEG_LCD_LIGHT;
                SEG_Endurance_20D = SEG_LCD_LIGHT;
                SEG_Endurance_20E = SEG_LCD_LIGHT;
                SEG_Endurance_20F = SEG_LCD_LIGHT;
                SEG_Endurance_20G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Endurance_20A = SEG_LCD_LIGHT;
                SEG_Endurance_20B = SEG_LCD_LIGHT;
                SEG_Endurance_20C = SEG_LCD_LIGHT;
                SEG_Endurance_20D = SEG_LCD_GRAY_light;  
                SEG_Endurance_20E = SEG_LCD_GRAY_light;  
                SEG_Endurance_20F = SEG_LCD_GRAY_light;  
                SEG_Endurance_20G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Endurance_20A  = SEG_LCD_LIGHT;
                SEG_Endurance_20B  = SEG_LCD_LIGHT;
                SEG_Endurance_20C  = SEG_LCD_LIGHT;
                SEG_Endurance_20D  = SEG_LCD_LIGHT;
                SEG_Endurance_20E  = SEG_LCD_LIGHT;
                SEG_Endurance_20F  = SEG_LCD_LIGHT;
                SEG_Endurance_20G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Endurance_20A  = SEG_LCD_LIGHT;
                SEG_Endurance_20B  = SEG_LCD_LIGHT;
                SEG_Endurance_20C  = SEG_LCD_LIGHT;
                SEG_Endurance_20D  = SEG_LCD_LIGHT;
                SEG_Endurance_20E  = SEG_LCD_GRAY_light;
                SEG_Endurance_20F  = SEG_LCD_LIGHT;
                SEG_Endurance_20G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Endurance_20A = SEG_LCD_GRAY_light;  
                SEG_Endurance_20B = SEG_LCD_GRAY_light;  
                SEG_Endurance_20C = SEG_LCD_GRAY_light;  
                SEG_Endurance_20D = SEG_LCD_GRAY_light;  
                SEG_Endurance_20E = SEG_LCD_GRAY_light;  
                SEG_Endurance_20F = SEG_LCD_GRAY_light;  
                SEG_Endurance_20G = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[0])
    {
    	case 0  : SEG_Endurance_21A  = SEG_LCD_LIGHT;
                SEG_Endurance_21B  = SEG_LCD_LIGHT;
                SEG_Endurance_21C  = SEG_LCD_LIGHT;
                SEG_Endurance_21D  = SEG_LCD_LIGHT;
                SEG_Endurance_21E  = SEG_LCD_LIGHT;
                SEG_Endurance_21F  = SEG_LCD_LIGHT;
                SEG_Endurance_21G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_Endurance_21A  = SEG_LCD_GRAY_light;
      		      SEG_Endurance_21B  = SEG_LCD_LIGHT;
      		      SEG_Endurance_21C  = SEG_LCD_LIGHT;
      		      SEG_Endurance_21D  = SEG_LCD_GRAY_light;
                SEG_Endurance_21E  = SEG_LCD_GRAY_light;
                SEG_Endurance_21F  = SEG_LCD_GRAY_light;
                SEG_Endurance_21G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_Endurance_21A = SEG_LCD_LIGHT;
                SEG_Endurance_21B = SEG_LCD_LIGHT;
                SEG_Endurance_21C = SEG_LCD_GRAY_light;
                SEG_Endurance_21D = SEG_LCD_LIGHT;
                SEG_Endurance_21E = SEG_LCD_LIGHT;
                SEG_Endurance_21F = SEG_LCD_GRAY_light;
                SEG_Endurance_21G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_Endurance_21A = SEG_LCD_LIGHT;
                SEG_Endurance_21B = SEG_LCD_LIGHT;
                SEG_Endurance_21C = SEG_LCD_LIGHT;
                SEG_Endurance_21D = SEG_LCD_LIGHT;
                SEG_Endurance_21E = SEG_LCD_GRAY_light;
                SEG_Endurance_21F = SEG_LCD_GRAY_light;
                SEG_Endurance_21G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_Endurance_21A = SEG_LCD_GRAY_light;
                SEG_Endurance_21B = SEG_LCD_LIGHT;
                SEG_Endurance_21C = SEG_LCD_LIGHT;
                SEG_Endurance_21D = SEG_LCD_GRAY_light;
                SEG_Endurance_21E = SEG_LCD_GRAY_light;
                SEG_Endurance_21F = SEG_LCD_LIGHT;
                SEG_Endurance_21G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_Endurance_21A = SEG_LCD_LIGHT;
                SEG_Endurance_21B = SEG_LCD_GRAY_light;
                SEG_Endurance_21C = SEG_LCD_LIGHT;
                SEG_Endurance_21D = SEG_LCD_LIGHT;
                SEG_Endurance_21E = SEG_LCD_GRAY_light;
                SEG_Endurance_21F = SEG_LCD_LIGHT;
                SEG_Endurance_21G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_Endurance_21A  = SEG_LCD_LIGHT;
                SEG_Endurance_21B  = SEG_LCD_GRAY_light;
                SEG_Endurance_21C  = SEG_LCD_LIGHT;
                SEG_Endurance_21D  = SEG_LCD_LIGHT;
                SEG_Endurance_21E  = SEG_LCD_LIGHT;
                SEG_Endurance_21F  = SEG_LCD_LIGHT;
                SEG_Endurance_21G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_Endurance_21A  = SEG_LCD_LIGHT;
                SEG_Endurance_21B  = SEG_LCD_LIGHT;
                SEG_Endurance_21C  = SEG_LCD_LIGHT;
                SEG_Endurance_21D  = SEG_LCD_GRAY_light;
                SEG_Endurance_21E  = SEG_LCD_GRAY_light;
                SEG_Endurance_21F  = SEG_LCD_GRAY_light;
                SEG_Endurance_21G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_Endurance_21A  = SEG_LCD_LIGHT;
                SEG_Endurance_21B  = SEG_LCD_LIGHT;
                SEG_Endurance_21C  = SEG_LCD_LIGHT;
                SEG_Endurance_21D  = SEG_LCD_LIGHT;
                SEG_Endurance_21E  = SEG_LCD_LIGHT;
                SEG_Endurance_21F  = SEG_LCD_LIGHT;
                SEG_Endurance_21G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_Endurance_21A = SEG_LCD_LIGHT;
                SEG_Endurance_21B = SEG_LCD_LIGHT;
                SEG_Endurance_21C = SEG_LCD_LIGHT;
                SEG_Endurance_21D = SEG_LCD_LIGHT;
                SEG_Endurance_21E = SEG_LCD_GRAY_light;
                SEG_Endurance_21F = SEG_LCD_LIGHT;
                SEG_Endurance_21G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_Endurance_21A = SEG_LCD_GRAY_light;
                SEG_Endurance_21B = SEG_LCD_GRAY_light;
                SEG_Endurance_21C = SEG_LCD_GRAY_light;
                SEG_Endurance_21D = SEG_LCD_GRAY_light;
                SEG_Endurance_21E = SEG_LCD_GRAY_light;
                SEG_Endurance_21F = SEG_LCD_GRAY_light;
                SEG_Endurance_21G = SEG_LCD_GRAY_light; 
      		    	break;
    }
   
    SEG_Endurance_W48 = SEG_LCD_LIGHT;
    SEG_Endurance_W49 = SEG_LCD_LIGHT; 
  }
}                    
                    
/******************************************************************************
SEG_LCD_Mileage_Speed_Num_Off
  : ֹر
  : 
ֵ
˵                              
******************************************************************************/
void SEG_LCD_Mileage_Speed_Num_Off(void)
{ 
    SEG_Endurance_19A  =  SEG_LCD_OFF ; 
    SEG_Endurance_19B  =  SEG_LCD_OFF ; 
    SEG_Endurance_19C  =  SEG_LCD_OFF ; 
    SEG_Endurance_19D  =  SEG_LCD_OFF ; 
    SEG_Endurance_19E  =  SEG_LCD_OFF ; 
    SEG_Endurance_19F  =  SEG_LCD_OFF ; 
    SEG_Endurance_19G  =  SEG_LCD_OFF ; 

    SEG_Endurance_20A  =  SEG_LCD_OFF ; 
    SEG_Endurance_20B  =  SEG_LCD_OFF ; 
    SEG_Endurance_20C  =  SEG_LCD_OFF ; 
    SEG_Endurance_20D  =  SEG_LCD_OFF ; 
    SEG_Endurance_20E  =  SEG_LCD_OFF ; 
    SEG_Endurance_20F  =  SEG_LCD_OFF ; 
    SEG_Endurance_20G  =  SEG_LCD_OFF ; 

    SEG_Endurance_21A  =  SEG_LCD_OFF ; 
    SEG_Endurance_21B  =  SEG_LCD_OFF ; 
    SEG_Endurance_21C  =  SEG_LCD_OFF ; 
    SEG_Endurance_21D  =  SEG_LCD_OFF ; 
    SEG_Endurance_21E  =  SEG_LCD_OFF ; 
    SEG_Endurance_21F  =  SEG_LCD_OFF ; 
    SEG_Endurance_21G  =  SEG_LCD_OFF ; 

    //ͼ--λ
    SEG_Endurance_W48  =  SEG_LCD_OFF ; 
    SEG_Endurance_W49  =  SEG_LCD_OFF ; 

    SEGLCDBackup.Mileage = 0xFFFF; 
}


/******************************************************************************
SEG_LCD_ODO_Speed_Num_Display
  : ܼʾ
  : 
ֵ
˵                              
******************************************************************************/
void SEG_LCD_ODO_Speed_Num_Display(uint32_t ODONum)
{ 
  uint8_t Dig[6];
  
  if (SEGLCDBackup.ODONum != ODONum)
  {
    SEGLCDBackup.ODONum = ODONum;
    
    if (ODONum > 9999999)
        ODONum = 9999999;
    
  
    ODONum /= 10;  
    Dig[0] = ODONum % 10;
    ODONum /= 10;
    Dig[1] = ODONum % 10; 
    ODONum /= 10;
    Dig[2] = ODONum % 10;
    ODONum /= 10;
    Dig[3] = ODONum % 10;
    ODONum /= 10;
    Dig[4] = ODONum % 10;
    Dig[5] = ODONum / 10;
    
    if (Dig[5] == 0)
    {
      Dig[5] = 0x0F;
      if (Dig[4] == 0)
      {
        Dig[4] = 0x0F;
        if (Dig[3] == 0)
        {
          Dig[3] = 0x0F;
          if (Dig[2] == 0)
          {
            Dig[2] = 0x0F;
            if (Dig[1] == 0)
             Dig[1] = 0x0F;
          }
        }
      }
    }
    
    switch (Dig[5])
    {
      case 0  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_LIGHT;
                SEG_OBD_13F  = SEG_LCD_LIGHT;
                SEG_OBD_13G  = SEG_LCD_GRAY_light;
                break;
                
      case 1  : SEG_OBD_13A  = SEG_LCD_GRAY_light;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_GRAY_light;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_GRAY_light;
                SEG_OBD_13G  = SEG_LCD_GRAY_light;
                break;
                
      case 2  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_GRAY_light;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_LIGHT;
                SEG_OBD_13F  = SEG_LCD_GRAY_light;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break;
                
      case 3  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_GRAY_light;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break;         
                
      case 4  : SEG_OBD_13A  = SEG_LCD_GRAY_light;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_GRAY_light;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_LIGHT;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break;  
                       
      case 5  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_GRAY_light;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_LIGHT;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break;    
                     
      case 6  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_GRAY_light;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_LIGHT;
                SEG_OBD_13F  = SEG_LCD_LIGHT;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break; 
                  
      case 7  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_GRAY_light;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_GRAY_light;
                SEG_OBD_13G  = SEG_LCD_GRAY_light;
                break;              
                      
      case 8  : SEG_OBD_13A  = SEG_LCD_LIGHT;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_LIGHT;
                SEG_OBD_13F  = SEG_LCD_LIGHT;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break;  
                
      case 9  : SEG_OBD_13A  = SEG_LCD_LIGHT;;
                SEG_OBD_13B  = SEG_LCD_LIGHT;
                SEG_OBD_13C  = SEG_LCD_LIGHT;
                SEG_OBD_13D  = SEG_LCD_LIGHT;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_LIGHT;
                SEG_OBD_13G  = SEG_LCD_LIGHT;
                break;                 
                
      default : SEG_OBD_13A  = SEG_LCD_GRAY_light;;
                SEG_OBD_13B  = SEG_LCD_GRAY_light;
                SEG_OBD_13C  = SEG_LCD_GRAY_light;
                SEG_OBD_13D  = SEG_LCD_GRAY_light;
                SEG_OBD_13E  = SEG_LCD_GRAY_light;
                SEG_OBD_13F  = SEG_LCD_GRAY_light;
                SEG_OBD_13G  = SEG_LCD_GRAY_light;        
                break;
    }
    
    switch (Dig[4])
    {
    	case 0  : SEG_OBD_14A  = SEG_LCD_LIGHT;
                SEG_OBD_14B  = SEG_LCD_LIGHT;
                SEG_OBD_14C  = SEG_LCD_LIGHT;
                SEG_OBD_14D  = SEG_LCD_LIGHT;
                SEG_OBD_14E  = SEG_LCD_LIGHT;
                SEG_OBD_14F  = SEG_LCD_LIGHT;
                SEG_OBD_14G  = SEG_LCD_GRAY_light;
      			    break;
      			    
      case 1  : SEG_OBD_14A  = SEG_LCD_GRAY_light;
      		      SEG_OBD_14B  = SEG_LCD_LIGHT;
      		      SEG_OBD_14C  = SEG_LCD_LIGHT;
      		      SEG_OBD_14D  = SEG_LCD_GRAY_light;
                SEG_OBD_14E  = SEG_LCD_GRAY_light;
                SEG_OBD_14F  = SEG_LCD_GRAY_light;
                SEG_OBD_14G  = SEG_LCD_GRAY_light;
      		    	break;
      		    	
      case 2  : SEG_OBD_14A = SEG_LCD_LIGHT;
                SEG_OBD_14B = SEG_LCD_LIGHT;
                SEG_OBD_14C = SEG_LCD_GRAY_light;
                SEG_OBD_14D = SEG_LCD_LIGHT;
                SEG_OBD_14E = SEG_LCD_LIGHT;
                SEG_OBD_14F = SEG_LCD_GRAY_light;
                SEG_OBD_14G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_OBD_14A  = SEG_LCD_LIGHT;
                SEG_OBD_14B  = SEG_LCD_LIGHT;
                SEG_OBD_14C  = SEG_LCD_LIGHT;
                SEG_OBD_14D  = SEG_LCD_LIGHT;
                SEG_OBD_14E  = SEG_LCD_GRAY_light;  
                SEG_OBD_14F  = SEG_LCD_GRAY_light;   
                SEG_OBD_14G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_OBD_14A  = SEG_LCD_GRAY_light;
                SEG_OBD_14B  = SEG_LCD_LIGHT;
                SEG_OBD_14C  = SEG_LCD_LIGHT;
                SEG_OBD_14D  = SEG_LCD_GRAY_light;   
                SEG_OBD_14E  = SEG_LCD_GRAY_light;
                SEG_OBD_14F  = SEG_LCD_LIGHT;
                SEG_OBD_14G  = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_OBD_14A = SEG_LCD_LIGHT;
                SEG_OBD_14B = SEG_LCD_GRAY_light; 
                SEG_OBD_14C = SEG_LCD_LIGHT;
                SEG_OBD_14D = SEG_LCD_LIGHT;
                SEG_OBD_14E = SEG_LCD_GRAY_light;
                SEG_OBD_14F = SEG_LCD_LIGHT;
                SEG_OBD_14G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_OBD_14A = SEG_LCD_LIGHT;
                SEG_OBD_14B = SEG_LCD_GRAY_light;
                SEG_OBD_14C = SEG_LCD_LIGHT;
                SEG_OBD_14D = SEG_LCD_LIGHT;
                SEG_OBD_14E = SEG_LCD_LIGHT;
                SEG_OBD_14F = SEG_LCD_LIGHT;
                SEG_OBD_14G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_OBD_14A = SEG_LCD_LIGHT;
                SEG_OBD_14B = SEG_LCD_LIGHT;
                SEG_OBD_14C = SEG_LCD_LIGHT;
                SEG_OBD_14D = SEG_LCD_GRAY_light;  
                SEG_OBD_14E = SEG_LCD_GRAY_light;  
                SEG_OBD_14F = SEG_LCD_GRAY_light;  
                SEG_OBD_14G = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_OBD_14A  = SEG_LCD_LIGHT;
                SEG_OBD_14B  = SEG_LCD_LIGHT;
                SEG_OBD_14C  = SEG_LCD_LIGHT;
                SEG_OBD_14D  = SEG_LCD_LIGHT;
                SEG_OBD_14E  = SEG_LCD_LIGHT;
                SEG_OBD_14F  = SEG_LCD_LIGHT;
                SEG_OBD_14G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_OBD_14A  = SEG_LCD_LIGHT;
                SEG_OBD_14B  = SEG_LCD_LIGHT;
                SEG_OBD_14C  = SEG_LCD_LIGHT;
                SEG_OBD_14D  = SEG_LCD_LIGHT;
                SEG_OBD_14E  = SEG_LCD_GRAY_light;
                SEG_OBD_14F  = SEG_LCD_LIGHT;
                SEG_OBD_14G  = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_OBD_14A = SEG_LCD_GRAY_light;  
                SEG_OBD_14B = SEG_LCD_GRAY_light;  
                SEG_OBD_14C = SEG_LCD_GRAY_light;  
                SEG_OBD_14D = SEG_LCD_GRAY_light;  
                SEG_OBD_14E = SEG_LCD_GRAY_light;  
                SEG_OBD_14F = SEG_LCD_GRAY_light;  
                SEG_OBD_14G = SEG_LCD_GRAY_light;   
      		    	break;
    }
    
    switch (Dig[3])
    {
    	case 0  : SEG_OBD_15A  = SEG_LCD_LIGHT;
                SEG_OBD_15B  = SEG_LCD_LIGHT;
                SEG_OBD_15C  = SEG_LCD_LIGHT;
                SEG_OBD_15D  = SEG_LCD_LIGHT;
                SEG_OBD_15E  = SEG_LCD_LIGHT;
                SEG_OBD_15F  = SEG_LCD_LIGHT;
                SEG_OBD_15G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_OBD_15A  = SEG_LCD_GRAY_light;
      		      SEG_OBD_15B  = SEG_LCD_LIGHT;
      		      SEG_OBD_15C  = SEG_LCD_LIGHT;
      		      SEG_OBD_15D  = SEG_LCD_GRAY_light;
                SEG_OBD_15E  = SEG_LCD_GRAY_light;
                SEG_OBD_15F  = SEG_LCD_GRAY_light;
                SEG_OBD_15G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_OBD_15A = SEG_LCD_LIGHT;
                SEG_OBD_15B = SEG_LCD_LIGHT;
                SEG_OBD_15C = SEG_LCD_GRAY_light;
                SEG_OBD_15D = SEG_LCD_LIGHT;
                SEG_OBD_15E = SEG_LCD_LIGHT;
                SEG_OBD_15F = SEG_LCD_GRAY_light;
                SEG_OBD_15G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_OBD_15A = SEG_LCD_LIGHT;
                SEG_OBD_15B = SEG_LCD_LIGHT;
                SEG_OBD_15C = SEG_LCD_LIGHT;
                SEG_OBD_15D = SEG_LCD_LIGHT;
                SEG_OBD_15E = SEG_LCD_GRAY_light;
                SEG_OBD_15F = SEG_LCD_GRAY_light;
                SEG_OBD_15G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_OBD_15A = SEG_LCD_GRAY_light;
                SEG_OBD_15B = SEG_LCD_LIGHT;
                SEG_OBD_15C = SEG_LCD_LIGHT;
                SEG_OBD_15D = SEG_LCD_GRAY_light;
                SEG_OBD_15E = SEG_LCD_GRAY_light;
                SEG_OBD_15F = SEG_LCD_LIGHT;
                SEG_OBD_15G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_OBD_15A = SEG_LCD_LIGHT;
                SEG_OBD_15B = SEG_LCD_GRAY_light;
                SEG_OBD_15C = SEG_LCD_LIGHT;
                SEG_OBD_15D = SEG_LCD_LIGHT;
                SEG_OBD_15E = SEG_LCD_GRAY_light;
                SEG_OBD_15F = SEG_LCD_LIGHT;
                SEG_OBD_15G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_OBD_15A  = SEG_LCD_LIGHT;
                SEG_OBD_15B  = SEG_LCD_GRAY_light;
                SEG_OBD_15C  = SEG_LCD_LIGHT;
                SEG_OBD_15D  = SEG_LCD_LIGHT;
                SEG_OBD_15E  = SEG_LCD_LIGHT;
                SEG_OBD_15F  = SEG_LCD_LIGHT;
                SEG_OBD_15G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_OBD_15A  = SEG_LCD_LIGHT;
                SEG_OBD_15B  = SEG_LCD_LIGHT;
                SEG_OBD_15C  = SEG_LCD_LIGHT;
                SEG_OBD_15D  = SEG_LCD_GRAY_light;
                SEG_OBD_15E  = SEG_LCD_GRAY_light;
                SEG_OBD_15F  = SEG_LCD_GRAY_light;
                SEG_OBD_15G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_OBD_15A  = SEG_LCD_LIGHT;
                SEG_OBD_15B  = SEG_LCD_LIGHT;
                SEG_OBD_15C  = SEG_LCD_LIGHT;
                SEG_OBD_15D  = SEG_LCD_LIGHT;
                SEG_OBD_15E  = SEG_LCD_LIGHT;
                SEG_OBD_15F  = SEG_LCD_LIGHT;
                SEG_OBD_15G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_OBD_15A = SEG_LCD_LIGHT;
                SEG_OBD_15B = SEG_LCD_LIGHT;
                SEG_OBD_15C = SEG_LCD_LIGHT;
                SEG_OBD_15D = SEG_LCD_LIGHT;
                SEG_OBD_15E = SEG_LCD_GRAY_light;
                SEG_OBD_15F = SEG_LCD_LIGHT;
                SEG_OBD_15G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_OBD_15A = SEG_LCD_GRAY_light;
                SEG_OBD_15B = SEG_LCD_GRAY_light;
                SEG_OBD_15C = SEG_LCD_GRAY_light;
                SEG_OBD_15D = SEG_LCD_GRAY_light;
                SEG_OBD_15E = SEG_LCD_GRAY_light;
                SEG_OBD_15F = SEG_LCD_GRAY_light;
                SEG_OBD_15G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    switch (Dig[2])
    {
    	case 0  : SEG_OBD_16A  = SEG_LCD_LIGHT;
                SEG_OBD_16B  = SEG_LCD_LIGHT;
                SEG_OBD_16C  = SEG_LCD_LIGHT;
                SEG_OBD_16D  = SEG_LCD_LIGHT;
                SEG_OBD_16E  = SEG_LCD_LIGHT;
                SEG_OBD_16F  = SEG_LCD_LIGHT;
                SEG_OBD_16G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_OBD_16A  = SEG_LCD_GRAY_light;
      		      SEG_OBD_16B  = SEG_LCD_LIGHT;
      		      SEG_OBD_16C  = SEG_LCD_LIGHT;
      		      SEG_OBD_16D  = SEG_LCD_GRAY_light;
                SEG_OBD_16E  = SEG_LCD_GRAY_light;
                SEG_OBD_16F  = SEG_LCD_GRAY_light;
                SEG_OBD_16G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_OBD_16A = SEG_LCD_LIGHT;
                SEG_OBD_16B = SEG_LCD_LIGHT;
                SEG_OBD_16C = SEG_LCD_GRAY_light;
                SEG_OBD_16D = SEG_LCD_LIGHT;
                SEG_OBD_16E = SEG_LCD_LIGHT;
                SEG_OBD_16F = SEG_LCD_GRAY_light;
                SEG_OBD_16G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_OBD_16A = SEG_LCD_LIGHT;
                SEG_OBD_16B = SEG_LCD_LIGHT;
                SEG_OBD_16C = SEG_LCD_LIGHT;
                SEG_OBD_16D = SEG_LCD_LIGHT;
                SEG_OBD_16E = SEG_LCD_GRAY_light;
                SEG_OBD_16F = SEG_LCD_GRAY_light;
                SEG_OBD_16G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_OBD_16A = SEG_LCD_GRAY_light;
                SEG_OBD_16B = SEG_LCD_LIGHT;
                SEG_OBD_16C = SEG_LCD_LIGHT;
                SEG_OBD_16D = SEG_LCD_GRAY_light;
                SEG_OBD_16E = SEG_LCD_GRAY_light;
                SEG_OBD_16F = SEG_LCD_LIGHT;
                SEG_OBD_16G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_OBD_16A = SEG_LCD_LIGHT;
                SEG_OBD_16B = SEG_LCD_GRAY_light;
                SEG_OBD_16C = SEG_LCD_LIGHT;
                SEG_OBD_16D = SEG_LCD_LIGHT;
                SEG_OBD_16E = SEG_LCD_GRAY_light;
                SEG_OBD_16F = SEG_LCD_LIGHT;
                SEG_OBD_16G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_OBD_16A  = SEG_LCD_LIGHT;
                SEG_OBD_16B  = SEG_LCD_GRAY_light;
                SEG_OBD_16C  = SEG_LCD_LIGHT;
                SEG_OBD_16D  = SEG_LCD_LIGHT;
                SEG_OBD_16E  = SEG_LCD_LIGHT;
                SEG_OBD_16F  = SEG_LCD_LIGHT;
                SEG_OBD_16G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_OBD_16A  = SEG_LCD_LIGHT;
                SEG_OBD_16B  = SEG_LCD_LIGHT;
                SEG_OBD_16C  = SEG_LCD_LIGHT;
                SEG_OBD_16D  = SEG_LCD_GRAY_light;
                SEG_OBD_16E  = SEG_LCD_GRAY_light;
                SEG_OBD_16F  = SEG_LCD_GRAY_light;
                SEG_OBD_16G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_OBD_16A  = SEG_LCD_LIGHT;
                SEG_OBD_16B  = SEG_LCD_LIGHT;
                SEG_OBD_16C  = SEG_LCD_LIGHT;
                SEG_OBD_16D  = SEG_LCD_LIGHT;
                SEG_OBD_16E  = SEG_LCD_LIGHT;
                SEG_OBD_16F  = SEG_LCD_LIGHT;
                SEG_OBD_16G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_OBD_16A = SEG_LCD_LIGHT;
                SEG_OBD_16B = SEG_LCD_LIGHT;
                SEG_OBD_16C = SEG_LCD_LIGHT;
                SEG_OBD_16D = SEG_LCD_LIGHT;
                SEG_OBD_16E = SEG_LCD_GRAY_light;
                SEG_OBD_16F = SEG_LCD_LIGHT;
                SEG_OBD_16G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_OBD_16A = SEG_LCD_GRAY_light;
                SEG_OBD_16B = SEG_LCD_GRAY_light;
                SEG_OBD_16C = SEG_LCD_GRAY_light;
                SEG_OBD_16D = SEG_LCD_GRAY_light;
                SEG_OBD_16E = SEG_LCD_GRAY_light;
                SEG_OBD_16F = SEG_LCD_GRAY_light;
                SEG_OBD_16G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    switch (Dig[1])
    {
    	case 0  : SEG_OBD_17A  = SEG_LCD_LIGHT;
                SEG_OBD_17B  = SEG_LCD_LIGHT;
                SEG_OBD_17C  = SEG_LCD_LIGHT;
                SEG_OBD_17D  = SEG_LCD_LIGHT;
                SEG_OBD_17E  = SEG_LCD_LIGHT;
                SEG_OBD_17F  = SEG_LCD_LIGHT;
                SEG_OBD_17G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_OBD_17A  = SEG_LCD_GRAY_light;
      		      SEG_OBD_17B  = SEG_LCD_LIGHT;
      		      SEG_OBD_17C  = SEG_LCD_LIGHT;
      		      SEG_OBD_17D  = SEG_LCD_GRAY_light;
                SEG_OBD_17E  = SEG_LCD_GRAY_light;
                SEG_OBD_17F  = SEG_LCD_GRAY_light;
                SEG_OBD_17G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_OBD_17A = SEG_LCD_LIGHT;
                SEG_OBD_17B = SEG_LCD_LIGHT;
                SEG_OBD_17C = SEG_LCD_GRAY_light;
                SEG_OBD_17D = SEG_LCD_LIGHT;
                SEG_OBD_17E = SEG_LCD_LIGHT;
                SEG_OBD_17F = SEG_LCD_GRAY_light;
                SEG_OBD_17G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_OBD_17A = SEG_LCD_LIGHT;
                SEG_OBD_17B = SEG_LCD_LIGHT;
                SEG_OBD_17C = SEG_LCD_LIGHT;
                SEG_OBD_17D = SEG_LCD_LIGHT;
                SEG_OBD_17E = SEG_LCD_GRAY_light;
                SEG_OBD_17F = SEG_LCD_GRAY_light;
                SEG_OBD_17G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_OBD_17A = SEG_LCD_GRAY_light;
                SEG_OBD_17B = SEG_LCD_LIGHT;
                SEG_OBD_17C = SEG_LCD_LIGHT;
                SEG_OBD_17D = SEG_LCD_GRAY_light;
                SEG_OBD_17E = SEG_LCD_GRAY_light;
                SEG_OBD_17F = SEG_LCD_LIGHT;
                SEG_OBD_17G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_OBD_17A = SEG_LCD_LIGHT;
                SEG_OBD_17B = SEG_LCD_GRAY_light;
                SEG_OBD_17C = SEG_LCD_LIGHT;
                SEG_OBD_17D = SEG_LCD_LIGHT;
                SEG_OBD_17E = SEG_LCD_GRAY_light;
                SEG_OBD_17F = SEG_LCD_LIGHT;
                SEG_OBD_17G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_OBD_17A  = SEG_LCD_LIGHT;
                SEG_OBD_17B  = SEG_LCD_GRAY_light;
                SEG_OBD_17C  = SEG_LCD_LIGHT;
                SEG_OBD_17D  = SEG_LCD_LIGHT;
                SEG_OBD_17E  = SEG_LCD_LIGHT;
                SEG_OBD_17F  = SEG_LCD_LIGHT;
                SEG_OBD_17G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_OBD_17A  = SEG_LCD_LIGHT;
                SEG_OBD_17B  = SEG_LCD_LIGHT;
                SEG_OBD_17C  = SEG_LCD_LIGHT;
                SEG_OBD_17D  = SEG_LCD_GRAY_light;
                SEG_OBD_17E  = SEG_LCD_GRAY_light;
                SEG_OBD_17F  = SEG_LCD_GRAY_light;
                SEG_OBD_17G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_OBD_17A  = SEG_LCD_LIGHT;
                SEG_OBD_17B  = SEG_LCD_LIGHT;
                SEG_OBD_17C  = SEG_LCD_LIGHT;
                SEG_OBD_17D  = SEG_LCD_LIGHT;
                SEG_OBD_17E  = SEG_LCD_LIGHT;
                SEG_OBD_17F  = SEG_LCD_LIGHT;
                SEG_OBD_17G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_OBD_17A = SEG_LCD_LIGHT;
                SEG_OBD_17B = SEG_LCD_LIGHT;
                SEG_OBD_17C = SEG_LCD_LIGHT;
                SEG_OBD_17D = SEG_LCD_LIGHT;
                SEG_OBD_17E = SEG_LCD_GRAY_light;
                SEG_OBD_17F = SEG_LCD_LIGHT;
                SEG_OBD_17G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_OBD_17A = SEG_LCD_GRAY_light;
                SEG_OBD_17B = SEG_LCD_GRAY_light;
                SEG_OBD_17C = SEG_LCD_GRAY_light;
                SEG_OBD_17D = SEG_LCD_GRAY_light;
                SEG_OBD_17E = SEG_LCD_GRAY_light;
                SEG_OBD_17F = SEG_LCD_GRAY_light;
                SEG_OBD_17G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    switch (Dig[0])
    {
    	case 0  : SEG_OBD_18A  = SEG_LCD_LIGHT;
                SEG_OBD_18B  = SEG_LCD_LIGHT;
                SEG_OBD_18C  = SEG_LCD_LIGHT;
                SEG_OBD_18D  = SEG_LCD_LIGHT;
                SEG_OBD_18E  = SEG_LCD_LIGHT;
                SEG_OBD_18F  = SEG_LCD_LIGHT;
                SEG_OBD_18G  = SEG_LCD_GRAY_light; 
      			    break;
      			    
      case 1  : SEG_OBD_18A  = SEG_LCD_GRAY_light;
      		      SEG_OBD_18B  = SEG_LCD_LIGHT;
      		      SEG_OBD_18C  = SEG_LCD_LIGHT;
      		      SEG_OBD_18D  = SEG_LCD_GRAY_light;
                SEG_OBD_18E  = SEG_LCD_GRAY_light;
                SEG_OBD_18F  = SEG_LCD_GRAY_light;
                SEG_OBD_18G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 2  : SEG_OBD_18A = SEG_LCD_LIGHT;
                SEG_OBD_18B = SEG_LCD_LIGHT;
                SEG_OBD_18C = SEG_LCD_GRAY_light;
                SEG_OBD_18D = SEG_LCD_LIGHT;
                SEG_OBD_18E = SEG_LCD_LIGHT;
                SEG_OBD_18F = SEG_LCD_GRAY_light;
                SEG_OBD_18G = SEG_LCD_LIGHT; 
      			    break;
      			
      case 3  : SEG_OBD_18A = SEG_LCD_LIGHT;
                SEG_OBD_18B = SEG_LCD_LIGHT;
                SEG_OBD_18C = SEG_LCD_LIGHT;
                SEG_OBD_18D = SEG_LCD_LIGHT;
                SEG_OBD_18E = SEG_LCD_GRAY_light;
                SEG_OBD_18F = SEG_LCD_GRAY_light;
                SEG_OBD_18G = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 4  : SEG_OBD_18A = SEG_LCD_GRAY_light;
                SEG_OBD_18B = SEG_LCD_LIGHT;
                SEG_OBD_18C = SEG_LCD_LIGHT;
                SEG_OBD_18D = SEG_LCD_GRAY_light;
                SEG_OBD_18E = SEG_LCD_GRAY_light;
                SEG_OBD_18F = SEG_LCD_LIGHT;
                SEG_OBD_18G = SEG_LCD_LIGHT; 
     			      break;
     			      
      case 5  : SEG_OBD_18A = SEG_LCD_LIGHT;
                SEG_OBD_18B = SEG_LCD_GRAY_light;
                SEG_OBD_18C = SEG_LCD_LIGHT;
                SEG_OBD_18D = SEG_LCD_LIGHT;
                SEG_OBD_18E = SEG_LCD_GRAY_light;
                SEG_OBD_18F = SEG_LCD_LIGHT;
                SEG_OBD_18G = SEG_LCD_LIGHT; 
      			    break;
      			    
      case 6  : SEG_OBD_18A  = SEG_LCD_LIGHT;
                SEG_OBD_18B  = SEG_LCD_GRAY_light;
                SEG_OBD_18C  = SEG_LCD_LIGHT;
                SEG_OBD_18D  = SEG_LCD_LIGHT;
                SEG_OBD_18E  = SEG_LCD_LIGHT;
                SEG_OBD_18F  = SEG_LCD_LIGHT;
                SEG_OBD_18G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 7  : SEG_OBD_18A  = SEG_LCD_LIGHT;
                SEG_OBD_18B  = SEG_LCD_LIGHT;
                SEG_OBD_18C  = SEG_LCD_LIGHT;
                SEG_OBD_18D  = SEG_LCD_GRAY_light;
                SEG_OBD_18E  = SEG_LCD_GRAY_light;
                SEG_OBD_18F  = SEG_LCD_GRAY_light;
                SEG_OBD_18G  = SEG_LCD_GRAY_light; 
      		    	break;
      		    	
      case 8  : SEG_OBD_18A  = SEG_LCD_LIGHT;
                SEG_OBD_18B  = SEG_LCD_LIGHT;
                SEG_OBD_18C  = SEG_LCD_LIGHT;
                SEG_OBD_18D  = SEG_LCD_LIGHT;
                SEG_OBD_18E  = SEG_LCD_LIGHT;
                SEG_OBD_18F  = SEG_LCD_LIGHT;
                SEG_OBD_18G  = SEG_LCD_LIGHT; 
      		    	break;
      		    	
      case 9  : SEG_OBD_18A = SEG_LCD_LIGHT;
                SEG_OBD_18B = SEG_LCD_LIGHT;
                SEG_OBD_18C = SEG_LCD_LIGHT;
                SEG_OBD_18D = SEG_LCD_LIGHT;
                SEG_OBD_18E = SEG_LCD_GRAY_light;
                SEG_OBD_18F = SEG_LCD_LIGHT;
                SEG_OBD_18G = SEG_LCD_LIGHT; 
                break;
                
      default : SEG_OBD_18A = SEG_LCD_GRAY_light;
                SEG_OBD_18B = SEG_LCD_GRAY_light;
                SEG_OBD_18C = SEG_LCD_GRAY_light;
                SEG_OBD_18D = SEG_LCD_GRAY_light;
                SEG_OBD_18E = SEG_LCD_GRAY_light;
                SEG_OBD_18F = SEG_LCD_GRAY_light;
                SEG_OBD_18G = SEG_LCD_GRAY_light; 
      		    	break;
    }
    //λ
    SEG_OBD_W26 = SEG_LCD_LIGHT; 
    //odo
    SEG_OBD_W24 = SEG_LCD_LIGHT;
    //С
    //SEG_OBD_W25 = SEG_LCD_LIGHT;
  }
}

/******************************************************************************
SEG_LCD_ODO_Speed_Num_Off
  : ֹܼر
  : 
ֵ
˵                              
******************************************************************************/
void SEG_LCD_ODO_Speed_Num_Off(void)
{ 
  SEG_OBD_13A   =  SEG_LCD_OFF  ;
  SEG_OBD_13B   =  SEG_LCD_OFF  ;
  SEG_OBD_13C   =  SEG_LCD_OFF  ;
  SEG_OBD_13D   =  SEG_LCD_OFF  ;
  SEG_OBD_13E   =  SEG_LCD_OFF  ;
  SEG_OBD_13F   =  SEG_LCD_OFF  ;
  SEG_OBD_13G   =  SEG_LCD_OFF  ;

  SEG_OBD_14A   =  SEG_LCD_OFF  ;
  SEG_OBD_14B   =  SEG_LCD_OFF  ;
  SEG_OBD_14C   =  SEG_LCD_OFF  ;
  SEG_OBD_14D   =  SEG_LCD_OFF  ;
  SEG_OBD_14E   =  SEG_LCD_OFF  ;
  SEG_OBD_14F   =  SEG_LCD_OFF  ;
  SEG_OBD_14G   =  SEG_LCD_OFF  ;

  SEG_OBD_15A   =  SEG_LCD_OFF  ;
  SEG_OBD_15B   =  SEG_LCD_OFF  ;
  SEG_OBD_15C   =  SEG_LCD_OFF  ;
  SEG_OBD_15D   =  SEG_LCD_OFF  ;
  SEG_OBD_15E   =  SEG_LCD_OFF  ;
  SEG_OBD_15F   =  SEG_LCD_OFF  ;
  SEG_OBD_15G   =  SEG_LCD_OFF  ;

  SEG_OBD_16A   =  SEG_LCD_OFF  ;
  SEG_OBD_16B   =  SEG_LCD_OFF  ;
  SEG_OBD_16C   =  SEG_LCD_OFF  ;
  SEG_OBD_16D   =  SEG_LCD_OFF  ;
  SEG_OBD_16E   =  SEG_LCD_OFF  ;
  SEG_OBD_16F   =  SEG_LCD_OFF  ;
  SEG_OBD_16G   =  SEG_LCD_OFF  ;

  SEG_OBD_17A   =  SEG_LCD_OFF  ;
  SEG_OBD_17B   =  SEG_LCD_OFF  ;
  SEG_OBD_17C   =  SEG_LCD_OFF  ;
  SEG_OBD_17D   =  SEG_LCD_OFF  ;
  SEG_OBD_17E   =  SEG_LCD_OFF  ;
  SEG_OBD_17F   =  SEG_LCD_OFF  ;
  SEG_OBD_17G   =  SEG_LCD_OFF  ;

  SEG_OBD_18A   =  SEG_LCD_OFF  ;
  SEG_OBD_18B   =  SEG_LCD_OFF  ;
  SEG_OBD_18C   =  SEG_LCD_OFF  ;
  SEG_OBD_18D   =  SEG_LCD_OFF  ;
  SEG_OBD_18E   =  SEG_LCD_OFF  ;
  SEG_OBD_18F   =  SEG_LCD_OFF  ;
  SEG_OBD_18G   =  SEG_LCD_OFF  ;

  SEG_OBD_W24   =  SEG_LCD_OFF  ;
  SEG_OBD_W25   =  SEG_LCD_OFF  ;
  SEG_OBD_W26   =  SEG_LCD_OFF  ;
  
  SEGLCDBackup.ODONum = 0xFFFF; 
}
