/****************************************************************************************************************************************************
  GPIO.h
GPIOӳ估GPIOʼͷļ
    ߣ
    V1.0
    ڣ2016.11.1
****************************************************************************************************************************************************/
#ifndef _GPIO_H_
#define _GPIO_H_

#include "stdint.h"
#include "mc9s12xhy128.h"

/****************************************************************************************************************************************************
GPIOӳ
****************************************************************************************************************************************************/

/*===================================================================================================================================================
PORTA ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      |         ˿       |    |    |  ֵ    |  ˵
===================================================================================================================================================*/
#define     LED_ABS_FAULT_Y             PORTA_PA0  	        // 87       OUT	    0         017 ABS()
#define     LED_OBD_Y                   PORTA_PA1  	        // 88       OUT	    0         047 OBDָʾ()
#define     LED_HI_TEMP_R               PORTA_PA2  	        // 89       OUT	    0         010 ȴҺ¶ȸ()
#define     LED_AD_BLUE_QUA             PORTA_PA3  	        // 90       OUT	    0         054 
#define     LED_SVS_Y                   PORTA_PA4  	        // 91       OUT	    0         013 ͻϵͳ()
#define     LED_PREHEAT_THE_LIGHT_G     PORTA_PA5  	        // 92       OUT	    0         041 Ԥָʾ()  
#define     LED_PTO_B                   PORTA_PA6  	        // 93       OUT	    0         055 PTO()
#define     LED_EX_BREAK_G              PORTA_PA7  	        // 94       OUT	    0         039 ƶָʾ()

/*===================================================================================================================================================
PORTB ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ    |  ˵
===================================================================================================================================================*/
#define     LED_CRUISE_G                PORTB_PB0  	        // 86       OUT	    0         024 Ѳָʾ()
#define     LED_ADBLUE_B                PORTB_PB1  	        // 95       OUT	    0         043 Һλָʾ()
#define     EEPROM_SCL		              PORTB_PB2           // 96       IN	    0         EEPROM SDAź
#define     EEPROM_SDA			            PORTB_PB3           // 97       IN      0         EEPROM SCLź
//#define    N.C.                      PORTB_PB4  	        // 100      OUT	    0        
//#define    N.C.                      PORTB_PB5  	        // 101      OUT	    0       
//#define    N.C.                      PORTB_PB6  	        // 102      OUT	    0         
//#define    N.C.                      PORTB_PB7  	        // 103      OUT	    0         

/*===================================================================================================================================================
PTT ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define    TFT_MOSI                   PTT_PTT0            // 52       OUT      1	  	   0             0       ƺTFT_MOSI    YAMAHA
#define    TFT_SCLK                   PTT_PTT1            // 53       OUT      1	  	   0             0       ƺTFT_SCLK    YAMAHA
#define    TFT_nCS                    PTT_PTT2            // 54       OUT      1	  	   0             0       ƺTFT_nCS     YAMAHA
#define    TFT_nINT                   PTT_PTT3            // 55       IN       0	  	   0             0       ƺTFT_nINT    YAMAHA
#define    TFT_SDA                    PTT_PTT4            // 57       OUT      1	  	   0             0       ƺ    ///////////ȥ 
#define    TFT_CSB                    PTT_PTT5            // 58       OUT      1	  	   0             0       ƺ    ///////////ȥ
#define    TFT_SCL                    PTT_PTT6            // 59       OUT      0	  	   0             0       ƺ    ///////////ȥ 
#define    TFT_STB                    PTT_PTT7            // 60       OUT      0	  	   0             0       ƺ     

/*===================================================================================================================================================
PTS ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define    LINE_RADAR_IN              PTS_PTS0            // 39       IN       0	  	   0             0         ״ź
#define    LINE_IN_GEAR_R             PTS_PTS1            // 40       IN       0	  	   0             0         ״ﵹź
#define    CAN0_RXD                   PTS_PTS2            // 43       IN       0	  	   1             0         ƺRXCAN
#define    CAN0_TXD                   PTS_PTS3            // 44       OUT      0	  	   0             0         ƺTXCAN    
#define    LED_WIF_R                  PTS_PTS4            // 47       OUT      0	  	   0             0         040 ˮָʾ()
#define    LED_DPF_AUTO_Y             PTS_PTS5            // 48       OUT      0	  	   0             0         053 DPFԶָʾ
#define    LED_DPF_Y                  PTS_PTS6            // 49       OUT      0	  	   0             0         050 DPFָʾ
#define    TFT_nRST                   PTS_PTS7            // 50       OUT      0	  	   0             0         TFT_RESET

/*===================================================================================================================================================
PTP ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/   
#define    LED_LOW_FUEL_Y             PTP_PTP0            // 29       OUT     0	  	   0             0          009 ȼͲ()
#define    LINE_SPEED_OUT             PTP_PTP1            // 30       OUT     0	  	   0             0           
#define    LINE_HOOVES                PTP_PTP2            // 31       OUT     0	  	   0             0          051 Ƭĥָʾ	      
#define    LED_LOW_TIRE_PRESSURE_Y    PTP_PTP3            // 32       OUT     0	  	   0             0          052 ̥ѹ      
#define    YMA_CTL                    PTP_PTP4            // 33       OUT     0	  	   0             0          ??????     
#define    LINE_IN_RIGHT              PTP_PTP5            // 34       IN      0	  	   0             0          ת
#define    LINT_RR_HOOVES_IN          PTP_PTP6            // 35       IN      0	  	   0             0          ҺƬĥ 
#define    LINE_LR_HOOVES_IN          PTP_PTP7            // 36       IN      0	  	   0             0          Ƭĥ    

/*===================================================================================================================================================
PTH ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define     UART_RXD                  PTH_PTH0             // 63       IN       0	  	   1             0           ͨUART RXD
#define     UART_TXD                  PTH_PTH1             // 64       OUT      1	  	   0             0           ͨUART TXD
#define     LINE_IN_BREAK_AIRn        PTH_PTH2             // 65       IN       1	  	   1             0           ѹ
#define     LINE_IN_Brake_Fluid       PTH_PTH3             // 66       IN       0	  	   0             0           ƶ(Һ)-
//#define    N.C.                     PTH_PTH4             // 75       IN       0	  	   0             0        
#define     LED_BRAKE_FAULT_R         PTH_PTH5             // 76       IN       0	  	   0             0           014 ƶҺλָʾ      
#define     RotaryKEY0_In1            PTH_PTH6             // 83       OUT      0	  	   0             0           
#define     RotaryKEY0_In2            PTH_PTH7             // 84       OUT      0	  	   0             0           
/*===================================================================================================================================================
PT1AD ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
===================================================================================================================================================*/
#define  LINE_IN_ABS                  PT1AD_PT1AD0	       // 108      IN	      0        0                         ABS
#define  LINE_IN_POSITION             PT1AD_PT1AD1	       // 109      IN       0        0	                       λõ+
#define  ADC_KL15                  		PT1AD_PT1AD2         // 110      IN       0        0
#define  ADC_KL30                    	PT1AD_PT1AD3         // 111      IN       0        0
#define  ADC_FUEL                    	PT1AD_PT1AD4	       // 112      IN       0        0
#define	 LED_PARK_R           			  PT1AD_PT1AD5	       // 1        OUT      0        0                         015 פƶ 
#define	 LINE_IN_LEFT                 PT1AD_PT1AD6         // 2        IN       0        0                         ת+                 
#define	 SPI_MISO               		  PT1AD_PT1AD7         // 3        IN       0        1                      
/*===================================================================================================================================================
PTR ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define	CAN0_STB               			  PTR_PTR0             // 45       OUT      0	  	   0             0           CANշSTB
#define	PWR_3V3EN               		  PTR_PTR1             // 46       OUT      0	  	   0             0			     lcdоƬ3.3vԴʹ
#define LINE_RF_HOOVES_IN           	PTR_PTR2             // 37       IN       0	  	   0             0           ǰƬĥ 
#define LINT_LF_HOOVES_IN             PTR_PTR3             // 38       IN       0	  	   0             0           ǰƬĥ 
#define	TFT_MISO                		  PTR_PTR4             // 56       IN       0	  	   1             0
#define	LINE_POIL          				    PTR_PTR5             // 61       IN       0	  	   1             0     	     11 ѹ      
#define LINE_IN_SEATBELTn             PTR_PTR6             // 62       IN       0	  	   1             0			     ȫ
#define LINE_IN_KEY1n                 PTR_PTR7             // 85       IN       0	  	   0             0           

/*===================================================================================================================================================
PTU ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/

//#define    N.C.                      PTU_PTU0            // 9        OUT      0	  	    0             0       Z_COS+    
//#define    N.C.                      PTU_PTU1            // 10       OUT      0	  	    0             0       Z_COS-    
//#define    N.C.                      PTU_PTU2            // 11       OUT      0	  	    0             0       Z_SIN+    
//#define    N.C.                      PTU_PTU3            // 12       OUT      0         0             0       Z_SIN-    
//#define    N.C.                      PTU_PTU4            // 15       OUT      0         0             0       S_COS+    
//#define    N.C.                      PTU_PTU5            // 16       OUT      0         0             0       S_COS-    
//#define    N.C.                      PTU_PTU6            // 17       OUT      0         0             0       Z_SIN+    
//#define    N.C.                      PTU_PTU7            // 18       OUT      0         0             0       Z_SIN-   

/*===================================================================================================================================================
PTV ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
//#define    N.C.                      PTV_PTV0            // 19       out      0	  	   0             0      R-COS+       
//#define    N.C.                      PTV_PTV1            // 20       out      0	  	   0             0      R_COS-       
//#define    N.C.                      PTV_PTV2            // 21       IN       0	  	   0             0      R_SIN+       
//#define    N.C.                      PTV_PTV3            // 22       out      0	  	   0             0      R_SIN-       
//#define    N.C.                      PTV_PTV4            // 25       IN       0	  	   0             0      C_COS+       
//#define    N.C.                      PTV_PTV5            // 26       OUT      0	  	   0             0      C_COS-       
//#define    N.C.                      PTV_PTV6            // 27       OUT      0	  	   0             0      C_SIN+       
//#define    N.C.                      PTV_PTV7            // 28       OUT      0	  	   0             0      C_SIN-       

/*===================================================================================================================================================
PTM ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define    LCD_BL                      PTM_PTM0            // 69       OUT      0	  	   0             0             ϵͳϸ  LED_MIL_Y0  
#define    BL                          PTM_PTM1            // 70       OUT      0	  	   0             0            
#define    LINE_FUEL_OUT               PTM_PTM2            // 71       OUT      0	  	   0             0             ȼź_
#define    LINE_IN_Parking_Brake       PTM_PTM3            // 72       IN       0	  	   0             0             פƶ(Һ)-
/*===================================================================================================================================================
PT0AD ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
===================================================================================================================================================*/
#define	     SPI_SCLK          				 PT0AD_PT0AD0        // 4        OUT      0	  	    0
#define	     AUDIO_nCS                 PT0AD_PT0AD1      	 // 5        OUT      0         0
#define      SPI_MOSI	            		 PT0AD_PT0AD2        // 6        OUT      0         0
#define	     LINE_BUZZER               PT0AD_PT0AD3        // 7        OUT      0         0                           //

/****************************************************************************************************************************************************

****************************************************************************************************************************************************/
void GPIO_Init(void);
void GPIO_OFF(void) ;

#endif
