/******************************************************************************
?? ?? ????Communication_Over_CAN.h
??????????????CAN?????????????????????
??    ???????
??    ????V1.3
??    ???2017.5.31
******************************************************************************/

#ifndef _COMMUNICATION_OVER_CAN_
#define _COMMUNICATION_OVER_CAN_

#include "API.h"

#include "DoCAN_ISO15765.h"
#include "CAN_Communication_Matrix.h"

/******************************************************************************
CAN??????????
******************************************************************************/
#define   CoCAN_RX_MSG_FIFO_MAX_DEPTH       16    //????FIFO???
#define   CoCAN_MSG_NUM_CHECK               0     //???????????(Debug??)

#define   CoCAN_TOTAL_MSG_NUM              (sizeof(CANMsgAttrTable) / sizeof(CANMsgAttrStruct))

/******************************************************************************
CAN???????????
******************************************************************************/
#define   CoCAN_DISABLE                     0
#define   COCAN_PSEUDO_DISABLE              1
#define   CoCAN_ENABLE                      2

/******************************************************************************
CAN?????????????
******************************************************************************/
#define   CoCAN_TX_IDLE                     0
#define   CoCAN_TX_REQ                      1
#define   CoCAN_TX_ON                       2

/******************************************************************************
CAN?????????????
******************************************************************************/
#define   CoCAN_MODE_NORMAL                 0
#define   CoCAN_MODE_INIT                   1

/******************************************************************************
CAN???????FIFO??
******************************************************************************/
typedef struct
{
  uint8_t  Index[CAN_TX_MSG_NUM];
  uint8_t  Iptr;
  uint8_t  Optr;
  uint8_t  Depth;
} CoCANTxMsgFIFOStruct;

/******************************************************************************
CAN???????FIFO??
******************************************************************************/
typedef struct
{
  uint32_t Identifier;
  uint8_t  Data[8];
  uint8_t  DLC;
} CoCANMsgStruct;

typedef struct
{
  CoCANMsgStruct   Msg[CoCAN_RX_MSG_FIFO_MAX_DEPTH];
  uint8_t          Iptr;          //????????
  uint8_t          Optr;          //????????
  uint8_t          Depth;
} CoCANRxMsgFIFOStruct;

/******************************************************************************
CAN?????????????
******************************************************************************/
/*** ????????????? ***/
typedef struct
{
  uint32_t          Identifier;   //????ID
  uint16_t          Offset;       //?????????????
  uint16_t          Cycle;        //???????????
  uint8_t           Rsvd;         //????
  uint8_t           Index;        //??????????????????????????,0xFF??????????????
  uint8_t           TxReq;        //????????
  uint8_t           DLC;          //???????
  volatile uint8_t  *pMsg;        //????????
  const    uint8_t  *pInit;       //?????????
  volatile uint8_t  *pStatus;     //???????
} CoCANTxMsgIDLookupStruct;

/*** ????????????? ***/
typedef struct
{
  uint32_t           Identifier;  //????ID
  uint16_t           Cycle;       //??????????,?????????
  uint8_t            Rsvd;        //????
  uint8_t            Index;       //??????????????????????????,0xFF??????????????
  uint8_t            DLCMax;      //????????
  uint8_t            DLCMin;      //??????????
  volatile uint8_t   *pMsg;       //????????
  const    uint8_t   *pInit;      //?????????
  const    uint8_t   *pTimeOut;   //????????
  const    uint8_t   *pMask;      //????????(????????????????????????)
  volatile uint8_t   *pStatus;    //???????
} CoCANRxMsgIDLookupStruct;

/******************************************************************************
CAN??????????????
******************************************************************************/
typedef struct                                
{
  uint8_t            TxNum;                       //????????????????
  uint8_t            TxIndex[CAN_TX_MSG_NUM];     //?????????????????????????
  uint16_t           TxTimer[CAN_TX_MSG_NUM];     //???????????
  
  uint8_t            RxNum;                       //????????????????
  uint8_t            RxIndex[CAN_RX_MSG_NUM];     //???????????????????????
  uint16_t           RxTimer[CAN_RX_MSG_NUM];     //???????????,?????????
} CoCANCycleMsgStruct;

/******************************************************************************
CAN???????
******************************************************************************/
typedef struct
{
  uint8_t   Mode;
  uint8_t   TxEnable;
  uint8_t   RxEnable;
  uint8_t   Prescaler;
  uint16_t  Timer;
}CoCANCtrlStruct;
extern CoCANCtrlStruct          CoCANCtrl;
/******************************************************************************
????????
******************************************************************************/
void CoCAN_L_Data_Indication(uint32_t Identifier, uint8_t DLC, uint8_t *Data); //?????????????????

#define CoCAN_L_Data_Request(Identifier, DLC, Data)  MSCAN0_L_Data_Request(Identifier, DLC, Data, 2)

void CoCAN_Init(void);
void CoCAN_Reset(void);
void CoCAN_Set_Mode(uint8_t Mode);
void CoCAN_Rx_Enable(uint8_t En);
void CoCAN_Tx_Enable(uint8_t En);

uint8_t CoCAN_Search_Tx_Msg(uint32_t Identifier);
uint8_t CoCAN_Search_Rx_Msg(uint32_t Identifier);

void CoCAN_Signal_Update_Service(void); //?????1ms?????????

void CoCAN_Transmit_Message(uint32_t Identifier);
void CoCAN_Modify_Tx_Msg_Cycle(uint32_t Identifier, uint16_t Cycle);

void CoCAN_Init_Mode_Tx_ISR(void);

#endif


