
#include "PowerManagement.h"
#include "CAN_Communication_Matrix.h"
 
uint8_t PowerStatusBackup;
uint8_t NM_RECEIVE;
uint8_t sleepFl1g, sleepFlg;
uint8_t PWRCANResetFlag;
uint8_t SpeedBackup;
uint8_t Speedtime;
uint8_t Powerstatus;

extern uint8_t PositionLightSts_Count;
extern uint8_t DriveDoorSts_Count;
extern INT8U   HIGH_VOLTAGE;
extern INT8U   LOW_VOLTAGE;
extern uint8_t DTC_STATUS[cnDTCslen];
extern uint8_t BlTurnOffDelay;

INT8U ContrlorResumeofFUEL;
extern INT8U ContrlorResumeofTEMP;
extern INT8U ContrlorResumeofVspeed;
extern INT8U ContrlorResumeofEspeed;
extern uint8_t ContrlorResumeofGAS1; //ѹ1

extern uint16_t ESpeedValNUM;        //ת
extern uint16_t VspeedValNUM;        //
extern uint16_t ESpeedVal;           //ת
extern uint8_t TempSeg;              //ˮ

uint16_t FuelSeg;                    //ȼ
uint16_t ADblueSeg;                  //Һ
uint16_t OilSeg;
uint16_t GAS1_DISPLAY;               //ѹ1
uint16_t GAS2_DISPLAY;               //ѹ2

extern uint8_t  S3_ServerEN;         //չỰ5sʱʹܿ
extern uint8_t  DiagnosticReceived;

_MeterPos	g_voltageMeter;
_MeterPos	g_currentMeter;
_MeterPos	g_EnergyFeedbackMeter;
_MeterPos	g_EnergyConsumMeter;

uint8_t  TIME_100MS;                 //RTC_ISR 100ms
Power_Statuss g_Power_St;            //ǰʵʵԴ״̬
uint8_t  Network_Status;  
uint8_t  CanFrameExist;              //CAN_ISR
uint8_t  CounterWarning;             //ʱ
uint8_t  tDelay1;                    //ʱ
uint8_t  tDelay2;                    //ʱ
uint8_t  tWaitBusSleep;              //ʱ
uint8_t  CounterCan;                 //ʱ
uint8_t  CounterWarningFlag;         //ʱ
uint8_t  CounterCanFlag;             //ʱ
uint8_t  CLEAR_ODO_STAR = 0;
uint8_t  BCM_Sleep_Flag;

void Power_Management_Init(void)
{
  uint8_t i;
  
  Power_On_System_Init();
  wdt_reset();
  Power_On_Memory_Init();
  Power_Wake_Up_Init();              //300ms
  PowerStatusBackup = 0xFF;
  Sys_Status_Update_Mode_Set ( SYS_STAT_UPDATE_MODE_WAKEUP );
  g_Power_St = IGN_Default;          //20200301
  for (i=0; i<16; i++)
  {
    NVMConfig3300.Data[i]=NVMDefault3300.Data[i];
  }
}

void Power_Management_Service ( void )
{
    uint8_t m_Power_St;
    
    m_Power_St = 0;

    switch ( g_Power_St )
    {
        case IGN_OFF:     //IGN-ON------->IGN_OFF  KL15--OFF   ȴж           δʱ
            
            //Data_Tpms_Init ();
            Stepper_Motor_Shutdown();
            //Network_Status  = Network_Active ;
                            
            m_Power_St = IGN_OFF_State_Keep();

            if ( m_Power_St == 0 )      //OFF---->OFFԱ
            {
                g_Power_St = IGN_OFF; 
            }
            else if ( m_Power_St == 1 ) //OFF---->Sleep--->WakeUp
            {
                g_Power_St = IGN_SleepInit;
            }
            else if ( m_Power_St == 2 ) //OFF---->ON
            {
                g_Power_St = IGN_ON;
                if (NVM_RESET_ODO_FLAG == 0) 
                {
                    if (KeyEnterinStatus == 1) 
                    {
                        CLEAR_ODO_STAR = 1;
                    }
                }
                Com_TxStart(); 
            }

            break;

        case IGN_SleepInit: //˯֮ǰʼ
            Power_Sleep_Init();
            MSCAN0_Enter_Low_Power_Mode();
            //if (!LINE_IN_POSITION)
                g_Power_St = IGN_Sleep;
            //break;         //----hyq--20180415

        case IGN_Sleep    : //IGN_OFF------>IGN_Sleep KL15--OFF      1.KL15 OOFF  2.ޱ 3.
            while ( g_Power_St == IGN_Sleep )
            {
                m_Power_St = Power_Sleep_Loop();

                if ( m_Power_St == 0 )
                {
                    Power_Wake_Up_Init();
                    //PWM_INIT();
                    g_Power_St = IGN_OFF;
                }
                else	if ( m_Power_St == 3 )
                {
                    g_Power_St = IGN_WakeUp;
                }
                else  if ( m_Power_St == 5 )
                {
                    g_Power_St = IGN_Sleep;
                }
            }

            break;

        case IGN_WakeUp: //IGN_Sleep---->IGN_WakeUp     
            Power_Wake_Up_Init();
            g_Power_St = IGN_ON;
            break;

        case IGN_ON:    //IGN-OFF---->IGN_ON   IGN_Wakeup
            //type_nvm = 0; //////////////////////////////////////////////////////////////
           // TFT_LCD_Clear_Multi_Layer ( 0, YVC_LYR_NUM_CPU-1 ); //////////////////////
            Power_IGN_On_Init();
            INIT_DTC_STATUS_IGN_ON();     //----hyq--20180728 
            Sys_Status_Update_Mode_Set ( SYS_STAT_UPDATE_MODE_NORMAL );
            g_Power_St = IGN_Stay_ON;
            LINE_OUT_FUEL_CTRL = 1 ;      //----hyq--20190506 ȼʹ
            break;

        case IGN_LVP:  //Ƿѹ
        case IGN_OVP:
            Power_Protect_Loop();
            g_Power_St = IGN_WakeUp;
            break;

        case IGN_Stay_ON:

            //жIGN OFF
            if ( SYS_OPR_STAT_IGN_OFF )
                g_Power_St = IGN_OFF;
            else
                g_Power_St = IGN_Stay_ON;

            break;

        case IGN_Default:  //ϵĬ״̬ ת
            Sys_Status_Update_Service();

            if ( SYS_OPR_STAT_IGN_OFF )
                g_Power_St = IGN_OFF;
            else
                g_Power_St = IGN_ON;

            break;

        default:
            break;
    }
}
/*****************************************************************
** Function name: IGN_OFF_State_Keep()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----  
**2 KL15
**1 
**0 άKL15 OFF                      
** Function Description: ˺жϵԴ״̬תʹ.3.0.IGN--OFF;  1:---->IGN_Sleep;  2:IGN_ON;                       
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/
uint8_t StepMoter;

uint8_t IGN_OFF_State_Keep(void)          
{
  //uint8_t i;                           
  if (SYS_OPR_STAT_IGN_ON)	  
 	  return 2;   //off 1  KL15ϵ绽       	
  
  if (SYS_OPR_STAT_IGN_OFF)          
 	{ 
 	  if (CanFrameExist == 1) //˳ܶ,Ϊʲô,Գ
 	 	{
 			CounterCan = 0;	
 			CounterCanFlag = 0;	
 		} 
 		  
 		if (TIME_100MS == 1) //100msʱ
 		{			       
   	  if (BCM_Sleep_Flag == 1) //Ԥʼ tDelay1
   	  {
     	  if (tDelay1 < 200)
     	    tDelay1++;
   	  }
   	  else
   	    tDelay1 = 0;
   	  
   	  if (Network_Status == Network_Ready) 
   	  {
   	    if (NWM_BCM_STATUS & CAN_MSG_LOST) //tWaitMsgTimeOut
       	{
          if (tDelay2 < 200)
           	tDelay2++;
       	}
   	  }
   	  else
   	    tDelay2 = 0;
   	  
   	  if (Network_Status == Network_Wait)
   	  {
   	    if (tWaitBusSleep < 200) //ȴ
   	      tWaitBusSleep++;
   	  }
   	  else
   	    tWaitBusSleep = 0;
   		
   		if (CounterCan < 250)
   	    CounterCan++; 
   		
   		TIME_100MS=0;
 		}
 		
 		//----------------
 	  StepMoter = Stepper_Motor_Get_Status();
 		
 		if (StepMoter != STEPPER_MOTOR_STOP)
 		  return 0;
 		
 		if (CounterCan >= 200) //20 fhl20200420ޱ20Լ˯
 		{
 		  CounterCan = 0; 		
 		  CounterCanFlag = 1;
 		} 
 		
 		if (CounterCanFlag == 1) // Ŀǰ ת
 		{
 		   return 1;
 		}
 	  
 	  switch ( Network_Status )
    {       
      case Network_Active:        if (BCM_Sleep_Indicator == 2) //Ԥ     C3-1
                                  {
                                    BCM_Sleep_Flag = 1; //ʼtDelay1ʱ
                                  }
                                  else if	(BCM_Sleep_Indicator == 1) //򱣳缤20190809
                                  {
                                    tDelay1 = 0;
                                    tDelay2 = 0;
                                    BCM_Sleep_Flag = 0; 
                                    tWaitBusSleep  = 0;
                                    ICM_Sleep_Indicator = 1; //20190809
                                    Network_Status = Network_Active;
                                  }
                                  
                                  if (CanFrameExist == 1) //20200305
                               	 	{
                               			CanFrameExist = 0;
                               		}
                                 	//if (tDelay1 > 150) // C3-2 //20200301, ÿ100ms+1
                                 	if (tDelay1 >= 148) // C3-2 //20200301ݲԷȥ 600ms
                                 	{
                                 		tDelay1 = 0;
                                 		BCM_Sleep_Flag = 0; 
                                    Network_Status = Network_Ready ;
                                 	}
                                  break;
                                  
        case Network_Ready:       ICM_Sleep_Indicator = 2; //20190807
                                  
                                  if (CanFrameExist == 1) //20200305
                               	 	{
                               			CanFrameExist = 0;
                               		}
                                  
                                  if (BCM_Sleep_Indicator == 2)
                                    tDelay2 = 0;
                                  else if (BCM_Sleep_Indicator == 1) //򱣳缤20190809
                                  {
                                    tDelay1 = 0;
                                    tDelay2 = 0;
                                    BCM_Sleep_Flag = 0; 
                                    tWaitBusSleep  = 0;
                                    ICM_Sleep_Indicator = 1; //20190809
                                    Network_Status = Network_Active ;
                                  }
                        	    		 
                        	    		if (tDelay2 >= 29) //ȴ C5 //20200301 ,ÿ100ms+1
                        	    	  //if (tDelay2 >= 24) //ȴ C5 //20200301ݲԷȥ 200ms
                               		{
                               		  tDelay2 = 0;
                                    Network_Status = Network_Wait;
                               		}	
                                  break;
                                  
        case Network_Wait:        //ICM_Sleep_Indicator = 0; //20200306
                                  Com_TxStop();	//ر ⷢ
                                  
                                  if (CanFrameExist == 1) //20200305
                               	  {
                               			CanFrameExist = 0;
                                	}
                                  
                                  if (BCM_Sleep_Indicator == 2) //򱣳缤20190809 C7
                                  {
                                    ICM_Sleep_Indicator = 2; //20190809
                                    tWaitBusSleep  = 0;
                                    Network_Status = Network_Ready ;
                                    Com_TxStart();  
                                  }
                                  else if	(BCM_Sleep_Indicator == 1) //򱣳缤20190809
                                  {
                                    tDelay1 = 0;
                                    tDelay2 = 0;
                                    BCM_Sleep_Flag = 0; 
                                    tWaitBusSleep = 0;
                                    ICM_Sleep_Indicator = 2; //20190809
                                    Network_Status = Network_Ready ;
                                    Com_TxStart(); 
                                  }
                                  
                                  if (tWaitBusSleep >= 49) //˯ӳʱ䵽Ǽ C8
                               		{
                                     Network_Status  = Network_Inactive;
                               		}
                                  break;
                                  
        case Network_Inactive:    tWaitBusSleep = 0;
                                  
                                  if (BCM_Sleep_Indicator == 1) //ڵź Sleep Indicator = AWAKE
                                  {
                                    tDelay1 = 0;
                                    tDelay2 = 0;
                                    BCM_Sleep_Flag = 0; 
                                    tWaitBusSleep  = 0;
                                    ICM_Sleep_Indicator = 1; //20190809
                                    Network_Status = Network_Active; //C2
                                  }
                                  
                                  if (CanFrameExist == 1) //缤
                               	 	{
                               			CanFrameExist  = 0;
                               		  Network_Status = Network_Active; //20200305
                               		  ICM_Sleep_Indicator = 1; //20190809
                               		  Com_TxStart(); 
                               		  return 0;
                               		} 
                                 return 1;
             break;
        default:              Network_Status  = Network_Active ;
                              ICM_Sleep_Indicator=1;   //20190809
                              if(CanFrameExist==1)     //20200305
                              {
                               		CanFrameExist=0;
                              }
            break;        
     }
 		 //----------------------------------------------------------------------------//
 	  return 0;   //Ŀǰ״̬offԱ   
 	}     
  
  return 0;   //Ŀǰ״̬offԱ                           
}    
/*****************************************************************
** Function name: Power_Protect_Loop()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----                        
** Function Description: ϵͳǳ(1ѹǷѹ 2ϵͳ)ʱ,ִеѭ
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/ 
void Power_Protect_Loop ( void )
{
  Sys_Status_Update_Mode_Set ( SYS_STAT_UPDATE_MODE_RECOVERY );
  while ( SYS_PWR_STAT_PROTECT )
  {
#if CODEMODE==Normal   
   wdt_reset();
   Enter_Stop_Mode();                 //----hyq--STOP
#endif 
   RTI_Timing_Service();
   Data_IGN_Off_Timing_Service();
   Sys_Status_Update_Service();
  }
}
/*****************************************************************
** Function name: Power_Sleep_Loop()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----   
** 0 can 
** 3 KL15
** 5                   
** Function Description: ˺Ҫ رոģ鹦.ʼʱ.幦.SleepLoop      100msrtcһ.KL15canǷ
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/
uint8_t Power_Sleep_Loop ( void )
{
#if CODEMODE==Normal 
  Enter_Stop_Mode();                  //----hyq--STOP
  wdt_reset();                        //Ź
#endif
  if (MSCAN0_Get_Wake_Up_Flag())      //߱
  {
    CAN0RIER_RXFIE = 1;   			//ʹCANж
    CoCAN_Signal_Update_Service();
    if((DriveDoorSts_can==1)||(PsngrDoorSts_can==1)||(PositionLightSts_can==1)||(HazardLightSts==1))    //20200524 fhl
    {
        Clock_Init();
        MSCAN0_Exit_Low_Power_Mode(); 
        tWaitBusSleep=0;
     		Network_Status  = Network_Active ;	       //20200305
        return 0;
    }
    else
   // MSCAN0_Enter_Low_Power_Mode();
      CAN0RIER_RXFIE = 0;   			//ʹCANж
  }
  //----hyq--20180808 Ӳ߻
  //if(LINE_IN_POSITION)
  //{
  //  Clock_Init();
  //  return 0;
  //}
  RTI_Timing_Service();
  Data_IGN_Off_Timing_Service();
  Sys_Status_Update_Service();

	if(!SYS_OPR_STAT_IGN_OFF)
	{
	  MSCAN0_Exit_Low_Power_Mode(); 
    return 3;
   }
  return 5;
}
/******************************************************************************
ϵͳʼ
******************************************************************************/

/*****************************************************************
** Function name: Power_On_System_Init()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----                        
** Function Description: ˺Ϊģ鼰ײʼ
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/
//uint16_t StartCanOutTime0 = 0;
//uint16_t StartCanOutTime1 = 0;
//״ϵʼ
void Power_On_System_Init ( void )
{
  DisableInterrupts;
  IVBR = 0xFB;                  // relocate interrupt table to 0xFB00;
#if CODEMODE==Normal  
  WDT_Init();                   //Ź
#endif  
  Clock_Init();                 
  RTI_Init();                   //ʱ
  
  MSCAN0_Init();
  
  GPIO_Init(); 
  DB8379_Init();
                    
  PWM_Init();		                 
  SCI0_UART_Init();
  IIC_Init();
  Analog_Signal_Converter_Init();
  Sys_Status_Init();
  Data_Power_On_Init();
  Drive_Info_Power_On_Init();   //ʼ
  Drive_Info_Export_Init();
  //Buzzer_Init();
  //LCD_Seg_Init();             //ʼ
  sleepFlg = 1;
  CoCAN_Set_Mode ( CoCAN_MODE_NORMAL );
  BL_Init();
  APIBGNMEnable = 1;
  //StartCanOutTime0 = 0;
  Com_TxStart(); 
  API_Start();
  EnableInterrupts;
  Line_In_Enable ( 1 );     
  Line_In_Status_Reset();
  Sys_Status_Update_Mode_Set ( SYS_STAT_UPDATE_MODE_INIT );
  Sys_Status_Update_Service();
}
/*****************************************************************
** Function name: Power_On_Memory_Init()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----                        
** Function Description: //״ϵ洢ʼ
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/ 
void Power_On_Memory_Init ( void )
{
  uint8_t i;
  
  NVM_Init();
  
  //ع
  for ( i = 0; i < cnDTCslen; i++ )
    DiagDtc[ i ].Status.Flag = NVMDTC.Data[i];   
  Read_27_DATA_FROM_FLASH();
  ReadAllDflashData();
}

/*****************************************************************
** Function name: Power_IGN_On_Init()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----                        
** Function Description: IGNתΪON״̬ʱʼ                  
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/ 
void Power_IGN_On_Init ( void )
{
  //CounterWarning = 0;             //ʱ
  CounterCan = 0;                 //ʱ
  CounterCanFlag = 0;
  //CouterLine = 0;                 //ʱ
  tDelay1 = 0;
  tDelay2 = 0;
  tWaitBusSleep = 0;
  BCM_Sleep_Flag = 0;
  Network_Status = Network_Active ;
  Data_IGN_On_Init();
  //Warning_Signal_Init();        //״̬ʼ
  Popup_Scheduler_Init();
  Sound_Scheduler_Init();
  Startup_Animation_Reset();
  //////////////////////////
  //PWM_INIT();
  Clear_TFT();
  BL_Init();  
  BackLight_Plate_Needle_Close(); //̱
  BackLight_TFT_Close();          //  
  /////////////////////////
  Stepper_Motor_Start_Up();
  LED_OUT_KEY_CTRL = 1;
  //Radar_R3_Init();
  //Radar_R3_Receive_Enable(1); 
	
	//SEG_LCD_Init();	                //--hyq-20180923
  Line_In_Enable ( 1 ); 
}
/*****************************************************************
** Function name: Power_Sleep_Init()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----                        
** Function Description: ˺Ҫ رոģ鹦.ʼʱ.幦.׼SleepLoop      
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/
void Power_Sleep_Init ( void )
{
  //wdt_reset();
  Line_In_Enable ( 0 );
  CoCAN_Set_Mode ( CoCAN_MODE_NORMAL );
  Com_TxStop() ;
  ///////////////////////////////////////////////
  //CLEAR_ALLSCR();                 //LCD
  BackLight_Plate_Needle_Close(); //̱
  BackLight_TFT_Close();          //
  Clear_TFT(); 
  ///////////////////////////////////////////////
  TFT_LCD_Shutdown();
  Buzzer_Shutdown();              //ر
  Analog_Signal_Converter_Init();
  GPIO_Init(); 
  PWM_Channel_Stop(2);
  PWM_Channel_Stop(5);
  //PWM_Channel_Stop(7);
  TFT_nRST = 0;        
  TFT_MOSI = 0;
  TFT_SCLK = 0;
  TFT_nCS  = 0;
  
  NM_RECEIVE = 0;
  API_Stop();
  
  RTICTL      = 0xDF;             //Real Time = 8M / 800000 = 10HZ  (10MS)
  CRGINT_RTIE = 1;	              //Real Time ж
  
  BlTurnOffDelay = 10 ;
  
  Sys_Status_Update_Mode_Set ( SYS_STAT_UPDATE_MODE_WAKEUP );
}
/*****************************************************************
** Function name: Power_Wake_Up_Init()                                             
** Input:-----                                                                                                         
** Output:----                                                        
** Return:----                        
** Function Description: ˺ҪԴ֮ݼģĳʼ. ;ΪIGN_Sleep.ΪIGN_ON           
** Version: 1.0                                                   
** Be careful:                                                    
*****************************************************************/
void Power_Wake_Up_Init ( void )
{
  //wdt_reset();
  Clock_Init();                   // ʼʱӺͿŹ
  GPIO_Init();                    // GPIO ʼ 
  DB8379_Init();
  CoCAN_Init();
  Drive_Info_Export_Init();
  Analog_Signal_Converter_Init();
  SCI0_UART_Init();
  
  APIBGNMEnable = 1;
  //StartCanOutTime1 = 0;
  Com_TxStart(); 
  API_Start();
  IIC_Init();
  ///////////////////////////////////////////////////
  //LCD_Seg_Init();      
  BL_Init();                      //
  // if (!LINE_IN_POSITION)
  //   BackLight_Plate_Needle_Close(); //̱
  // else
  //   BackLight_TFT_Set(60);
    
  //BackLight_TFT_Close();          //
  //SEG_LCD_Init();                 //----hyq--20180923
  
  Line_In_Enable ( 1 );
  
  //////////////////////////////////////////////////
  Key_Status_Init();                //ʼ
  Popup_Scheduler_Init();
  IO_Management_Init();             //״̬ʼ
  Diagnostic_init();
  TFT_LCD_Startup();                //ʼ
  PWM_INIT();
  Sound_Player_Init();              //ʼ
  Sound_Scheduler_Init();
  INIT_DTC_STATUS_IGN_ON();
  Sys_Status_Update_Mode_Set ( SYS_STAT_UPDATE_MODE_NORMAL );
  ICM_Sleep_Indicator = 1;          //20190807
  CoCAN_Set_Mode ( CoCAN_MODE_NORMAL );
  Com_RxStart();
  //Com_TxStart(); 
  PositionLightSts_Count = 0;
  DriveDoorSts_Count     = 0;
  TelltaleLCD_Flag33     = 0;
}            

void Com_RxStart ( void )
{
  CoCAN_Rx_Enable(CoCAN_ENABLE);
}

void Com_TxStart(void)
{
  CoCAN_Tx_Enable(CoCAN_ENABLE);
}

void Com_TxStop(void)
{
  CoCAN_Tx_Enable(CoCAN_DISABLE);
}

void Com_RxStop(void)
{
  CoCAN_Rx_Enable(COCAN_PSEUDO_DISABLE);
}

void Diagnostic_init(void)
{
  ContrlorResumeofFUEL = 0;
  ContrlorResumeofTEMP = 0;
  ContrlorResumeofVspeed = 0;
  ContrlorResumeofEspeed = 0;
  ContrlorResumeofGAS1   = 0;     //ѹ1
  ESpeedValNUM = 0;       
  VspeedValNUM = 0;       
  ESpeedVal = 0;          
  VspeedVal = 0;          
  TempSeg = 0;           
  FuelSeg = 0;  
  ADblueSeg = 0;                  //Һ
  OilSeg = 0;
  GAS1_DISPLAY = 0;               //ѹ1
  GAS2_DISPLAY = 0;               //ѹ2                 
}
