/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.sfntly.testutils.TestUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class GlyphEditingTests
extends TestCase {
    private static final boolean DEBUG = false;
    private static final File TEST_FONT_FILE = TestFont.TestFontNames.OPENSANS.getFile();

    public GlyphEditingTests() {
    }

    public GlyphEditingTests(String name) {
        super(name);
    }

    public void testEditLocaTable() throws Exception {
        int locaSlots = 1024;
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        LocaTable.Builder locaBuilder = (LocaTable.Builder)fontBuilder.getTableBuilder(Tag.loca);
        List<Integer> locaList = locaBuilder.locaList();
        locaList.clear();
        ArrayList<Integer> newLoca = new ArrayList<Integer>();
        int glyphId = 0;
        while (glyphId < locaSlots) {
            newLoca.add(glyphId * 6);
            ++glyphId;
        }
        locaBuilder.setLocaList(newLoca);
        MaximumProfileTable.Builder maxProfileBuilder = (MaximumProfileTable.Builder)fontBuilder.getTableBuilder(Tag.maxp);
        maxProfileBuilder.setNumGlyphs(locaSlots - 1);
        Font font = fontBuilder.build();
        LocaTable loca = (LocaTable)font.getTable(Tag.loca);
        GlyphEditingTests.assertEquals(locaSlots - 1, loca.numGlyphs());
        int glyphId2 = 0;
        while (glyphId2 < loca.numGlyphs()) {
            GlyphEditingTests.assertEquals(glyphId2 * 6, loca.glyphOffset(glyphId2));
            ++glyphId2;
        }
    }

    public void testRemoveOneGlyph() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        LocaTable.Builder locaTableBuilder = (LocaTable.Builder)fontBuilder.getTableBuilder(Tag.loca);
        FontHeaderTable.Builder headerTableBuilder = (FontHeaderTable.Builder)fontBuilder.getTableBuilder(Tag.head);
        MaximumProfileTable.Builder maxpTableBuilder = (MaximumProfileTable.Builder)fontBuilder.getTableBuilder(Tag.maxp);
        GlyphTable.Builder glyphTableBuilder = (GlyphTable.Builder)fontBuilder.getTableBuilder(Tag.glyf);
        List<Integer> originalLocas = locaTableBuilder.locaList();
        glyphTableBuilder.setLoca(originalLocas);
        WritableFontData glyphData = glyphTableBuilder.data();
        WritableFontData glyphBytes = WritableFontData.createWritableFontData(0);
        glyphData.copyTo(glyphBytes);
        int numLocas = locaTableBuilder.numLocas();
        int lastLoca = locaTableBuilder.loca(numLocas - 1);
        int numGlyphs = locaTableBuilder.numGlyphs();
        GlyphEditingTests.assertEquals(numLocas, numGlyphs + 1);
        int firstGlyphOffset = locaTableBuilder.glyphOffset(0);
        int firstGlyphLength = locaTableBuilder.glyphLength(0);
        int glyphTableSize = glyphTableBuilder.header().length();
        Header oldHeader = glyphTableBuilder.header();
        List<Glyph.Builder<? extends Glyph>> glyphBuilders = glyphTableBuilder.glyphBuilders();
        glyphBuilders.remove(0);
        List<Integer> locaList = glyphTableBuilder.generateLocaList();
        locaTableBuilder.setLocaList(locaList);
        maxpTableBuilder.setNumGlyphs(locaTableBuilder.numGlyphs());
        Font font = fontBuilder.build();
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        ReadableFontData newGlyphData = glyphTable.readFontData();
        WritableFontData newGlyphBytes = WritableFontData.createWritableFontData(0);
        newGlyphData.copyTo(newGlyphBytes);
        GlyphEditingTests.assertEquals(glyphBytes.length() - firstGlyphLength, newGlyphBytes.length());
        TestUtils.equals(firstGlyphLength, glyphBytes, 0, newGlyphBytes, newGlyphBytes.length());
        Header newHeader = glyphTable.header();
        GlyphEditingTests.assertEquals(locaTable.numGlyphs(), numGlyphs - 1);
        GlyphEditingTests.assertEquals(locaTable.loca(locaTable.numLocas() - 1), lastLoca - firstGlyphLength);
        GlyphEditingTests.assertEquals(glyphTable.dataLength(), glyphTableSize - firstGlyphLength);
    }

    public void testClearAllGlyphs() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        LocaTable.Builder locaTableBuilder = (LocaTable.Builder)fontBuilder.getTableBuilder(Tag.loca);
        FontHeaderTable.Builder headerTableBuilder = (FontHeaderTable.Builder)fontBuilder.getTableBuilder(Tag.head);
        MaximumProfileTable.Builder maxpTableBuilder = (MaximumProfileTable.Builder)fontBuilder.getTableBuilder(Tag.maxp);
        GlyphTable.Builder glyphTableBuilder = (GlyphTable.Builder)fontBuilder.getTableBuilder(Tag.glyf);
        glyphTableBuilder.setLoca(locaTableBuilder.locaList());
        int lastGlyphId = locaTableBuilder.numGlyphs() - 1;
        int offset = locaTableBuilder.glyphOffset(lastGlyphId);
        int length = locaTableBuilder.glyphLength(lastGlyphId);
        List<Glyph.Builder<? extends Glyph>> glyphBuilders = glyphTableBuilder.glyphBuilders();
        glyphBuilders.clear();
        List<Integer> locaList = glyphTableBuilder.generateLocaList();
        locaTableBuilder.setLocaList(locaList);
        Font font = fontBuilder.build();
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        GlyphEditingTests.assertEquals(4, locaTable.dataLength());
        GlyphEditingTests.assertEquals(0, glyphTable.dataLength());
    }
}

