/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.issue_tests;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class Issue28Tests
extends TestCase {
    private static byte[] readToByteArray(File file) throws IOException {
        byte[] data = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            fis.read(data);
        }
        return data;
    }

    private static Glyph getLastGlyph(Font font) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        int glyphId = locaTable.numGlyphs() - 1;
        GlyphTable glyfTable = (GlyphTable)font.getTable(Tag.glyf);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        return glyfTable.glyph(offset, length);
    }

    public void testStreamVsBytes() throws Exception {
        Font streamFont;
        FontFactory factory = FontFactory.getInstance();
        byte[] data = Issue28Tests.readToByteArray(TestFont.TestFontNames.ROBOTO.getFile());
        Font byteFont = factory.loadFonts(data)[0];
        try (FileInputStream is = new FileInputStream(TestFont.TestFontNames.ROBOTO.getFile());){
            streamFont = factory.loadFonts(is)[0];
        }
        boolean thrown = false;
        Glyph byteGlyph = Issue28Tests.getLastGlyph(byteFont);
        try {
            int n = byteGlyph.xMin();
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Issue28Tests.assertTrue("IndexOutOfBoundsException was expected but was not thrown.", thrown);
        thrown = false;
        Glyph streamGlyph = Issue28Tests.getLastGlyph(streamFont);
        try {
            int e = streamGlyph.xMin();
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Issue28Tests.assertTrue("IndexOutOfBoundsException was expected but was not thrown.", thrown);
    }
}

