/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.tools.subsetter.DumbSubsetter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class BasicSubsetTests
extends TestCase {
    private static final boolean DEBUG = false;
    private static final File fontFile = TestFont.TestFontNames.OPENSANS.getFile();

    public void testSubsetGlyphs() throws Exception {
        int glyphCount = 11;
        Font[] srcFontArray = TestFontUtils.loadFont(fontFile);
        Font srcFont = srcFontArray[0];
        LocaTable srcLocaTable = (LocaTable)srcFont.getTable(Tag.loca);
        GlyphTable srcGlyphTable = (GlyphTable)srcFont.getTable(Tag.glyf);
        ArrayList<Integer> srcLoca = new ArrayList<Integer>(glyphCount + 1);
        int i = 0;
        while (i <= glyphCount + 1) {
            srcLoca.add(srcLocaTable.loca(i));
            ++i;
        }
        FontFactory factory = FontFactory.getInstance();
        DumbSubsetter subsetter = new DumbSubsetter(srcFont, factory);
        ArrayList<Integer> glyphs = new ArrayList<Integer>(glyphCount);
        glyphs.add(0);
        glyphs.add(1);
        glyphs.add(2);
        glyphs.add(3);
        glyphs.add(4);
        glyphs.add(5);
        glyphs.add(6);
        glyphs.add(7);
        glyphs.add(8);
        glyphs.add(9);
        glyphs.add(11);
        glyphs.add(10);
        subsetter.setGlyphs(glyphs);
        ArrayList<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
        cmapIds.add(CMapTable.CMapId.getInstance(Font.PlatformId.Macintosh.value(), Font.MacintoshEncodingId.Mongolian.value()));
        cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
        subsetter.setCMaps(cmapIds, 1);
        HashSet<Integer> removeTables = new HashSet<Integer>();
        removeTables.add(Tag.GPOS);
        removeTables.add(Tag.GSUB);
        removeTables.add(Tag.kern);
        subsetter.setRemoveTables(removeTables);
        Font.Builder dstFontBuilder = subsetter.subset();
        Map<Integer, Table.Builder<? extends Table>> tableBuilders = dstFontBuilder.tableBuilderMap();
        Set<Integer> builderTags = dstFontBuilder.tableBuilderMap().keySet();
        Font dstFont = dstFontBuilder.build();
        LocaTable dstLocaTable = (LocaTable)dstFont.getTable(Tag.loca);
        ArrayList<Integer> dstLoca = new ArrayList<Integer>(glyphCount + 1);
        int i2 = 0;
        while (i2 <= glyphCount + 1) {
            dstLoca.add(dstLocaTable.loca(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 <= 10) {
            BasicSubsetTests.assertEquals(srcLoca.get(i2), dstLoca.get(i2));
            ++i2;
        }
        BasicSubsetTests.assertEquals((Integer)srcLoca.get(11) - (Integer)srcLoca.get(10), (Integer)dstLoca.get(12) - (Integer)dstLoca.get(11));
        BasicSubsetTests.assertEquals((Integer)srcLoca.get(12) - (Integer)srcLoca.get(11), (Integer)dstLoca.get(11) - (Integer)dstLoca.get(10));
        CMapTable cmapTable = (CMapTable)dstFont.getTable(Tag.cmap);
        BasicSubsetTests.assertNotNull(cmapTable.cmap(CMapTable.CMapId.WINDOWS_BMP));
        BasicSubsetTests.assertEquals(1, cmapTable.numCMaps());
        BasicSubsetTests.assertFalse(dstFont.hasTable(Tag.GPOS));
        BasicSubsetTests.assertFalse(dstFont.hasTable(Tag.GSUB));
        BasicSubsetTests.assertFalse(dstFont.hasTable(Tag.kern));
    }
}

