
#ifndef _WARNING_PROCESSOR_H_
#define _WARNING_PROCESSOR_H_

#include "Communication_Over_CAN.h"
#include "Line_In.h"
#include "IO_Manager.h"
#include "Non_volatile_Memorys.h"
#include "Data_Processor.h"

/******************************************************************************
ָʾ״̬
******************************************************************************/
#define   WARNING_TEL_OFF                   0x00
#define   WARNING_TEL_ON                    0x01
#define   WARNING_TEL_FLASH_1Hz             0x02
#define   WARNING_TEL_FLASH_2Hz             0x03

/******************************************************************************
״̬
******************************************************************************/
#define   WARNING_POPUP_OFF                 0x00
#define   WARNING_POPUP_1                   0x01
#define   WARNING_POPUP_2                   0x02

/******************************************************************************
ȫֱ
******************************************************************************/

/*** ѹ ***/
extern volatile uint8_t WarningLowOilPressureTel;
extern volatile uint8_t WarningLowOilPressurePopup;

#define   WARNING_LOW_OIL_PRESSURE_TEL      WarningLowOilPressureTel
#define   WARNING_LOW_OIL_PRESSURE_POPUP    WarningLowOilPressurePopup

/*** פƶ ***/
extern volatile uint8_t WarningParkingBrakeTel;
extern volatile uint8_t WarningParkingBrakePopup;

#define   WARNING_PARKING_BRAKE_TEL         WarningParkingBrakeTel
#define   WARNING_PARKING_BRAKE_POPUP       WarningParkingBrakePopup

/*** ݰȫ ***/
extern volatile uint8_t WarningSeatbeltDrTel;
extern volatile uint8_t WarningSeatbeltDrPopup;

#define   WARNING_SEATBELT_DR_TEL           WarningSeatbeltDrTel
#define   WARNING_SEATBELT_DR_POPUP         WarningSeatbeltDrPopup

/*** ȫ ***/
extern volatile uint8_t WarningAirbagTel;
extern volatile uint8_t WarningAirbagPopup;

#define   WARNING_AIRBAG_TEL                WarningAirbagTel
#define   WARNING_AIRBAG_POPUP              WarningAirbagPopup

/*** ݰȫ ***/
extern volatile uint8_t WarningSeatbeltPaTel;
extern volatile uint8_t WarningSeatbeltPaPopup;

#define   WARNING_SEATBELT_PA_TEL           WarningSeatbeltPaTel
#define   WARNING_SEATBELT_PA_POPUP         WarningSeatbeltPaPopup

/*** ̥ѹ ***/
extern volatile uint8_t WarningTPMSTel;
extern volatile uint8_t WarningTPMSSignalAbnormal;
#define   WARNING_TPMS_TEL                  WarningTPMSTel
#define   WARNING_TPMS_SIGNAL_ABNORMAL      WarningTPMSSignalAbnormal

/*** ſ ***/
#define   WARNING_DOOR_OPEN_SINGLE          0x00
#define   WARNING_DOOR_OPEN_HIGH_SPEED      0x01

#define   WARNING_DOOR_FL                   0x01
#define   WARNING_DOOR_FR                   0x02
#define   WARNING_DOOR_RL                   0x04
#define   WARNING_DOOR_RR                   0x08
#define   WARNING_DOOR_HO                   0x10
#define   WARNING_DOOR_TR                   0x20

extern volatile uint8_t  WarningDoorOpenMode;
extern volatile uint8_t  WarningDoorOpenSoundEnable;
extern volatile uint8_t  WarningDoorStatus;

#define   WARNING_DOOR_OPEN_MODE            WarningDoorOpenMode
#define   WARNING_DOOR_OPEN_SND_EN          WarningDoorOpenSoundEnable
#define   WARNING_DOOR_STATUS               WarningDoorStatus

#define   WARNING_DOOR_OPEN_FL              (WarningDoorStatus & WARNING_DOOR_FL)
#define   WARNING_DOOR_OPEN_FR              (WarningDoorStatus & WARNING_DOOR_FR)
#define   WARNING_DOOR_OPEN_RL              (WarningDoorStatus & WARNING_DOOR_RL)
#define   WARNING_DOOR_OPEN_RR              (WarningDoorStatus & WARNING_DOOR_RR)
#define   WARNING_DOOR_OPEN_HO              (WarningDoorStatus & WARNING_DOOR_HO)
#define   WARNING_DOOR_OPEN_TR              (WarningDoorStatus & WARNING_DOOR_TR)

/*** Ƭ***/
#define   WARNING_HOOVES_LF                   0x01
#define   WARNING_HOOVES_RF                   0x02
#define   WARNING_HOOVES_LR                   0x04
#define   WARNING_HOOVES_RR                   0x08

extern volatile uint8_t  WarningHOOVEMode;
extern volatile uint8_t  WarningHOOVESoundEnable;
extern volatile uint8_t  WarningHOOVEStatus;

#define   WARNING_HOOVE_MODE                 WarningHOOVEMode
#define   WARNING_HOOVE_SND_EN               WarningHOOVESoundEnable
#define   WARNING_HOOVE_STATUS               WarningHOOVEStatus

#define   WARNING_HOOVE_OPEN_LF              (WarningHOOVEStatus & WARNING_HOOVES_LF)
#define   WARNING_HOOVE_OPEN_RF              (WarningHOOVEStatus & WARNING_HOOVES_RF)
#define   WARNING_HOOVE_OPEN_LR              (WarningHOOVEStatus & WARNING_HOOVES_LR)
#define   WARNING_HOOVE_OPEN_RR              (WarningHOOVEStatus & WARNING_HOOVES_RR)

/******************************************************************************

******************************************************************************/
#define   WARNING_LOW_OIL_PRESSURE_WAIT     5         //ѹԷĵȴʱ

/******************************************************************************
ṹ
******************************************************************************/
typedef struct
{
  uint8_t   Flag;
  uint16_t  Timer;
  uint16_t  LostTimer;
} WarningItemStruct;

typedef struct
{
  uint8_t   EngineRun;
  uint16_t  Timer;
} WarningLowOilPressureStruct;

/******************************************************************************

******************************************************************************/
void Warning_Signal_Init(void);
void Warning_Processing_Service(void);
void Warning_Parking_Brake_Processing(void);
void Warning_Seatbelt_Dr_Processing(void);
void Warning_Seatbelt_Pa_Processing(void);
void Warning_Door_Open_Processing(void);
void Warning_HOOVES_Processing(void);
void Warning_TPMS_Processing(void);

#endif