
#ifndef _DRIVE_INFO_H_
#define _DRIVE_INFO_H_

#include "GUI.h"
#include "IPC.h"
#include "IO_Manager.h"
#include "Data_Processor.h"
#include "Popup_Scheduler.h"
#include "Sound_Scheduler.h"
#include "Warning_Processor.h"
#include "Flash_synchronizer.h"
#include "Menus.h"
#include "PowerManagement.h"
#include "Non_volatile_Memorys.h"

#define        ChoiceTripA				0
#define        ChoiceTripB				1
extern uint8_t TripPlay;

extern uint8_t DriveInfoCurrent;
extern uint8_t Status;
extern uint8_t BL_KEY_Step;
extern uint8_t Flash;



#define   DRIVE_INFO_AVG_FUEL_CONS          GUI_DRIVE_INFO_AVG_FUEL_CONS
#define   DRIVE_INFO_INST_FUEL_CONS         GUI_DRIVE_INFO_INST_FUEL_CONS
#define   DRIVE_INFO_DTE                    GUI_DRIVE_INFO_DTE
#define   DRIVE_INFO_DRIVING_TIME           GUI_DRIVE_INFO_DRIVING_TIME
#define   DRIVE_INFO_TPMS                   GUI_DRIVE_INFO_TPMS
#define   DRIVE_INFO_WARNING                GUI_DRIVE_INFO_WARNING

#define   DRIVE_INFO_PAGE_MAX               6
#define   DRIVE_INFO_PAGE_INVALID           0xFF

typedef struct
{
  uint8_t   Current;
  uint8_t   Total;
  uint8_t   DispTotal;
  uint8_t   DispOffset;
  uint8_t   Available[10];
  uint8_t   Attach[10];
} DriveInfoPageStruct;


#define   DRIVE_INFO_BCM_ODO_RECEIVED       0x01
#define   DRIVE_INFO_EMS_ODO_RECEIVED       0x02
#define   DRIVE_INFO_ODO_BACKUP_COMPLETE    0x03

#define   TpmsNormal  1;
#define   Tpmsfailure 0;

typedef struct
{
  uint8_t   BackupComplete;
  uint8_t   BackupEnable;
  uint32_t  Output;
} DriveInfoODOExchangeStruct;

typedef struct
{
  uint8_t   TripMask;
  uint8_t   Enable;
  uint8_t   IGNOn;
  uint8_t   Timer;
  uint8_t   TimerTenS;
  uint16_t  TimerEighteenS;
  uint8_t   TpmsStatus;
  uint8_t   TpmsStatustens;
} DriveInfoODOClearStruct;

typedef struct
{
  uint8_t   Enable;
  uint8_t   Level;
  uint16_t  Timer;
  uint16_t  Period;
  uint16_t  ActPeriod;
} DriveInfoSpeedPlusConverterStruct;

typedef struct							   
{	
   uint16_t    CurBoardVal;											 
   uint16_t	   CurPosition; 	 	
   uint16_t	   DestPosition;
   uint16_t	   CalPosition;
   uint16_t	   Time;
} _MeterPos;


typedef struct	//35 byte							  
{	
	uint16_t	Resistor[8];	
	uint16_t	DashStep[8]; 
	uint8_t		bFlag;
	uint8_t		bVirtualVal;	
	uint8_t		bCheckSun; 
	uint8_t 	N;
}_EE_MeterInfo;



extern	_MeterPos				g_voltageMeter;
extern	_MeterPos				g_currentMeter;
extern  _MeterPos				g_EnergyFeedbackMeter;
extern  _MeterPos				g_EnergyConsumMeter;


extern _MeterPos	g_batMeter;
extern _MeterPos  g_gas1Meter;
extern _MeterPos  g_gas2Meter;

extern _EE_MeterInfo			g_gas1MeterInfo;
extern _EE_MeterInfo			g_gas2MeterInfo;

extern uint8_t type_nvm;
#define  DRIVE_INFO_SPEED_PLUS_PPK          15925             //PPKʵֵ15924.6
void Drive_Info_Tpms_Learning_Ctrl(void);
void Drive_Info_Export_Init(void);

static void Drive_Info_IC1_STATUS_Tx(void);

void Drive_Info_Power_On_Init(void);
void Drive_Info_Display_Update_Service(void);
void Drive_Info_Import_Export_Service(void);
void Drive_Info_ODO_Clear_Ctrl(void);
void Drive_Info_Speed_Plus_Conversion(void);
void Drive_Info_Fuel_Plus_Conversion ( void );
#endif


