/********************************************************************************/
/*  CONFIDENTIAL                                                                */
/*  Copyright (C) 2011 Yamaha Corporation. All rights reserved.                 */
/*  Module          : $Workfile: YGV642_SPI_Flash_IS25LP256D.h $                 */
/*  Description     : Pattern memory IS25LP256D driver include header            */
/*  Version         : $Rev: 145 $                                               */
/*  Last UpDate Time: $Date:: 2012-08-24 13:55:38#$                             */
/*  FOOT NOTE       : adjust 2tab                                               */
/*  AUTHOR          : H.Katayama                                                */
/********************************************************************************/
#ifndef _YGV642_SPI_FLASH_IS25LP256D_H_
#define _YGV642_SPI_FLASH_IS25LP256D_H_

#include "YGV642.h"

enum PM_IS25LP256D_CMD
{
  PM_IS25LP256D_CMD_READ_JEDEC_ID = 0,
	PM_IS25LP256D_CMD_E_READ_STATUS,
	PM_IS25LP256D_CMD_E_READ_CONFIG,
	PM_IS25LP256D_CMD_E_WRITE_ENABLE,
	PM_IS25LP256D_CMD_E_WRITE_STATUS,
	PM_IS25LP256D_CMD_QUAD_READ_STATUS,
	PM_IS25LP256D_CMD_QUAD_INPUT_OUTPUT_FAST_CONTINUOUS_READ_ENTER,
	PM_IS25LP256D_CMD_QUAD_INPUT_OUTPUT_FAST_CONTINUOUS_READ,
	PM_IS25LP256D_CMD_QUAD_INPUT_OUTPUT_FAST_MODE,
	PM_IS25LP256D_CMD_ENTER_4_BYTE_ADDRESS_MODE,
	PM_IS25LP256D_CMD_ENTER_QPI_MODE,
};

/*------------------------------------------------------------------------------*/
/*                      D E F I N E                                             */
/*------------------------------------------------------------------------------*/

#define PM_IS25LP256D_POLLING_COUNT_MAX      (3000000)
#define PM_IS25LP256D_READ_REGISTER_MASK     (0x03)

#define PM_IS25LP256D_READACS_PMRREQ         (0x80)
#define PM_IS25LP256D_READACS_PWBUSY         (0x40)
#define PM_IS25LP256D_READACS_CSNEG          (0x10)

#define PM_IS25LP256D_MANUFACTURER_ID        (0x9D)
#define PM_IS25LP256D_DEVICE_ID_MSB          (0x60)
#define PM_IS25LP256D_DEVICE_ID_LSB          (0x19)

/*------------------------------------------------------------------------------*/
/*                      V A R I A B L E S                                       */
/*------------------------------------------------------------------------------*/
static const uint8_t PMIS25LP256DCmdData[][8] =
{
 /* R#55h R#56h R#57h R#58h R#59h R#5Ah R#5Bh  P#3 */
  { 0x06, 0x03, 0x00, 0x03, 0x9F, 0x00, 0x00, 0x00 }, /* Read JEDEC ID                                */
	{ 0x06, 0x03, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00 },	/* Read Status				                          */
	{ 0x06, 0x0B, 0x00, 0x03, 0x15, 0x00, 0x00, 0x00 },	/* Read Config				                          */
	{ 0x06, 0x00, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00 },	/* Write Enable                                 */
	{ 0x06, 0x03, 0x00, 0x03, 0x01, 0x00, 0x00, 0x40 },	/* Write Status                                 */
	{ 0x06, 0x09, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00 },	/* Quod Read Status								              */
	{ 0x06, 0x89, 0x22, 0x13, 0xEB, 0x00, 0xA5, 0x00 },	/* Enter Continuous Quad Input/Ouput Fast Read  */
	{ 0x26, 0x89, 0x22, 0x13, 0xEB, 0x00, 0xA5, 0x00 },	/* Continuous Quad Input/Ouput Fast Read      	*/
	{ 0x06, 0x89, 0x22, 0x13, 0xEB, 0x00, 0x00, 0x00 }, /* Fast I/O read                                */
	{ 0x06, 0x08, 0x00, 0x03, 0xB7, 0x00, 0x00, 0x00 },	/* Enter 4-Byte Address Mode			            	*/
	{ 0x06, 0x08, 0x00, 0x03, 0x35, 0x00, 0x00, 0x00 },	/* Enter QPI Mode				                        */
};

/*------------------------------------------------------------------------------*/
/*                      F U N C T I O N S                                       */
/*------------------------------------------------------------------------------*/
uint8_t PM_IS25LP256D_ID_Check(void);
void PM_IS25LP256D_Init(void);
void PM_IS25LP256D_Set_Pattern_Memory_Addr(uint32_t Addr);
void PM_IS25LP256D_Write_Cmd(uint8_t CmdNo, uint8_t CmdLen, uint8_t Send);    //
uint8_t PM_IS25LP256D_Read_Pattern_Memory_Data_Port(uint8_t CmdNo, uint8_t CmdLen); //
void PM_IS25LP256D_Wait_Clear_Flag(uint8_t Mask);    //

#endif
