/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import java.io.IOException;
import java.io.OutputStream;

public class FontOutputStream
extends OutputStream {
    private final OutputStream out;
    private long position;

    public FontOutputStream(OutputStream os) {
        this.out = os;
    }

    public long position() {
        return this.position;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.position;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.out.write(b, off, len);
        this.position += (long)len;
    }

    public void writeChar(byte c) throws IOException {
        this.write(c);
    }

    public void writeUShort(int us) throws IOException {
        this.write((byte)(us >> 8 & 0xFF));
        this.write((byte)(us & 0xFF));
    }

    public void writeShort(int s) throws IOException {
        this.writeUShort(s);
    }

    public void writeUInt24(int ui) throws IOException {
        this.write((byte)(ui >> 16 & 0xFF));
        this.write((byte)(ui >> 8 & 0xFF));
        this.write((byte)(ui & 0xFF));
    }

    public void writeULong(long ul) throws IOException {
        this.write((byte)(ul >> 24 & 0xFFL));
        this.write((byte)(ul >> 16 & 0xFFL));
        this.write((byte)(ul >> 8 & 0xFFL));
        this.write((byte)(ul & 0xFFL));
    }

    public void writeLong(long l) throws IOException {
        this.writeULong(l);
    }

    public void writeFixed(int f) throws IOException {
        this.writeULong(f);
    }

    public void writeDateTime(long date) throws IOException {
        this.writeULong(date >> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.writeULong(date & 0xFFFFFFFFFFFFFFFFL);
    }
}

