/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.BitIOWriter;
import junit.framework.TestCase;

public class BitIOWriterTest
extends TestCase {
    private void assertEqualsByteArray(byte[] expected, byte[] actual) {
        BitIOWriterTest.assertEquals(expected.length, actual.length);
        int i = 0;
        while (i < expected.length) {
            BitIOWriterTest.assertEquals(expected[i], actual[i]);
            ++i;
        }
    }

    public void testBitIOBit() {
        BitIOWriter writer = new BitIOWriter();
        writer.writeBit(1);
        writer.writeBit(0);
        writer.writeBit(1);
        writer.writeBit(1);
        writer.writeBit(0);
        writer.writeBit(0);
        writer.writeBit(1);
        writer.writeBit(0);
        writer.writeBit(1);
        writer.flush();
        byte[] result = writer.toByteArray();
        byte[] expected = new byte[]{-78, -128};
        this.assertEqualsByteArray(expected, result);
    }

    public void testBitIOValues() {
        BitIOWriter writer = new BitIOWriter();
        writer.writeValue(85, 7);
        writer.writeValue(581, 10);
        writer.flush();
        byte[] result = writer.toByteArray();
        byte[] expected = new byte[]{-85, 34, -128};
        this.assertEqualsByteArray(expected, result);
    }

    public void testBitIOBool() {
        BitIOWriter writer = new BitIOWriter();
        writer.writeBit(true);
        writer.writeBit(false);
        writer.writeBit(true);
        writer.writeBit(true);
        writer.writeBit(false);
        writer.writeBit(false);
        writer.writeBit(true);
        writer.writeBit(false);
        writer.writeBit(true);
        writer.flush();
        byte[] result = writer.toByteArray();
        byte[] expected = new byte[]{-78, -128};
        this.assertEqualsByteArray(expected, result);
    }
}

