
#include "Sound_Player.h"

SoundPlayCtrlStruct     SoundPlayCtrl;

void Sound_Player_Init ( void )
{
  SoundPlayCtrl.Playing = SND_SRC_NONE;                //Ҫŵ
  SoundPlayCtrl.Timer   = 0;
  SoundPlayCtrl.Cycle   = 0;
  SoundPlayCtrl.Status  = SND_PLAYER_IDLE;
  SoundPlayCtrl.VolInit = 1;
  Buzzer_Start_Up();
}

uint8_t Sound_Play ( uint8_t SoundID )
{
  if ( SoundPlayCtrl.VolInit )                         //״βʱʼ
  {
    SoundPlayCtrl.VolInit = 0;
  }

  if ( SoundID < SND_TOTAL_NUM )
  {
    if ( SoundPlayCtrl.Status != SND_PLAYER_IDLE )     //ڲ,򷵻زʧ
      return 1;

    SoundPlayCtrl.Playing = SoundID;                   //Ҫŵ
    SoundPlayCtrl.Timer   = 0;
    SoundPlayCtrl.Cycle   = SndAttributeTable[SoundID].Cycle;
    SoundPlayCtrl.Status  = SND_PLAYER_PLAY_REQ;
    return 0;                                          //زųɹ
  }
  else
    return 2;                                          //ش״̬
}

uint8_t Sound_Stop ( uint8_t SoundID )
{
  if ( SoundID < SND_TOTAL_NUM )
  {
    if ( ( SoundPlayCtrl.Status == SND_PLAYER_IDLE ) || \
         ( SoundPlayCtrl.Playing != SoundID ) )        //ֹͣŻڲŵֹͣŵ
      return 0;                                        //ֹͣɹ

    if ( SoundPlayCtrl.Status == SND_PLAYER_PLAY_REQ ) //ֹͣŵǸ󲥷ŵ
    {
        SoundPlayCtrl.Playing = SND_SRC_NONE;
        SoundPlayCtrl.Timer   = 0;
        SoundPlayCtrl.Cycle   = 0;
        SoundPlayCtrl.Status = SND_PLAYER_IDLE;        //ȡ
        return 0;                                      //ֹͣɹ
    }

    SoundPlayCtrl.Status = SND_PLAYER_STOP_REQ;        //ֹͣ
    return 1;                                          //ֹͣʧ
  }
  else
    return 2;                                          //ش״̬
}

void Sound_Clear ( void )
{
  if ( SoundPlayCtrl.Status == SND_PLAYER_IDLE )
    return;
  else if ( SoundPlayCtrl.Status == SND_PLAYER_PLAY_REQ )
  {
    SoundPlayCtrl.Playing = SND_SRC_NONE;
    SoundPlayCtrl.Timer   = 0;
    SoundPlayCtrl.Cycle   = 0;
    SoundPlayCtrl.Status = SND_PLAYER_IDLE;            //ȡ
    return;
  }
  else
  {
    if (SoundPlayCtrl.Playing < SND_TOTAL_NUM)
      Buzzer_Stop_Play();

    SoundPlayCtrl.Playing = SND_SRC_NONE;
    SoundPlayCtrl.Timer   = 0;
    SoundPlayCtrl.Cycle   = 0;
    SoundPlayCtrl.Status = SND_PLAYER_IDLE;            //ȡ
  }
}

uint8_t Sound_Priority_Query ( uint8_t SoundID )
{
  if ( SoundID == SND_SRC_CURRENT )
  {
    if ( SoundPlayCtrl.Playing < SND_TOTAL_NUM )
      return SndAttributeTable[SoundPlayCtrl.Playing].Priority;
    else
      return 0xFF;
  }
  else if ( SoundID < SND_TOTAL_NUM )
    return SndAttributeTable[SoundID].Priority;
  else
    return 0xFF;
}

//10ms
void Sound_Play_Service ( void )
{
  if ( SoundPlayCtrl.Status == SND_PLAYER_IDLE )
    return;

  if ( SoundPlayCtrl.Timer >= 10 )
    SoundPlayCtrl.Timer -= 10;
  else if ( SoundPlayCtrl.Timer > 0 )
    SoundPlayCtrl.Timer  = 0;

  if ( ( SoundPlayCtrl.Status == SND_PLAYER_PLAYING ) || ( SoundPlayCtrl.Status == SND_PLAYER_PLAY_REQ ) )
  {
    if ( SoundPlayCtrl.Timer == 0 )
    {
      if ( SoundPlayCtrl.Cycle == 0 )
      {
        if ( SoundPlayCtrl.Playing < SND_TOTAL_NUM )
        {
          if (SndAttributeTable[SoundPlayCtrl.Playing].Mode != SND_MODE_SINGLE)
            Buzzer_Stop_Play();
        }

        SoundPlayCtrl.Playing = SND_SRC_NONE;
        SoundPlayCtrl.Status  = SND_PLAYER_IDLE;
      }
      else
      {
        if ( SoundPlayCtrl.Playing < SND_TOTAL_NUM )
        {
          if ( SndAttributeTable[SoundPlayCtrl.Playing].Mode == SND_MODE_SINGLE)
            Buzzer_Play_Track(SndAttributeTable[SoundPlayCtrl.Playing].Index);
          else
          {
            if ( SoundPlayCtrl.Status == SND_PLAYER_PLAY_REQ )
              Buzzer_Repeat_Play_Track(SndAttributeTable[SoundPlayCtrl.Playing].Index);
          }

          SoundPlayCtrl.Timer = SndAttributeTable[SoundPlayCtrl.Playing].Period;
          SoundPlayCtrl.Status  = SND_PLAYER_PLAYING;

          if ( SoundPlayCtrl.Cycle != SND_CYCLE_NONSTOP )
            SoundPlayCtrl.Cycle--;
        }
        else
        {
          SoundPlayCtrl.Playing = SND_SRC_NONE;
          SoundPlayCtrl.Cycle   = 0;
          SoundPlayCtrl.Status  = SND_PLAYER_IDLE;     //ȡ
        }
      }
    }
  }
  else                                                 //ǰֹͣ
  {
    if ( SoundPlayCtrl.Playing < SND_TOTAL_NUM )
    {
      if ( SndAttributeTable[SoundPlayCtrl.Playing].Mode != SND_MODE_SINGLE )
      {
        Buzzer_Stop_Play();
        SoundPlayCtrl.Playing = SND_SRC_NONE;
        SoundPlayCtrl.Cycle   = 0;
        SoundPlayCtrl.Status  = SND_PLAYER_IDLE;
      }
      else
      {
        if ( SoundPlayCtrl.Timer == 0 )
        {
          SoundPlayCtrl.Playing = SND_SRC_NONE;
          SoundPlayCtrl.Cycle   = 0;
          SoundPlayCtrl.Status  = SND_PLAYER_IDLE;
        }
      }
    }
  }
}

