/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import com.google.typography.font.tools.subsetter.HintStripper;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;

public class HintStripTest
extends TestCase {
    private static final File fontFile = TestFont.TestFontNames.OPENSANS.getFile();
    Font dstFont;

    @Override
    public void setUp() throws IOException {
        Font srcFont = TestFontUtils.loadFont(fontFile)[0];
        FontFactory factory = FontFactory.getInstance();
        HintStripper subsetter = new HintStripper(srcFont, factory);
        HashSet<Integer> removeTables = new HashSet<Integer>();
        removeTables.add(Tag.fpgm);
        removeTables.add(Tag.prep);
        removeTables.add(Tag.cvt);
        subsetter.setRemoveTables(removeTables);
        Font.Builder dstFontBuilder = subsetter.subset();
        this.dstFont = dstFontBuilder.build();
    }

    public void testNumGlyphs() {
        MaximumProfileTable maxpTable = (MaximumProfileTable)this.dstFont.getTable(Tag.maxp);
        HintStripTest.assertEquals(938, maxpTable.numGlyphs());
        LocaTable locaTable = (LocaTable)this.dstFont.getTable(Tag.loca);
        HintStripTest.assertEquals(938, locaTable.numGlyphs());
    }

    public void testCmap() throws IOException {
        CMapTable cmapTable = (CMapTable)this.dstFont.getTable(Tag.cmap);
        HintStripTest.assertEquals(1.0f, (float)cmapTable.numCMaps(), 1.0f);
        CMap cmap = cmapTable.cmap(0);
        HintStripTest.assertEquals(CMapTable.CMapId.WINDOWS_BMP, cmap.cmapId());
        HintStripTest.assertEquals(67, cmap.glyphId(96));
        HintStripTest.assertEquals(68, cmap.glyphId(97));
        HintStripTest.assertEquals(162, cmap.glyphId(224));
    }

    public void testHorizontalMetrics() {
        HorizontalMetricsTable hmtxTable = (HorizontalMetricsTable)this.dstFont.getTable(Tag.hmtx);
        HintStripTest.assertEquals(1229, hmtxTable.advanceWidth(0));
        HintStripTest.assertEquals(193, hmtxTable.leftSideBearing(0));
        HintStripTest.assertEquals(1182, hmtxTable.advanceWidth(67));
        HintStripTest.assertEquals(393, hmtxTable.leftSideBearing(67));
        HintStripTest.assertEquals(1139, hmtxTable.advanceWidth(68));
        HintStripTest.assertEquals(94, hmtxTable.leftSideBearing(68));
        HintStripTest.assertEquals(1139, hmtxTable.advanceWidth(162));
        HintStripTest.assertEquals(94, hmtxTable.leftSideBearing(162));
    }

    public void testSimpleGlyph1() {
        Glyph glyph = HintStripTest.getGlyph(this.dstFont, 67);
        HintStripTest.assertEquals((Object)Glyph.GlyphType.Simple, (Object)glyph.glyphType());
        SimpleGlyph simple = (SimpleGlyph)glyph;
        HintStripTest.assertEquals(1, simple.numberOfContours());
        HintStripTest.assertEquals(10, simple.numberOfPoints(0));
        HintStripTest.assertEquals(0, simple.instructionSize());
        HintStripTest.assertTrue(simple.onCurve(0, 0));
        HintStripTest.assertEquals(786, simple.xCoordinate(0, 0));
        HintStripTest.assertEquals(1241, simple.yCoordinate(0, 0));
        HintStripTest.assertTrue(simple.onCurve(0, 1));
        HintStripTest.assertEquals(676, simple.xCoordinate(0, 1));
        HintStripTest.assertEquals(1241, simple.yCoordinate(0, 1));
        HintStripTest.assertTrue(simple.onCurve(0, 9));
        HintStripTest.assertEquals(786, simple.xCoordinate(0, 9));
        HintStripTest.assertEquals(1266, simple.yCoordinate(0, 9));
        HintStripTest.assertEquals(1, simple.padding());
    }

    public void testSimpleGlyph2() {
        Glyph glyph = HintStripTest.getGlyph(this.dstFont, 68);
        HintStripTest.assertEquals((Object)Glyph.GlyphType.Simple, (Object)glyph.glyphType());
        SimpleGlyph simple = (SimpleGlyph)glyph;
        HintStripTest.assertEquals(2, simple.numberOfContours());
        HintStripTest.assertEquals(26, simple.numberOfPoints(0));
        HintStripTest.assertEquals(11, simple.numberOfPoints(1));
        HintStripTest.assertEquals(0, simple.instructionSize());
        HintStripTest.assertEquals(1, simple.padding());
    }

    public void testCompositeGlyph() {
        Glyph glyph = HintStripTest.getGlyph(this.dstFont, 162);
        HintStripTest.assertEquals((Object)Glyph.GlyphType.Composite, (Object)glyph.glyphType());
        CompositeGlyph composite = (CompositeGlyph)glyph;
        HintStripTest.assertEquals(2, composite.numGlyphs());
        HintStripTest.assertEquals(68, composite.glyphIndex(0));
        HintStripTest.assertEquals(0, composite.argument1(0));
        HintStripTest.assertEquals(0, composite.argument2(0));
        HintStripTest.assertEquals(67, composite.glyphIndex(1));
        HintStripTest.assertEquals(-114, composite.argument1(1));
        HintStripTest.assertEquals(0, composite.argument2(1));
        HintStripTest.assertEquals(0, composite.instructionSize());
        HintStripTest.assertEquals(0, composite.padding());
    }

    public void testTablesRemoved() {
        HintStripTest.assertNull(this.dstFont.getTable(Tag.fpgm));
        HintStripTest.assertNull(this.dstFont.getTable(Tag.prep));
        HintStripTest.assertNull(this.dstFont.getTable(Tag.cvt));
    }

    private static Glyph getGlyph(Font font, int glyphId) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyfTable = (GlyphTable)font.getTable(Tag.glyf);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        return glyfTable.glyph(offset, length);
    }
}

