/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.component;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.opentype.component.Record;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class RecordList<T extends Record>
implements Iterable<T> {
    private static final int COUNT_OFFSET = 0;
    static final int DATA_OFFSET = 2;
    final int base;
    private final int recordBase;
    final ReadableFontData readData;
    private final WritableFontData writeData;
    private int count;
    private List<T> recordsToWrite;

    protected RecordList(ReadableFontData data, int countDecrement, int countOffset, int valuesOffset) {
        this.readData = data;
        this.writeData = null;
        this.base = countOffset;
        this.recordBase = valuesOffset;
        if (this.readData != null) {
            this.count = data.readUShort(countOffset + 0) - countDecrement;
        }
    }

    protected RecordList(RecordList<T> other) {
        this.readData = other.readData;
        this.writeData = other.writeData;
        this.base = other.base;
        this.recordBase = other.recordBase;
        this.count = other.count;
        this.recordsToWrite = other.recordsToWrite;
    }

    protected RecordList(ReadableFontData data) {
        this(data, 0);
    }

    protected RecordList(ReadableFontData data, int countDecrement) {
        this(data, countDecrement, 0, 2);
    }

    protected RecordList(ReadableFontData data, int countDecrement, int countOffset) {
        this(data, countDecrement, countOffset, countOffset + 2);
    }

    public int count() {
        if (this.recordsToWrite != null) {
            return this.recordsToWrite.size();
        }
        return this.count;
    }

    public int limit() {
        return this.sizeOfList(this.count());
    }

    private int sizeOfList(int count) {
        return this.baseAt(this.recordBase, count);
    }

    private int baseAt(int base, int index) {
        return base + index * this.recordSize();
    }

    T get(int index) {
        if (this.recordsToWrite != null) {
            return (T)((Record)this.recordsToWrite.get(index));
        }
        return this.getRecordAt(this.readData, this.sizeOfList(index));
    }

    public boolean contains(T record) {
        if (this.recordsToWrite != null) {
            return this.recordsToWrite.contains(record);
        }
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!record.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.recordsToWrite != null) {
            return this.recordsToWrite.iterator();
        }
        return new Iterator<T>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < RecordList.this.count;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RecordList.this.getRecordAt(RecordList.this.readData, RecordList.this.sizeOfList(this.current++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public RecordList<T> add(T record) {
        this.copyFromRead();
        this.recordsToWrite.add(record);
        return this;
    }

    public int writeTo(WritableFontData writeData) {
        this.copyFromRead();
        writeData.writeUShort(this.base + 0, this.count);
        int nextWritePos = this.recordBase;
        for (Record record : this.recordsToWrite) {
            nextWritePos += record.writeTo(writeData, nextWritePos);
        }
        return nextWritePos - this.recordBase + 2;
    }

    private void copyFromRead() {
        if (this.recordsToWrite == null) {
            this.recordsToWrite = new ArrayList<T>(this.count);
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                this.recordsToWrite.add((Record)iterator.next());
            }
        }
    }

    protected abstract T getRecordAt(ReadableFontData var1, int var2);

    protected abstract int recordSize();
}

