/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.testing;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FontLoader {
    public static List<File> getFontFiles(String fontDir) {
        ArrayList<File> fontFiles = new ArrayList<File>();
        FontLoader.getFontFiles(fontFiles, new File(fontDir), "", true);
        return fontFiles;
    }

    public static Font getFont(File fontFile) throws IOException {
        Font[] fonts = FontLoader.load(fontFile);
        if (fonts == null) {
            throw new IllegalArgumentException("No font found");
        }
        return fonts[0];
    }

    private static void getFontFiles(List<File> fonts, File dir, String startFrom, boolean foundStart) {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".ttf") && (foundStart || startFrom.endsWith(file.getName()))) {
                foundStart = true;
                fonts.add(file);
            }
            if (file.isDirectory()) {
                FontLoader.getFontFiles(fonts, file, startFrom, foundStart);
            }
            ++n2;
        }
    }

    private static Font[] load(File file) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(true);
        try (FileInputStream is = new FileInputStream(file);){
            Font[] fontArray = fontFactory.loadFonts(is);
            return fontArray;
        }
    }
}

