/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.tools.subsetter.HorizontalMetricsTableBuilder;
import com.google.typography.font.tools.subsetter.Subsetter;
import com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.util.ArrayList;
import java.util.List;

public class HorizontalMetricsTableSubsetter
extends TableSubsetterImpl {
    protected HorizontalMetricsTableSubsetter() {
        super(Tag.hmtx, Tag.hhea);
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder fontBuilder) {
        List<Integer> permutationTable = subsetter.glyphMappingTable();
        if (permutationTable == null) {
            return false;
        }
        HorizontalMetricsTable origMetrics = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        ArrayList<HorizontalMetricsTableBuilder.LongHorMetric> metrics = new ArrayList<HorizontalMetricsTableBuilder.LongHorMetric>();
        int i = 0;
        while (i < permutationTable.size()) {
            int origGlyphId = permutationTable.get(i);
            int advanceWidth = origMetrics.advanceWidth(origGlyphId);
            int lsb = origMetrics.leftSideBearing(origGlyphId);
            metrics.add(new HorizontalMetricsTableBuilder.LongHorMetric(advanceWidth, lsb));
            ++i;
        }
        new HorizontalMetricsTableBuilder(fontBuilder, metrics).build();
        return true;
    }
}

