/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapFormat4;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.tools.subsetter.CMapTableBuilder;
import com.google.typography.font.tools.subsetter.Subsetter;
import com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RenumberingCMapTableSubsetter
extends TableSubsetterImpl {
    public RenumberingCMapTableSubsetter() {
        super(Tag.cmap);
    }

    private static CMapFormat4 getCMapFormat4(Font font) {
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format4.value()) continue;
            return (CMapFormat4)cmap;
        }
        return null;
    }

    static Map<Integer, Integer> computeMapping(Subsetter subsetter, Font font) {
        CMapFormat4 cmap4 = RenumberingCMapTableSubsetter.getCMapFormat4(font);
        if (cmap4 == null) {
            throw new RuntimeException("CMap format 4 table in source font not found");
        }
        Map<Integer, Integer> inverseMapping = subsetter.getInverseMapping();
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        for (Integer unicode : cmap4) {
            int glyph = cmap4.glyphId(unicode);
            if (!inverseMapping.containsKey(glyph)) continue;
            mapping.put(unicode, inverseMapping.get(glyph));
        }
        return mapping;
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder fontBuilder) throws IOException {
        CMapTableBuilder cmapBuilder = new CMapTableBuilder(fontBuilder, RenumberingCMapTableSubsetter.computeMapping(subsetter, font));
        cmapBuilder.build();
        return true;
    }
}

