/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.impl.ICUBinary;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class UConverterAliasDataReader
implements ICUBinary.Authenticate {
    private DataInputStream dataInputStream;
    private static final byte[] DATA_FORMAT_ID = new byte[]{67, 118, 65, 108};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{3, 0, 1};
    private static final int UNSIGNED_INT_MASK = -1;

    protected UConverterAliasDataReader(InputStream inputStream) throws IOException {
        ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        this.dataInputStream = new DataInputStream(inputStream);
    }

    protected int[] readToc(int n) throws IOException {
        int[] toc = new int[n];
        for (int i = 0; i < n; ++i) {
            toc[i] = this.dataInputStream.readInt() & 0xFFFFFFFF;
        }
        return toc;
    }

    protected void read(int[] convList, int[] tagList, int[] aliasList, int[] untaggedConvArray, int[] taggedAliasArray, int[] taggedAliasLists, int[] optionTable, byte[] stringTable, byte[] normalizedStringTable) throws IOException {
        int i;
        for (i = 0; i < convList.length; ++i) {
            convList[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < tagList.length; ++i) {
            tagList[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < aliasList.length; ++i) {
            aliasList[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < untaggedConvArray.length; ++i) {
            untaggedConvArray[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < taggedAliasArray.length; ++i) {
            taggedAliasArray[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < taggedAliasLists.length; ++i) {
            taggedAliasLists[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < optionTable.length; ++i) {
            optionTable[i] = this.dataInputStream.readUnsignedShort();
        }
        this.dataInputStream.readFully(stringTable);
        this.dataInputStream.readFully(normalizedStringTable);
    }

    public boolean isDataVersionAcceptable(byte[] version) {
        return version.length >= DATA_FORMAT_VERSION.length && version[0] == DATA_FORMAT_VERSION[0] && version[1] == DATA_FORMAT_VERSION[1] && version[2] == DATA_FORMAT_VERSION[2];
    }
}

