

#ifndef _DATA_PROCESSOR_H_
#define _DATA_PROCESSOR_H_

#include "Communication_Over_CAN.h"
#include "Non_volatile_Memorys.h"
#include "System_Status_Monitor.h"
#include "GUI.h"
#include "CAN_Communication_Matrix.h"
#include "Telltales.h"
#include "Menus.h"
/******************************************************************************
ݱƽ
******************************************************************************/
#define   DATA_APPR_DIR_INC                 0x00
#define   DATA_APPR_DIR_DEC                 0x01


//extern uint16_t TireTEMP;
extern uint16_t TireTEMPL;
extern uint16_t TireTEMPR;
//extern uint16_t TirePLR;
extern uint16_t TirePL;
extern uint16_t TirePR;
/******************************************************************************
ת
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataESpeedActual;
extern uint16_t DataESpeedDisp;
extern uint8_t  DataESpeedValid;
extern uint8_t  Maintain_alarm;
#define  DATA_ENGINE_SPEED_ACTUAL           DataESpeedActual
#define  DATA_ENGINE_SPEED_DISPLAYING       DataESpeedDisp
#define  DATA_ENGINE_SPEED_VALID            DataESpeedValid
extern uint8_t IO_DISP_TEST_OFF_TIME;   //Լʱ
/***  ***/
#define   DATA_ENGINE_RUNNING_THRESHOLD     400 //תֵ    
#define   DATA_ENGINE_STOP_THRESHOLD        300 //ֵֹͣ

#define   DATA_ESPEED_DAMPING_FACTOR        50   //ϵ
#define   DATA_ESPEED_INC_STEP              3   //ٶʱٶȱ仯
#define   DATA_ESPEED_DEC_STEP              8   //ıʱٶȱ仯
#define   DATA_ESPEED_APPR_SPEED_MIN        2   //Сƽٶ
#define   DATA_ESPEED_HYSTERESIS            40   //ز    

/*** ƽṹ ***/
typedef struct
{
  uint16_t  Timer;
  uint16_t  Backup;
  uint16_t  Buffer[5];
  uint8_t   Cnt;
  uint8_t   UseBackup;
} DataESpeedSamplerStruct;            //תٲṹ

typedef struct
{
  uint16_t  Speed;
  uint16_t  Delta;
  uint8_t   Dir;
} DataESPeedDampingStruct;            //תṹ

typedef struct
{
  uint16_t  ESpeedBackup;
  uint16_t  Timer;
  uint8_t   Mode;
} DataESpeedIdleStruct;               //ٴṹ

/******************************************************************************

******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataVSpeedActual;
extern uint16_t DataVSpeedDisp;
extern uint8_t  DataVSpeedValid;
extern uint8_t  DataOverSpeed;

#define  DATA_VEHICLE_SPEED_ACTUAL          DataVSpeedActual
#define  DATA_VEHICLE_SPEED_DISPLAYING      DataVSpeedDisp
#define  DATA_VEHICLE_SPEED_VALID           DataVSpeedValid
#define  DATA_OVER_SPEED_WARNING            DataOverSpeed

/***  ***/
#define   DATA_VEHICLE_RUNNING_THRESHOLD    25  //нֵ    
#define   DATA_VEHICLE_STOP_THRESHOLD       20  //ֵֹͣ

#define   DATA_VSPEED_DAMPING_FACTOR        4   //ϵ
#define   DATA_VSPEED_INC_STEP              3   //ٶʱٶȱ仯
#define   DATA_VSPEED_DEC_STEP              8   //ıʱٶȱ仯
#define   DATA_VSPEED_APPR_SPEED_MIN        2   //Сƽٶ
#define   DATA_VSPEED_HYSTERESIS            10   //ز 20201208Ѳٲ

/*** ƽṹ ***/
typedef struct
{
  uint16_t  Timer;
  uint16_t  Backup;
  uint16_t  Buffer[3];
  uint8_t   Cnt;
  uint8_t   UseBackup;
} DataVSpeedSamplerStruct;            //ٲṹ

typedef struct
{
  uint16_t  Speed;
  uint16_t  Delta;
  uint8_t   Dir;
} DataVSPeedDampingStruct;            //ṹ

/******************************************************************************
ˮ
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataCoolantTempSegDisp;
extern uint16_t DataCoolantTemp;
extern uint8_t DataCollantTempValid;
extern uint8_t DataHiCollantTempWarning;

#define  DATA_COOLANT_TEMP_SEG_DISPLAYING   DataCoolantTempSegDisp               
#define  DATA_COOLANT_TEMP_VALID            DataCollantTempValid                 
#define  DATA_COOLANT_TEMP                  DataCoolantTemp                      
#define  DATA_HI_COOLANT_TEMP_WARNING       DataHiCollantTempWarning             

/*** ״̬ ***/
#define   DATA_COOLANT_TEMP_STATE_DELAY     0x00       //ϵʱ
#define   DATA_COOLANT_TEMP_STATE_INIT      0x01       //ʼ
#define   DATA_COOLANT_TEMP_STATE_FAST      0x02       //
#define   DATA_COOLANT_TEMP_STATE_NORMAL    0x03       //ģʽ
#define   DATA_COOLANT_TEMP_STATE_FAULT     0x04       //

/***  ***/
#define   DATA_COOLANT_TEMP_WAIT_SEC        3     //೤ʱһ
#define   DATA_COOLANT_TEMP_SEG_STEP_FAST   20    //߶ʱ,ÿһʱ,λms
#define   DATA_COOLANT_TEMP_SEG_STEP_SLOW   1500  //߶ʱ,ÿһʱ,λms 

#define   DATA_COOLANT_TEMP_SEG_PER_GROUP   1      
#define   DATA_COOLANT_TEMP_TOTAL_GROUP     8     
#define   DATA_COOLANT_TEMP_TOTAL_SEG       (DATA_COOLANT_TEMP_SEG_PER_GROUP * DATA_COOLANT_TEMP_TOTAL_GROUP)   
#define   DATA_HI_COOLANT_TEMP_SEG          7       

/*** ƽṹ ***/
typedef struct
{
  uint16_t  Backup;
  uint16_t  LostTimer;
  uint16_t  Last;
  uint8_t   InvalidCnt;
  uint8_t   DstSeg;
  uint8_t   State;
  uint8_t   Wait;
  uint8_t   Prescaler;
  uint8_t   FastMode;
  uint8_t   OutputEnable;
  uint8_t   DispTimer;
} DataCoolantTempCalcStruct;

typedef struct
{
  uint16_t  Up[DATA_COOLANT_TEMP_TOTAL_GROUP + 1];
  uint16_t  Dn[DATA_COOLANT_TEMP_TOTAL_GROUP + 1];
} DataCoolantTempTableStruct;

/*** ˮ± ***/                       
static const DataCoolantTempTableStruct DataCoolantTempTable14T =
{
  /*                                                   -------------------->                                */
  {           50,      59,      67,       75,       90,      98,      105,     111,    120},
  /* +--------+---------+---------+---------+---------+---------+---------+                                 */
  /* |  |         |    1    |    2    |    3    |    4    |    5    |                                 */
  /* +--------+---------+---------+---------+---------+---------+---------+                                 */
  {           50,      59,      67,       75,       90,      98,      105,     111,    120},
  /*                                                  <--------------------                                 */
};

/******************************************************************************
ADBLUE
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataCoolantADblueSegDisp;
extern uint16_t DataCoolantADblue;
extern uint8_t DataCollantADblueValid;
extern uint8_t DataHiCollantADblueWarning;

#define  DATA_COOLANT_ADBLUE_SEG_DISPLAYING   DataCoolantADblueSegDisp               
#define  DATA_COOLANT_ADBLUE_VALID            DataCollantADblueValid                 
#define  DATA_COOLANT_ADBLUE                  DataCoolantADblue                      
#define  DATA_HI_COOLANT_ADBLUE_WARNING       DataHiCollantADblueWarning             

/*** ״̬ ***/
#define   DATA_COOLANT_ADBLUE_STATE_DELAY     0x00     //ϵʱ
#define   DATA_COOLANT_ADBLUE_STATE_INIT      0x01     //ʼ
#define   DATA_COOLANT_ADBLUE_STATE_FAST      0x02     //
#define   DATA_COOLANT_ADBLUE_STATE_NORMAL    0x03     //ģʽ
#define   DATA_COOLANT_ADBLUE_STATE_FAULT     0x04     //

/***  ***/
#define   DATA_COOLANT_ADBLUE_WAIT_SEC        3     //೤ʱһ
#define   DATA_COOLANT_ADBLUE_SEG_STEP_FAST   20    //߶ʱ,ÿһʱ,λms
#define   DATA_COOLANT_ADBLUE_SEG_STEP_SLOW   1500  //߶ʱ,ÿһʱ,λms 

#define   DATA_COOLANT_ADBLUE_SEG_PER_GROUP   1        
#define   DATA_COOLANT_ADBLUE_TOTAL_GROUP     13       
#define   DATA_COOLANT_ADBLUE_TOTAL_SEG       (DATA_COOLANT_ADBLUE_SEG_PER_GROUP * DATA_COOLANT_ADBLUE_TOTAL_GROUP)   
#define   DATA_HI_COOLANT_ADBLUE_SEG          120         

/*** ƽṹ ***/
typedef struct
{
  uint16_t  Backup;
  uint16_t  LostTimer;
  uint16_t  Last;
  uint8_t   InvalidCnt;
  uint8_t   DstSeg;
  uint8_t   State;
  uint8_t   Wait;
  uint8_t   Prescaler;
  uint8_t   FastMode;
  uint8_t   OutputEnable;
  uint8_t   DispTimer;
} DataCoolantADblueCalcStruct;

typedef struct
{
  uint16_t  Up[DATA_COOLANT_ADBLUE_TOTAL_GROUP + 1];
  uint16_t  Dn[DATA_COOLANT_ADBLUE_TOTAL_GROUP + 1];
} DataCoolantADblueTableStruct;

/*** ˮ± ***/                       
static const DataCoolantADblueTableStruct DataCoolantADblueTable14T =
{
  /*                                                   -------------------->                                */
  {           50,      54,      58,      63,    68,      73,78,101,104,106,108,110,111,210},
  /* +--------+---------+---------+---------+---------+---------+---------+                                 */
  /* |  |         |    1    |    2    |    3    |    4    |    5    |                                 */
  /* +--------+---------+---------+---------+---------+---------+---------+                                 */
  {           50,      54,      58,      63,    68,      72,78,101,104,106,108,110,111,210},
  /*                                                  <--------------------                                 */
};
/******************************************************************************
ѹ
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataCoolantOilSegDisp;
extern uint16_t DataCoolantOil;
extern uint8_t DataCollantOilValid;
extern uint8_t DataHiCollantOilWarning;

#define  DATA_COOLANT_OIL_SEG_DISPLAYING   DataCoolantOilSegDisp               
#define  DATA_COOLANT_OIL_VALID            DataCollantOilValid                 
#define  DATA_COOLANT_OIL                  DataCoolantOil                      
#define  DATA_HI_COOLANT_OIL_WARNING       DataHiCollantOilWarning             

/*** ״̬ ***/
#define   DATA_COOLANT_OIL_STATE_DELAY     0x00       //ϵʱ
#define   DATA_COOLANT_OIL_STATE_INIT      0x01       //ʼ
#define   DATA_COOLANT_OIL_STATE_FAST      0x02       //
#define   DATA_COOLANT_OIL_STATE_NORMAL    0x03       //ģʽ
#define   DATA_COOLANT_OIL_STATE_FAULT     0x04       //

/***  ***/
#define   DATA_COOLANT_OIL_WAIT_SEC        3     //೤ʱһ
#define   DATA_COOLANT_OIL_SEG_STEP_FAST   20    //߶ʱ,ÿһʱ,λms
#define   DATA_COOLANT_OIL_SEG_STEP_SLOW   1500  //߶ʱ,ÿһʱ,λms 

//#define   DATA_COOLANT_OIL_SEG_PER_GROUP   1      
//#define   DATA_COOLANT_OIL_TOTAL_GROUP     8     
//#define   DATA_COOLANT_OIL_TOTAL_SEG       (DATA_COOLANT_OIL_SEG_PER_GROUP * DATA_COOLANT_OIL_TOTAL_GROUP)   
//#define   DATA_HI_COOLANT_OIL_SEG          7       

/*** ƽṹ ***/
typedef struct
{
  uint16_t  Backup;
  uint16_t  LostTimer;
  uint16_t  Last;
  uint8_t   InvalidCnt;
  uint8_t   DstSeg;
  uint8_t   State;
  uint8_t   Wait;
  uint8_t   Prescaler;
  uint8_t   FastMode;
  uint8_t   OutputEnable;
  uint8_t   DispTimer;
} DataCoolantOilCalcStruct;


/******************************************************************************
AirO
******************************************************************************/
/*** ȫֱ ***/
extern uint16_t DataCoolantAirOSegDisp;
extern uint32_t DataCoolantAirO;
extern uint8_t  DataCollantAirOValid;
extern uint8_t  DataHiCollantAirOWarning;
extern uint8_t  FrontPress;
extern uint8_t  RearPress;
#define  DATA_COOLANT_GAS1_SEG_DISPLAYING   DataCoolantAirOSegDisp            
#define  DATA_COOLANT_GAS1_VALID            DataCoolantAirO            
#define  DATA_COOLANT_GAS1                  DataCollantAirOValid            
#define  DATA_LOW_COOLANT_GAS1_WARNING      DataHiCollantAirOWarning  

/*** ״̬ ***/
#define   DATA_COOLANT_AirO_STATE_DELAY     0x00       //ϵʱ
#define   DATA_COOLANT_AirO_STATE_INIT      0x01       //ʼ
#define   DATA_COOLANT_AirO_STATE_FAST      0x02       //
#define   DATA_COOLANT_AirO_STATE_NORMAL    0x03       //ģʽ
#define   DATA_COOLANT_AirO_STATE_FAULT     0x04       //

/***  ***/
#define   DATA_COOLANT_AirO_WAIT_SEC        3     //೤ʱһ
#define   DATA_COOLANT_AirO_SEG_STEP_FAST   20    //߶ʱ,ÿһʱ,λms
#define   DATA_COOLANT_AirO_SEG_STEP_SLOW   1500  //߶ʱ,ÿһʱ,λms 

#define   DATA_COOLANT_AirO_SEG_PER_GROUP   10       //һСߵ΢ǽǶ*12 ƽص㣩
#define   DATA_COOLANT_AirO_TOTAL_GROUP     5         //ؼӦ̹߱ؼ
#define   DATA_COOLANT_AirO_TOTAL_SEG       (DATA_COOLANT_AirO_SEG_PER_GROUP * DATA_COOLANT_AirO_TOTAL_GROUP)   
#define   DATA_HI_COOLANT_AirO_SEG          1180         //

/******************************************************************************
AirT
******************************************************************************/
/*** ȫֱ ***/
extern uint16_t DataCoolantAirTSegDisp;
extern uint32_t DataCoolantAirT;
extern uint8_t  DataCollantAirTValid;
extern uint8_t  DataHiCollantAirTWarning;

#define  DATA_COOLANT_GAS2_SEG_DISPLAYING   DataCoolantAirTSegDisp         
#define  DATA_COOLANT_GAS2_VALID            DataCoolantAirT  
#define  DATA_COOLANT_GAS2                  DataCollantAirTValid       
#define  DATA_LOW_COOLANT_GAS2_WARNING      DataHiCollantAirTWarning

/*** ״̬ ***/
#define   DATA_COOLANT_AirT_STATE_DELAY     0x00       //ϵʱ
#define   DATA_COOLANT_AirT_STATE_INIT      0x01       //ʼ
#define   DATA_COOLANT_AirT_STATE_FAST      0x02       //
#define   DATA_COOLANT_AirT_STATE_NORMAL    0x03       //ģʽ
#define   DATA_COOLANT_AirT_STATE_FAULT     0x04       //

/***  ***/
#define   DATA_COOLANT_AirT_WAIT_SEC        3     //೤ʱһ
#define   DATA_COOLANT_AirT_SEG_STEP_FAST   20    //߶ʱ,ÿһʱ,λms
#define   DATA_COOLANT_AirT_SEG_STEP_SLOW   1500  //߶ʱ,ÿһʱ,λms 

#define   DATA_COOLANT_AirT_SEG_PER_GROUP   10       //һСߵ΢ǽǶ*12 ƽص㣩
#define   DATA_COOLANT_AirT_TOTAL_GROUP     5         //ؼӦ̹߱ؼ
#define   DATA_COOLANT_AirT_TOTAL_SEG       (DATA_COOLANT_AirT_SEG_PER_GROUP * DATA_COOLANT_AirT_TOTAL_GROUP)   
#define   DATA_HI_COOLANT_AirT_SEG          1180         //

/******************************************************************************
ȼ
******************************************************************************/

/*** ȫֱ ***/
extern uint8_t DataFuelSensorFault;
extern uint8_t DataFuelLevelLow;
extern uint8_t DataFuelLevelVolatile;
extern uint8_t DataFuelLevelSegDisp;
extern uint16_t DataFuelVolRemaining;
extern uint16_t DataFuelSensorRes;
extern uint16_t FuelConsumptionRate;
       
#define  DATA_FUEL_SENSOR_FAULT             DataFuelSensorFault
#define  DATA_FUEL_LEVEL_LOW                DataFuelLevelLow
#define  DATA_FUEL_LEVEL_VOLATILE           DataFuelLevelVolatile
#define  DATA_FUEL_LEVEL_SEG_DISPLAYING     DataFuelLevelSegDisp
#define  DATA_FUEL_VOLUME_REMAINING         DataFuelVolRemaining
#define  DATA_FUEL_SENSOR_RESISTANCE        DataFuelSensorRes

/*** ״̬ ***/
#define   DATA_FUEL_STATE_STOP              0x00
#define   DATA_FUEL_STATE_DELAY             0x01
#define   DATA_FUEL_STATE_INIT              0x02
#define   DATA_FUEL_STATE_FAST              0x03
#define   DATA_FUEL_STATE_MID               0x04
#define   DATA_FUEL_STATE_SLOW              0x05
#define   DATA_FUEL_STATE_WAIT              0x06
#define   DATA_FUEL_STATE_REINIT            0x07
#define   DATA_FUEL_STATE_FAULT             0x08

/***  ***/
#define   DATA_FUEL_LEVEL_WAIT_SEC          3
#define   DATA_IGN_ON_REFUEL_ENABLE         1
#define   DATA_ENGINE_RUNNING_REFUEL_ENABLE 1
//#define   DATA_COOL_SENSOR_RES_MIN          100     //ˮ¶·
//#define   DATA_COOL_SENSOR_RES_MAX          3500    //ˮ¿·
#define   DATA_FUEL_SENSOR_RES_MIN          30
#define   DATA_FUEL_SENSOR_RES_MAX          1900
#define   DATA_FUEL_SENSOR_FAULT_DET_TIME   20000      //ʧЧʱ(δʧЧ -> ʧЧ),λms
#define   DATA_FUEL_SENSOR_FAULT_RECOV_TIME 20000      //ʧЧָʱ(ʧЧ -> δʧЧ),λms
//#define   DATA_COOL_SENSOR_FAULT_RECOV_TIME 20000      //ˮ´ʧЧָʱ(ʧЧ -> δʧЧ),λms
#define   DATA_REFUEL_THRESHOLD             60         //ֵ (x0.1L)
#define   DATA_DEFUEL_THRESHOLD             120        //ֵ (x0.1L)
#define   DATA_FUEL_TANK_CAPACITY           600        // (x0.1L)

#define   DATA_FUEL_SAMPLE_CYCLE_FAST       1500       //ٲ,λms
#define   DATA_FUEL_SAMPLE_CYCLE_MID        2500       //ٲ,λms
#define   DATA_FUEL_SAMPLE_CYCLE_SLOW       120000     //ٲ,λms

#define   DATA_FUEL_SAMPLE_POINT_MIN_FAST   12         //ٲʱ,С
#define   DATA_FUEL_SAMPLE_POINT_MIN_MID    20         //ٲʱ,С
#define   DATA_FUEL_SAMPLE_POINT_MIN_SLOW   1000       //ٲʱ,С

#define   DATA_FUEL_DAMPING_FACTOR_RES      0.000003   //ֵϵ

#define   DATA_FUEL_LEVEL_SEG_STEP          20         //ÿһʱ,λms 
#define   DATA_FUEL_LEVEL_SEG_STEP_FORCE    800        //ʱһÿһǿƼʱ,λms

#define   DATA_FUEL_RES_VOL_TABLE_COL       (sizeof(DataFuelResVolTable) / sizeof(DataFuelResVsVolStruct))
//#define   DATA_Cool_RES_VOL_TABLE_COL       (sizeof(DataCoolResVolTable) / sizeof(DataCoolResVsVolStruct))
#define   DATA_FUEL_LEVEL_SEG_PER_GROUP     1
//#define   DATA_COOL_LEVEL_SEG_PER_GROUP     1
#define   DATA_FUEL_LEVEL_TOTAL_GROUP       8
//#define   DATA_COOL_LEVEL_TOTAL_GROUP       8
#define   DATA_FUEL_LEVEL_TOTAL_SEG         (DATA_FUEL_LEVEL_SEG_PER_GROUP * DATA_FUEL_LEVEL_TOTAL_GROUP)
//#define   DATA_COOL_LEVEL_TOTAL_SEG         (DATA_COOL_LEVEL_SEG_PER_GROUP * DATA_COOL_LEVEL_TOTAL_GROUP)
#define   DATA_LOW_FUEL_SEG                 1

/*** ƽṹ ***/
typedef struct
{
  uint8_t   Init;
  uint8_t   State;
  uint8_t   Timer;
  uint8_t   Prescaler;
  uint8_t   Wait;
  uint8_t   VehicleRunning;
  uint8_t   EngineRunning;
  uint8_t   OutputEnable;
  uint8_t   LowFuelEnable;
  uint8_t   BackupValid;
  uint8_t   SegBackup;
  uint16_t  VolRef;
  uint16_t  VolBackup;
  uint16_t  ResBackup;
} DataFuelLevelStateStruct;

typedef struct
{
  uint8_t   Enable;
  uint8_t   Cnt;
  uint8_t   Valid;
  uint16_t  Timer;
  uint16_t  Buffer[5];
  uint16_t  Res;
} DataFuelSensorSamplerStruct;

typedef struct
{
  uint8_t   Enable;
  uint8_t   Update;
  uint8_t   Valid;
  uint16_t  Timer;
  uint16_t  SampleCycle;
  uint16_t  Cnt;
  uint16_t  SamplePointMin;
  uint32_t  Sum;
  uint16_t  Res;
  uint16_t  Vol;
} DataFuelSensorResCalcStruct;

typedef struct
{
  uint8_t   Enable;
  uint8_t   RefuelEnable;
  uint8_t   Busy;
  uint8_t   SlowMode;
  uint16_t  ResInput;
  uint16_t  Timer;
  uint16_t  Res;
  uint16_t  Vol;
  float     DampingRes;
} DataFuelSensorResDampingStruct;

typedef struct
{
  uint8_t   FastMode;
  uint8_t   DstSeg;
  uint16_t  ResDisp;
  uint16_t  Timer;
} DataFuelLevelDisplayStruct;

typedef struct
{
  uint16_t Res;
  uint16_t Vol;
} DataFuelResVsVolStruct;
typedef struct
{
  uint16_t Res;
  uint16_t Vol;
} DataCoolResVsVolStruct;

typedef struct
{
  uint16_t  Up[DATA_FUEL_LEVEL_TOTAL_GROUP + 1];
  uint16_t  Dn[DATA_FUEL_LEVEL_TOTAL_GROUP + 1];
} DataFuelLevelTableStruct;

/*** ֵ/ȼӦ ***/
static const DataFuelResVsVolStruct DataFuelResVolTable[] =
{
  /*=================================
     Res(x0.1 Ohm) |  Vol(x0.1 L)
  ---------------------------------*/
  {             30,            500,},
  {             80,            420,},
  {             70,            380,},
  {             50,            330,},
  {             130,           270,},
  {             910,           210,},
  {            1140,           150,},
  {            1350,           100,},
  {            2000,            50,},
  {            2830,            30,},
  /*===============================*/
};

/*** ȼ ***/
static const DataFuelLevelTableStruct DataFuelLevelTable =
{
  /*                                                  -------------------->                                 */
  {                   1110,     1050,      1000,      400,     350,      300,      200,      100,      50, },
  /* +--------+---------+---------+---------+---------+---------+---------+---------+---------+---------+   */
  /* |  |         |    1    |    2    |    3    |    4    |    5    |    6    |    7    |    8    |   */
  /* +--------+---------+---------+---------+---------+---------+---------+---------+---------+---------+   */
  {                   1000,     980,       900,       350,     300,      250,      170,      80,       30, },
  /*                                                  <--------------------                                 */
};

/******************************************************************************
ϵʱ
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataIGNOffTimerSec;

#define  DATA_IGN_OFF_TIMER_SEC             DataIGNOffTimerSec

/*** ƽṹ ***/
typedef struct
{
  uint8_t   IGNStatus;
  uint16_t  RoCBackup;
} DataIGNOffTimingStruct;

/******************************************************************************
¶ʾ
******************************************************************************/

/*** ȫֱ ***/
extern uint8_t  DataAmbientTempDispMode;
extern uint8_t  DataAmbientTemp;
extern uint8_t  DataAmbientTempUnit;

#define  DATA_AMBIENT_TEMP_DISP_MODE        DataAmbientTempDispMode
#define  DATA_AMBIENT_TEMP                  DataAmbientTemp
#define  DATA_AMBIENT_TEMP_UNIT             DataAmbientTempUnit

extern uint8_t  DataoilTempDispMode;
extern uint8_t  DataoiltTemp;
extern uint8_t  DataoilTempUnit;

#define  DATA_oil_TEMP_DISP_MODE        DataoilTempDispMode
#define  DATA_oil_TEMP                  DataoiltTemp
#define  DATA_oil_TEMP_UNIT             DataoilTempUnit

/******************************************************************************
̹
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataMileageRollingCounter;

#define  DATA_MILEAGE_ROLLING_COUNTER       DataMileageRollingCounter     //̹,λm

/*** ƽṹ ***/
typedef struct
{
  uint16_t  mmRollingCounter;
  uint16_t  mmRoCBackup;
} DataMileageCalcStruct;

/******************************************************************************
ܼ
******************************************************************************/

/*** ȫֱ ***/
extern uint8_t  DataODOValid;

#define  DATA_ODO_VALID                     DataODOValid

/*** ƽṹ ***/
typedef struct
{
  uint8_t  UpdateDisable;
  uint16_t RoCBackup;
  uint32_t LastSaved;
} DataODOStruct;

/******************************************************************************
С
******************************************************************************/

/*** ȫֱ ***/
extern uint16_t DataTrip;
extern uint16_t   DataTripA;
extern uint16_t   DataTripB;
extern uint8_t  DataTripUnit;
extern uint8_t  DataTripValid;

//extern uint16_t DataTripAFuelAve;
extern uint16_t DataTripASeatbelt;

#define  DATA_TRIP                          DataTrip
#define  DATA_TRIPA                          DataTripA
#define  DATA_TRIPB                          DataTripB
#define  DATA_TRIP_UNIT                     DataTripUnit
#define  DATA_TRIP_VALID                    DataTripValid

/*** ƽṹ ***/
typedef struct
{
  uint16_t  MileageA100m;
  uint16_t  MileageB100m;
  uint16_t  RoCBackup;
} DataTripStruct;

/******************************************************************************
ʻʱ
******************************************************************************/

/*** ȫֱ ***/
extern uint8_t DataDrivingTimeHour;
extern uint8_t DataDrivingTimeMin;

#define  DATA_DRIVING_TIME_HOUR             DataDrivingTimeHour
#define  DATA_DRIVING_TIME_MIN              DataDrivingTimeMin

/*** ƽṹ ***/
typedef struct
{
  uint8_t   Init;
  uint8_t   Start;
  uint16_t  RoCBackup;
  uint16_t  Timer;
} DataDrivingTimeStruct;

/******************************************************************************
ƽ
******************************************************************************/

/*** ȫֱ ***/
extern uint8_t DataAvgSpeed;
extern uint8_t DataAvgSpeedValid;
extern uint16_t  DataDTE;
#define  DATA_AVG_SPEED                     DataAvgSpeed
#define  DATA_AVG_SPEED_VALID               DataAvgSpeedValid

/***  ***/
#define  DATA_AVG_SPEED_TOTAL_KM            50

/*** ƽṹ ***/
typedef struct
{
  uint16_t  MileageRoCBackup;
  uint16_t  TimeRoCBackup;
  uint16_t  Mileage[DATA_AVG_SPEED_TOTAL_KM];
  uint16_t  Time[DATA_AVG_SPEED_TOTAL_KM];
  uint16_t  MileageSample;
  uint16_t  TimeSample;
  uint8_t   Ptr;
  uint8_t   Cnt;
  uint8_t   UpdateTimer;
  uint8_t   Running;
} DataAvgSpeedStruct;


/****************************תٲݴ*********************************/
/******************************************************************************
ȫֱ
******************************************************************************/
//extern volatile uint8_t ESPWMDutyCycle;
//#define   ES_PWM_DUTY_CYCLE                 TimerCycle

/******************************************************************************

******************************************************************************/
#define   ES_PWM_DUTY_CYCLE_FILTER          5    //յռձȲڴֵΪЧռձ
#define   ES_PWM_FILTER_MAX_CNT             10   //ֹմ
#define   ES_SAMPLE_POINT                   10   //10
#define   ES_PWM_DUTY_CYCLE_MAX             7000
#define   ES_PWM_DUTY_CYCLE_MIN             7
#define   ES_PWM_DUTY_CYCLE_HYSTERESIS      5    //ز
#define   ES_PWM_DUTY_CYCLE_APPR_FACTOR     8    //ռձȱƽϵ 
#define   ES_PWM_DUTY_CYCLE_APPR_SPEED      20   //ռձȱƽ,λms  

#define   ES_OFF_TIME_DOOR_OPEN_ONLY        150


/******************************************************************************
ṹ
******************************************************************************/
typedef struct
{
  uint8_t   Backup;
  uint16_t  Timer;
  uint16_t  HiLvTimer;
} ESPWMCaptureStruct;

typedef struct
{
  uint16_t   InitTimer;
  uint8_t    Backup;
  uint8_t    BackupCnt;
  uint16_t   Sample[ES_SAMPLE_POINT];
  uint16_t   Ptr;
  uint16_t   Cnt;
  uint8_t    Locked;
  uint16_t   Timer;
  uint16_t   Current;
} ESPWMFilterStruct;

/******************************************************************************

******************************************************************************/

void Data_Power_On_Init(void);
void Data_IGN_On_Init(void);
void Data_Tpms_Proceser(void);

void Data_Engine_Speed_Processing_Service(void);
void Data_Vehicle_Speed_Processing_Service(void);
void Data_AirO_Level_Processing_Service(void);
void Data_AirT_Level_Processing_Service(void);
void Data_Coolant_Temp_Processing_Service(void);
void Data_Coolant_ADblue_Processing_Service(void);
void Data_Coolant_Oil_Processing_Service(void);
void Data_Drive_Info_Group1_Processing_Service(void);
void Data_Drive_Info_Group2_Processing_Service(void);
void Data_IGN_Off_Timing_Service(void);
void Data_ODO_Processing(void);
void Data_Trip_Processing(void);
void Data_Fuel_Consumption_Processing(void);
uint8_t Data_Get_Average_Fuel_Consumption(void);
void Data_Average_Fuel_Consumption_Reset(void);
void Data_DTE_Processing(void);
void Data_DTE_Init(void);
void Data_TPMS_Value_Processing(void);
void Data_Mileage_Rolling_Counter_Update_ISR(void);
void Data_Clear_TripA(void);
void Data_Clear_TripB(void);
void Data_ODO_Update_Disable(void);
#endif