


#include "System_Status_Monitor.h"

#pragma MESSAGE DISABLE C4000
#pragma MESSAGE DISABLE C4001

volatile uint8_t        SysPowerStatus;
volatile uint8_t        SysOperatingStatus;

uint8_t                 SysStatUpdateMode;

SysPwrModeStruct        SysPwrMode;
SysSignalStatusStruct   SysKL15Signal;

/******************************************************************************
Sys_Status_Init
  ܣϵͳ״̬ʼ
        ״ϵʱʼһ
  
ֵ
******************************************************************************/
void Sys_Status_Init(void)
{
  SysStatUpdateMode      = 0xFF;

  SysPowerStatus         = 0x00;
  SysOperatingStatus     = 0x00;

  SysPwrMode.Mode        = SYS_PWR_NORMAL_MODE;
  SysPwrMode.LVPTimer    = 0;
  SysPwrMode.LimitTimer  = 0;
  SysPwrMode.NormalTimer = 0;
  SysPwrMode.OVPTimer    = 0;

  SysKL15Signal.Status   = SYS_SIG_STAT_INACTIVE;
  SysKL15Signal.Timer    = 0;
}

/******************************************************************************
Sys_Status_Update_Mode_Set
  ܣϵͳ״̬ģʽ
  Modeģʽ SYS_STAT_UPDATE_MODE_NORMAL   - ģʽ
                       SYS_STAT_UPDATE_MODE_WAKEUP   - ߺѸģʽ
                       SYS_STAT_UPDATE_MODE_RECOVERY - ѹ쳣ָģʽ
                       SYS_STAT_UPDATE_MODE_INIT     - ʼģʽ
ֵ
******************************************************************************/
void Sys_Status_Update_Mode_Set(uint8_t Mode)
{
  if (Mode != SysStatUpdateMode)              //ģʽ仯ʱ,жʱ
  {
    SysPwrMode.LVPTimer    = 0;
    SysPwrMode.LimitTimer  = 0;
    SysPwrMode.NormalTimer = 0;
    SysPwrMode.OVPTimer    = 0;

    SysKL15Signal.Timer    = 0;

    SysStatUpdateMode      = Mode;
  }
}

/******************************************************************************
Sys_Status_Update_Service
  ܣϵͳ״̬·
  
ֵ
*******************************************************************************
ע  ⣺÷ڲͬĹģʽҪղͬڵ
        SYS_STAT_UPDATE_MODE_NORMAL   ģʽ,ÿ  20ms һ
        SYS_STAT_UPDATE_MODE_WAKEUP   ģʽ,ϸҪʱ
        SYS_STAT_UPDATE_MODE_RECOVERY ģʽ,ÿ 100ms һ
        SYS_STAT_UPDATE_MODE_INIT     ģʽ,ڳʼ׶εһ
******************************************************************************/
void Sys_Status_Update_Service(void)
{
  uint8_t   i;
  uint8_t   LVPCnt;
  uint8_t   LimitCnt;
  uint8_t   NormalCnt;
  uint8_t   OVPCnt;
  uint16_t  Voltage;
  uint16_t  RocBackup;
  uint16_t  Counter;
  uint8_t   OpStatus;

  if (SysStatUpdateMode == SYS_STAT_UPDATE_MODE_NORMAL)         //ģʽ
  {
    //if ( (ANALOG_KL15_VOLTAGE_VALID == 0))
    //  return;                                                   //ڵԴѹЧ²Ž״̬

    //ģʽ,ȻȡԴ״̬
    //Voltage = 0;                                                //ȡԴѹ
    //Voltage = ANALOG_KL15_VOLTAGE;
    if ((ANALOG_KL30_VOLTAGE_VALID == 0) || (ANALOG_KL15_VOLTAGE_VALID == 0))
      return;                                                   //ڵԴѹЧ²Ž״̬
    
    //ģʽ,ȻȡԴ״̬
    Voltage = 0;                                                //ȡԴѹ
    
#if SYS_POWERED_BY_KL30_ONLY
      Voltage = ANALOG_KL30_VOLTAGE;
#else
   if (ANALOG_KL15_VOLTAGE > ANALOG_KL30_VOLTAGE)
      Voltage = ANALOG_KL15_VOLTAGE;
   else
      Voltage = ANALOG_KL30_VOLTAGE;
#endif
    
    switch (SysPwrMode.Mode)                                    //Դ״̬ת
    {
    case SYS_PWR_LVP_MODE     :
    if(NVM_CONFIG_POWER==1)
    {
        if (Voltage >= 32000)           //ѹֵ
        {
          SysPwrMode.LimitTimer++;
          SysPwrMode.NormalTimer++;
          SysPwrMode.OVPTimer++;
        }
        else if (Voltage >= 18000)     //
        {
          SysPwrMode.LimitTimer++;
          SysPwrMode.NormalTimer++;
          SysPwrMode.OVPTimer = 0;
        }
        else if (Voltage >= 16000)       //˳ѹֵ
        {
          SysPwrMode.LimitTimer++;
          SysPwrMode.NormalTimer = 0;
          SysPwrMode.OVPTimer    = 0;
        }
        else
        {
          SysPwrMode.LimitTimer  = 0;
          SysPwrMode.NormalTimer = 0;
          SysPwrMode.OVPTimer    = 0;
        }
      }
      else
       {
          if (Voltage >= 18000)           //ѹֵ
          {
            SysPwrMode.LimitTimer++;
            SysPwrMode.NormalTimer++;
            SysPwrMode.OVPTimer++;
          }
          else if (Voltage >= 9500)     //
          {
            SysPwrMode.LimitTimer++;
            SysPwrMode.NormalTimer++;
            SysPwrMode.OVPTimer = 0;
          }
          else if (Voltage >= 7000)       //˳ѹֵ
          {
            SysPwrMode.LimitTimer++;
            SysPwrMode.NormalTimer = 0;
            SysPwrMode.OVPTimer    = 0;
          }
          else
          {
            SysPwrMode.LimitTimer  = 0;
            SysPwrMode.NormalTimer = 0;
            SysPwrMode.OVPTimer    = 0;
          }
      }
      if (SysPwrMode.OVPTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_OVP_MODE;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else if (SysPwrMode.NormalTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else if (SysPwrMode.LimitTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_LIMIT_MODE;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      break;

    case SYS_PWR_LIMIT_MODE   :
    if(NVM_CONFIG_POWER==1)
    {
        if (Voltage >= 32000)
        {
          SysPwrMode.LVPTimer = 0;
          SysPwrMode.NormalTimer++;
          SysPwrMode.OVPTimer++;
        }
        else if (Voltage >= 18000)
        {
          SysPwrMode.LVPTimer = 0;
          SysPwrMode.NormalTimer++;
          SysPwrMode.OVPTimer = 0;
        }
        else if (Voltage < 15500)           //ѹֵ 
        {
          SysPwrMode.LVPTimer++;
          SysPwrMode.NormalTimer = 0;
          SysPwrMode.OVPTimer    = 0;
        }
        else
        {
          SysPwrMode.LVPTimer    = 0;
          SysPwrMode.NormalTimer = 0;
          SysPwrMode.OVPTimer    = 0;
        }
      }
      else
       {
          if (Voltage >= 18000)
          {
            SysPwrMode.LVPTimer = 0;
            SysPwrMode.NormalTimer++;
            SysPwrMode.OVPTimer++;
          }
          else if (Voltage >= 9500)
          {
            SysPwrMode.LVPTimer = 0;
            SysPwrMode.NormalTimer++;
            SysPwrMode.OVPTimer = 0;
          }
          else if (Voltage < 6500)           //ѹֵ 
          {
            SysPwrMode.LVPTimer++;
            SysPwrMode.NormalTimer = 0;
            SysPwrMode.OVPTimer    = 0;
          }
          else
          {
            SysPwrMode.LVPTimer    = 0;
            SysPwrMode.NormalTimer = 0;
            SysPwrMode.OVPTimer    = 0;
          }
      }
      if (SysPwrMode.OVPTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_OVP_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else if (SysPwrMode.NormalTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else if (SysPwrMode.LVPTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_LVP_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      break;

    case SYS_PWR_NORMAL_MODE  :
      if(NVM_CONFIG_POWER==1)
     {
        if (Voltage < 15500)
        {
          SysPwrMode.LVPTimer++;
          SysPwrMode.LimitTimer++;
          SysPwrMode.OVPTimer = 0;
        }
        else if (Voltage < 17000)
        {
          SysPwrMode.LVPTimer = 0;
          SysPwrMode.LimitTimer++;
          SysPwrMode.OVPTimer = 0;
        }
        else if (Voltage >= 32000)
        {
          SysPwrMode.LVPTimer   = 0;
          SysPwrMode.LimitTimer = 0;
          SysPwrMode.OVPTimer++;
        }
        else
        {
          SysPwrMode.LVPTimer   = 0;
          SysPwrMode.LimitTimer = 0;
          SysPwrMode.OVPTimer   = 0;
        }
      }
      else
       {
          if (Voltage < 6500)
          {
            SysPwrMode.LVPTimer++;
            SysPwrMode.LimitTimer++;
            SysPwrMode.OVPTimer = 0;
          }
          else if (Voltage < 9000)
          {
            SysPwrMode.LVPTimer = 0;
            SysPwrMode.LimitTimer++;
            SysPwrMode.OVPTimer = 0;
          }
          else if (Voltage >= 18000)
          {
            SysPwrMode.LVPTimer   = 0;
            SysPwrMode.LimitTimer = 0;
            SysPwrMode.OVPTimer++;
          }
          else
          {
            SysPwrMode.LVPTimer   = 0;
            SysPwrMode.LimitTimer = 0;
            SysPwrMode.OVPTimer   = 0;
          }
      }
      if (SysPwrMode.LVPTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_LVP_MODE;
        SysPwrMode.LVPTimer   = 0;
        SysPwrMode.LimitTimer = 0;
        SysPwrMode.OVPTimer   = 0;
      }
      else if (SysPwrMode.LimitTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_LIMIT_MODE;
        SysPwrMode.LVPTimer   = 0;
        SysPwrMode.LimitTimer = 0;
        SysPwrMode.OVPTimer   = 0;
      }
      else if (SysPwrMode.OVPTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_OVP_MODE;
        SysPwrMode.LVPTimer   = 0;
        SysPwrMode.LimitTimer = 0;
        SysPwrMode.OVPTimer   = 0;
      }
      break;

    case SYS_PWR_OVP_MODE     :
      if(NVM_CONFIG_POWER==1)
     {
          if (Voltage < 15500)
          {
            SysPwrMode.LVPTimer++;
            SysPwrMode.LimitTimer++;
            SysPwrMode.NormalTimer++;
          }
          else if (Voltage < 17000)
          {
            SysPwrMode.LVPTimer = 0;
            SysPwrMode.LimitTimer++;
            SysPwrMode.NormalTimer++;
          }
          else if (Voltage < 32200)
          {
            SysPwrMode.LVPTimer   = 0;
            SysPwrMode.LimitTimer = 0;
            SysPwrMode.NormalTimer++;
          }
          else
          {
            SysPwrMode.LVPTimer    = 0;
            SysPwrMode.LimitTimer  = 0;
            SysPwrMode.NormalTimer = 0;
          }
      }
      else
     {
      if (Voltage < 6500)
      {
        SysPwrMode.LVPTimer++;
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
      }
      else if (Voltage < 9000)
      {
        SysPwrMode.LVPTimer = 0;
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
      }
      else if (Voltage < 18200)
      {
        SysPwrMode.LVPTimer   = 0;
        SysPwrMode.LimitTimer = 0;
        SysPwrMode.NormalTimer++;
      }
      else
      {
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      }      
      if (SysPwrMode.LVPTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_LVP_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      else if (SysPwrMode.LimitTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_LIMIT_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      else if (SysPwrMode.NormalTimer >= SYS_PWR_DEBOUNCE_TIME / 20)
      {
        SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      break;

    default :
      SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
      SysPwrMode.LVPTimer    = 0;
      SysPwrMode.LimitTimer  = 0;
      SysPwrMode.NormalTimer = 0;
      SysPwrMode.OVPTimer    = 0;
      break;
    }

    if (SysPwrMode.Mode == SYS_PWR_LVP_MODE)                             //µԴ־
      SysPowerStatus = SYS_PWR_STATUS_BIT_LVP;                /////////////ѹģʽû
    else if (SysPwrMode.Mode == SYS_PWR_LIMIT_MODE)           /////////////ѹģʽû
      SysPowerStatus = SYS_PWR_STATUS_BIT_LIM;                /////////////ѹģʽû
    else if (SysPwrMode.Mode == SYS_PWR_OVP_MODE)             /////////////ѹģʽû
     SysPowerStatus = SYS_PWR_STATUS_BIT_OVP;                /////////////ѹģʽû
    else 
     SysPowerStatus = SYS_PWR_STATUS_BIT_RUN;


    //ϵͳ״̬
#if SYS_RUNNING_IN_LIMIT_MODE

    if (SYS_PWR_STAT_UNPROTECT)

#else
    if (SYS_PWR_STAT_NORMAL)
#endif
    {
	  OpStatus = SYS_OPR_STATUS_BIT_OFF;
      //SysOperatingStatus = SYS_OPR_STATUS_BIT_OFF;

      //ACC״̬
#if SYS_ACC_MODE_DET_ENABLE
      if (Sys_ACC_Status_Detect())
        OpStatus = SYS_OPR_STATUS_BIT_ACC;
		//SysOperatingStatus = SYS_OPR_STATUS_BIT_ACC;
#endif

      //IGN״̬
      if (SysKL15Signal.Status == SYS_SIG_STAT_ACTIVE)
      {
        if (ANALOG_KL15_VOLTAGE < SYS_OFF_THRESHOLD)
        {
          SysKL15Signal.Timer++;
          if (SysKL15Signal.Timer >= SYS_OPR_DEBOUNCE_TIME / 20)
          {
            SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
            SysKL15Signal.Timer  = 0;
          }
        }
        else
          SysKL15Signal.Timer = 0;
      }
      else
      {
        if (ANALOG_KL15_VOLTAGE >= SYS_ON_THRESHOLD)
        {
          SysKL15Signal.Timer++;
          if (SysKL15Signal.Timer >= SYS_OPR_DEBOUNCE_TIME / 20)
          {
            SysKL15Signal.Status = SYS_SIG_STAT_ACTIVE;
            SysKL15Signal.Timer  = 0;
          }
        }
        else
          SysKL15Signal.Timer  = 0;
      }

      if (SysKL15Signal.Status)
 		OpStatus = SYS_OPR_STATUS_BIT_IGN;
        //SysOperatingStatus = SYS_OPR_STATUS_BIT_IGN;

      //START״̬
#if SYS_CRANK_MODE_DET_ENABLE
      if (Sys_Crank_Status_Detect())
	  	OpStatus = SYS_OPR_STATUS_BIT_CRK;
        //SysOperatingStatus = SYS_OPR_STATUS_BIT_CRK;
#endif
	SysOperatingStatus = OpStatus;
    }
    else
      SysOperatingStatus = SYS_OPR_STATUS_BIT_ERR;
  }
  else if (SysStatUpdateMode == SYS_STAT_UPDATE_MODE_WAKEUP)    //Ѹģʽ
  {
    //IGNԴ5μ,5ξֵΪIGN ON
    for (i = 0; i < 5; i++)
    {
      Analog_KL15_Voltage_Conversion();
      if (ANALOG_KL15_VOLTAGE < SYS_ON_THRESHOLD)
        return;
    }

    //ĬϵԴΪ״̬,ѺʼԴ״̬
    LVPCnt    = 0;
    LimitCnt  = 0;
    NormalCnt = 0;
    OVPCnt    = 0;

    for (;;)
    {
      Voltage = 0;

#if SYS_POWERED_BY_KL30_ONLY
      Analog_KL30_Voltage_Conversion();
      Voltage = ANALOG_KL30_VOLTAGE;  
#else
      Analog_KL30_Voltage_Conversion();
      Analog_KL15_Voltage_Conversion();
   if (ANALOG_KL15_VOLTAGE > ANALOG_KL30_VOLTAGE)
      Voltage = ANALOG_KL15_VOLTAGE;
   else
      Voltage = ANALOG_KL30_VOLTAGE;
#endif
     if(NVM_CONFIG_POWER==1)
     {  
      if (Voltage < 15500)
      {
        LVPCnt++;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage < 17000)
      {
        LVPCnt    = 0;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage >= 32000)
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt = 0;
        OVPCnt++;
      }
      else
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt++;
        OVPCnt    = 0;
      }
      }
      else
      {  
      if (Voltage < 6500)
      {
        LVPCnt++;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage < 9000)
      {
        LVPCnt    = 0;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage >= 18000)
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt = 0;
        OVPCnt++;
      }
      else
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt++;
        OVPCnt    = 0;
      }
      }
      
      if (LVPCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_LVP_MODE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_LVP;
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
        return;
      }

      if (LimitCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_LIMIT_MODE;
        SysKL15Signal.Status = SYS_SIG_STAT_ACTIVE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_LIM;
#if SYS_RUNNING_IN_LIMIT_MODE
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_IGN;
#else
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
#endif
        return;
      }

      if (NormalCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_NORMAL_MODE;
        SysKL15Signal.Status = SYS_SIG_STAT_ACTIVE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_RUN;
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_IGN;
        return;
      }

      if (OVPCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_OVP_MODE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_OVP;
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
        return;
      }
    }
  }
  else if (SysStatUpdateMode == SYS_STAT_UPDATE_MODE_RECOVERY)  //쳣ָģʽ
  {
    Voltage = 0;

#if SYS_POWERED_BY_KL30_ONLY
      Analog_KL30_Voltage_Conversion();
      Voltage = ANALOG_KL30_VOLTAGE;  
#else
      Analog_KL30_Voltage_Conversion();
      Analog_KL15_Voltage_Conversion();
   if (ANALOG_KL15_VOLTAGE > ANALOG_KL30_VOLTAGE)
      Voltage = ANALOG_KL15_VOLTAGE;
   else
      Voltage = ANALOG_KL30_VOLTAGE;
#endif

    //쳣ָģʽֻԵԴ״̬м
    if (SysPwrMode.Mode == SYS_PWR_LVP_MODE)
    {
      if(NVM_CONFIG_POWER==1)
     {  
      if (Voltage >= 32000)
      {
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
        SysPwrMode.OVPTimer++;
      }
      else if (Voltage >= 18000)
      {
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
        SysPwrMode.OVPTimer = 0;
      }
      else if (Voltage >= 16000)
      {
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else
      {
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      }
      else
           {  
      if (Voltage >= 18000)
      {
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
        SysPwrMode.OVPTimer++;
      }
      else if (Voltage >= 9500)
      {
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
        SysPwrMode.OVPTimer = 0;
      }
      else if (Voltage >= 7000)
      {
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else
      {
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      }
      if (SysPwrMode.OVPTimer >= SYS_PWR_DEBOUNCE_TIME / 100)
      {
        SysPwrMode.Mode = SYS_PWR_OVP_MODE;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else if (SysPwrMode.NormalTimer >= SYS_PWR_DEBOUNCE_TIME / 100)
      {
        SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
      else if (SysPwrMode.LimitTimer >= SYS_PWR_DEBOUNCE_TIME / 100)
      {
        SysPwrMode.Mode = SYS_PWR_LIMIT_MODE;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
        SysPwrMode.OVPTimer    = 0;
      }
    }
    else if (SysPwrMode.Mode == SYS_PWR_OVP_MODE)
    {
      if(NVM_CONFIG_POWER==1)
     {    
      if (Voltage < 15500)
      {
        SysPwrMode.LVPTimer++;
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
      }
      else if (Voltage < 17000)
      {
        SysPwrMode.LVPTimer = 0;
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
      }
      else if (Voltage < 32200)
      {
        SysPwrMode.LVPTimer   = 0;
        SysPwrMode.LimitTimer = 0;
        SysPwrMode.NormalTimer++;
      }
      else
      {
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      }
      else
     {    
      if (Voltage < 6500)
      {
        SysPwrMode.LVPTimer++;
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
      }
      else if (Voltage < 9000)
      {
        SysPwrMode.LVPTimer = 0;
        SysPwrMode.LimitTimer++;
        SysPwrMode.NormalTimer++;
      }
      else if (Voltage < 18200)
      {
        SysPwrMode.LVPTimer   = 0;
        SysPwrMode.LimitTimer = 0;
        SysPwrMode.NormalTimer++;
      }
      else
      {
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      }      
      if (SysPwrMode.LVPTimer >= SYS_PWR_DEBOUNCE_TIME / 100)
      {
        SysPwrMode.Mode = SYS_PWR_LVP_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      else if (SysPwrMode.LimitTimer >= SYS_PWR_DEBOUNCE_TIME / 100)
      {
        SysPwrMode.Mode = SYS_PWR_LIMIT_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
      else if (SysPwrMode.NormalTimer >= SYS_PWR_DEBOUNCE_TIME / 100)
      {
        SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
        SysPwrMode.LVPTimer    = 0;
        SysPwrMode.LimitTimer  = 0;
        SysPwrMode.NormalTimer = 0;
      }
    }

    if (SysPwrMode.Mode == SYS_PWR_LVP_MODE)                    //µԴ־
      SysPowerStatus       = SYS_PWR_STATUS_BIT_LVP;
    else if (SysPwrMode.Mode == SYS_PWR_LIMIT_MODE)
    {
      SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
      SysPowerStatus       = SYS_PWR_STATUS_BIT_LIM;
#if SYS_RUNNING_IN_LIMIT_MODE
      SysOperatingStatus   = SYS_OPR_STATUS_BIT_OFF;
#else
      SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
#endif
    }
    else if (SysPwrMode.Mode == SYS_PWR_OVP_MODE)
      SysPowerStatus       = SYS_PWR_STATUS_BIT_OVP;
    else
    {
      SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
      SysPowerStatus       = SYS_PWR_STATUS_BIT_RUN;
      SysOperatingStatus   = SYS_OPR_STATUS_BIT_OFF;
    }
  }
  else                                                          //ʼģʽ
  {

    //ϵʱ250ms,ȴԴѹȶ
    RocBackup = API_ROLLING_COUNTER;
    do
    {
      Counter  = API_ROLLING_COUNTER;
      Counter -= RocBackup;
    }
    while (Counter < (250000 / API_INT_CYCLE));

    //ĬϵԴΪ״̬,ʼԴ״̬
    LVPCnt    = 0;
    LimitCnt  = 0;
    NormalCnt = 0;
    OVPCnt    = 0;

    for (;;)
    {
      Voltage = 0;
      
#if SYS_POWERED_BY_KL30_ONLY
      Analog_KL30_Voltage_Conversion();
      Voltage = ANALOG_KL30_VOLTAGE;
#else
      Analog_KL15_Voltage_Conversion();
      Analog_KL30_Voltage_Conversion();
if (ANALOG_KL15_VOLTAGE > ANALOG_KL30_VOLTAGE)
        Voltage = ANALOG_KL15_VOLTAGE;
      else
        Voltage = ANALOG_KL30_VOLTAGE;
#endif
      if(NVM_CONFIG_POWER==1)
     { 
      if (Voltage < 15500)
      {
        LVPCnt++;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage < 17000)
      {
        LVPCnt    = 0;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage >= 32000)
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt = 0;
        OVPCnt++;
      }
      else
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt++;
        OVPCnt    = 0;
      }
      }
      else
            { 
      if (Voltage < 6500)
      {
        LVPCnt++;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage < 9000)
      {
        LVPCnt    = 0;
        LimitCnt++;
        NormalCnt = 0;
        OVPCnt    = 0;
      }
      else if (Voltage >= 18000)
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt = 0;
        OVPCnt++;
      }
      else
      {
        LVPCnt    = 0;
        LimitCnt  = 0;
        NormalCnt++;
        OVPCnt    = 0;
      }
      }
      if (LVPCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_LVP_MODE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_LVP;
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
        return;
      }

      if (LimitCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_LIMIT_MODE;
        SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_LIM;
#if     SYS_RUNNING_IN_LIMIT_MODE
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_OFF;
#else
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
#endif
        return;
      }

      if (NormalCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_NORMAL_MODE;
        SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_RUN;
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_OFF;
        return;
      }

      if (OVPCnt >= 5)
      {
        SysPwrMode.Mode      = SYS_PWR_OVP_MODE;
        SysPowerStatus       = SYS_PWR_STATUS_BIT_OVP;
        SysOperatingStatus   = SYS_OPR_STATUS_BIT_ERR;
        return;
      }
    }
  }
}

/******************************************************************************
Sys_ACC_Status_Detect
  ܣACC״̬
  
ֵ0 - ACCر 1 - ACC
******************************************************************************/
uint8_t Sys_ACC_Status_Detect(void)
{
 /* if ((PEPS_PowerModeValidity == 0x02) && (PEPS_PowerMode == 0x01))
    return 1;
  else
    return 0;*/
}
 
/******************************************************************************
Sys_Crank_Status_Detect
  ܣCRANK״̬
  
ֵ0 - CRANKر 1 - CRANK
******************************************************************************/
uint8_t Sys_Crank_Status_Detect(void)
{
 /* if ((PEPS_PowerModeValidity == 0x02) && (PEPS_PowerMode == 0x04))
    return 1;
  else
    return 0;    */
}
