/******************************************************************************
  Communication_Over_CAN.c
CANߵźշļ
    ߣ
    V1.3
    ڣ2017.5.31
******************************************************************************/

#include "Communication_Over_CAN.h"

#pragma MESSAGE DISABLE C4301

CoCANTxMsgFIFOStruct     CoCANTxMsgFIFO;
CoCANRxMsgFIFOStruct     CoCANRxMsgFIFO;

CoCANTxMsgIDLookupStruct CoCANTxMsgTable[CAN_TX_MSG_NUM];
CoCANRxMsgIDLookupStruct CoCANRxMsgTable[CAN_RX_MSG_NUM];

CoCANCycleMsgStruct      CoCANCycleMsg;

CoCANCtrlStruct          CoCANCtrl;

//ڷͱװFIFO
void CoCAN_Tx_Fill_FIFO(uint8_t cycleMsgID)
{
  //ĶеţCoCANTxMsgTable
  uint8_t Index = CoCANCycleMsg.TxIndex[cycleMsgID];

  //ⷢ
  if ( *(CoCANTxMsgTable[Index].pStatus) & CAN_TX_EN )
  {
    //ϢFIFO
    CoCANTxMsgFIFO.Index[CoCANTxMsgFIFO.Iptr] = Index;
    
    //FIFO
    if (CoCANTxMsgFIFO.Depth < CAN_TX_MSG_NUM)
      CoCANTxMsgFIFO.Depth++;

	  //FIFOǰдλλѭλ
    CoCANTxMsgFIFO.Iptr++;
    if (CoCANTxMsgFIFO.Iptr >= CAN_TX_MSG_NUM)
      CoCANTxMsgFIFO.Iptr = 0;
    
    //Աһηʱ
    CoCANCycleMsg.TxTimer[cycleMsgID] = CoCANCtrl.Timer + CoCANTxMsgTable[Index].Cycle;
	  //ѷTAG
    *(CoCANTxMsgTable[Index].pStatus) |= CAN_UPDATE;
  }
  //end
}

//FIFOзһ
void CoCAN_Tx_SendOutOne()
{
  //һֻ1
  uint8_t Index = CoCANTxMsgFIFO.Index[CoCANTxMsgFIFO.Optr];
  
  //ķ
  CoCANTxMsgTable[Index].TxReq = CoCAN_TX_ON;
  CoCAN_L_Data_Request(CoCANTxMsgTable[Index].Identifier, CoCANTxMsgTable[Index].DLC, (uint8_t*)CoCANTxMsgTable[Index].pMsg);
  
  //FIFO
  CoCANTxMsgFIFO.Depth--;
  CoCANTxMsgFIFO.Optr++;
  if (CoCANTxMsgFIFO.Optr >= CAN_TX_MSG_NUM)
    CoCANTxMsgFIFO.Optr = 0;
  //end
}

/******************************************************************************
CoCAN_L_Data_Indication
  ܣ ·㴫ݶ,ָʾݵĵﲢ
        ú뱻²(·)
   Identifier CANID
        DLC        ݳ
        Data       
ֵ
******************************************************************************/
void CoCAN_L_Data_Indication(uint32_t Identifier, uint8_t DLC, uint8_t *Data)
{
  uint8_t i;
  
  //Ƿձ
  if (CoCANCtrl.RxEnable != CoCAN_ENABLE)
  {
    if (Identifier == 0x18FFA021)
    {
    }
    else
      return;
  }
  //FIFOǷ
  if (CoCANRxMsgFIFO.Depth >= CoCAN_RX_MSG_FIFO_MAX_DEPTH)
    return;
  
  //
  CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Iptr].Identifier = Identifier;//ID
  for (i = 0; i < DLC; i++)
    CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Iptr].Data[i]  = Data[i];	//Data
  CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Iptr].DLC        = DLC;		//DLC
  
  //FIFO
  CoCANRxMsgFIFO.Depth++;
  CoCANRxMsgFIFO.Iptr++;
  if (CoCANRxMsgFIFO.Iptr >= CoCAN_RX_MSG_FIFO_MAX_DEPTH)
    CoCANRxMsgFIFO.Iptr = 0;
  //end
}

/******************************************************************************
CoCAN_Init
  ܣ CANźշʼ
        ڳʼźųʼֵ,ʼĶʱ,ԼɱĿٲұ
   
ֵ
******************************************************************************/
void CoCAN_Init(void) 
{  
  uint8_t   i;
  uint8_t   Index;
  uint8_t   RxMsgNum;
  uint8_t   TxMsgNum;
  uint32_t  Identifier;
  
  //ɱĿٲұ
  //ٲұɹIndexԱʱڴűĴ洢ԱеλϢ
  //λϢںвұ䱨Ŀٲұ
  RxMsgNum = 0;
  TxMsgNum = 0;

  //CAN_Communication_Matrix.hϢϢ
  for (Index = 0; Index < CoCAN_TOTAL_MSG_NUM; Index++)
  {
    Identifier = CANMsgAttrTable[Index].ID;
    
    //ձĿٲұ (CoCANRxMsgTable)
    if (CANMsgAttrTable[Index].Dir == CAN_MSG_Rx)
    {
      if (RxMsgNum == 0) //ٲұһ⴦
      {
        CoCANRxMsgTable[0].Identifier = Identifier;
        CoCANRxMsgTable[0].Index      = Index;
      }
      else //ݱIDӴСвұ
      {
        i = RxMsgNum;
        while (i)
        {
          if (CoCANRxMsgTable[i - 1].Identifier > Identifier)
          {
            CoCANRxMsgTable[i].Identifier = CoCANRxMsgTable[i - 1].Identifier;
            CoCANRxMsgTable[i].Index      = CoCANRxMsgTable[i - 1].Index;
            
            CoCANRxMsgTable[i - 1].Identifier = Identifier;
            CoCANRxMsgTable[i - 1].Index      = Index;
          }
          else
          {
            CoCANRxMsgTable[i].Identifier = Identifier;
            CoCANRxMsgTable[i].Index      = Index;
            break;
          }
          i--;
        }
      }
      RxMsgNum++;
    }
    //ͱĿٲұ(CoCANTxMsgTable)
    else
    {
      if (TxMsgNum == 0) //ٲұһ⴦
      {
        CoCANTxMsgTable[0].Identifier = Identifier;
        CoCANTxMsgTable[0].Index      = Index;
      }
      else               //ݱIDӴСвұ
      {
        i = TxMsgNum;
		    //ͱİID򣨴С
        while (i)
        {
          //һID²ID
          if (CoCANTxMsgTable[i - 1].Identifier > Identifier)
          {
            CoCANTxMsgTable[i].Identifier = CoCANTxMsgTable[i - 1].Identifier;
            CoCANTxMsgTable[i].Index      = CoCANTxMsgTable[i - 1].Index;
            
            CoCANTxMsgTable[i - 1].Identifier = Identifier;
            CoCANTxMsgTable[i - 1].Index      = Index;
          }
          else
          {
            CoCANTxMsgTable[i].Identifier = Identifier;
            CoCANTxMsgTable[i].Index      = Index;
            break;
          }
          i--;
        }
      }
      TxMsgNum++;
    }
  }

  //ϷУ
 #if CoCAN_MSG_NUM_CHECK
  //Աеı붨ıһʱѭȴŹλ
  if ( CoCAN_TOTAL_MSG_NUM != (CAN_TX_MSG_NUM + CAN_RX_MSG_NUM) )
    for (;;);
 
  //Աеı붨ıһʱѭȴŹλ
  if ((TxMsgNum != CAN_TX_MSG_NUM) || (RxMsgNum != CAN_RX_MSG_NUM))          
    for (;;);
 #endif
  
  //ƱĲұϢ,ԱĹ
  CoCANCycleMsg.TxNum = 0;
  CoCANCycleMsg.RxNum = 0;
  
  //ͱ
  for (i = 0; i < CAN_TX_MSG_NUM; i++)
  {
    Index = CoCANTxMsgTable[i].Index; //ȡĴ洢ԱеλϢ

	  //Ա
    if (CANMsgAttrTable[Index].Type == CAN_MSG_CYCLE)
    {
      CoCANTxMsgTable[i].Offset = CANMsgAttrTable[Index].Offset;
      CoCANTxMsgTable[i].Cycle  = CANMsgAttrTable[Index].Cycle;
      CoCANTxMsgTable[i].Index  = CoCANCycleMsg.TxNum;
      //
      CoCANCycleMsg.TxIndex[CoCANCycleMsg.TxNum] = i;
      CoCANCycleMsg.TxNum++;
    }
    else
      CoCANTxMsgTable[i].Index = 0xFF; //ʾԱ
    
    CoCANTxMsgTable[i].DLC     = CANMsgAttrTable[Index].DLCMax;
    CoCANTxMsgTable[i].pMsg    = CANMsgAttrTable[Index].pMsg;
    CoCANTxMsgTable[i].pInit   = CANMsgAttrTable[Index].pInit;
    CoCANTxMsgTable[i].pStatus = CANMsgAttrTable[Index].pStatus;
  }
  
  //ձ
  for (i = 0; i < CAN_RX_MSG_NUM; i++)
  {
    Index = CoCANRxMsgTable[i].Index; //ȡĴ洢ԱеλϢ
    
    if (CANMsgAttrTable[Index].Type == CAN_MSG_CYCLE)
    {
      CoCANRxMsgTable[i].Cycle = CANMsgAttrTable[Index].Cycle;
      CoCANRxMsgTable[i].Index = CoCANCycleMsg.RxNum;
      //
      CoCANCycleMsg.RxIndex[CoCANCycleMsg.RxNum] = i;
      CoCANCycleMsg.RxNum++;
    }
    else
      CoCANRxMsgTable[i].Index = 0xFF; //ʾԱ
    
    CoCANRxMsgTable[i].DLCMax   = CANMsgAttrTable[Index].DLCMax;
    CoCANRxMsgTable[i].DLCMin   = CANMsgAttrTable[Index].DLCMin;
    CoCANRxMsgTable[i].pMsg     = CANMsgAttrTable[Index].pMsg;
    CoCANRxMsgTable[i].pInit    = CANMsgAttrTable[Index].pInit;
    CoCANRxMsgTable[i].pTimeOut = CANMsgAttrTable[Index].pTimeOut;
    CoCANRxMsgTable[i].pMask    = CANMsgAttrTable[Index].pMask;
    CoCANRxMsgTable[i].pStatus  = CANMsgAttrTable[Index].pStatus;
  }

  //CanӲʼ
  CoCAN_Reset();
  CoCAN_Set_Mode(CoCAN_MODE_INIT);
}

/******************************************************************************
CoCAN_Reset
  ܣCANշ״̬,úӰ죺
        1./FIFO
        2.źŻָʼֵ
        3.״ָ̬ʼ״̬
        4.з󽫱ȡ
        5./Ͷʱ
        ñ,ӰCANͨŵĽ/ʹ״̬
  
ֵ
******************************************************************************/
void CoCAN_Reset(void)
{
  uint8_t i;
  uint8_t j;
  
  //ʼͱFIFO
  CoCANTxMsgFIFO.Iptr  = 0;
  CoCANTxMsgFIFO.Optr  = 0;
  CoCANTxMsgFIFO.Depth = 0;
  
  //ʼձFIFO
  CoCANRxMsgFIFO.Iptr  = 0;
  CoCANRxMsgFIFO.Optr  = 0;
  CoCANRxMsgFIFO.Depth = 0;
  
  //ͱ
  for (i = 0; i < CAN_TX_MSG_NUM; i++)
  {
    //ʼźֵ
    for (j = 0; j < CoCANTxMsgTable[i].DLC; j++)
      CoCANTxMsgTable[i].pMsg[j] = CoCANTxMsgTable[i].pInit[j];
    
    //ʼ״̬
    *CoCANTxMsgTable[i].pStatus  = 0x00;
    
    //
    CoCANTxMsgTable[i].TxReq   = CoCAN_TX_IDLE;
  }
  
  //ձ
  for (i = 0; i < CAN_RX_MSG_NUM; i++)
  {
    //ʼ
    for (j = 0; j < CoCANRxMsgTable[i].DLCMax; j++)
      CoCANRxMsgTable[i].pMsg[j] = CoCANRxMsgTable[i].pInit[j];
    
    //ʼ״̬
    *CoCANRxMsgTable[i].pStatus  = 0x01;
  }
  
  //öʱ
  CoCANCtrl.Timer = 0;
  
  for (i = 0; i < CoCANCycleMsg.TxNum; i++)
    CoCANCycleMsg.TxTimer[i] = CoCANTxMsgTable[CoCANCycleMsg.TxIndex[i]].Offset;

  for (i = 0; i < CoCANCycleMsg.RxNum; i++)
    CoCANCycleMsg.RxTimer[i] = CoCANRxMsgTable[CoCANCycleMsg.RxIndex[i]].Cycle;
}

/******************************************************************************
CoCAN_Set_Mode
  ܣCANͨŵĹģʽ
  ModeCoCAN_MODE_INIT   - ʼģʽ,Ľں̨жϳ
             CoCAN_MODE_NORMAL - ģʽ,ɱķͳз
ֵ
******************************************************************************/
void CoCAN_Set_Mode(uint8_t Mode)
{
  uint8_t i;

  //״̬
  if (CoCANCtrl.Mode == Mode)
  	return;

  //״̬¼
  CoCANCtrl.Mode = Mode;

  //CoCAN_MODE_INIT
  if (Mode == CoCAN_MODE_INIT)
    CoCANCtrl.Prescaler = 0;

  //CoCAN_MODE_NORMAL
  else
  {
    //ýձĶʱ
    for (i = 0; i < CoCANCycleMsg.RxNum; i++)
      CoCANCycleMsg.RxTimer[i] = CoCANRxMsgTable[CoCANCycleMsg.RxIndex[i]].Cycle + CoCANCtrl.Timer;
  }
  //end
}

/******************************************************************************
CoCAN_Rx_Enable
  ܣCANͨŽչʹ/ر
  En CoCAN_DISABLE           - ֹCANͨŽչ
            COCAN_PSEUDO_DISABLE - ֹCANͨŽչ,ĵ״̬
            CoCAN_ENABLE         - CANͨŽչʹ
ֵ
******************************************************************************/
void CoCAN_Rx_Enable(uint8_t En)
{
  uint8_t i;
  
  if ((En == CoCAN_DISABLE) || (En == COCAN_PSEUDO_DISABLE))
    CoCANCtrl.RxEnable = En;
  else
  {
    if (CoCANCtrl.RxEnable != CoCAN_ENABLE)
    {
      CoCANCtrl.RxEnable = CoCAN_ENABLE;
      
      //ýձĶʱ
      for (i = 0; i < CoCANCycleMsg.RxNum; i++) //0λΪģҪ  20190929   
        CoCANCycleMsg.RxTimer[i] = CoCANRxMsgTable[CoCANCycleMsg.RxIndex[i]].Cycle + CoCANCtrl.Timer;
    }
  }
}

/******************************************************************************
CoCAN_Tx_Enable
  ܣCANͨŷ͹ʹ/ر
  En CoCAN_DISABLE - ֹCANͨŷ͹
            CoCAN_ENABLE  - ʹCANͨŷ͹
ֵ
******************************************************************************/
void CoCAN_Tx_Enable(uint8_t En)
{
  uint8_t i;
  
  //򿪷
  if ( En==CoCAN_ENABLE )
  {
    if (CoCANCtrl.TxEnable != CoCAN_ENABLE)
    {
      //÷ͱĶʱ
      for (i = 0; i < CoCANCycleMsg.TxNum; i++) //0λΪģʱ򲻿
        CoCANCycleMsg.TxTimer[i] = CoCANTxMsgTable[CoCANCycleMsg.TxIndex[i]].Offset + CoCANCtrl.Timer + 20;
    }
	  CoCANCtrl.TxEnable = CoCAN_ENABLE;
  }

  //رշ
  else
  {
    //ԭǹر
    if (CoCANCtrl.TxEnable != CoCAN_DISABLE)
    {
	    //շͱFIFO
	    CoCANTxMsgFIFO.Iptr  = 0;
      CoCANTxMsgFIFO.Optr  = 0;
      CoCANTxMsgFIFO.Depth = 0;
      //
      for (i = 0; i < CAN_TX_MSG_NUM; i++) //0λΪģصʱ򲻹, Ĳ0λ
      {
        CoCANTxMsgTable[i].TxReq = CoCAN_TX_IDLE;
      }
    }
	  CoCANCtrl.TxEnable = CoCAN_DISABLE;
  }
  //end
}

/******************************************************************************
CoCAN_Search_Tx_Msg
  ܣ ӷͱĿٲұҵĿ걨IDϢ洢λ
   IdentifierĿ걨ID
ֵñĵϢڷͱĿٲұеĴ洢λ
        0xFFʾδҵ
******************************************************************************/
//#pragma INLINE
uint8_t CoCAN_Search_Tx_Msg(uint32_t Identifier)
{
  uint8_t SearchStart;
  uint8_t SearchPoint;
  uint8_t SearchLen;
  
  SearchStart = 0;              //ӷͿٲұĵ׶
  SearchLen   = CAN_TX_MSG_NUM; //ҳΪұ
  
  //õݹṹƵջջɵʱ˷
  while (SearchLen)
  {
    //۰
    SearchPoint = SearchStart + SearchLen / 2;
    if (CoCANTxMsgTable[SearchPoint].Identifier == Identifier)
    {
      return SearchPoint;
    }
    else if (CoCANTxMsgTable[SearchPoint].Identifier < Identifier)
    {
      //ĿIDȲҵIDֵ,Ҳҵ֮Ĳұ
      //һεĲΪεĲҵ֮һ,ҳΪʣĲұ - 1
      SearchStart = SearchPoint + 1;
      SearchLen   = SearchLen - SearchLen / 2 - 1;
    }
    else
    {
      //ĿIDȲҵIDֵС,Ҳҵ֮ǰĲұ
      //һεĲΪԭ㲻,ҳȼ
      SearchLen   = SearchLen / 2;
    }
  }
  
  //δҵĿID
  return 0xFF;
}

/******************************************************************************
CoCAN_Search_Rx_Msg
  ܣӽձĿٲұҵĿ걨IDϢ洢λ
  IdentifierĿ걨ID
ֵñĵϢڽձĿٲұеĴ洢λ
        0xFFʾδҵ
******************************************************************************/
uint8_t CoCAN_Search_Rx_Msg(uint32_t Identifier)
{
  uint8_t SearchStart;
  uint8_t SearchPoint;
  uint8_t SearchLen;
  
  SearchStart = 0;              //ӽտٲұĵ׶                   
  SearchLen   = CAN_RX_MSG_NUM; //ҳΪұ
  
  //õݹṹƵջջɵʱ˷
  while (SearchLen)
  {
    SearchPoint = SearchStart + SearchLen / 2;
      
    if (CoCANRxMsgTable[SearchPoint].Identifier == Identifier)
    {
      return SearchPoint;
    }
    else if (CoCANRxMsgTable[SearchPoint].Identifier < Identifier)  
    {
      //ĿIDȲҵIDֵ,Ҳҵ֮Ĳұ
      //һεĲΪεĲҵ֮һ,ҳΪʣĲұ - 1
      SearchStart = SearchPoint + 1;
      SearchLen   = SearchLen - SearchLen / 2 - 1;
    }
    else
    {
      //ĿIDȲҵIDֵС,Ҳҵ֮ǰĲұ
      //һεĲΪԭ㲻,ҳȼ
      SearchLen   = SearchLen / 2;
    }
  }
  
  //δҵĿID
  return 0xFF;
}

/******************************************************************************
CoCAN_Signal_Update_Service
  ܣ CANźŸ·
        úУ1.յıĽź
                      2.رǷбĶʧ
                      3.ʱԷͱ
   
ֵ
*******************************************************************************
ע  ⣺÷ÿ1msһ
******************************************************************************/
void CoCAN_Signal_Update_Service(void)
{
  uint8_t   i, j;
  uint8_t   Index;
  uint32_t  Identifier;
  
  //һø÷,˵ϵͳѾʼ׶,CANͨŹģʽתΪģʽ
  CoCAN_Set_Mode(CoCAN_MODE_NORMAL);
  
  //ӱĽFIFOȡ
  while (CoCANRxMsgFIFO.Depth)
  {
    Identifier = CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Optr].Identifier;
    Index      = CoCAN_Search_Rx_Msg(Identifier);
    
	  //Ա
    if (Index != 0xFF)
    {
      //֤ĳ
      if ((CoCANRxMsgTable[Index].DLCMax >= CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Optr].DLC) &&\
          (CoCANRxMsgTable[Index].DLCMin <= CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Optr].DLC))
      {
        //һγʱ
        if (CoCANRxMsgTable[Index].Index != 0xFF)
          CoCANCycleMsg.RxTimer[CoCANRxMsgTable[Index].Index] = CoCANCtrl.Timer + CoCANRxMsgTable[Index].Cycle;
        
        //Buffer
        for (i = 0; i < CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Optr].DLC; i++)
          CoCANRxMsgTable[Index].pMsg[i] = CoCANRxMsgFIFO.Msg[CoCANRxMsgFIFO.Optr].Data[i];
        
        //Ķʧ״̬,ñĸ±־
        *CoCANRxMsgTable[Index].pStatus = CAN_UPDATE;
      }
    }
    
    //FIFO
    CoCANRxMsgFIFO.Depth--;
    CoCANRxMsgFIFO.Optr++;
    if (CoCANRxMsgFIFO.Optr >= CoCAN_RX_MSG_FIFO_MAX_DEPTH)
      CoCANRxMsgFIFO.Optr = 0;
  }
  
  //COCAN_PSEUDO_DISABLE״̬ʱڽձļ
  if (CoCANCtrl.RxEnable != COCAN_PSEUDO_DISABLE)
  {
    for (i = 0; i < CoCANCycleMsg.RxNum; i++)
    {
      //ĵ,Ĭֵ
      if (CoCANCycleMsg.RxTimer[i] <= CoCANCtrl.Timer)
      {
        Index = CoCANCycleMsg.RxIndex[i];
        if (*CoCANRxMsgTable[Index].pStatus & CAN_UPDATE) 
        {
          for (j = 0; j < CoCANRxMsgTable[Index].DLCMax; j++)
          {
            CoCANRxMsgTable[Index].pMsg[j] &= CoCANRxMsgTable[Index].pMask[j];
            CoCANRxMsgTable[Index].pMsg[j] |= CoCANRxMsgTable[Index].pTimeOut[j];
          }
            
          //ñĶʧ״̬
          *CoCANRxMsgTable[Index].pStatus |= CAN_MSG_LOST;
        }
      }
    }
  }

  //Աⷢ
  if (CoCANCtrl.TxEnable == CoCAN_ENABLE)
  {
    //ڷͱķ
    for (i = 0; i < CoCANCycleMsg.TxNum; i++)
    {
      //ķʱ䵽,Ҫ͵ıװ뷢FIFO
      if (CoCANCycleMsg.TxTimer[i] == CoCANCtrl.Timer) //20200702
      {
        Index = CoCANCycleMsg.TxIndex[i];
        
        if (*CoCANTxMsgTable[Index].pStatus & CAN_TX_EN)
        {
          CoCANTxMsgFIFO.Index[CoCANTxMsgFIFO.Iptr] = Index;
            
          //FIFO
          if (CoCANTxMsgFIFO.Depth < CAN_TX_MSG_NUM)
            CoCANTxMsgFIFO.Depth++;
          
          CoCANTxMsgFIFO.Iptr++;
          
          if (CoCANTxMsgFIFO.Iptr >= CAN_TX_MSG_NUM)
            CoCANTxMsgFIFO.Iptr = 0;
          
          //Աһηʱ
          CoCANCycleMsg.TxTimer[i] = CoCANCtrl.Timer + CoCANTxMsgTable[Index].Cycle;

          *CoCANTxMsgTable[Index].pStatus |= CAN_UPDATE;
        }
      }
    }
  }
    
  //ķFIFOеıķͳȥ
  if (CoCANTxMsgFIFO.Depth)
  {
    //һֻ1
    Index = CoCANTxMsgFIFO.Index[CoCANTxMsgFIFO.Optr];
    
    //ķ
    CoCANTxMsgTable[Index].TxReq = CoCAN_TX_ON;
    CoCAN_L_Data_Request(CoCANTxMsgTable[Index].Identifier, CoCANTxMsgTable[Index].DLC, (uint8_t*)CoCANTxMsgTable[Index].pMsg);
 
    //FIFO
    CoCANTxMsgFIFO.Depth--;
    CoCANTxMsgFIFO.Optr++;
    if (CoCANTxMsgFIFO.Optr >= CAN_TX_MSG_NUM)
      CoCANTxMsgFIFO.Optr = 0;
  }

  //**********************************ʱ
  //ȫֶʱ
  CoCANCtrl.Timer++;
  //ʱλֵΪ 0 - 23767,λΪλλ
  if (CoCANCtrl.Timer > 0x7FFF)                  
  {
    //ܼʱ
    CoCANCtrl.Timer &= 0x7FFF;
	  //ͼʱ
    for (i = 0; i < CoCANCycleMsg.TxNum; i++)
      CoCANCycleMsg.TxTimer[i] &= 0x7FFF;
    //ռʱ
    for (i = 0; i < CoCANCycleMsg.RxNum; i++)
      CoCANCycleMsg.RxTimer[i] &= 0x7FFF;
  }
}

/******************************************************************************
CoCAN_Transmit_Message
  ܣ ͱ
        ͵ıļȿ͵,Ҳ¼͵,ñڱԱб
        뱻Ϊͱ
        Էͱڱֱֹʹ,ʹܵͬʱӦô˺
        ĵԷ
  IdentifierID
ֵ
******************************************************************************/
void CoCAN_Transmit_Message(uint32_t Identifier)
{
  uint8_t Index;
  
  if (CoCANCtrl.TxEnable != CoCAN_ENABLE)
    return;
  
  Index = CoCAN_Search_Tx_Msg(Identifier);
  
  if (Index != 0xFF) //λڷͿٲұ
  {
    if (*CoCANTxMsgTable[Index].pStatus & CAN_TX_EN)
    {
      if (CoCANTxMsgTable[Index].TxReq == CoCAN_TX_IDLE)
      {
        CoCANTxMsgFIFO.Index[CoCANTxMsgFIFO.Iptr] = Index;
          
        //FIFO
        if (CoCANTxMsgFIFO.Depth < CAN_TX_MSG_NUM)
          CoCANTxMsgFIFO.Depth++;
        
        CoCANTxMsgFIFO.Iptr++;
        
        if (CoCANTxMsgFIFO.Iptr >= CAN_TX_MSG_NUM)
          CoCANTxMsgFIFO.Iptr = 0;
          
        //
        CoCANTxMsgTable[Index].TxReq = CoCAN_TX_REQ;
      }
    }
  }
}

/******************************************************************************
CoCAN_Modify_Tx_Msg_Cycle
  ܣ޸ıĵķ
        úԷͱЧ,޸ĵı¼͵Ļǽձ,
        κЧ
        ڻһαķͳɹЧ
  IdentifierID
        Cycle     Ŀ걨
ֵ
******************************************************************************/
void CoCAN_Modify_Tx_Msg_Cycle(uint32_t Identifier, uint16_t Cycle)
{
  uint8_t Index;
  
  Index = CoCAN_Search_Tx_Msg(Identifier);
  
  if (Index != 0xFF) //λڷͿٲұ
    CoCANTxMsgTable[Index].Cycle = Cycle;
}

/******************************************************************************
CoCAN_Init_Mode_Tx_ISR
   ܣʼģʽCANͨűķжϷ
   
ֵ
*******************************************************************************
ע  ⣺÷뱻Ƕ뵽ʱж
******************************************************************************/
void CoCAN_Init_Mode_Tx_ISR(void)
{
  uint8_t i;
  
  if (CoCANCtrl.Mode != CoCAN_MODE_INIT)
    return;

  //ķͣʼ
  CoCANCtrl.Prescaler++;

  //ʱδ
  if (CoCANCtrl.Prescaler <= (uint8_t)(1000 / API_INT_CYCLE))
    return;
  
  //гʼ
  CoCANCtrl.Prescaler = 0;

  //Է
  if (CoCANCtrl.TxEnable == CoCAN_ENABLE)
  {
    //ڷͱķ
    for (i = 0; i < CoCANCycleMsg.TxNum; i++)
    {
      //ķʱ䵽,Ҫ͵ıװ뷢FIFO
      if (CoCANCycleMsg.TxTimer[i] == CoCANCtrl.Timer) 
        CoCAN_Tx_Fill_FIFO(i);
    }
  }
    
  //ķFIFOеıķͳȥ
  if (CoCANTxMsgFIFO.Depth)
    CoCAN_Tx_SendOutOne();
  
  //********************************ȫֶʱ
  CoCANCtrl.Timer++;
  //ʱλֵΪ 0 - 23767
  if (CoCANCtrl.Timer > 0x7FFF)                  
  {
    CoCANCtrl.Timer &= 0x7FFF;
    for (i = 0; i < CoCANCycleMsg.TxNum; i++)
      CoCANCycleMsg.TxTimer[i] &= 0x7FFF;
  }
  //end
}

