/******************************************************************************
  TFT_LCD.h
TFTɫҺʾƺͷļ
    ߣ
    V1.0
    ڣ2017.4.8
******************************************************************************/

#ifndef _TFT_LCD_H_
#define _TFT_LCD_H_

#include "PWM.h"
#include "YGV642.h"
#include "mapData.h"

/******************************************************************************
״̬ṹ
******************************************************************************/
typedef struct
{
  uint8_t   LyrEn;
  uint8_t   Scale;
  uint16_t  SpriteID;
  uint16_t  PosX;
  uint16_t  PosY;
} TFTLCDLayerStatusStruct;

/******************************************************************************
ͼƬṹ
******************************************************************************/
typedef struct
{
  uint8_t   UpdateCnt;
  uint8_t   Buffer[12];
} TFTLCDLayerBufferStruct;

/******************************************************************************
ʾ¿ƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   TblUpdate;
  uint8_t   Timer;
  uint8_t   State;
  uint8_t   Step;
  uint16_t  LyrBaseAddr;
  uint16_t  CurrentLyr;
  uint8_t   BytePtr;
  uint8_t   AddrBuffer[2];
  uint8_t   Data[12];
  uint8_t   Brightness;
  uint8_t   Enable;
} TFTLCDUpdateCtrlStruct;

/******************************************************************************
հͼ
******************************************************************************/
static const uint8_t TFTLCDBlankLayer[12] = SET_LYR_ERASE_ATTR_DEF;

/******************************************************************************

******************************************************************************/
void TFT_LCD_Display_Sprite(uint16_t LyrId, uint16_t SpriteID, uint16_t PosX, uint16_t PosY, uint8_t Scale);
void TFT_LCD_Clear_Layer(uint16_t LyrId);
void TFT_LCD_Clear_Multi_Layer(uint16_t LyrIdLo, uint16_t LyrIdHi);

void TFT_LCD_Startup(void);
void TFT_LCD_Shutdown(void);
void TFT_LCD_Set_Brightness(uint8_t Br);
void TFT_LCD_Display_Update_Service(void);

void TFT_LCD_Update_Layer_Buffer(uint16_t LyrId, uint16_t SpriteID, uint16_t PosX, uint16_t PosY, uint8_t Scale);
void TFT_LCD_Start_Update_General_Table(void);
uint8_t TFT_LCD_Get_General_Table_Update_Status(void);
void TFT_LCD_General_Table_Write_Service(void);




#endif