/************************************************ ******************************
文 件 名：YGV642_SPI.c
功能描述：YGV642的模拟SPI通信驱动库文件
作    者：张暄
版    本：V1.0
日    期：2017.4.8
******************************************************************************/
#include "YGV642_SPI.h"

/******************************************************************************
函数名：YGV642_SPI_Byte_Write
功  能：通过模拟SPI总线向YGV642发送1字节数据
参  数：Data：要发送的数据
返回值：无
******************************************************************************/
void YGV642_SPI_Byte_Write(uint8_t Data)
{
  uint8_t i;

  for(i = 0; i < 8; i++)
  {
    YGV642_SPI_SCLK_Low();

    if(Data & 0x01)
      YGV642_SPI_MOSI_High();
    else
      YGV642_SPI_MOSI_Low();

    YGV642_SPI_SCLK_High();

    Data >>= 1;
  }
}

/******************************************************************************
函数名：YGV642_SPI_Byte_Read
功  能：通过模拟SPI总线从YGV642读取1字节数据
参  数：无
返回值：读取到的数据
******************************************************************************/
uint8_t YGV642_SPI_Byte_Read(void)
{
  uint8_t   i;
  uint8_t   Data;

  Data  = 0;

  for(i = 0; i < 8; i++)
  {
    YGV642_SPI_SCLK_Low();

    Data >>= 1;

    if(YGV642_SPI_Read_MISO())
      Data |= 0x80;

    YGV642_SPI_SCLK_High();
  }

  return Data;
}

/******************************************************************************
函数名：YGV642_SPI_Word_Write
功  能：通过模拟SPI总线向YGV642发送1个字(16bit)的数据
参  数：Data：要发送的数据
返回值：无
******************************************************************************/
void YGV642_SPI_Word_Write(uint16_t Data)
{
  uint8_t i;

  for(i = 0; i < 16; i++)
  {
    YGV642_SPI_SCLK_Low();

    if(Data & 0x0001)
      YGV642_SPI_MOSI_High();
    else
      YGV642_SPI_MOSI_Low();

    YGV642_SPI_SCLK_High();

    Data >>= 1;
  }
}

/******************************************************************************
函数名：YGV642_SPI_Word_Read
功  能：通过模拟SPI总线从YGV642读取1个字(16bit)的数据
参  数：无
返回值：读取到的数据
******************************************************************************/
uint16_t YGV642_SPI_Word_Read(void)
{
  uint8_t   i;
  uint16_t  Data;

  Data  = 0;

  for(i = 0; i < 16; i++)
  {
    YGV642_SPI_SCLK_Low();

    Data >>= 1;

    if(YGV642_SPI_Read_MISO())
      Data |= 0x8000;

    YGV642_SPI_SCLK_High();
  }

  return Data;
}
