#ifndef _POWER_MANAGEMENT_H_
#define _POWER_MANAGEMENT_H_

#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "stdint.h"
#include "comdef.h"
 
#include "UDS_ISO14229_Services.h"
#include "CRG.h"
#include "API.h"
#include "GPIO.h"
#include "PWM.h"
//#include "MSCAN0_J1939.h"
//#include "DoCAN_J1939.h"
#include "DoCAN_ISO15765_Config.h"
#include "DoCAN_ISO15765.h"
#include "SCI0_UART.h"
#include "Analog_Signal_Conversion.h"
#include "Communication_Over_CAN.h"
#include "Simulated_IIC_Master.h"
#include "LED.h"
#include "Line_In.h"
#include "EEPROM_24Cxx_Remap.h"
#include "Non_volatile_Memorys.h"
#include "Flash_synchronizer.h"
#include "TFT_LCD.h"
#include "Warning_Processor.h"
#include "Line_In.h"
#include "Stepper_Motor.h"
#include "Drive_Info.h"
#include "Telltales.h"
#include "IO_Manager.h"
#include "Popup_Scheduler.h"
#include "Key.h"
#include "IPC.h"
#include "Startup_Animation.h"
#include "Sound_Scheduler.h"
#include "LCD_SEG.h"
#include "API_BD8379.h"
//#define NET_WORK_STATE              0x01
//#define PREPARE_BUS_SLEEP_STATE     0x02
//#define BUS_SLEEP_STATE             0x03
//#define START_INDICATION_STATE      0x04
extern     uint8_t  CLEAR_ODO_STAR;
extern    uint8_t Powerstatus;
extern    uint8_t SpeedBackup;
extern    uint8_t Speedtime;
#define   POWER_STATUS_IGN_OFF              0x00
#define   POWER_STATUS_IGN_ON               0x01
#define   POWER_STATUS_STOP                 0x02
#define   POWER_STATUS_PROTECT              0x03

extern uint8_t  TIME_100MS;      //RTC_ISR 100ms
extern uint16_t FuelSeg;             //ȼ
extern uint16_t ADblueSeg;           //Һ
extern uint16_t OilSeg;
extern uint16_t GAS1_DISPLAY;                //ѹ1
extern uint16_t GAS2_DISPLAY;                //ѹ2
extern uint8_t  ContrlorResumeofFUEL;    //ͱƱ־λ
#define IGN_OFF         0x00
#define IGN_SleepInit   0x01
#define IGN_Sleep       0x02
#define IGN_WakeUp      0x03
#define IGN_ON          0x04
#define IGN_LVP         0x05
#define IGN_OVP         0x06
#define IGN_Default     0x07 
#define IGN_Stay_ON     0x08 

#define Network_Active        0x00
#define Network_Ready         0x01
#define Network_Wait          0x02
#define Network_Inactive      0x03

  typedef enum Power_Status
{
 IGN__OFF,          
 IGN__SleepInit,   
 IGN__Sleep,       
 IGN__WakeUp,      
 IGN__ON,          
 IGN__LVP,         
 IGN__OVP,         
 IGN__Default,     
 IGN__Stay_ON
}Power_Statuss;



void Power_Management_Init ( void );
void Power_Management_Service ( void );

void Power_Protect_Loop ( void );
uint8_t Power_Sleep_Loop ( void );

void Power_On_System_Init ( void );
void Power_On_Memory_Init ( void );
void Power_IGN_On_Init ( void );
void Power_Sleep_Init ( void );
void Power_Wake_Up_Init ( void );
void Diagnostic_init(void); 
uint8_t IGN_OFF_State_Keep(void);




void Com_RxStart ( void );
void Com_TxStart ( void );
void 	Com_TxStop ( void );
void  Com_RxStop ( void );




#endif