
#ifndef _RADAR_COMMON_H_
#define _RADAR_COMMON_H_

#include "stdint.h"

/******************************************************************************
ȫֱ
******************************************************************************/
extern volatile uint8_t RadarValid;
#define   RADAR_VALID                       RadarValid

extern volatile uint8_t RadarSelfTestPassed;
#define   RADAR_SELF_TEST_PASSED            RadarSelfTestPassed

extern volatile uint8_t RadarSysFault;
#define   RADAR_SYS_FAULT                   RadarSysFault

extern volatile uint8_t RadarSound;
#define   RADAR_SOUND                       RadarSound


//extern volatile uint8_t RadarSensorFL;
//#define RADAR_SENSOR_FL                     RadarSensorFL

//extern volatile uint8_t RadarSensorFLM;
//#define RADAR_SENSOR_FM                     RadarSensorFLM
//#define RADAR_SENSOR_FLM                    RadarSensorFLM

//extern volatile uint8_t RadarSensorFRM;
//#define RADAR_SENSOR_FRM                    RadarSensorFRM

//extern volatile uint8_t RadarSensorFR;
//#define RADAR_SENSOR_FR                     RadarSensorFR


extern volatile uint16_t RadarSensorRL;
#define RADAR_SENSOR_RL                     RadarSensorRL

extern volatile uint16_t RadarSensorRLM;
#define RADAR_SENSOR_RLM                    RadarSensorRLM

extern volatile uint16_t RadarSensorRRM;
#define RADAR_SENSOR_RRM                    RadarSensorRRM

extern volatile uint16_t RadarSensorRR;
#define RADAR_SENSOR_RR                     RadarSensorRR

extern volatile uint8_t  RADAR_SENSOR_RL_Num    ;
extern volatile uint8_t  RADAR_SENSOR_RLM_Num   ;
extern volatile uint8_t  RADAR_SENSOR_RRM_Num   ;
extern volatile uint8_t  RADAR_SENSOR_RR_Num    ;

/******************************************************************************
״Ч
******************************************************************************/
#define   RADAR_REAR_SYS                    0x0F
#define   RADAR_REAR_VALID_FLAG             0x01
#define   RADAR_REAR_FAULT_FLAG             0x02

#define   RADAR_FRONT_SYS                   0xF0
#define   RADAR_FRONT_VALID_FLAG            0x10
#define   RADAR_FRONT_FAULT_FLAG            0x20

#define   RADAR_REAR_INVALID                ((RADAR_VALID & RADAR_REAR_SYS) == 0x00)
#define   RADAR_REAR_VALID                  ((RADAR_VALID & RADAR_REAR_SYS) == RADAR_REAR_VALID_FLAG)
#define   RADAR_REAR_FAULT                  ((RADAR_VALID & RADAR_REAR_SYS) == RADAR_REAR_FAULT_FLAG)

#define   RADAR_FRONT_INVALID               ((RADAR_VALID & RADAR_FRONT_SYS) == 0x00)
#define   RADAR_FRONT_VALID                 ((RADAR_VALID & RADAR_FRONT_SYS) == RADAR_FRONT_VALID_FLAG)
#define   RADAR_FRONT_FAULT                 ((RADAR_VALID & RADAR_FRONT_SYS) == RADAR_FRONT_FAULT_FLAG)

/******************************************************************************
ϵͳ״̬
******************************************************************************/
#define   RADAR_HOST_FAULT_BIT              0x01
#define   RADAR_SWITCH_FAULT_BIT            0x02
#define   RADAR_LED_FAULT_BIT               0x04
#define   RADAR_MSG_LOST_BIT                0x10
#define   RADAR_MSG_INVALID_BIT             0x20

#define   RADAR_HOST_FAULT                  (RADAR_SYS_FAULT & RADAR_HOST_FAULT_BIT)
#define   RADAR_SWITCH_FAULT                (RADAR_SYS_FAULT & RADAR_SWITCH_FAULT_BIT)
#define   RADAR_LED_FAULT                   (RADAR_SYS_FAULT & RADAR_LED_FAULT_BIT)
#define   RADAR_MSG_LOST                    (RADAR_SYS_FAULT & RADAR_MSG_LOST_BIT)
#define   RADAR_MSG_INVALID                 (RADAR_SYS_FAULT & RADAR_MSG_INVALID_BIT)

/******************************************************************************
̽ͷ״̬
******************************************************************************/
#ifndef   RADAR_SENSOR_FAULT
#define   RADAR_SENSOR_FAULT                0x80
#endif

/******************************************************************************
״״̬
******************************************************************************/
#define   RADAR_SND_MUTE                    0x00      //
#define   RADAR_SND_1Hz                     0x01      //
#define   RADAR_SND_2Hz                     0x02      
#define   RADAR_SND_4Hz                     0x03
#define   RADAR_SND_CONTINUOUS              0x04      //

#endif
