/******************************************************************************
  DoCAN_ISO15765_Config.h
ISO 15765 淶涨Ϸļ
    ߣ
    V1.0
    ڣ2016.7.18
******************************************************************************/

/******************************************************************************
      Diagnostic/Programming Specifications Applicable to the OSI Layers
===============================================================================
  *     NO.     OSI Layer        Diagnostics services
-------------------------------------------------------------------------------
         7      Application      ISO 14229-1 ISO 14229-3
         6      Presentation     -
         5      Session          ISO 14229-2
  *      4      Transport        ISO 15765-2
  *      3      Network          ISO 15765-2
         2      Data Link        ISO 11898
         1      Physical         ISO 11898
===============================================================================
******************************************************************************/

#ifndef _DOCAN_ISO15765_CONFIG_H_
#define _DOCAN_ISO15765_CONFIG_H_

#include "Diag_ID_Def.h"

/*-----------------------------------------------------------------------------
If CAN frame data padding is used, the DLC is always set to 8, even if the
N_PDU to be transmitted is shorter than 8 bytes. The sender has to pad any
unused bytes in the frame. In particular, this can be the case for an SF, FC
frame or the last CF of a segmented message.
-----------------------------------------------------------------------------*/
#define  FILLER_BYTE_HANDLING                          1
#define  FILLER_BYTE                                0x00

/*-----------------------------------------------------------------------------
Link layer Rx FIFO depth
-----------------------------------------------------------------------------*/
#define  LINK_RX_FIFO_MAX_DEPTH                        2

/*-----------------------------------------------------------------------------
Network layer buffer size
-----------------------------------------------------------------------------*/
#define  N_USDATA_RX_BUFFER_SIZE                      96
#define  N_USDATA_TX_BUFFER_SIZE                      96

/******************************************************************************
The FlowControl mechanism allows the receiver to inform the sender about the
receivers capabilities. Since different nodes may have different capabilities,
the FlowControl sent by the receiver informs the sender about its capabilities.
The sender shall conform to the receivers capabilities.
These capabilities are defined as follows.
******************************************************************************/
/*-----------------------------------------------------------------------------
 BlockSize (BS): The maximum number of N_PDUs the receiver allows the sender
to send, before waiting for an authorization to continue transmission of the
following N_PDUs.
-----------------------------------------------------------------------------*/
#define  N_MAX_BS                                      8

/*-----------------------------------------------------------------------------
 SeparationTime minimum (STmin): The minimum time the sender is to wait
between transmission of two CF N_PDUs. (Unit: ms)
-----------------------------------------------------------------------------*/
#define  N_STmin                                      20

/*-----------------------------------------------------------------------------
 N_WFTmax: Upper limit to the number of FC.WAIT a receiver is allowed to send
            in a row. This parameter is a system design constant and is not
            transmitted in the first FC N_PDU.
-----------------------------------------------------------------------------*/
#define  N_WFTmax                                      0

/******************************************************************************
Timing parameters
******************************************************************************/
/*-----------------------------------------------------------------------------
- Timing Parametera       : N_As
- Description             : Time for transmission of the CAN frame (any N_PDU)
                            on the sender side
- Start                   : L_Data.request
- End                     : L_Data.confirm
- Timeout(Max)            : 1,000 ms
- Performance Requirement :
-----------------------------------------------------------------------------*/
#define  N_As                             ((uint32_t)25)

/*-----------------------------------------------------------------------------
- Timing Parametera       : N_Ar
- Description             : Time for transmission of the CAN frame (any N_PDU)
                            on the receiver side
- Start                   : L_Data.request
- End                     : L_Data.confirm
- Timeout(Max)            : 1,000 ms
- Performance Requirement :
-----------------------------------------------------------------------------*/
#define  N_Ar                             ((uint32_t)25)

/*-----------------------------------------------------------------------------
- Timing Parametera       : N_Bs
- Description             : Time until reception of the next FlowControl N_PDU
- Start                   : L_Data.confirm (FF) / L_Data.confirm (CF) /
                            L_Data.indication (FC)
- End                     : L_Data.indication (FC)
- Timeout(Max)            : 1,000 ms
- Performance Requirement :
-----------------------------------------------------------------------------*/
#define  N_Bs                            ((uint32_t)75)

/*-----------------------------------------------------------------------------
- Timing Parametera       : N_Br
- Description             : Time until transmission of the next FlowControl
                            N_PDU
- Start                   : L_Data.indication (FF) / L_Data.indication (CF)
                            L_Data.confirm (FC)
- End                     : L_Data.request (FC)
- Timeout(Max)            : N/A
- Performance Requirement : (N_Br + N_Ar) < (0.9  N_Bs timeout)
-----------------------------------------------------------------------------*/
#define  N_Br                             ((uint32_t)9)

/*-----------------------------------------------------------------------------
- Timing Parametera       : N_Cs
- Description             : Time until transmission of the next
                            ConsecutiveFrame N_PDU
- Start                   : L_Data.indication (FC) / L_Data.confirm (CF)
- End                     : L_Data.request (CF)
- Timeout(Max)            : N/A
- Performance Requirement : (N_Cs + N_As) < (0.9  N_Cr timeout)
-----------------------------------------------------------------------------*/
#define  N_Cs                             ((uint32_t)0)

/*-----------------------------------------------------------------------------
- Timing Parametera       : N_Cr
- Description             : Time until reception of the next Consecutive Frame
                            N_PDU
- Start                   : L_Data.confirm (FC) / L_Data.indication (CF)
- End                     : L_Data.indication (CF)
- Timeout(Max)            : 1,000 ms
- Performance Requirement :
-----------------------------------------------------------------------------*/
#define  N_Cr                            ((uint32_t)150)

/******************************************************************************
For debug purpose
******************************************************************************/
/*-----------------------------------------------------------------------------
Global debug switch
-----------------------------------------------------------------------------*/
#define  DOCAN_DEBUG_EN                                0

/*-----------------------------------------------------------------------------
Bug indicator functions
-----------------------------------------------------------------------------*/
#if      DOCAN_DEBUG_EN
#define  LINK_RX_FIFO_OVERFLOW_INDICATOR()
#endif

#endif