
#ifndef _SOUND_LIST_H_
#define _SOUND_LIST_H_

#include "Sound_Source.h"

#define   SND_TOTAL_NUMBER                  32

/******************************************************************************
б
******************************************************************************/
enum SoundName
{
   SND_HI_COOLANT_TEMP_SPEED=0x00,           // 
   SND_HI_PRESSURE_SPEED     ,           // 
   SND_CAN_ERROR_SPEED       ,           // 
   SND_LOW_ADBLUE_SPEED      ,           // 
   SND_ADBLUE_ERROR          ,
   SND_RADAR_1Hz             ,           //״1Hz
   SND_RADAR_2Hz             ,           //״2Hz
   SND_RADAR_4Hz             ,           //״4Hz
   SND_RADAR_CONTINUOUS      ,           //״ﳤ,
   SND_RADAR_SYSTEM_FAILURE  ,           //ϵͳ
   SND_YOUTIPIAN_ERROR       ,
   SND_LF_HOOVES_ERROR       ,
   SND_RF_HOOVES_ERROR       ,
   SND_LR_HOOVES_ERROR       ,
   SND_RR_HOOVES_ERROR       ,
   SND_LOW_OIL_SPEED         ,           // 
   SND_LOW_FUEL_SPEED        ,           // 
   SND_TICK                  ,           //ת
   SND_TOCK                  ,           //ת
   SND_SEATBELT_SPEED        ,           //ȫ
   SND_LOW_PBRAKE_SPEED      ,           //ƶҺλ
   SND_PPARK_SPEED           ,           //פƶ
   SND_DOOR_OPENED           ,           //ſ
   SND_PTO                  ,           //
   SND_noKeyInCar           ,           // Կײڳ
   SND_POffWithoutN         ,           // δN µ
   SND_LockWithKeyInCar      ,           // ʱԿڳ
   SND_BreakPressure         ,           // ƶѹ
   SND_OVER_SPEED            ,
   SND_AEB                   ,
   SND_Break_down            ,
   SND_CNG_GasLeak           ,
};

/******************************************************************************
αб
******************************************************************************/
#define   SND_NONE                          0xFF
#define   SND_RADAR                         SND_RADAR_1Hz
#define   SND_FASTEN_SEATBELT               SND_RADAR_CONTINUOUS


/******************************************************************************
Խṹ
******************************************************************************/
typedef struct
{
  uint8_t Src;    //Դ
  uint8_t Type;   //
} SoundAttributeStruct;

#define   SND_TYPE_NORMAL                   0x00    //ͨ
#define   SND_TYPE_MULTI                    0x01    //ɶδ
#define   SND_TYPE_RADAR                    0x02    //״
#define   SND_TYPE_SEATBELT                 0x03    //ȫ

/******************************************************************************
б
******************************************************************************/
static const SoundAttributeStruct SoundList[] =
{
  /*=====================================================================================
                           |              Դ              |        ģʽ
  -------------------------------------------------------------------------------------*/
  { /* SND_HI_COOLANT_TEMP_SPEED 0*/   SND_HI_COOLANT_TEMP_SPEED1,    SND_TYPE_NORMAL,},
  { /* SND_HI_PRESSURE_SPEED     1*/   SND_HI_PRESSURE_SPEED1,        SND_TYPE_NORMAL,},
  { /* SND_CAN_ERROR_SPEED       2*/   SND_CAN_ERROR_SPEED1,          SND_TYPE_NORMAL,},
  { /* SND_LOW_ADBLUE_SPEED      3*/   SND_LOW_ADBLUE_SPEED1,         SND_TYPE_NORMAL,},
  { /* SND_ADBLUE_ERROR          4*/   SND_ADBLUE_ERROR1,             SND_TYPE_NORMAL,},  
  { /* SND_RADAR_1Hz             5*/   SND_RADAR_1Hz,                 SND_TYPE_RADAR ,},
  { /* SND_RADAR_2Hz             6*/   SND_RADAR_2Hz,                 SND_TYPE_RADAR ,},
  { /* SND_RADAR_4Hz             7*/   SND_RADAR_4Hz,                 SND_TYPE_RADAR ,},
  { /* SND_RADAR_CONTINUOUS      8*/   SND_RADAR_CONTINUOUS,          SND_TYPE_RADAR ,},
  { /*                           9*/   SND_RADAR_SYSTEM_FAILURE,      SND_TYPE_RADAR ,},
  { /* SND_YOUTIPIAN_ERROR      10*/   SND_YOUTIPIAN_ERROR1 ,         SND_TYPE_NORMAL,}, 
  { /*                          11*/   SND_LF_HOOVES_ERROR1 ,         SND_TYPE_NORMAL,},
  { /*                          12*/   SND_RF_HOOVES_ERROR1 ,         SND_TYPE_NORMAL,},
  { /*                          13*/   SND_LR_HOOVES_ERROR1 ,         SND_TYPE_NORMAL,},
  { /*                          14*/   SND_RR_HOOVES_ERROR1 ,         SND_TYPE_NORMAL,},
  { /* SND_LOW_OIL_SPEED        15*/   SND_LOW_OIL_SPEED1,            SND_TYPE_NORMAL,},
  { /* SND_LOW_FUEL_SPEED       16*/   SND_LOW_FUEL_SPEED1,           SND_TYPE_NORMAL,},
  { /* SND_TICK                 17*/   SND_SRC_TICK,                  SND_TYPE_NORMAL,},
  { /* SND_TOCK                 18*/   SND_SRC_TOCK,                  SND_TYPE_NORMAL,},
  { /* SND_SEATBELT_SPEED       19*/   SND_SEATBELT_SPEED1,           SND_TYPE_NORMAL,},
  { /* SND_LOW_PBRAKE_SPEED     20*/   SND_LOW_PBRAKE_SPEED1,         SND_TYPE_NORMAL,},
  { /* SND_PPARK_SPEED          21*/   SND_PPARK_SPEED1 ,             SND_TYPE_NORMAL,},
  { /* SND_DOOR_OPENED          22*/   SND_DOOR_OPENED1 ,             SND_TYPE_NORMAL,},
  { /* SND_PTO                  23*/   SND_PTO1 ,                     SND_TYPE_NORMAL,},
  { /* SND_noKeyInCar           24*/   SND_noKeyInCar1 ,              SND_TYPE_NORMAL,},
  { /* SND_POffWithoutN         25*/   SND_POffWithoutN1 ,            SND_TYPE_NORMAL,},
  { /* SND_LockWithKeyInCar     26*/   SND_LockWithKeyInCar1 ,        SND_TYPE_NORMAL,},
  { /* SND_BreakPressure        27*/   SND_BreakPressure1 ,           SND_TYPE_NORMAL,},
  { /* SND_OVER_SPEED           28*/   SND_OVER_SPEED1 ,              SND_TYPE_NORMAL,},
  { /* SND_OVER_SPEED           29*/   SND_SRC_AEB ,                  SND_TYPE_NORMAL,},
  { /* SND_Break_down           30*/   SND_SRC_Break_down ,           SND_TYPE_NORMAL,},
  { /* SND_CNG_GasLeak          31*/   SND_SRC_CNG_GasLeak ,          SND_TYPE_NORMAL,},
  /*====================================================================================*/
};

#endif