#include "Unit_Conv.h"

//==============================================
//	tempc = C
//	return = F
//==============================================
unsigned int Unit_Conv_C_To_F(unsigned int TempC)
{
  unsigned long	TempF;
  unsigned long	Val;

  Val   = (unsigned long)TempC;
  TempF = 32 + (Val * 18) / 10;

  return (unsigned int)TempF;
}

//==============================================
//	kpa = kpa
//  return = 10bar(Сһλ)
//==============================================
unsigned int Unit_Conv_kPa_To_bar(unsigned int kPa)
{
  return kPa / 10;
}

//==============================================
//	kpa = kpa
//	return = psi
//==============================================
unsigned int Unit_Conv_kPa_To_psi(unsigned int kPa)
{
  unsigned long	psi;
  unsigned long	Val;

  Val = (unsigned long)kPa;
  psi = (Val * 145) / 1000;

  return (unsigned int)psi;
}


//==============================================
//	km = km
//	return = mile
//==============================================
unsigned long Unit_Conv_km_To_mile(unsigned long km)
{

  if(km * 3940 / 634 % 10 > 5)

    return (km * 394 / 634) + 1;        //mile = km *  3937 / 6336
  else
    return km * 394 / 634;
}

//==============================================
//	mile = mile
//	return = km
//==============================================
unsigned long Unit_Conv_mile_To_km(unsigned long mile)
{
  return mile * 634 / 394;          //mile = km * 6336 / 3937
}

//==============================================
//	L_100km = 10L/100km (Сһλ))
//	return  = 10km/L (Сһλ)
//==============================================
unsigned int Unit_Conv_L_100km_To_km_L(unsigned int L_100km)
{
  unsigned long	km_L;
  unsigned long	Val;

  if(L_100km == 0)
    return 0xFFFF;

  Val  = (unsigned long)L_100km;
  km_L = 10000 / Val ;

  return (unsigned int)km_L;
}

//==============================================
//	L_100km = 10L/100km (Сһλ)
//	return = 10mpg(US)(Сһλ)
//==============================================
unsigned int Unit_Conv_L_100km_To_mpg_US(unsigned int L_100km)
{
  unsigned long	mpg_US;
  unsigned long	Val;

  if(L_100km == 0)
    return 0xFFFF;

  Val    = (unsigned long)L_100km;
  mpg_US = 23500 / Val ;

  return (unsigned int)mpg_US;
}

//==============================================
//	L_100km = 10L/100km (Сһλ)
//	return = 10mpg(UK)(Сһλ)
//==============================================
unsigned int Unit_Conv_L_100km_To_mpg_UK(unsigned int L_100km)
{
  unsigned long	mpg_UK;
  unsigned long	Val;

  if(L_100km == 0)
    return 0xFFFF;

  Val    = (unsigned long)L_100km;
  mpg_UK = 28200 / Val ;

  return (unsigned int)mpg_UK;
}
