/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.OS2Table;
import com.google.typography.font.tools.conversion.eot.MtxWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class EOTWriter {
    private final boolean compressed;
    private final FontFactory factory = FontFactory.getInstance();
    private static final long RESERVED = 0L;
    private static final short PADDING = 0;
    private static final long VERSION = 131074L;
    private static final short MAGIC_NUMBER = 20556;
    private static final long DEFAULT_FLAGS = 0L;
    private static final long FLAGS_TT_COMPRESSED = 4L;
    private static final byte DEFAULT_CHARSET = 1;
    private static final long CS_XORKEY = 1346851650L;

    public EOTWriter() {
        this.compressed = false;
    }

    public EOTWriter(boolean compressed) {
        this.compressed = compressed;
    }

    public WritableFontData convert(Font font) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.factory.serializeFont(font, baos);
        byte[] fontData = baos.toByteArray();
        NameTable name = (NameTable)font.getTable(Tag.name);
        byte[] familyName = this.convertUTF16StringToLittleEndian(name.nameAsBytes(3, 1, 1033, 1));
        byte[] styleName = this.convertUTF16StringToLittleEndian(name.nameAsBytes(3, 1, 1033, 2));
        byte[] versionName = this.convertUTF16StringToLittleEndian(name.nameAsBytes(3, 1, 1033, 5));
        byte[] fullName = this.convertUTF16StringToLittleEndian(name.nameAsBytes(3, 1, 1033, 4));
        long flags = 0L;
        if (this.compressed) {
            flags |= 4L;
            MtxWriter mtxWriter = new MtxWriter();
            fontData = mtxWriter.compress(font);
        }
        long eotSize = this.computeEotSize(familyName.length, styleName.length, versionName.length, fullName.length, fontData.length);
        WritableFontData writableFontData = this.createWritableFontData((int)eotSize);
        OS2Table os2Table = (OS2Table)font.getTable(Tag.OS_2);
        int index = 0;
        index += writableFontData.writeULongLE(index, eotSize);
        index += writableFontData.writeULongLE(index, fontData.length);
        index += writableFontData.writeULongLE(index, 131074L);
        index += writableFontData.writeULongLE(index, flags);
        index += this.writeFontPANOSE(index, os2Table, writableFontData);
        index += writableFontData.writeByte(index, (byte)1);
        index += writableFontData.writeByte(index, (byte)(os2Table.fsSelectionAsInt() & 1));
        index += writableFontData.writeULongLE(index, os2Table.usWeightClass());
        index += writableFontData.writeUShortLE(index, (short)os2Table.fsTypeAsInt());
        index += writableFontData.writeUShortLE(index, 20556);
        index += this.writeUnicodeRanges(index, os2Table, writableFontData);
        index += this.writeCodePages(index, os2Table, writableFontData);
        FontHeaderTable head = (FontHeaderTable)font.getTable(Tag.head);
        index += writableFontData.writeULongLE(index, head.checkSumAdjustment());
        index += this.writeReservedFields(index, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += this.writeUTF16String(index, familyName, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += this.writeUTF16String(index, styleName, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += this.writeUTF16String(index, versionName, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += this.writeUTF16String(index, fullName, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += writableFontData.writeULongLE(index, 1346851650L);
        index += writableFontData.writeULongLE(index, 0L);
        index += this.writePadding(index, writableFontData);
        index += this.writePadding(index, writableFontData);
        index += writableFontData.writeULongLE(index, 0L);
        index += writableFontData.writeULongLE(index, 0L);
        writableFontData.writeBytes(index, fontData, 0, fontData.length);
        return writableFontData;
    }

    private long computeEotSize(int familyNameSize, int styleNameSize, int versionNameSize, int fullNameSize, int fontDataSize) {
        return 16 * FontData.DataSize.ULONG.size() + 12 * FontData.DataSize.BYTE.size() + 12 * FontData.DataSize.USHORT.size() + familyNameSize * FontData.DataSize.BYTE.size() + styleNameSize * FontData.DataSize.BYTE.size() + versionNameSize * FontData.DataSize.BYTE.size() + fullNameSize * FontData.DataSize.BYTE.size() + fontDataSize * FontData.DataSize.BYTE.size() + 5 * FontData.DataSize.ULONG.size();
    }

    private int writeFontPANOSE(int index, OS2Table os2Table, WritableFontData writableFontData) {
        byte[] fontPANOSE = os2Table.panose();
        return writableFontData.writeBytes(index, fontPANOSE, 0, fontPANOSE.length);
    }

    private int writeReservedFields(int start, WritableFontData writableFontData) {
        int index = start;
        int i = 0;
        while (i < 4) {
            index += writableFontData.writeULongLE(index, 0L);
            ++i;
        }
        return index - start;
    }

    private int writeUnicodeRanges(int start, OS2Table os2Table, WritableFontData writableFontData) {
        int index = start;
        index += writableFontData.writeULongLE(index, os2Table.ulUnicodeRange1());
        index += writableFontData.writeULongLE(index, os2Table.ulUnicodeRange2());
        index += writableFontData.writeULongLE(index, os2Table.ulUnicodeRange3());
        index += writableFontData.writeULongLE(index, os2Table.ulUnicodeRange4());
        return index - start;
    }

    private int writeCodePages(int start, OS2Table os2Table, WritableFontData writableFontData) {
        int index = start;
        if (os2Table.tableVersion() >= 1) {
            index += writableFontData.writeULongLE(index, os2Table.ulCodePageRange1());
            index += writableFontData.writeULongLE(index, os2Table.ulCodePageRange2());
        } else {
            index += writableFontData.writeULongLE(index, 1L);
            index += writableFontData.writeULongLE(index, 0L);
        }
        return index - start;
    }

    private int writePadding(int index, WritableFontData writableFontData) {
        return writableFontData.writeUShortLE(index, 0);
    }

    private int writeUTF16String(int start, byte[] str, WritableFontData writableFontData) {
        int index = start;
        index += writableFontData.writeUShortLE(index, (short)str.length);
        index += writableFontData.writeBytes(index, str, 0, str.length);
        return index - start;
    }

    private byte[] convertUTF16StringToLittleEndian(byte[] bytesString) {
        if (bytesString == null) {
            return new byte[0];
        }
        int i = 0;
        while (i < bytesString.length) {
            byte tmp = bytesString[i];
            bytesString[i] = bytesString[i + 1];
            bytesString[i + 1] = tmp;
            i += 2;
        }
        return bytesString;
    }

    private WritableFontData createWritableFontData(int length) {
        return WritableFontData.createWritableFontData(length);
    }
}

