/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapFormat4;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.testutils.TestFont;
import com.google.typography.font.sfntly.testutils.TestFontUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class CMapEditingTests
extends TestCase {
    private static final boolean DEBUG = false;
    private static final File TEST_FONT_FILE = TestFont.TestFontNames.OPENSANS.getFile();

    public CMapEditingTests() {
    }

    public CMapEditingTests(String name) {
        super(name);
    }

    public void testRemoveAllButOneCMap() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        CMapTable.Builder cmapTableBuilder = (CMapTable.Builder)fontBuilder.getTableBuilder(Tag.cmap);
        Iterator<? extends CMap.Builder<? extends CMap>> cmapBuilderIter = cmapTableBuilder.iterator();
        while (cmapBuilderIter.hasNext()) {
            CMap.Builder<? extends CMap> cmapBuilder = cmapBuilderIter.next();
            if (cmapBuilder.cmapId().equals(CMapTable.CMapId.WINDOWS_BMP)) continue;
            cmapBuilderIter.remove();
        }
        Font font = fontBuilder.build();
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        CMapEditingTests.assertEquals(1, cmapTable.numCMaps());
        CMap cmap = cmapTable.cmap(CMapTable.CMapId.WINDOWS_BMP);
        CMapEditingTests.assertEquals(CMapTable.CMapId.WINDOWS_BMP, cmap.cmapId());
    }

    public void testCopyAllCMapToNewFont() throws Exception {
        FontFactory factory = FontFactory.getInstance();
        Font font = TestFontUtils.loadFont(TEST_FONT_FILE)[0];
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        Font.Builder fontBuilder = factory.newFontBuilder();
        CMapTable.Builder cmapTableBuilder = (CMapTable.Builder)fontBuilder.newTableBuilder(Tag.cmap);
        for (CMap cmap : cmapTable) {
            cmapTableBuilder.newCMapBuilder(cmap.cmapId(), cmap.readFontData());
        }
        Font newFont = fontBuilder.build();
        CMapTable newCMapTable = (CMapTable)font.getTable(Tag.cmap);
        CMapEditingTests.assertEquals(cmapTable.numCMaps(), newCMapTable.numCMaps());
        CMap cmap = cmapTable.cmap(CMapTable.CMapId.WINDOWS_BMP);
        CMapEditingTests.assertEquals(CMapTable.CMapId.WINDOWS_BMP, cmap.cmapId());
    }

    public void testCMap4WithNoEditing() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        CMapTable.Builder cmapTableBuilder = (CMapTable.Builder)fontBuilder.getTableBuilder(Tag.cmap);
        CMap.Builder<? extends CMap> cmapBuilder = cmapTableBuilder.cmapBuilder(CMapTable.CMapId.WINDOWS_BMP);
        CMapEditingTests.assertEquals((Object)cmapBuilder.format(), (Object)CMap.CMapFormat.Format4);
        Font newFont = fontBuilder.build();
        CMapTable newCMapTable = (CMapTable)newFont.getTable(Tag.cmap);
        CMap newCMap = newCMapTable.cmap(CMapTable.CMapId.WINDOWS_BMP);
        CMapEditingTests.assertNotNull(newCMap);
    }

    public void testCMap4Editing() throws Exception {
        Font.Builder fontBuilder = TestFontUtils.builderForFontFile(TEST_FONT_FILE);
        CMapTable.Builder cmapTableBuilder = (CMapTable.Builder)fontBuilder.getTableBuilder(Tag.cmap);
        CMap.Builder<? extends CMap> cmapBuilder = cmapTableBuilder.cmapBuilder(CMapTable.CMapId.WINDOWS_BMP);
        if (cmapBuilder.format() != CMap.CMapFormat.Format4) {
            CMapEditingTests.fail("Windows BMP CMap is not Format 4.");
        }
        CMapFormat4.Builder cmapFormat4Builder = (CMapFormat4.Builder)cmapBuilder;
        List<CMapFormat4.Builder.Segment> segments = cmapFormat4Builder.getSegments();
        List<Integer> glyphIdArray = cmapFormat4Builder.getGlyphIdArray();
        int segmentModified = -1;
        int newStartCode = 100;
        int newIdDelta = 0;
        int i = 0;
        while (i < segments.size()) {
            CMapFormat4.Builder.Segment segment = segments.get(i);
            if (97 > segment.getStartCount() && 97 < segment.getEndCount()) {
                segmentModified = i;
                newIdDelta = segment.getIdDelta() + 1;
                segment.setIdDelta(newIdDelta);
                segment.setStartCount(newStartCode);
            }
            ++i;
        }
        cmapFormat4Builder.setSegments(segments);
        Font newFont = fontBuilder.build();
        CMapTable newCMapTable = (CMapTable)newFont.getTable(Tag.cmap);
        CMap newCMap = newCMapTable.cmap(CMapTable.CMapId.WINDOWS_BMP);
        CMapEditingTests.assertEquals(CMap.CMapFormat.Format4.value(), newCMap.format());
        CMapEditingTests.assertTrue(segmentModified >= 0);
        CMapFormat4 cmap4 = (CMapFormat4)newCMap;
        CMapEditingTests.assertEquals(newStartCode, cmap4.startCode(segmentModified));
        CMapEditingTests.assertEquals(newIdDelta, cmap4.idDelta(segmentModified));
    }
}

