/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.testutils.TestUtils;
import junit.framework.TestCase;

public class FontDataTests
extends TestCase {
    private static final int[] BYTE_ARRAY_SIZES = new int[]{1, 7, 127, 128, 129, 255, 256, 257, 666, 1023, 65536};
    private static final int[] LOWER_BYTE_ARRAY_FOR_SEARCHING = new int[]{2, 4, 7, 13, 127};
    private static final int[] UPPER_BYTE_ARRAY_FOR_SEARCHING = new int[]{2, 5, 12, 16, 256};
    private static final int[][] SEARCH_TEST_PAIRS;
    private static final int[][] SEARCH_TEST_OFFSETS;
    private static final int SLICING_READWRITE_TEST_BUFFER_TRIM_FRACTION_DENOMINATOR = 21;
    private static final int TEST_READWRITE_BUFFER_INCREMENT_FRACTION_OF_ORIGINAL = 11;

    static {
        int[][] nArrayArray = new int[15][];
        int[] nArray = new int[2];
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, -1};
        int[] nArray2 = new int[2];
        nArray2[0] = 2;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{3, -1};
        nArrayArray[4] = new int[]{4, 1};
        nArrayArray[5] = new int[]{5, 1};
        nArrayArray[6] = new int[]{6, -1};
        nArrayArray[7] = new int[]{12, 2};
        nArrayArray[8] = new int[]{13, 3};
        nArrayArray[9] = new int[]{17, -1};
        nArrayArray[10] = new int[]{126, -1};
        nArrayArray[11] = new int[]{127, 4};
        nArrayArray[12] = new int[]{256, 4};
        nArrayArray[13] = new int[]{257, -1};
        nArrayArray[14] = new int[]{4096, -1};
        SEARCH_TEST_PAIRS = nArrayArray;
        int[][] nArrayArray2 = new int[4][];
        int[] nArray3 = new int[5];
        nArray3[0] = (LOWER_BYTE_ARRAY_FOR_SEARCHING.length + UPPER_BYTE_ARRAY_FOR_SEARCHING.length) * FontData.DataSize.USHORT.size();
        nArray3[2] = FontData.DataSize.USHORT.size();
        nArray3[3] = LOWER_BYTE_ARRAY_FOR_SEARCHING.length * FontData.DataSize.USHORT.size();
        nArray3[4] = FontData.DataSize.USHORT.size();
        nArrayArray2[0] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[0] = (LOWER_BYTE_ARRAY_FOR_SEARCHING.length + UPPER_BYTE_ARRAY_FOR_SEARCHING.length) * FontData.DataSize.USHORT.size();
        nArray4[2] = 2 * FontData.DataSize.USHORT.size();
        nArray4[3] = FontData.DataSize.USHORT.size();
        nArray4[4] = 2 * FontData.DataSize.USHORT.size();
        nArrayArray2[1] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[0] = (LOWER_BYTE_ARRAY_FOR_SEARCHING.length + UPPER_BYTE_ARRAY_FOR_SEARCHING.length) * FontData.DataSize.USHORT.size();
        nArray5[1] = LOWER_BYTE_ARRAY_FOR_SEARCHING.length * FontData.DataSize.USHORT.size();
        nArray5[2] = FontData.DataSize.USHORT.size();
        nArray5[4] = FontData.DataSize.USHORT.size();
        nArrayArray2[2] = nArray5;
        int[] nArray6 = new int[5];
        nArray6[0] = (LOWER_BYTE_ARRAY_FOR_SEARCHING.length + UPPER_BYTE_ARRAY_FOR_SEARCHING.length) * FontData.DataSize.USHORT.size();
        nArray6[1] = FontData.DataSize.USHORT.size();
        nArray6[2] = 2 * FontData.DataSize.USHORT.size();
        nArray6[4] = 2 * FontData.DataSize.USHORT.size();
        nArrayArray2[3] = nArray6;
        SEARCH_TEST_OFFSETS = nArrayArray2;
    }

    public void testReadableFontData() throws Exception {
        int[] nArray = BYTE_ARRAY_SIZES;
        int n = BYTE_ARRAY_SIZES.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            WritableFontData rfd = FontDataTests.fillTestWFD(WritableFontData.createWritableFontData(size), size);
            this.slicingReadTest(rfd);
            ++n2;
        }
    }

    public void testReadableFontDataSearching() throws Exception {
        int[][] nArray = SEARCH_TEST_OFFSETS;
        int n = SEARCH_TEST_OFFSETS.length;
        int n2 = 0;
        while (n2 < n) {
            int[] arraySetupOffsets = nArray[n2];
            WritableFontData wfd = WritableFontData.createWritableFontData(arraySetupOffsets[0]);
            FontDataTests.fillTestFontDataWithShortsForSearching(wfd, LOWER_BYTE_ARRAY_FOR_SEARCHING, arraySetupOffsets[1], arraySetupOffsets[2], UPPER_BYTE_ARRAY_FOR_SEARCHING, arraySetupOffsets[3], arraySetupOffsets[4]);
            int[][] nArray2 = SEARCH_TEST_PAIRS;
            int n3 = SEARCH_TEST_PAIRS.length;
            int n4 = 0;
            while (n4 < n3) {
                int[] testCase = nArray2[n4];
                int found = wfd.searchUShort(arraySetupOffsets[1], arraySetupOffsets[2], arraySetupOffsets[3], arraySetupOffsets[4], LOWER_BYTE_ARRAY_FOR_SEARCHING.length, testCase[0]);
                FontDataTests.assertEquals(testCase[1], found);
                ++n4;
            }
            ++n2;
        }
    }

    public void testWritableFontData() throws Exception {
        WritableFontData wfd;
        int size;
        int[] nArray = BYTE_ARRAY_SIZES;
        int n = BYTE_ARRAY_SIZES.length;
        int n2 = 0;
        while (n2 < n) {
            size = nArray[n2];
            wfd = WritableFontData.createWritableFontData(size);
            FontDataTests.fillTestWFD(wfd, size);
            this.slicingReadTest(wfd);
            this.slicingWriteTest(wfd, WritableFontData.createWritableFontData(size));
            ++n2;
        }
        nArray = BYTE_ARRAY_SIZES;
        n = BYTE_ARRAY_SIZES.length;
        n2 = 0;
        while (n2 < n) {
            size = nArray[n2];
            wfd = WritableFontData.createWritableFontData(0);
            FontDataTests.fillTestWFD(wfd, size);
            this.slicingReadTest(wfd);
            this.slicingWriteTest(wfd, WritableFontData.createWritableFontData(0));
            ++n2;
        }
    }

    private void slicingReadTest(ReadableFontData rfd) throws Exception {
        int trim = 0;
        while (trim < rfd.length() / 2 + 1) {
            int length = rfd.length() - 2 * trim;
            ReadableFontData slice = rfd.slice(trim, length);
            this.readComparison(trim, length, rfd, slice);
            trim += rfd.length() / 21 + 1;
        }
    }

    private void slicingWriteTest(ReadableFontData rfd, WritableFontData wfd) throws Exception {
        int trim = 0;
        while (trim < rfd.length() / 2 + 1) {
            int length = rfd.length() - 2 * trim;
            WritableFontData slice = null;
            slice = wfd.slice(trim, length);
            FontDataTests.writeFontDataWithSingleByte(rfd.slice(trim, length), slice);
            this.readComparison(trim, length, rfd, slice);
            int increments = Math.max(length / 11, 1);
            int bufferSize = 1;
            while (bufferSize < length) {
                slice = wfd.slice(trim, length);
                FontDataTests.writeFontDataWithBuffer(rfd.slice(trim, length), slice, bufferSize);
                this.readComparison(trim, length, rfd, slice);
                bufferSize += increments;
            }
            int windowSize = 1;
            while (windowSize < length) {
                slice = wfd.slice(trim, length);
                FontDataTests.writeFontDataWithSlidingWindow(rfd.slice(trim, length), slice, windowSize);
                this.readComparison(trim, length, rfd, slice);
                windowSize += increments;
            }
            trim += rfd.length() / 21 + 1;
        }
    }

    private void readComparison(int offset, int length, ReadableFontData rfd1, ReadableFontData rfd2) throws Exception {
        FontDataTests.assertEquals(length, rfd2.length());
        byte[] b1 = FontDataTests.readFontDataWithSingleByte(rfd1);
        byte[] b2 = FontDataTests.readFontDataWithSingleByte(rfd2);
        FontDataTests.assertTrue(TestUtils.equals(b1, offset, b2, 0, length));
        int increments = Math.max(length / 11, 1);
        int bufferSize = 1;
        while (bufferSize <= length) {
            b1 = FontDataTests.readFontDataWithBuffer(rfd1, bufferSize);
            b2 = FontDataTests.readFontDataWithBuffer(rfd2, bufferSize);
            FontDataTests.assertTrue(TestUtils.equals(b1, offset, b2, 0, length));
            bufferSize += increments;
        }
        int windowSize = 1;
        while (windowSize <= length) {
            b1 = FontDataTests.readFontDataWithSlidingWindow(rfd1, windowSize);
            b2 = FontDataTests.readFontDataWithSlidingWindow(rfd2, windowSize);
            FontDataTests.assertTrue(TestUtils.equals(b1, offset, b2, 0, length));
            windowSize += increments;
        }
    }

    private static byte[] readFontDataWithBuffer(ReadableFontData rfd, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        byte[] b = new byte[rfd.length()];
        int index = 0;
        while (index < rfd.length()) {
            int bytesRead = rfd.readBytes(index, buffer, 0, buffer.length);
            System.arraycopy(buffer, 0, b, index, bytesRead);
            index += bytesRead;
        }
        return b;
    }

    private static byte[] readFontDataWithSlidingWindow(ReadableFontData rfd, int windowSize) {
        byte[] b = new byte[rfd.length()];
        int index = 0;
        while (index < rfd.length()) {
            windowSize = Math.min(windowSize, b.length - index);
            int bytesRead = rfd.readBytes(index, b, index, windowSize);
            index += bytesRead;
        }
        return b;
    }

    private static byte[] readFontDataWithSingleByte(ReadableFontData rfd) {
        byte[] b = new byte[rfd.length()];
        int index = 0;
        while (index < rfd.length()) {
            b[index] = (byte)rfd.readByte(index);
            ++index;
        }
        return b;
    }

    private static void writeFontDataWithBuffer(ReadableFontData rfd, WritableFontData wfd, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        int index = 0;
        while (index < rfd.length()) {
            int bytesRead = rfd.readBytes(index, buffer, 0, buffer.length);
            wfd.writeBytes(index, buffer, 0, buffer.length);
            index += bytesRead;
        }
    }

    private static void writeFontDataWithSlidingWindow(ReadableFontData rfd, WritableFontData wfd, int windowSize) {
        byte[] b = new byte[rfd.length()];
        int index = 0;
        while (index < rfd.length()) {
            windowSize = Math.min(windowSize, b.length - index);
            int bytesRead = rfd.readBytes(index, b, index, windowSize);
            wfd.writeBytes(index, b, index, bytesRead);
            index += bytesRead;
        }
    }

    private static void writeFontDataWithSingleByte(ReadableFontData rfd, WritableFontData wfd) {
        int index = 0;
        while (index < rfd.length()) {
            byte b = (byte)rfd.readByte(index);
            wfd.writeByte(index, b);
            ++index;
        }
    }

    private static WritableFontData fillTestWFD(WritableFontData wfd, int size) {
        int i = 0;
        while (i < size) {
            wfd.writeByte(i, (byte)(i % 256));
            ++i;
        }
        return wfd;
    }

    private static ReadableFontData fillTestFontDataWithShortsForSearching(WritableFontData wfd, int[] lowerData, int lowerStartIndex, int lowerOffset, int[] upperData, int upperStartIndex, int upperOffset) {
        int d;
        int offset = lowerStartIndex;
        int[] nArray = lowerData;
        int n = lowerData.length;
        int n2 = 0;
        while (n2 < n) {
            d = nArray[n2];
            wfd.writeUShort(offset, d);
            offset += lowerOffset;
            ++n2;
        }
        offset = upperStartIndex;
        nArray = upperData;
        n = upperData.length;
        n2 = 0;
        while (n2 < n) {
            d = nArray[n2];
            wfd.writeUShort(offset, d);
            offset += upperOffset;
            ++n2;
        }
        return wfd;
    }
}

