#ifndef _NM_CFG_H_
#define _NM_CFG_H_



typedef struct {
	unsigned int AppId;
	unsigned int AppCycleTime;  //unit:ms
	unsigned int AppCycleTimeMax;  //unit:ms
	unsigned char AppLen;
	unsigned char AppData[8];
}_AppMsgTime;

#define VoltUpCh0Limit 1820  //18.2V
#define VoltDownCh0Limit 680   //6.8V
	
#define VoltUpCh1Limit 1820  //18.2V
#define VoltDownCh1Limit 680   //6.8V

typedef enum {
	NM_STATE_LIMPHOME_MAIN,
	NM_STATE_NORMAL_MAIN,
	NM_STATE_TWBSNORMAL_MAIN,
	NM_STATE_NORMALPREPSLEEP_MAIN,
	NM_STATE_BUSSLEEP_MAIN,
	NM_STATE_LIMPHOMEPREPSLEEP_MAIN,
	NM_STATE_TWBSLIMPHOME_MAIN,
	NM_STATE_RESET_MAIN,
	NM_STATE_DO_NOTHING,
}_NM_STATE;


typedef struct {
	unsigned int RecoverTime;
	unsigned char RecoverCnt;
}_NM_BusOffCtlInfo;

typedef struct {
  unsigned int NmIdBase;                    //default:0x400
  unsigned int NmIdBottom;                  //default:0x4ff
  unsigned char NmIdOwn;                    //default:0x4;
  unsigned char NmRxLimit;                  //default:0x4
  unsigned char NmTxLimit;                  //default:0x8
  unsigned int NmTimeType;                  //default:100,unit:ms
  unsigned int NmTimeMax;                   //default:260,unit:ms
  unsigned int NmTimeError;                 //default:1000,unit:ms
  unsigned int NmTimeWaitBusSleep;          //default:1500,unit:ms
  unsigned int NmTimeRequestSleepInd;       //default:5000,unit:ms
  unsigned char NmTimeRequestLimpSleepInd;  //default:4
}OSEK_NM_INIT;

typedef struct { 
  volatile _NetWorkStatus NmNetWorkStatus;          //NetWorkStatus
  volatile _NM_STATE NmState;                       //NM_State
  volatile unsigned char NmTaskLock;                //NM_Task_Lock
	volatile unsigned int NmIdBase;                   //#define NM_CAN_ID_BASE 0x400
	volatile unsigned int NmIdBottom;                 //#define NM_CAN_ID_BOTTOM 0x4FF
	volatile unsigned char NmIdOwn;                   //#define OWN_NODE_CHL0 0x04
	volatile unsigned char NmLastSendPDUType;         //NM_LastSend_PDU_Type
	volatile unsigned char NmDestination;             //NM_Destination
	volatile unsigned int NmCanLastId;                //NM_LAST_ID
	volatile unsigned int NmRxErrCount;               //NM_rx_err_count                                          
	volatile unsigned int NmTxErrCount;               //NM_tx_err_count
	volatile unsigned char NmTxState;                 //NM_TX_STATE
	volatile unsigned char NmRxState;                 //NM_RX_STATE
	volatile unsigned char NmErrState;                //NM_ER_STATE
	volatile unsigned char NmRxLimit;                 //#define NM_RX_LIMIT 4
	volatile unsigned char NmTxLimit;                 //#define NM_TX_LIMIT 8 
	volatile unsigned int NmTimeType;                 //#define NM_Time_Type 100
	volatile unsigned int NmTimeMax;                  //#define NM_Time_Max 260
	volatile unsigned int NmTimeError;                //#define NM_Time_Error 1000
	volatile unsigned int NmTimeWaitBusSleep;         //#define NM_Time_WaitBusSleep 1500
	volatile unsigned int NmTimeRequestSleepInd;      //#define NM_Time_RequestSleepInd 5000
	volatile unsigned char NmTimeRequestLimpSleepInd; //#define NM_Time_RequestLimpSleepInd 4
	volatile _NM_BusOffCtlInfo NmBusOffCtrl;          //NM_BusOffCtl;
  volatile unsigned char NmLimpHomeTxCnt;           //LimpHomeTxCnt
  volatile unsigned char NmResetContinueCallCnt;    //NM_ResetContinueCallCnt
  volatile _SleepStatus NmSleep;                    //NM_Sleep
  volatile _MarkerStatus NmMarker;                  //NM_Marker
  volatile unsigned int NmSleepRequestMin;          //NM_tSleepRequestMin;
  volatile _NMPDU NmRecvPdu;                        //NM_RPDU receive PDU buf
  volatile _NMPDU NmSendPdu;                        //NM_SPDU send PDU buf  
  
	volatile unsigned int NmIdBuf;                    //NM_ID_BUF
  volatile _NMPDU NmPduBuf;                         //NM_PDU_BUF
  
  volatile _NM_TimeInfo NmTime;                     //NM_Time
  void (*NM_Main_Program)(void);
  void (*NMInitReset_Program)(void);
  void (*NMReset_Program)(void);
  
	volatile unsigned char NmIGNState;                //NM_IGN_State
                                       
  volatile unsigned char AppMsgSendRequest;
  volatile _AppMsgTime AppMsg[20];
}OSEK_NM_PARA;

extern OSEK_NM_PARA NmPara;


void InitNM(OSEK_NM_INIT *NmInit);
void SetTxState(unsigned char n);
void SetRxState(unsigned char n);
void SetErrState(unsigned char n);

#endif
