
#ifndef _SOUND_SCHEDULER_H_
#define _SOUND_SCHEDULER_H_

#include "Sound_List.h"
#include "Sound_Player.h"
typedef struct
{
  uint8_t   Current;
  uint8_t   Next;
  uint8_t   ReqCode;
  uint8_t   StopReq;
} SoundSchedulingStruct;

#define   SND_SEATBELT_120s_TIME            117000    //120ʱ,λms
#define   SND_SEATBELT_DISABLE              0x00
#define   SND_SEATBELT_TIMING               0x01
#define   SND_SEATBELT_TIME_UP              0x02
#define   SND_SEATBELT_CONTINUOUS           0x03

typedef struct
{
  uint8_t   DrMode;
  uint8_t   PaMode;
  uint16_t  DrTimer;
  uint16_t  PaTimer;
} SoundSeatbeltCtrlStruct;

void Sound_Scheduler_Init(void);
void Sound_Request(uint8_t Sound, uint8_t ReqCode);
void Sound_Delete(uint8_t Sound);
void Sound_Scheduling_Service(void);

#endif

