
#include    "ISD2360.h"

/******************************************************************************
ISD_Init
  ܣʼISDоƬ
  
ֵ
******************************************************************************/
void ISD_Init(void)
{
  Sim_SPI_Master_Start(SIM_SPI_MODE_3, SIM_SPI_MSB_FIRST);
  
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_RESET_CODE);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Power_Up
  ܣISDоƬԴ
  
ֵ
******************************************************************************/
void ISD_Power_Up(void)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_PWR_UP_CODE);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Power_Down
  ܣرISDоƬԴ
  
ֵ
******************************************************************************/
void ISD_Power_Down(void)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_PWR_DN_CODE);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Play_Vp
  ܣָԴ
  IndexԴ
ֵ
******************************************************************************/
void ISD_Play_Vp(uint16_t Index)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_PLAY_VP_CODE);
  Sim_SPI_Master_Byte_Write((uint8_t)(Index >> 8));
  Sim_SPI_Master_Byte_Write((uint8_t)Index);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Stop
  ܣֹͣ
  
ֵ
******************************************************************************/
void ISD_Stop(void)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_STOP_CODE);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Play_Vp_Loop
  ܣѭָԴ
  Index  Դ
        LoopCntѭŵĴ,0ʾѭ
ֵ
******************************************************************************/
void ISD_Play_Vp_Loop(uint16_t Index, uint16_t LoopCnt)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_PLAY_VP_LP_CODE);
  Sim_SPI_Master_Byte_Write((uint8_t)(Index >> 8));
  Sim_SPI_Master_Byte_Write((uint8_t)Index);
  Sim_SPI_Master_Byte_Write((uint8_t)(LoopCnt >> 8));
  Sim_SPI_Master_Byte_Write((uint8_t)LoopCnt);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Stop_Loop
  ܣֹͣѭ
  
ֵ
******************************************************************************/
void ISD_Stop_Loop(void)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_STOP_LP_CODE);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Set_Volume
  ܣò
  Volume(˥)ֵ,Ϊ0x00(Ĭ)ʱ,Ϊ0xFFʱС
ֵ
******************************************************************************/
void ISD_Set_Volume(uint8_t Volume)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_WR_CFG_REG_CODE);
  Sim_SPI_Master_Byte_Write(0x03);
  Sim_SPI_Master_Byte_Write(Volume);
  AUDIO_nCS = 1;
}

/******************************************************************************
ISD_Select_Channel
  ܣѡ񲥷ͨ
  ChNumѡͨISD_CHANNEL_0(Ĭ)
                           ISD_CHANNEL_1
                           ISD_CHANNEL_2
                           ISD_CHANNEL_ALL
ֵ
******************************************************************************/
void ISD_Select_Channel(uint8_t ChNum)
{
  AUDIO_nCS = 0;
  Sim_SPI_Master_Byte_Write(ISD_WR_CFG_REG_CODE);
  Sim_SPI_Master_Byte_Write(0x0C);
  Sim_SPI_Master_Byte_Write(ChNum);
  AUDIO_nCS = 1;
}
