/******************************************************************************
  DoCAN_ISO15765.c
ISO 15765 淶涨Ϸļ
    ߣ
    V1.0
    ڣ2016.7.18
******************************************************************************/

#include "DoCAN_ISO15765.h"

LinkRxFIFOStruct              LinkRxFIFO;
LinkTxCtrlStruct              LinkTxCtrl;

volatile TransportDataUnion   TransportRxData;
volatile TransportDataUnion   TransportTxData;

N_USDataRxStruct              N_USDataRxBuffer;
N_USDataTxStruct              N_USDataTxBuffer;

TransportControlStruct        TpCtrl;
TransportTimingControlStruct  TpTimingCtrl;

uint8_t DiagnosticReceived;

extern void UDS_N_USData_Confirm (uint32_t N_TAtype, N_ResultEnum N_Result);
extern void UDS_N_USData_FF_Indication(uint32_t N_TAtype, uint16_t Length);
extern void UDS_N_USData_Indication(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length, N_ResultEnum N_Result);

/******************************************************************************
̨
******************************************************************************/
/******************************************************************************
DoCAN_Communication_Service
  ܣCANߵͨŷ̨ƺ
  
ֵ
*******************************************************************************
ע  ⣺÷뱻ʵʱ
******************************************************************************/
void DoCAN_Communication_Service(void)
{
  DoCAN_Update_Timer();                       //ʱº
  DoCAN_Handle_Time_Out();                    //ʱ
  
  DoCAN_Receive_And_Assemble_N_USData();      //N_PDU
  DoCAN_Disassemble_And_Transmit_N_USData();  //ݲΪ֡(CF)ͳȥ
}

/******************************************************************************
DoCAN_Timer_Update
  ܣ¶ʱֵ,ʱԼSTminʱ
  Intervalʱθµʱ,λus
ֵ
*******************************************************************************
ע  ⣺÷뱻Ƕ뵽ʱж
******************************************************************************/
void DoCAN_Timer_Update(uint16_t Interval)
{
  TpTimingCtrl.Cnt += Interval;
}

/******************************************************************************
Services provided by network layer to higher layers
******************************************************************************/
/******************************************************************************
DoCAN_N_USData_Request
  ܣ÷
        This service is used to request the transfer of data. If necessary, the
        network layer segments the data.
  N_TAtype    Ŀַ,ʹ DIAG_ID_Tx
        MessageData 
        Length      ݳ
ֵ
******************************************************************************/
void DoCAN_N_USData_Request(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length)
{
  uint8_t i;
  
  //ǿ״̬²
  if (TpCtrl.Process != TP_IDLE)
  {
    DoCAN_N_USData_Confirm (N_TAtype, N_ERROR);
    return;
  }

  if ((Length == 0) || (Length > N_USDATA_TX_BUFFER_SIZE))     //Ƿĳ
  {
    DoCAN_N_USData_Confirm (N_TAtype, N_ERROR);
    return;
  }
  
  //ݻ浽Buffer
  N_USDataTxBuffer.N_TAtype = N_TAtype;
  N_USDataTxBuffer.Length   = Length;
  
  for (i = 0; i < Length; i++)
  {
    N_USDataTxBuffer.MsgData[i] = *MessageData;
    MessageData++;
  }
  
  //´״̬
  TpCtrl.NonStopMode = 0;
  TpCtrl.TotalLen  = Length;                    //¼ֽ
  TpCtrl.BSMax     = 0xFF;                      //ʼBSMaxֵ
  TpCtrl.STmin     = 0x7F;
  
  //ΪN_PDU
  if (TpCtrl.TotalLen < 8)                      //ܳС8,õ֡
  {
    TpCtrl.BlockSize = 1;                       //֡,BlockΪ1
    TpCtrl.Len       = TpCtrl.TotalLen;         //֡ȫ
    TpCtrl.BlockCnt  = 1;                       //¼ѷBlock
    
    TransportTxData.N_PDU_SF.N_TAtype    = N_USDataTxBuffer.N_TAtype;
    TransportTxData.N_PDU_SF.N_PCI.Type  = SINGLE_FRAME;
    TransportTxData.N_PDU_SF.N_PCI.SF_DL = (uint8_t)(TpCtrl.TotalLen);
    TransportTxData.N_PDU_SF.DLC         = (uint8_t)(TpCtrl.TotalLen) + 1;
    
    for (i = 0; i < TpCtrl.TotalLen; i++)
      TransportTxData.N_PDU_SF.N_Data[i] = N_USDataTxBuffer.MsgData[i];
  }
  else                                          //ܳȴڵ8,ö֡,ȷ֡
  {
    if ((Length + 1) % 7)                       //BlockSize
      TpCtrl.BlockSize = (Length + 8) / 7;      //Ч(Length + 1) / 7 + 1
    else
      TpCtrl.BlockSize = (Length + 1) / 7;
    TpCtrl.Len       = 6;                       //֡ݳΪ6
    TpCtrl.BlockCnt  = 1;                       //¼ѷBlock
      
    TransportTxData.N_PDU_FF.N_TAtype      = N_USDataTxBuffer.N_TAtype;
    TransportTxData.N_PDU_FF.N_PCI.Type    = FIRST_FRAME;
    TransportTxData.N_PDU_FF.N_PCI.FF_DL_H = (uint8_t)((TpCtrl.TotalLen >> 8) & 0x000F);
    TransportTxData.N_PDU_FF.N_PCI.FF_DL_L = (uint8_t)(TpCtrl.TotalLen & 0x00FF);
    TransportTxData.N_PDU_FF.DLC           = 8;
    
    for (i = 0; i < 6; i++)
      TransportTxData.N_PDU_FF.N_Data[i] = N_USDataTxBuffer.MsgData[i];
  }
  //TpCtrl.TxReq = 1;
  DoCAN_Start_Timer(TIMING_PARA_N_As);          //N_Asʱ
  DoCAN_L_Data_Request(TransportTxData.Frame.Identifier, TransportTxData.Frame.DLC, TransportTxData.Frame.Data);
  TpCtrl.Process = TP_TX_INIT;                  //֡ѷ,ȴ
}

/******************************************************************************
DoCAN_N_USData_Confirm
  ܣ÷㷢,ȷǰһʹN_USData.request
        N_TAtypeַ͵Ƿ
        The N_USData.confirm service is issued by the network layer. The service
        primitive confirms the completion of an N_USData.request service
        identified by the address information in N_TAtype.
  N_TAtype N_USData.confirmķ͵ַ
        N_Result N_USData.requestĴ״̬
ֵ
******************************************************************************/
void DoCAN_N_USData_Confirm (uint32_t N_TAtype, N_ResultEnum N_Result)
{
  UDS_N_USData_Confirm(N_TAtype, N_Result);
}


/******************************************************************************
DoCAN_N_USData_FF_Indication
  ܣ÷㷢,ϲָʾַΪN_TAtypeһ֡ݵ֡
        ĵ
        The N_USData_FF.indication service is issued by the network layer. The
        service primitive indicates to the adjacent upper layer the arrival of
        a FirstFrame (FF) of a segmented message received from a peer protocol
        entity, identified by the address information N_TAtype.
  N_TAtype µĶ֡֡ĵַϢ
        Length   µĶ֡ݵܳ
ֵ
******************************************************************************/
void DoCAN_N_USData_FF_Indication(uint32_t N_TAtype, uint16_t Length)
{
  UDS_N_USData_FF_Indication(N_TAtype, Length);
}

/******************************************************************************
DoCAN_N_USData_Indication
  ܣ÷㷢,ϲָN_TAtypeַĳΪLength
        MessageDataݵĴͽN_Result,ͬʱһ
        The N_USData.indication service is issued by the network layer. The
        service primitive indicates <N_Result> events and delivers
        <MessageData> with <Length> bytes received from a peer protocol entity
        identified by the address information in N_TAtype to the adjacent upper
        layer.
  N_TAtype    յݵַϢ
        MessageData յ      (N_ResultΪN_OKʱЧ)
        Length      յݳ  (N_ResultΪN_OKʱЧ)
        N_Result    ݵĽս
ֵ
******************************************************************************/
void DoCAN_N_USData_Indication(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length, N_ResultEnum N_Result)
{
  UDS_N_USData_Indication(N_TAtype, MessageData, Length, N_Result);
}


/******************************************************************************
²ӿں
******************************************************************************/

/******************************************************************************
DoCAN_L_Data_Request
  ܣ÷ԭ<Identifier>ضʽ<Data>
        The service primitive requests transmission of <Data> that shall be
        mapped within specific attributes of the data link protocol data unit
        selected by means of <Identifier>.
  Identifier ID
        dlc        ݳ
        Data       <Data>·Ĵŵַ
ֵ
******************************************************************************/
void DoCAN_L_Data_Request(uint32_t Identifier, uint8_t dlc, uint8_t *Data)
{
  uint8_t i;
  
  LinkTxCtrl.Identifier = Identifier;
  
  for (i = 0; i < dlc; i++)
  {
    LinkTxCtrl.Data[i] = *Data;
    Data++;
  }
  
  #if FILLER_BYTE_HANDLING
    for (i = dlc; i < 8; i++)
      LinkTxCtrl.Data[i] = FILLER_BYTE;
      
    MSCAN0_L_Data_Request(LinkTxCtrl.Identifier, 8, LinkTxCtrl.Data, 1);
  #else
    MSCAN0_L_Data_Request(LinkTxCtrl.Identifier, dlc, LinkTxCtrl.Data, 1);
  #endif
  
  LinkTxCtrl.Busy  = 1;
}

/******************************************************************************
DoCAN_L_Data_Confirm
  ܣ÷ԭȷϾض<Identifier>ıǷɡ
        <TransferStatus>ڴݷ״̬
        The service primitive confirms the completion of an L_Data.request
        service for a specific <Identifier>.The parameter <TransferStatus>
        provides the status of the service request.
  Identifier     ID
        TransferStatus Not_Complete - δ
                         Complete     - ѷ
ֵ
******************************************************************************/
void DoCAN_L_Data_Confirm (uint32_t Identifier, uint8_t TransferStatus)
{
  //ݷͳɹ,շ״̬Ӧı
  if (LinkTxCtrl.Identifier  == Identifier)
  {
    if (TransferStatus == COMPLETE)
    {
      switch (TpCtrl.Process)
      {
        case TP_TX_INIT : if (TpCtrl.BlockSize == 1)                //BlockSizeΪ1,֡ͳɹ
                          {
                            TpCtrl.Process = TP_IDLE;               //ݷ,ص״̬
                            DoCAN_Stop_Timer();                     //ֹͣʱ
                            DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_OK);
                          }
                          else                                      //BlockSizeΪ1,֡ͳɹ
                          {
                            DoCAN_Start_Timer(TIMING_PARA_N_Bs);    //N_Bsʱ
                            TpCtrl.Process = TP_TX_RTS;             //ȴջɶ֡
                          }
                          break;
                          
        case TP_TX_CTS  : TpCtrl.BlockCnt++;
                          if (TpCtrl.BlockCnt == TpCtrl.BlockSize)  //һ֡
                          {
                            TpCtrl.Process = TP_IDLE;               //ݷ,ص״̬
                            DoCAN_Stop_Timer();                     //ֹͣʱ
                            DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_OK);
                          }
                          else
                          {
                            //DoCAN_Start_Timer(TIMING_PARA_N_Bs);
                          //DoCAN_Start_Timer(TIMING_PARA_N_Bs);    ///N_Bsʱ
                          if(TpCtrl.BSMax)      //Լ֡,STminʱ
                            {
                              DoCAN_Stop_Timer();  
                              DoCAN_Start_STmin_Timer(TpCtrl.STmin);
                            } 
                          else 
                          {
                              DoCAN_Start_Timer(TIMING_PARA_N_Bs);
                          }
                        }
                        break;
      
      case TP_RX_RTS  : DoCAN_Start_Timer(TIMING_PARA_N_Cr);      //N_Crʱ
                        TpCtrl.Process = TP_RX_CTS;
                        break;
                        
      case TP_RX_WAIT : DoCAN_Start_Timer(TIMING_PARA_N_Cr);      //N_Crʱ
                        TpCtrl.Process = TP_RX_CTS;
                        break;
                        
      case TP_RX_OVFL : TpCtrl.Process = TP_IDLE;                 //ֹͣչ
                        DoCAN_Stop_Timer();                       //ֹͣʱ
                        DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                                                  N_USDataRxBuffer.Length, N_ERROR);
                        break;

        default         : break;
      }
    }                                             //ʧ,ط
  }
}

/******************************************************************************
DoCAN_L_Data_Indication
  ܣ÷ԭʾһ·¼ϲ㲢<Identifier><Data>
        The service primitive indicates a data link layer event to the adjacent
        upper layer and delivers <Data> identified by <Identifier>
  Identifier ID
        dlc        ݳ
        pData      <Data>·Ĵŵַ
ֵ
******************************************************************************/
extern void DoCAN_L_Data_Indication(uint32_t Identifier, uint8_t dlc, uint8_t *pData)
{
  uint8_t i;
  
 
  
  if (LinkRxFIFO.Depth >= LINK_RX_FIFO_MAX_DEPTH)                    //FIFOδʱװ뱨,
  { 
    #if DOCAN_DEBUG_EN
      LINK_RX_FIFO_OVERFLOW_INDICATOR();
    #endif
    return;
  }
  
  LinkRxFIFO.LinkData[LinkRxFIFO.IPtr].Identifier = Identifier;      //װ뱨ID
  for (i = 0; i < dlc; i++)                                          //
    LinkRxFIFO.LinkData[LinkRxFIFO.IPtr].Data[i] = *(pData + i);
  LinkRxFIFO.LinkData[LinkRxFIFO.IPtr].DLC = dlc;                    //汨ĳ
  
  LinkRxFIFO.Depth++;                                                //±װ,+1
  LinkRxFIFO.IPtr++;                                                 //ָ+1
  if(LinkRxFIFO.IPtr >= LINK_RX_FIFO_MAX_DEPTH)
    LinkRxFIFO.IPtr = 0;
}

/******************************************************************************
Э
******************************************************************************/
 
/******************************************************************************
DoCAN_Receive_And_Assemble_N_USData();
  ܣN_PDU
  
ֵ
******************************************************************************/
void DoCAN_Receive_And_Assemble_N_USData(void)
{
  DoCAN_Get_N_PDU();
  
  if (TransportRxData.N_PDU.New)
  {
    switch (TransportRxData.N_PDU.N_PCI.Type)
    { //֡
      case SINGLE_FRAME       : DoCAN_Receive_Single_Frame_N_Data();
                                break;
      //֡                          
      case FIRST_FRAME        : DoCAN_Receive_First_Frame_N_Data();
                                DoCAN_Transmit_Flow_Control();     //֡Ϻ뷢֡
                                break;
      //֡                          
      case CONSECUTIVE_FRAME  : DoCAN_Receive_Consecutive_Frame_N_Data();
                                DoCAN_Transmit_Flow_Control();     //һBlockSizeʱ,Ҫ֡
                                break;
      //֡
      case FLOW_CONTROL       : DoCAN_Receive_Flow_Control();
                                break;
                                
      default                 : DoCAN_Handle_Unknown_N_PDU();
                                break;
    }
    TransportRxData.N_PDU_FC.New = 0;
  }
}

/******************************************************************************
DoCAN_Get_N_PDU
  ܣ·ȡN_PDU(network protocol data unit)
  
ֵ
******************************************************************************/
void DoCAN_Get_N_PDU(void)
{
  uint8_t i;
  
  if (LinkRxFIFO.Depth)                                                                  //FIFO
  {
    TransportRxData.Frame.Identifier = LinkRxFIFO.LinkData[LinkRxFIFO.OPtr].Identifier;  //ȡID
    for (i = 0; i < 8; i++)                                                              //
      TransportRxData.Frame.Data[i] = LinkRxFIFO.LinkData[LinkRxFIFO.OPtr].Data[i];
    TransportRxData.Frame.DLC = LinkRxFIFO.LinkData[LinkRxFIFO.OPtr].DLC;                //ȡĳ
    TransportRxData.Frame.New = 1;
  
    LinkRxFIFO.Depth--;                                                                  //ȡ,-1
    LinkRxFIFO.OPtr++;                                                                   //ָ+1
    if(LinkRxFIFO.OPtr >= LINK_RX_FIFO_MAX_DEPTH)
      LinkRxFIFO.OPtr = 0;
  }
}

/******************************************************************************
DoCAN_Receive_Single_Frame_N_Data
  ܣ֡ݽ
  
ֵ
******************************************************************************/
void DoCAN_Receive_Single_Frame_N_Data(void)
{
  uint8_t i;
  
  if ((TpCtrl.Process & TP_DIR_MASK) == TP_TX)    //в
    return;
  
  
  if ((TransportRxData.N_PDU_SF.N_TAtype != DIAG_ID_Rx_PHY) && (TpCtrl.Process != TP_IDLE))   
    return;
  
  /*---------------------------------------------------------------------------
  Tester sends a Single frame with a CAN-DLC shorter and equal to the transport
  protocol data length field. ECU must not send a response.
  2018.11.28ӳȻҪ8
  ---------------------------------------------------------------------------*/ 
  if ((TransportRxData.N_PDU_SF.DLC <= TransportRxData.N_PDU_SF.N_PCI.SF_DL) || (TransportRxData.N_PDU_SF.DLC != 8) )
    return;
    
  /*---------------------------------------------------------------------------
  Tester sends a Single frame with a data length that is not allowed by the
  protocol. ECU must not send a response.
  ---------------------------------------------------------------------------*/
  if ((TransportRxData.N_PDU_SF.N_PCI.SF_DL == 0) || (TransportRxData.N_PDU_SF.N_PCI.SF_DL > 7))
    return;
    
  N_USDataRxBuffer.N_TAtype = TransportRxData.N_PDU_SF.N_TAtype;
  N_USDataRxBuffer.Length   = TransportRxData.N_PDU_SF.N_PCI.SF_DL;
  for (i = 0; i < N_USDataRxBuffer.Length; i ++)
    N_USDataRxBuffer.MsgData[i] = TransportRxData.N_PDU_SF.N_Data[i];
  
  TpCtrl.Process = TP_IDLE;               //,صIDLE״̬ 
  DoCAN_Stop_Timer();  
  DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                            N_USDataRxBuffer.Length, N_OK); 
}

/******************************************************************************
DoCAN_Receive_First_Frame_N_Data
  ܣ֡ݲʼ֡ݽ
  
ֵ
******************************************************************************/
void DoCAN_Receive_First_Frame_N_Data(void)
{
  uint8_t  i;
  uint16_t Len;

  if ((TpCtrl.Process & TP_DIR_MASK) == TP_TX)    //в
    return;
    
  /*-----------------------------------------------------------------------------
  Tester sends a functional addressed First frame. ECU must not send a response.
  -----------------------------------------------------------------------------*/
  if (TransportRxData.N_PDU_FF.N_TAtype != DIAG_ID_Rx_PHY)
    return;
  
  /*---------------------------------------------------------------------------
  (8.3) A FirstFrame protocol data unit (FF N_PDU), containing the first six
  data bytes
  ---------------------------------------------------------------------------*/
  if (TransportRxData.N_PDU_FF.DLC != 8)    //֡ܳ(N_PCI + N_Data)ӦΪ8
    return;
    
  /*---------------------------------------------------------------------------
	Tester sends a First frame with Data length set to 0. ECU must not send a
	response.
	-----------------------------------------------------------------------------
	(8.5.3.3) If the network layer receives an FF with an FF_DL that is less than
	eight when using normal addressing, then the network layer shall ignore the
	received FF N_PDU and not transmit an FC N_PDU.
	---------------------------------------------------------------------------*/
	Len   = (uint16_t)(TransportRxData.N_PDU_FF.N_PCI.FF_DL_H);
	Len <<= 8;
	Len  |= (uint16_t)(TransportRxData.N_PDU_FF.N_PCI.FF_DL_L);
    
	if (Len < 8)
    return;
    
  /*---------------------------------------------------------------------------
  Tester sends a First frame of a segmented request. After the receipt of the
  ECU Flow Control the Tester sends another segmented request. The ECU must
  send a response for the second request.
  ---------------------------------------------------------------------------*/
  #if (N_MAX_BS)
    TpCtrl.NonStopMode = 0;
  #else
    TpCtrl.NonStopMode = 1;
  #endif
    
  TpCtrl.Len       = 6;                   //֡6ֽ
  TpCtrl.TotalLen  = Len;                 //¼ֽ
  TpCtrl.BlockCnt  = 1;                   //֡1block
  TpCtrl.BSMax     = N_MAX_BS;            //װBS
  TpCtrl.WFTCnt    = N_WFTmax;            //װȴ
  
  //֡6ֽ,֡7ֽ,ֽBlock
  if ((TpCtrl.TotalLen + 1) % 7)
    TpCtrl.BlockSize = (TpCtrl.TotalLen + 8) / 7;     //Ч(TpCtrl.TotalLen + 1) / 7 + 1
  else
    TpCtrl.BlockSize = (TpCtrl.TotalLen + 1) / 7;
    
  //ʼ֡
  N_USDataRxBuffer.N_TAtype = TransportRxData.N_PDU_FF.N_TAtype;
  N_USDataRxBuffer.Length   = Len;
  for (i = 0; i < 6; i ++)
    N_USDataRxBuffer.MsgData[i] = TransportRxData.N_PDU_FF.N_Data[i];
    
  DoCAN_Start_Timer(TIMING_PARA_N_Br);    //N_Brʱ
  TpCtrl.Process = TP_RX_INIT;
  DoCAN_N_USData_FF_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.Length);
}

/******************************************************************************
DoCAN_Receive_Consecutive_Frame_N_Data
  ܣ֡
  
ֵ
******************************************************************************/
void DoCAN_Receive_Consecutive_Frame_N_Data(void)
{
  uint8_t i;
  
  /*---------------------------------------------------------------------------
  Tester sends a request with a response that is longer than one frame. After
  the Flow control the Tester sends a Consecutive frame. ECU must send a
  diagnostic response for the first request. ECU must not send a response
  for the Consecutive frame.
  -----------------------------------------------------------------------------
  Tester sends a single Consecutive frame. The ECU must not send a response.
  ---------------------------------------------------------------------------*/
  if (TpCtrl.Process != TP_RX_CTS)
    return;
    
  if (TransportRxData.N_PDU_CF.N_TAtype != DIAG_ID_Rx_PHY)
    return;
  
  /*---------------------------------------------------------------------------
  Send a request which requires more than 4 frames. Drop the third consecutive
  frame (CF). The ECU should not respond.
  -----------------------------------------------------------------------------
  Send a multi frame message to the ECU. Send the first consecutive frame (CF)
  twice. No response is expected.
  ---------------------------------------------------------------------------*/
  if (TransportRxData.N_PDU_CF.N_PCI.SN != (uint8_t)(TpCtrl.BlockCnt & 0x000F))                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
  {
    TpCtrl.Process = TP_IDLE;               //ֹͣչ
    DoCAN_Stop_Timer();                     //ֹͣʱ
    DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                              N_USDataRxBuffer.Length, N_WRONG_SN);
    return;
  }
  
  TpCtrl.BlockCnt++;                        //յ1Block
  TpCtrl.BSMax--;
  
  if (TpCtrl.BlockCnt < TpCtrl.BlockSize)   //˴νղһ֡
  {
    if (TransportRxData.N_PDU_CF.DLC != 8)  //ʱ֡ܳ(N_PCI + N_Data)ӦΪ8
      return;

    for (i = 0; i < 7; i++)
    {
      N_USDataRxBuffer.MsgData[TpCtrl.Len] = TransportRxData.N_PDU_CF.N_Data[i];
      TpCtrl.Len++;
    }
    
    DoCAN_Start_Timer(TIMING_PARA_N_Cr);    //N_Crʱ
  }
  else                                      //˴νһ֡
  {
    /*-------------------------------------------------------------------------
    In a segmented request the Tester sends a Consecutive frame with a CAN-DLC
    shorter or equal to transport protocol data length field. ECU must not send
    a response.
    2018.11.28ӳӦõ8
    -------------------------------------------------------------------------*/
    if ((TransportRxData.N_PDU_CF.DLC <= TpCtrl.TotalLen - TpCtrl.Len) || (TransportRxData.N_PDU_CF.DLC != 8)  )   //ʱ֡ܳӦСʣݳ
      return;
    
    i = 0;
    while (TpCtrl.Len < TpCtrl.TotalLen)
    {
      N_USDataRxBuffer.MsgData[TpCtrl.Len] = TransportRxData.N_PDU_CF.N_Data[i];
      i++;
      TpCtrl.Len++;
    }
      
    TpCtrl.Process = TP_IDLE;               //,صIDLE״̬ 
    DoCAN_Stop_Timer();
    DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                              N_USDataRxBuffer.Length, N_OK);   
  }
}

/******************************************************************************
DoCAN_Receive_Flow_Control
  ܣ֡
  
ֵ
******************************************************************************/
void DoCAN_Receive_Flow_Control(void)
{
  /*--------------------------------------------------------------------------
  Tester sends a segmented request interrupted by a Flow control after the ECU
  Flow control. After that the Tester sends the remaining consecutive frames. 
  ECU should send a diagnostic response for the request.
  -----------------------------------------------------------------------------
  Tester sends a single Flow Control. The ECU must not send a response.
  ---------------------------------------------------------------------------*/
  if ((TpCtrl.Process != TP_TX_RTS) && (TpCtrl.Process != TP_TX_CTS) && (TpCtrl.Process != TP_TX_WAIT))
    return;
  
  /*---------------------------------------------------------------------------
  Tester sends a request with a response that is longer than one frame. After
  the First frame is received the Tester sends a functional addressed Flow
  control. ECU must abort sending of the response.
  ---------------------------------------------------------------------------*/
  if (TransportRxData.N_PDU_FC.N_TAtype != DIAG_ID_Rx_PHY)
  {
    DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_ERROR);
    DoCAN_Stop_Timer();                   //ֹͣʱ
    TpCtrl.Process = TP_IDLE;             //ֹݷ,ص״̬
    return;
  }
  
  /*---------------------------------------------------------------------------
  Tester sends a Flow control with a too short CAN-DLC for a response that is
  longer than one frame. ECU must not send Consecutive frames. After that the
  tester sends a new request. ECU must send a response for the last request.
  ԭ TransportRxData.N_PDU_FC.DLC < 3Ϊ
  ---------------------------------------------------------------------------*/
  if(TransportRxData.N_PDU_FC.DLC != 8)
  {
    DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_ERROR);
    DoCAN_Stop_Timer();                   //ֹͣʱ
    TpCtrl.Process = TP_IDLE;             //ֹݷ,ص״̬
    return;
  }
  
  switch(TransportRxData.N_PDU_FC.N_PCI.FS)
  {
    case FC_FS_CTS  : if (TpCtrl.NonStopMode)
                        break;
                        
                      /*-------------------------------------------------------
                      Tester sends a Flow control with Blocksize 0 for a
                      response that is longer than one frame. ECU must send the
                      complete response.
                      ---------------------------------------------------------
                      Tester sends a Flow control with Blocksize 0 for a
                      response that is longer than one frame. ECU must send the
                      complete response without waiting for another Flow
                      control. Tester verifies that every Consecutive frame is
                      received within TimeoutCr.
                      -------------------------------------------------------*/
                      if (TransportRxData.N_PDU_FC.N_PCI.BS == 0)
                        TpCtrl.NonStopMode = 1;
                      
                      /*-------------------------------------------------------
                      Tester sends a Flow control with a special Blocksize for
                      a response that is longer than one frame. ECU must send
                      the number of Consecutive frames that matches the
                      blocksize. Blocksize 1, 8 and 20 is checked if the
                      response is long enough.
                      -------------------------------------------------------*/
                      else
                        TpCtrl.BSMax = TransportRxData.N_PDU_FC.N_PCI.BS;
                        
                      /*-------------------------------------------------------
                      Tester sends a Flow control for a response that is longer
                      than one frame. ECU must send the complete response.
                      Tester verifies that the time between the Consecutive
                      Frames is not below STMin time. This is tested for STMin
                      values 1,10,20,30,40,50 and 60.
                      2018.11.29Ϊڷ֡ʱԵڶصstmin
                      -------------------------------------------------------*/
                      if( TpCtrl.Process != TP_TX_CTS )
                      {
                        if( TransportRxData.N_PDU_FC.N_PCI.STmin!=0)
                          TpCtrl.STmin = TransportRxData.N_PDU_FC.N_PCI.STmin;
                        else
                          TpCtrl.STmin =1; 
                      }                      
                      /*-------------------------------------------------------
                      Request a service where the response requires more than
                      one response frame. Tester sends two Flow Controls (FC)
                      instead of one. A response from the ECU is expected.
                      -------------------------------------------------------*/
                      TpCtrl.Process = TP_TX_CTS;             //ͻɷ
                    //2018.11.28 
                    //  DoCAN_Start_Timer(TIMING_PARA_N_Bs);Ϊֹͣ    ///N_Bsʱ
                      DoCAN_Stop_Timer();
                      DoCAN_Start_STmin_Timer(TpCtrl.STmin);  //STminʱ
                      break;
                      
    case FC_FS_WAIT : if (TpCtrl.NonStopMode)
                        break;
                        
                      /*-------------------------------------------------------
                      Tester sends a Flow control with Status value wait (WT)
                      for a response that is longer than one frame. ECU must
                      not send Consecutive frames. After the N_Bs Timeout the
                      Tester sends another Flow control with status continue to
                      send (CTS). Then the tester sends a new request. ECU must
                      send a response for the last request.
                      -------------------------------------------------------*/
                      TpCtrl.Process = TP_TX_WAIT;            //ջͻȴ
                      DoCAN_Start_Timer(TIMING_PARA_N_Bs);    ///N_Bsʱ
                      break;
                      
    case FC_FS_OVFL : if (TpCtrl.NonStopMode)
                        break;
                        
                      /*-------------------------------------------------------
                      Tester sends a Flow control with status overflow for a
                      response that is longer than one frame. ECU must not send
                      Consecutive frame(s).
                      ---------------------------------------------------------
                      Tester sends a request with a response that is longer 
                      than one frame. After sending the Flow control the Tester
                      receives the first Consecutive frame and sends another
                      Flow control with status overflow (OVFLW). ECU must send
                      a diagnostic response for the first request. ECU must not
                      send a response for the Flow control.
                      -------------------------------------------------------*/
                      if (TpCtrl.Process == TP_TX_RTS)
                      {
                        DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_BUFFER_OVFLW);
                        DoCAN_Stop_Timer();                   //ֹͣʱ
                        TpCtrl.Process = TP_IDLE;             //ֹݷ,ص״̬
                      }
                      break;
                      
    default         : /*-------------------------------------------------------
                      Tester sends a Flow control with an invalid Status value
                      (3-15) for a response that is longer than one frame. ECU
                      must not send a response.
                      -------------------------------------------------------*/
                      DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_INVALID_FS);
                      DoCAN_Stop_Timer();                   //ֹͣʱ
                      TpCtrl.Process = TP_IDLE;             //ֹݷ,ص״̬
                      break;
  }
}

/******************************************************************************
DoCAN_Transmit_Flow_Control
  ܣݵǰĽջ״̬֡
  
ֵ
******************************************************************************/
void DoCAN_Transmit_Flow_Control(void)
{
  if (TpCtrl.Process == TP_RX_INIT)
  {
    /*-------------------------------------------------------------------------
    (8.5.3.3) If the network layer receives an FF with an FF_DL that is greater
    than the available receiver buffer size, then this shall be considered as
    an error condition. The network layer shall abort the message reception and
    send an FC N_PDU with the parameter FlowStatus = Overflow.
    -------------------------------------------------------------------------*/  
    if(N_USDataRxBuffer.Length > N_USDATA_RX_BUFFER_SIZE)
    {
      TransportTxData.N_PDU_FC.N_PCI.FS = FC_FS_OVFL;
      TpCtrl.Process = TP_RX_OVFL;
    }
    else
    {
      TransportTxData.N_PDU_FC.N_PCI.FS = FC_FS_CTS;
      TpCtrl.Process = TP_RX_RTS;
    }
  }
  else if (TpCtrl.Process == TP_RX_CTS)
  {
    if(TpCtrl.BSMax)              //ȻûнһBSN_PDU
      return;
    
    if (TpCtrl.NonStopMode)       //ģʽ(BS0)
      return;
    
    /*  
    if (0)                        //ȴ,͵ȴFC֡
    {
      if(TpCtrl.WFTCnt == 0)
      {
        TpCtrl.Process = TP_IDLE;                         
        DoCAN_Stop_Timer();
        DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                                  N_USDataRxBuffer.Length, N_WFT_OVRN);
        return;
      }
      
      TpCtrl.WFTCnt--;
      TransportTxData.N_PDU_FC.N_PCI.FS = FC_FS_WAIT;
    }*/
    
    TpCtrl.BSMax = N_MAX_BS;      //װBS
    TransportTxData.N_PDU_FC.N_PCI.FS = FC_FS_CTS;
    TpCtrl.Process = TP_RX_RTS;   //ȴRTS
  }
  else
    return;
    
  TransportTxData.N_PDU_FC.N_TAtype    = DIAG_ID_Tx;
  TransportTxData.N_PDU_FC.N_PCI.Type  = FLOW_CONTROL;
  TransportTxData.N_PDU_FC.N_PCI.BS    = TpCtrl.BSMax;
  /*---------------------------------------------------------------------------
  Tester sends a segmented request to check for a valid STMin time in the ECU
  Flow control. The STMin time value must be within 0x01-0x7F or 0xF1-0xF9.
  ---------------------------------------------------------------------------*/
  TransportTxData.N_PDU_FC.N_PCI.STmin = N_STmin;
  TransportTxData.N_PDU_FC.DLC         = 3;

  DoCAN_Start_Timer(TIMING_PARA_N_Ar);          //N_Arʱ
  DoCAN_L_Data_Request(TransportTxData.Frame.Identifier, TransportTxData.Frame.DLC, TransportTxData.Frame.Data);
}

/******************************************************************************
DoCAN_Handle_Unknown_N_PDU
  ܣյδ֪͵N_PDU
  
ֵ
******************************************************************************/
void DoCAN_Handle_Unknown_N_PDU(void)
{                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               

}

/******************************************************************************
DoCAN_Disassemble_And_Transmit_N_USData
  ܣݲΪ֡(CF)ͳȥ
  
ֵ
******************************************************************************/
void DoCAN_Disassemble_And_Transmit_N_USData(void)
{
  uint8_t i;
  uint8_t Len;
  
  if (TpCtrl.Process != TP_TX_CTS)    //δʱԷ֡
    return;
  
  //STminʱʱ䵽һ
  if (DoCAN_Get_STmin_Timer_Status() == STmin_TIME_UP)
  {
    TransportTxData.N_PDU_CF.N_TAtype   = N_USDataTxBuffer.N_TAtype;
    TransportTxData.N_PDU_CF.N_PCI.Type = CONSECUTIVE_FRAME;
    TransportTxData.N_PDU_CF.N_PCI.SN   = (uint8_t)(TpCtrl.BlockCnt & 0x000F);
    
    //BSMaxС0ʱ,·ݷϺ,STmin(DoCAN_L_Data_Confirm
    //STmin_TIME_UP״̬ٳ,Ӷֹͣ֡ķ
    //ֱµCF֡BSMaxֵ,N_Bsʱʱ
    TpCtrl.BSMax--;
    
    if(TpCtrl.BlockCnt < TpCtrl.BlockSize - 1)          //Ҫ͵Ĳһ֡
    {
      TransportTxData.N_PDU_CF.DLC = 8;
      for (i = 0; i < 7; i++)
      {
        TransportTxData.N_PDU_CF.N_Data[i] = N_USDataTxBuffer.MsgData[TpCtrl.Len];
        TpCtrl.Len++;
      }
    }
    else if (TpCtrl.BlockCnt == TpCtrl.BlockSize - 1)   //Ҫһ֡
    {
      Len = (uint8_t)(TpCtrl.TotalLen - TpCtrl.Len);
      
      TransportTxData.N_PDU_CF.DLC = Len + 1;
      for (i = 0; i < Len; i++)
      {
        TransportTxData.N_PDU_CF.N_Data[i] = N_USDataTxBuffer.MsgData[TpCtrl.Len];
        TpCtrl.Len++;
      }
    }
    else    //ѷܴ֡֡,д
    {
      DoCAN_Stop_Timer();                           //ֹͣʱ
      TpCtrl.Process = TP_IDLE;                     //ֹݷ,ص״̬
      DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_ERROR);
      return;
    }
    
    DoCAN_Start_Timer(TIMING_PARA_N_As);          //N_Asʱ
    DoCAN_L_Data_Request(TransportTxData.Frame.Identifier, TransportTxData.Frame.DLC, TransportTxData.Frame.Data);
  }
}

/******************************************************************************
ʱ
******************************************************************************/
/******************************************************************************
DoCAN_Update_Timer
  ܣʱº
  
ֵ
******************************************************************************/
#pragma MESSAGE DISABLE C2705
void DoCAN_Update_Timer(void)
{
  uint16_t CurrentCnt;
  uint16_t Dec;
    
  CurrentCnt = TpTimingCtrl.Cnt;
  if(CurrentCnt != TpTimingCtrl.LastCnt)    //ʱֵи
  {
    if (CurrentCnt > TpTimingCtrl.LastCnt)
      Dec = CurrentCnt - TpTimingCtrl.LastCnt;
    else
      Dec = 65535 - TpTimingCtrl.LastCnt + 1 + CurrentCnt;
      
    TpTimingCtrl.LastCnt = CurrentCnt;
    
    if (TpTimingCtrl.Type != TIMING_PARA_NONE)
    {
      if (TpTimingCtrl.NTimer)
      {
        if (TpTimingCtrl.NTimer > (uint32_t)Dec)
          TpTimingCtrl.NTimer -= Dec;
        else
          TpTimingCtrl.NTimer  = 0;
      }
    }
    
    if (TpTimingCtrl.STminStatus == STmin_TIMING)
    {  
      if(TpTimingCtrl.STimer)
      {
        if (TpTimingCtrl.STimer > (uint32_t)Dec)
          TpTimingCtrl.STimer -= Dec;
        else
          TpTimingCtrl.STimer  = 0;
      }
      
      if (TpTimingCtrl.STimer == 0)
        TpTimingCtrl.STminStatus = STmin_TIME_UP;
    }
  }
}

/******************************************************************************
DoCAN_Handle_Time_Out
  ܣʱ
  
ֵ
******************************************************************************/
void DoCAN_Handle_Time_Out(void)
{
  if (TpTimingCtrl.NTimer == 0)             //ʱʱ
  {                        
    switch (TpTimingCtrl.Type)
    {
      case TIMING_PARA_N_As : if (TpCtrl.Process != TP_IDLE)
                              {
                                TpCtrl.Process = TP_IDLE;   //ֹշ,ص״̬
                                DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_TIMEOUT_A);
                              }
                              break;
                                    
      case TIMING_PARA_N_Ar : if (TpCtrl.Process != TP_IDLE)
                              {
                                TpCtrl.Process = TP_IDLE;   //ֹշ,ص״̬
                                DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                                                          N_USDataRxBuffer.Length, N_TIMEOUT_A);
                              }
                              break;
      
      case TIMING_PARA_N_Bs : if (TpCtrl.Process != TP_IDLE)
                              {
                                TpCtrl.Process = TP_IDLE;   //ֹݷ,ص״̬
                                DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_TIMEOUT_Bs);
                              }
                              break;
      
      case TIMING_PARA_N_Br : if (TpCtrl.Process != TP_IDLE)
                              {
                                TpCtrl.Process = TP_IDLE;   //ֹշ,ص״̬
                                DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                                                          N_USDataRxBuffer.Length, N_ERROR);
                              }
                              break;
                              
      case TIMING_PARA_N_Cs : if (TpCtrl.Process != TP_IDLE)
                              {
                                TpCtrl.Process = TP_IDLE;   //ֹշ,ص״̬
                                DoCAN_N_USData_Confirm(N_USDataTxBuffer.N_TAtype, N_ERROR);
                              }
                              break;
      
      case TIMING_PARA_N_Cr : if (TpCtrl.Process != TP_IDLE)
                              {
                                TpCtrl.Process = TP_IDLE;   //ֹݽ,ص״̬
                                DoCAN_N_USData_Indication(N_USDataRxBuffer.N_TAtype, N_USDataRxBuffer.MsgData, \
                                                  N_USDataRxBuffer.Length, N_TIMEOUT_Cr);
                              }
                              break;
      
      default               : break;
    }
    
    DoCAN_Stop_Timer();                     //ֹͣʱ
  }
}

/******************************************************************************
DoCAN_Start_Timer
  ܣʱʱ
  TimingParameter ʱ,веһ
                          TIMING_PARA_N_As
                          TIMING_PARA_N_Ar
                          TIMING_PARA_N_Bs
                          TIMING_PARA_N_Br
                          TIMING_PARA_N_Cs
                          TIMING_PARA_N_Cr
ֵ
******************************************************************************/
void DoCAN_Start_Timer(uint8_t TimingParameter)
{
  switch (TimingParameter)
  {
    case TIMING_PARA_N_As : TpTimingCtrl.Type   = TIMING_PARA_N_As;
                            TpTimingCtrl.NTimer = N_As * 1000;
                            break;
    
    case TIMING_PARA_N_Ar : TpTimingCtrl.Type   = TIMING_PARA_N_Ar;
                            TpTimingCtrl.NTimer = N_Ar * 1000;
                            break;
    
    case TIMING_PARA_N_Bs : TpTimingCtrl.Type   = TIMING_PARA_N_Bs;
                            TpTimingCtrl.NTimer = N_Bs * 1000;
                            break;
    
    case TIMING_PARA_N_Br : TpTimingCtrl.Type   = TIMING_PARA_N_Br;
                            TpTimingCtrl.NTimer = N_Br * 1000;
                            break;
    
    case TIMING_PARA_N_Cs : TpTimingCtrl.Type   = TIMING_PARA_N_Cs;
                            TpTimingCtrl.NTimer = N_Cs * 1000;
                            break;
    
    case TIMING_PARA_N_Cr : TpTimingCtrl.Type   = TIMING_PARA_N_Cr;
                            TpTimingCtrl.NTimer = N_Cr * 1000;
                            break;
    
    default               : TpTimingCtrl.Type   = TIMING_PARA_NONE;
                            TpTimingCtrl.NTimer = 0;
                            break;

  }
}

/******************************************************************************
DoCAN_Stop_Timer
  ܣֹͣʱʱ
  
ֵ
******************************************************************************/
void DoCAN_Stop_Timer(void)
{
  TpTimingCtrl.Type = TIMING_PARA_NONE;
}

/******************************************************************************
DoCAN_Start_STmin_Timer
  ܣSTminʱ
  STminTimeSTminʱ
ֵ
******************************************************************************/
void DoCAN_Start_STmin_Timer(uint8_t STminTime)
{
  if (STminTime <= 0x7F)                                //0x00 - 0x7F0ms - 127ms
    TpTimingCtrl.STimer = (uint32_t)STminTime * 1000;
  else if ((STminTime >= 0xF1) && (STminTime <= 0xF9))  //0xF1 - 0xF9100us - 900us
    TpTimingCtrl.STimer = (uint32_t)(STminTime & 0x0F) * 100;
  else                                                  //Reserved   127ms
    TpTimingCtrl.STimer = 127000;
    
  TpTimingCtrl.STminStatus = STmin_TIMING;              //STminʼʱ
}

/******************************************************************************
DoCAN_Get_STmin_Timer_Status
  ܣȡǰSTminʱ״̬
  
ֵSTmin_TIMER_IDLESTminʱ
        STmin_TIME_UP   STminʱʱ䵽
        STmin_TIMING    STminʱʱ
******************************************************************************/
uint8_t DoCAN_Get_STmin_Timer_Status(void)
{
  uint8_t Status;
  
  Status = TpTimingCtrl.STminStatus;
  
  if(Status == STmin_TIME_UP)
    TpTimingCtrl.STminStatus = STmin_TIMER_IDLE;
    
  return Status;
}