/************************************************ ******************************
  API.c
APIƺļ
    ߣ
    V1.0
    ڣ2016.11.3
******************************************************************************/

#include "API.h"
#include "Stepper_Motor.h"
#include "Common.h"
#include "Buzzer.h"
 
extern void DoCAN_Timer_Update(uint16_t Interval);
extern void CoCAN_Init_Mode_Tx_ISR(void);
extern void Drive_Info_Speed_Plus_Conversion_ISR(void);
//extern void Drive_Info_Fuel_Plus_Conversion_ISR (void);

APImsTimerStruct     APImsTimer;
volatile  uint16_t   APIRollingCounter;
uint8_t   Time10ms;
uint8_t   Time2ms;
uint8_t   APIBGNMEnable;
uint8_t   PriorityLock;  //ȼΪ˱ִ֤ ִӦñⷢ

/******************************************************************************
API_Start
  ܣAPI
        APIÿAPI_INT_CYCLEڻᷢһж,ϵͳԸжΪʱ
        API_INT_CYCLEҪԤAPI.hж
  
ֵ
******************************************************************************/
void API_Start(void)
{
  VREGAPICL_APICLK  = 1;            //Bus Clock ΪAPIʱԴ

#pragma MESSAGE DISABLE C2705
  VREGAPIR = (uint16_t)((BUSCLK / 1000000 ) * API_INT_CYCLE / 2);   //APIж

  VREGAPICL_APIE    = 1;           //APIж
  VREGAPICL_APIFE   = 1;			     //ʹAPI,ʼʱ

  APImsTimer.Cnt    = 0;
  APImsTimer.Flag   = 0;
  APIRollingCounter = 0;
}

/******************************************************************************
API_Stop
  ܣرAPI
  
ֵ
******************************************************************************/
void API_Stop ( void )
{
  VREGAPICL_APIE = 0;           //API
  VREGAPICL_APIFE = 0;			    //ֹAPIжϹ
}

/******************************************************************************
API_1ms_Timer_Update
  ܣȡ붨ʱ±־
        ָʾһ1msʱ
  
ֵ1 - 1msʱ
        0 - 1msʱδ
******************************************************************************/
uint8_t API_1ms_Timer_Update ( void )
{
  if( APImsTimer.Flag )
  {
    APImsTimer.Flag = 0;
    return 1;
  }
  else
   return 0;
}

/******************************************************************************
жϺ
******************************************************************************/
#pragma CODE_SEG __NEAR_SEG NON_BANKED   	//жϺFLASHķǷҳ

void interrupt NONUSE1_ISR(void)
{
}

void interrupt NONUSE2_ISR(void)
{
}

void interrupt NONUSE3_ISR(void)
{
}

void interrupt NONUSE5_ISR(void)
{
}
/******************************************************************************
interrupt API_ISR
  ܣAPIжϷ
  
ֵ
******************************************************************************/
uint8_t iTIME1MS ;
uint8_t T1MS_SYB_FF;
static uint8_t tempCnt = 0;
void interrupt API_ISR ( void )
{
  VREGAPICL_APIF = 1;		            //ͨд10жϱ־
  Buzzer_Play_ISR();                //
  APImsTimer.Cnt++;
  
    tempCnt++;
  if(tempCnt >= 20) 
  {
    tempCnt = 0;
    MSCAN0_L_Data_Service();  
  }
  
  if ( APImsTimer.Cnt >= API_MS_CNT_TOP )
  {
    APImsTimer.Cnt  = 0;
    APImsTimer.Flag = 1;

  }
  if ( APIBGNMEnable )
  {
    Time10ms++;
    if ( Time10ms >= 200 )
    {
      Time10ms = 0;
      PriorityLock = 1;
    }
  }
  else
  {
    PriorityLock = 0;
    Time10ms = 0;
  }
  APIRollingCounter++;

  DoCAN_Timer_Update(API_INT_CYCLE);
  if(PriorityLock == 1)
    CoCAN_Init_Mode_Tx_ISR();
  Stepper_Motor_Rotating_ISR();
  
  /************************************/
  //0.128MSг
  if(SCI0SR1_RDRF)     	     	//ڽܻ
  {
    RX_BUF[RSB_P] = SCI0DRL;	//SCI1DRLԶSCI1SR1_RDRF
    if(RSB_P != cnRSBufLen - 1)
      RSB_P++;
  }
  /***************1MS************************/
  //0.128MSг
  iTIME1MS++;

  if ( iTIME1MS == 8 )		// 1.024MS
  {
    iTIME1MS = 0;
    T1MS_SYB_FF = 1;
  }
}
#pragma CODE_SEG DEFAULT