/******************************
	Map Data
	Filename	: mapData.h
	Format Ver	: 1.1.0.27
	Date		: 2019/5/10 12:50:04 +08:00
*******************************/

#ifndef _MAPDATA_H_
#define _MAPDATA_H_

#if 1

/*------------------------------*/
/*	BASIC - DEFINITION			*/
/*------------------------------*/
typedef signed char		S08;				/* signed  8 bit integer	*/
typedef signed short	S16;				/* signed 16 bit integer	*/
typedef signed long		S32;				/* signed 32 bit integer	*/
typedef unsigned char	U08;				/* unsigned  8 bit integer	*/
typedef unsigned short	U16;				/* unsigned 16 bit integer	*/
typedef unsigned long	U32;				/* unsigned 32 bit integer	*/

#endif

/*------------------------------*/
/*	PATTERN DATA STRUCTURE		*/
/*------------------------------*/
typedef struct {							/*--------------------------*/
	U08 SpriteAttributeData[12];			/* Sprite Attribute Data	*/
	S32 PaletteID;							/* Palette ID				*/
} T_VC1H_PATTERNDATA;						/*--------------------------*/

/*------------------------------*/
/*	PALETTE DATA STRUCTURE		*/
/*------------------------------*/
typedef struct {							/*--------------------------*/
	U32 PaletteDataIndex;					/* Palette Data Index		*/
	U16 PaletteNumber;						/* Palette Number			*/
} T_VC1H_PALETTEDATA;						/*--------------------------*/

#define ROMDATA_STARTADDR	(0x00000000)
#define ROMDATA_ENDADDR	(0x00855A4F)
#define ROMDATA_CHECKSUM	(0x1F34)

#define PATTERN_DATA_NUMBER	(424)

enum SpriteName {
	SN_ALARM_01_png = 0,	/* ALARM_01.png - S1 */
	SN_ALARM_02_png,	/* ALARM_02.png - S2 */
	SN_ALARM_03_png,	/* ALARM_03.png - S3 */
	SN_ALARM_04_png,	/* ALARM_04.png - S4 */
	SN_ALARM_05_png,	/* ALARM_05.png - S5 */
	SN_ALARM_06_png,	/* ALARM_06.png - S6 */
	SN_ALARM_07_png,	/* ALARM_07.png - S7 */
	SN_ALARM_08_png,	/* ALARM_08.png - S8 */
	SN_ALARM_09_png,	/* ALARM_09.png - S9 */
	SN_ALARM_10_png,	/* ALARM_10.png - S10 */
	SN_ALARM_11_png,	/* ALARM_11.png - S11 */
	SN_ALARM_12_png,	/* ALARM_12.png - S12 */
	SN_AnimationLeft_00000_png,	/* AnimationLeft_00000.png - S13 */
	SN_AnimationLeft_00001_png,	/* AnimationLeft_00001.png - S14 */
	SN_AnimationLeft_00002_png,	/* AnimationLeft_00002.png - S15 */
	SN_AnimationLeft_00003_png,	/* AnimationLeft_00003.png - S16 */
	SN_AnimationLeft_00004_png,	/* AnimationLeft_00004.png - S17 */
	SN_AnimationLeft_00005_png,	/* AnimationLeft_00005.png - S18 */
	SN_AnimationLeft_00006_png,	/* AnimationLeft_00006.png - S19 */
	SN_AnimationLeft_00007_png,	/* AnimationLeft_00007.png - S20 */
	SN_AnimationLeft_00008_png,	/* AnimationLeft_00008.png - S21 */
	SN_AnimationLeft_00009_png,	/* AnimationLeft_00009.png - S22 */
	SN_AnimationLeft_00010_png,	/* AnimationLeft_00010.png - S23 */
	SN_AnimationLeft_00011_png,	/* AnimationLeft_00011.png - S24 */
	SN_AnimationLeft_00012_png,	/* AnimationLeft_00012.png - S25 */
	SN_AnimationLeft_00013_png,	/* AnimationLeft_00013.png - S26 */
	SN_AnimationLeft_00014_png,	/* AnimationLeft_00014.png - S27 */
	SN_AnimationLeft_00015_png,	/* AnimationLeft_00015.png - S28 */
	SN_AnimationLeft_00016_png,	/* AnimationLeft_00016.png - S29 */
	SN_AnimationLeft_00017_png,	/* AnimationLeft_00017.png - S30 */
	SN_AnimationLeft_00018_png,	/* AnimationLeft_00018.png - S31 */
	SN_AnimationLeft_00019_png,	/* AnimationLeft_00019.png - S32 */
	SN_AnimationLeft_00020_png,	/* AnimationLeft_00020.png - S33 */
	SN_AnimationLeft_00021_png,	/* AnimationLeft_00021.png - S34 */
	SN_AnimationLeft_00022_png,	/* AnimationLeft_00022.png - S35 */
	SN_AnimationLeft_00023_png,	/* AnimationLeft_00023.png - S36 */
	SN_AnimationLeft_00024_png,	/* AnimationLeft_00024.png - S37 */
	SN_AnimationLeft_00025_png,	/* AnimationLeft_00025.png - S38 */
	SN_AnimationLeft_00026_png,	/* AnimationLeft_00026.png - S39 */
	SN_AnimationLeft_00027_png,	/* AnimationLeft_00027.png - S40 */
	SN_AnimationLeft_00028_png,	/* AnimationLeft_00028.png - S41 */
	SN_AnimationLeft_00029_png,	/* AnimationLeft_00029.png - S42 */
	SN_AnimationLeft_00030_png,	/* AnimationLeft_00030.png - S43 */
	SN_AnimationLeft_00031_png,	/* AnimationLeft_00031.png - S44 */
	SN_AnimationLeft_00032_png,	/* AnimationLeft_00032.png - S45 */
	SN_AnimationLeft_00033_png,	/* AnimationLeft_00033.png - S46 */
	SN_AnimationLeft_00034_png,	/* AnimationLeft_00034.png - S47 */
	SN_AnimationLeft_00035_png,	/* AnimationLeft_00035.png - S48 */
	SN_AnimationLeft_00036_png,	/* AnimationLeft_00036.png - S49 */
	SN_AnimationLeft_00037_png,	/* AnimationLeft_00037.png - S50 */
	SN_AnimationLeft_00038_png,	/* AnimationLeft_00038.png - S51 */
	SN_AnimationLeft_00039_png,	/* AnimationLeft_00039.png - S52 */
	SN_AnimationLeft_00040_png,	/* AnimationLeft_00040.png - S53 */
	SN_AnimationLeft_00041_png,	/* AnimationLeft_00041.png - S54 */
	SN_AnimationLeft_00042_png,	/* AnimationLeft_00042.png - S55 */
	SN_AnimationLeft_00043_png,	/* AnimationLeft_00043.png - S56 */
	SN_AnimationLeft_00044_png,	/* AnimationLeft_00044.png - S57 */
	SN_AnimationLeft_00045_png,	/* AnimationLeft_00045.png - S58 */
	SN_AnimationLeft_00046_png,	/* AnimationLeft_00046.png - S59 */
	SN_AnimationLeft_00047_png,	/* AnimationLeft_00047.png - S60 */
	SN_AnimationLeft_00048_png,	/* AnimationLeft_00048.png - S61 */
	SN_AnimationLeft_00049_png,	/* AnimationLeft_00049.png - S62 */
	SN_AnimationLeft_00050_png,	/* AnimationLeft_00050.png - S63 */
	SN_AnimationLeft_00051_png,	/* AnimationLeft_00051.png - S64 */
	SN_AnimationLeft_00052_png,	/* AnimationLeft_00052.png - S65 */
	SN_AnimationLeft_00053_png,	/* AnimationLeft_00053.png - S66 */
	SN_AnimationLeft_00054_png,	/* AnimationLeft_00054.png - S67 */
	SN_AnimationLeft_00055_png,	/* AnimationLeft_00055.png - S68 */
	SN_AnimationLeft_00056_png,	/* AnimationLeft_00056.png - S69 */
	SN_AnimationLeft_00057_png,	/* AnimationLeft_00057.png - S70 */
	SN_AnimationLeft_00058_png,	/* AnimationLeft_00058.png - S71 */
	SN_AnimationLeft_00059_png,	/* AnimationLeft_00059.png - S72 */
	SN_AnimationLeft_00060_png,	/* AnimationLeft_00060.png - S73 */
	SN_AnimationLeft_00061_png,	/* AnimationLeft_00061.png - S74 */
	SN_AnimationLeft_00062_png,	/* AnimationLeft_00062.png - S75 */
	SN_AnimationLeft_00063_png,	/* AnimationLeft_00063.png - S76 */
	SN_AnimationLeft_00064_png,	/* AnimationLeft_00064.png - S77 */
	SN_AnimationLeft_00065_png,	/* AnimationLeft_00065.png - S78 */
	SN_AnimationLeft_00066_png,	/* AnimationLeft_00066.png - S79 */
	SN_AnimationLeft_00067_png,	/* AnimationLeft_00067.png - S80 */
	SN_AnimationLeft_00068_png,	/* AnimationLeft_00068.png - S81 */
	SN_AnimationLeft_00069_png,	/* AnimationLeft_00069.png - S82 */
	SN_AnimationLeft_00070_png,	/* AnimationLeft_00070.png - S83 */
	SN_AnimationLeft_00071_png,	/* AnimationLeft_00071.png - S84 */
	SN_AnimationLeft_00072_png,	/* AnimationLeft_00072.png - S85 */
	SN_AnimationLeft_00073_png,	/* AnimationLeft_00073.png - S86 */
	SN_AnimationLeft_00074_png,	/* AnimationLeft_00074.png - S87 */
	SN_AnimationLeft_00075_png,	/* AnimationLeft_00075.png - S88 */
	SN_AnimationLeft_00076_png,	/* AnimationLeft_00076.png - S89 */
	SN_AnimationLeft_00077_png,	/* AnimationLeft_00077.png - S90 */
	SN_AnimationLeft_00078_png,	/* AnimationLeft_00078.png - S91 */
	SN_AnimationLeft_00079_png,	/* AnimationLeft_00079.png - S92 */
	SN_AnimationLeft_00080_png,	/* AnimationLeft_00080.png - S93 */
	SN_AnimationLeft_00081_png,	/* AnimationLeft_00081.png - S94 */
	SN_AnimationLeft_00082_png,	/* AnimationLeft_00082.png - S95 */
	SN_AnimationLeft_00083_png,	/* AnimationLeft_00083.png - S96 */
	SN_AnimationLeft_00084_png,	/* AnimationLeft_00084.png - S97 */
	SN_AnimationLeft_00085_png,	/* AnimationLeft_00085.png - S98 */
	SN_AnimationLeft_00086_png,	/* AnimationLeft_00086.png - S99 */
	SN_AnimationLeft_00087_png,	/* AnimationLeft_00087.png - S100 */
	SN_AnimationLeft_00088_png,	/* AnimationLeft_00088.png - S101 */
	SN_AnimationRight_00000_png,	/* AnimationRight_00000.png - S102 */
	SN_AnimationRight_00001_png,	/* AnimationRight_00001.png - S103 */
	SN_AnimationRight_00002_png,	/* AnimationRight_00002.png - S104 */
	SN_AnimationRight_00003_png,	/* AnimationRight_00003.png - S105 */
	SN_AnimationRight_00004_png,	/* AnimationRight_00004.png - S106 */
	SN_AnimationRight_00005_png,	/* AnimationRight_00005.png - S107 */
	SN_AnimationRight_00006_png,	/* AnimationRight_00006.png - S108 */
	SN_AnimationRight_00007_png,	/* AnimationRight_00007.png - S109 */
	SN_AnimationRight_00008_png,	/* AnimationRight_00008.png - S110 */
	SN_AnimationRight_00009_png,	/* AnimationRight_00009.png - S111 */
	SN_AnimationRight_00010_png,	/* AnimationRight_00010.png - S112 */
	SN_AnimationRight_00011_png,	/* AnimationRight_00011.png - S113 */
	SN_AnimationRight_00012_png,	/* AnimationRight_00012.png - S114 */
	SN_AnimationRight_00013_png,	/* AnimationRight_00013.png - S115 */
	SN_AnimationRight_00014_png,	/* AnimationRight_00014.png - S116 */
	SN_AnimationRight_00015_png,	/* AnimationRight_00015.png - S117 */
	SN_AnimationRight_00016_png,	/* AnimationRight_00016.png - S118 */
	SN_AnimationRight_00017_png,	/* AnimationRight_00017.png - S119 */
	SN_AnimationRight_00018_png,	/* AnimationRight_00018.png - S120 */
	SN_AnimationRight_00019_png,	/* AnimationRight_00019.png - S121 */
	SN_AnimationRight_00020_png,	/* AnimationRight_00020.png - S122 */
	SN_AnimationRight_00021_png,	/* AnimationRight_00021.png - S123 */
	SN_AnimationRight_00022_png,	/* AnimationRight_00022.png - S124 */
	SN_AnimationRight_00023_png,	/* AnimationRight_00023.png - S125 */
	SN_AnimationRight_00024_png,	/* AnimationRight_00024.png - S126 */
	SN_AnimationRight_00025_png,	/* AnimationRight_00025.png - S127 */
	SN_AnimationRight_00026_png,	/* AnimationRight_00026.png - S128 */
	SN_AnimationRight_00027_png,	/* AnimationRight_00027.png - S129 */
	SN_AnimationRight_00028_png,	/* AnimationRight_00028.png - S130 */
	SN_AnimationRight_00029_png,	/* AnimationRight_00029.png - S131 */
	SN_AnimationRight_00030_png,	/* AnimationRight_00030.png - S132 */
	SN_AnimationRight_00031_png,	/* AnimationRight_00031.png - S133 */
	SN_AnimationRight_00032_png,	/* AnimationRight_00032.png - S134 */
	SN_AnimationRight_00033_png,	/* AnimationRight_00033.png - S135 */
	SN_AnimationRight_00034_png,	/* AnimationRight_00034.png - S136 */
	SN_AnimationRight_00035_png,	/* AnimationRight_00035.png - S137 */
	SN_AnimationRight_00036_png,	/* AnimationRight_00036.png - S138 */
	SN_AnimationRight_00037_png,	/* AnimationRight_00037.png - S139 */
	SN_AnimationRight_00038_png,	/* AnimationRight_00038.png - S140 */
	SN_AnimationRight_00039_png,	/* AnimationRight_00039.png - S141 */
	SN_AnimationRight_00040_png,	/* AnimationRight_00040.png - S142 */
	SN_AnimationRight_00041_png,	/* AnimationRight_00041.png - S143 */
	SN_AnimationRight_00042_png,	/* AnimationRight_00042.png - S144 */
	SN_AnimationRight_00043_png,	/* AnimationRight_00043.png - S145 */
	SN_AnimationRight_00044_png,	/* AnimationRight_00044.png - S146 */
	SN_AnimationRight_00045_png,	/* AnimationRight_00045.png - S147 */
	SN_AnimationRight_00046_png,	/* AnimationRight_00046.png - S148 */
	SN_AnimationRight_00047_png,	/* AnimationRight_00047.png - S149 */
	SN_AnimationRight_00048_png,	/* AnimationRight_00048.png - S150 */
	SN_AnimationRight_00049_png,	/* AnimationRight_00049.png - S151 */
	SN_AnimationRight_00050_png,	/* AnimationRight_00050.png - S152 */
	SN_AnimationRight_00051_png,	/* AnimationRight_00051.png - S153 */
	SN_AnimationRight_00052_png,	/* AnimationRight_00052.png - S154 */
	SN_AnimationRight_00053_png,	/* AnimationRight_00053.png - S155 */
	SN_AnimationRight_00054_png,	/* AnimationRight_00054.png - S156 */
	SN_AnimationRight_00055_png,	/* AnimationRight_00055.png - S157 */
	SN_AnimationRight_00056_png,	/* AnimationRight_00056.png - S158 */
	SN_AnimationRight_00057_png,	/* AnimationRight_00057.png - S159 */
	SN_AnimationRight_00058_png,	/* AnimationRight_00058.png - S160 */
	SN_AnimationRight_00059_png,	/* AnimationRight_00059.png - S161 */
	SN_AnimationRight_00060_png,	/* AnimationRight_00060.png - S162 */
	SN_AnimationRight_00061_png,	/* AnimationRight_00061.png - S163 */
	SN_AnimationRight_00062_png,	/* AnimationRight_00062.png - S164 */
	SN_AnimationRight_00063_png,	/* AnimationRight_00063.png - S165 */
	SN_AnimationRight_00064_png,	/* AnimationRight_00064.png - S166 */
	SN_AnimationRight_00065_png,	/* AnimationRight_00065.png - S167 */
	SN_AnimationRight_00066_png,	/* AnimationRight_00066.png - S168 */
	SN_AnimationRight_00067_png,	/* AnimationRight_00067.png - S169 */
	SN_AnimationRight_00068_png,	/* AnimationRight_00068.png - S170 */
	SN_AnimationRight_00069_png,	/* AnimationRight_00069.png - S171 */
	SN_AnimationRight_00070_png,	/* AnimationRight_00070.png - S172 */
	SN_AnimationRight_00071_png,	/* AnimationRight_00071.png - S173 */
	SN_AnimationRight_00072_png,	/* AnimationRight_00072.png - S174 */
	SN_AnimationRight_00073_png,	/* AnimationRight_00073.png - S175 */
	SN_AnimationRight_00074_png,	/* AnimationRight_00074.png - S176 */
	SN_AnimationRight_00075_png,	/* AnimationRight_00075.png - S177 */
	SN_AnimationRight_00076_png,	/* AnimationRight_00076.png - S178 */
	SN_AnimationRight_00077_png,	/* AnimationRight_00077.png - S179 */
	SN_AnimationRight_00078_png,	/* AnimationRight_00078.png - S180 */
	SN_AnimationRight_00079_png,	/* AnimationRight_00079.png - S181 */
	SN_AnimationRight_00080_png,	/* AnimationRight_00080.png - S182 */
	SN_AnimationRight_00081_png,	/* AnimationRight_00081.png - S183 */
	SN_AnimationRight_00082_png,	/* AnimationRight_00082.png - S184 */
	SN_AnimationRight_00083_png,	/* AnimationRight_00083.png - S185 */
	SN_AnimationRight_00084_png,	/* AnimationRight_00084.png - S186 */
	SN_AnimationRight_00085_png,	/* AnimationRight_00085.png - S187 */
	SN_AnimationRight_00086_png,	/* AnimationRight_00086.png - S188 */
	SN_AnimationRight_00087_png,	/* AnimationRight_00087.png - S189 */
	SN_AnimationRight_00088_png,	/* AnimationRight_00088.png - S190 */
	SN_chesu_16_1_00_png,	/* chesu-16-1-00.png - S191 */
	SN_chesu_16_1_01_png,	/* chesu-16-1-01.png - S192 */
	SN_chesu_16_1_02_png,	/* chesu-16-1-02.png - S193 */
	SN_chesu_16_1_03_png,	/* chesu-16-1-03.png - S194 */
	SN_chesu_16_1_04_png,	/* chesu-16-1-04.png - S195 */
	SN_chesu_16_1_05_png,	/* chesu-16-1-05.png - S196 */
	SN_chesu_16_1_06_png,	/* chesu-16-1-06.png - S197 */
	SN_chesu_16_1_07_png,	/* chesu-16-1-07.png - S198 */
	SN_chesu_16_1_08_png,	/* chesu-16-1-08.png - S199 */
	SN_chesu_16_2_07_png,	/* chesu-16-2-07.png - S200 */
	SN_chesu_16_2_08_png,	/* chesu-16-2-08.png - S201 */
	SN_chesu_16_2_09_png,	/* chesu-16-2-09.png - S202 */
	SN_chesu_16_2_10_png,	/* chesu-16-2-10.png - S203 */
	SN_chesu_16_2_11_png,	/* chesu-16-2-11.png - S204 */
	SN_chesu_16_2_12_png,	/* chesu-16-2-12.png - S205 */
	SN_chesu_16_2_13_png,	/* chesu-16-2-13.png - S206 */
	SN_chesu_16_2_14_png,	/* chesu-16-2-14.png - S207 */
	SN_chesu_16_2_15_png,	/* chesu-16-2-15.png - S208 */
	SN_chesu_16_2_16_png,	/* chesu-16-2-16.png - S209 */
	SN_daxiaoji_01_png,	/* daxiaoji-01.png - S210 */
	SN_daxiaoji_02_png,	/* daxiaoji-02.png - S211 */
	SN_GEAR_D_png,	/* GEAR_D.png - S212 */
	SN_GEAR_H_png,	/* GEAR_H.png - S213 */
	SN_GEAR_L_png,	/* GEAR_L.png - S214 */
	SN_GEAR_M_png,	/* GEAR_M.png - S215 */
	SN_GEAR_N_png,	/* GEAR_N.png - S216 */
	SN_GEAR_R_png,	/* GEAR_R.png - S217 */
	SN_heiqu_png,	/* heiqu.png - S218 */
	SN_heisequyu_png,	/* heisequyu.png - S219 */
	SN_menu00_png,	/* menu00.png - S220 */
	SN_menu01_png,	/* menu01.png - S221 */
	SN_menu02_png,	/* menu02.png - S222 */
	SN_menu03_png,	/* menu03.png - S223 */
	SN_menu04_png,	/* menu04.png - S224 */
	SN_NB_16_8_00_png,	/* NB_16.8_00.png - S225 */
	SN_NB_16_8_01_png,	/* NB_16.8_01.png - S226 */
	SN_NB_16_8_02_png,	/* NB_16.8_02.png - S227 */
	SN_NB_16_8_03_png,	/* NB_16.8_03.png - S228 */
	SN_NB_16_8_04_png,	/* NB_16.8_04.png - S229 */
	SN_NB_16_8_05_png,	/* NB_16.8_05.png - S230 */
	SN_NB_16_8_06_png,	/* NB_16.8_06.png - S231 */
	SN_NB_16_8_07_png,	/* NB_16.8_07.png - S232 */
	SN_NB_16_8_08_png,	/* NB_16.8_08.png - S233 */
	SN_NB_16_8_09_png,	/* NB_16.8_09.png - S234 */
	SN_NB_16_00_png,	/* NB_16_00.png - S235 */
	SN_NB_16_01_png,	/* NB_16_01.png - S236 */
	SN_NB_16_02_png,	/* NB_16_02.png - S237 */
	SN_NB_16_03_png,	/* NB_16_03.png - S238 */
	SN_NB_16_04_png,	/* NB_16_04.png - S239 */
	SN_NB_16_05_png,	/* NB_16_05.png - S240 */
	SN_NB_16_06_png,	/* NB_16_06.png - S241 */
	SN_NB_16_07_png,	/* NB_16_07.png - S242 */
	SN_NB_16_08_png,	/* NB_16_08.png - S243 */
	SN_NB_16_09_png,	/* NB_16_09.png - S244 */
	SN_NB_16_dian_png,	/* NB_16_dian.png - S245 */
	SN_NB_16_maohao_png,	/* NB_16_maohao.png - S246 */
	SN_NB_17_00_png,	/* NB_17_00.png - S247 */
	SN_NB_17_01_png,	/* NB_17_01.png - S248 */
	SN_NB_17_02_png,	/* NB_17_02.png - S249 */
	SN_NB_17_03_png,	/* NB_17_03.png - S250 */
	SN_NB_17_04_png,	/* NB_17_04.png - S251 */
	SN_NB_17_05_png,	/* NB_17_05.png - S252 */
	SN_NB_17_06_png,	/* NB_17_06.png - S253 */
	SN_NB_17_07_png,	/* NB_17_07.png - S254 */
	SN_NB_17_08_png,	/* NB_17_08.png - S255 */
	SN_NB_17_09_png,	/* NB_17_09.png - S256 */
	SN_NB_17_point_png,	/* NB_17_point.png - S257 */
	SN_NB_22_00_png,	/* NB_22_00.png - S258 */
	SN_NB_22_01_png,	/* NB_22_01.png - S259 */
	SN_NB_22_02_png,	/* NB_22_02.png - S260 */
	SN_NB_22_03_png,	/* NB_22_03.png - S261 */
	SN_NB_22_04_png,	/* NB_22_04.png - S262 */
	SN_NB_22_05_png,	/* NB_22_05.png - S263 */
	SN_NB_22_06_png,	/* NB_22_06.png - S264 */
	SN_NB_22_07_png,	/* NB_22_07.png - S265 */
	SN_NB_22_08_png,	/* NB_22_08.png - S266 */
	SN_NB_22_09_png,	/* NB_22_09.png - S267 */
	SN_NB_22_dian_png,	/* NB_22_dian.png - S268 */
	SN_NB_22_henggang_png,	/* NB_22_henggang.png - S269 */
	SN_NB_22_red_00_png,	/* NB_22_red_00.png - S270 */
	SN_NB_22_red_01_png,	/* NB_22_red_01.png - S271 */
	SN_NB_22_red_02_png,	/* NB_22_red_02.png - S272 */
	SN_NB_22_red_03_png,	/* NB_22_red_03.png - S273 */
	SN_NB_22_red_04_png,	/* NB_22_red_04.png - S274 */
	SN_NB_22_red_05_png,	/* NB_22_red_05.png - S275 */
	SN_NB_22_red_06_png,	/* NB_22_red_06.png - S276 */
	SN_NB_22_red_07_png,	/* NB_22_red_07.png - S277 */
	SN_NB_22_red_08_png,	/* NB_22_red_08.png - S278 */
	SN_NB_22_red_09_png,	/* NB_22_red_09.png - S279 */
	SN_NB_23_00_png,	/* NB_23_00.png - S280 */
	SN_NB_23_01_png,	/* NB_23_01.png - S281 */
	SN_NB_23_02_png,	/* NB_23_02.png - S282 */
	SN_NB_23_03_png,	/* NB_23_03.png - S283 */
	SN_NB_23_04_png,	/* NB_23_04.png - S284 */
	SN_NB_23_05_png,	/* NB_23_05.png - S285 */
	SN_NB_23_06_png,	/* NB_23_06.png - S286 */
	SN_NB_23_07_png,	/* NB_23_07.png - S287 */
	SN_NB_23_08_png,	/* NB_23_08.png - S288 */
	SN_NB_23_09_png,	/* NB_23_09.png - S289 */
	SN_NB_23_black_00_png,	/* NB_23_black_00.png - S290 */
	SN_NB_23_black_01_png,	/* NB_23_black_01.png - S291 */
	SN_NB_23_black_02_png,	/* NB_23_black_02.png - S292 */
	SN_NB_23_black_03_png,	/* NB_23_black_03.png - S293 */
	SN_NB_23_black_04_png,	/* NB_23_black_04.png - S294 */
	SN_NB_23_black_05_png,	/* NB_23_black_05.png - S295 */
	SN_NB_23_black_06_png,	/* NB_23_black_06.png - S296 */
	SN_NB_23_black_07_png,	/* NB_23_black_07.png - S297 */
	SN_NB_23_black_08_png,	/* NB_23_black_08.png - S298 */
	SN_NB_23_black_09_png,	/* NB_23_black_09.png - S299 */
	SN_NB_23_maohao_png,	/* NB_23_maohao.png - S300 */
	SN_NB_32_5_00_png,	/* NB_32.5_00.png - S301 */
	SN_NB_32_5_01_png,	/* NB_32.5_01.png - S302 */
	SN_NB_32_5_02_png,	/* NB_32.5_02.png - S303 */
	SN_NB_32_5_03_png,	/* NB_32.5_03.png - S304 */
	SN_NB_32_5_04_png,	/* NB_32.5_04.png - S305 */
	SN_NB_32_5_05_png,	/* NB_32.5_05.png - S306 */
	SN_NB_32_5_06_png,	/* NB_32.5_06.png - S307 */
	SN_NB_32_5_07_png,	/* NB_32.5_07.png - S308 */
	SN_NB_32_5_08_png,	/* NB_32.5_08.png - S309 */
	SN_NB_32_5_09_png,	/* NB_32.5_09.png - S310 */
	SN_NB_32_5_dian_png,	/* NB_32.5_dian.png - S311 */
	SN_NB_55_00_png,	/* NB_55_00.png - S312 */
	SN_NB_55_01_png,	/* NB_55_01.png - S313 */
	SN_NB_55_02_png,	/* NB_55_02.png - S314 */
	SN_NB_55_03_png,	/* NB_55_03.png - S315 */
	SN_NB_55_04_png,	/* NB_55_04.png - S316 */
	SN_NB_55_05_png,	/* NB_55_05.png - S317 */
	SN_NB_55_06_png,	/* NB_55_06.png - S318 */
	SN_NB_55_07_png,	/* NB_55_07.png - S319 */
	SN_NB_55_08_png,	/* NB_55_08.png - S320 */
	SN_NB_55_09_png,	/* NB_55_09.png - S321 */
	SN_qiya1_png,	/* qiya1.png - S322 */
	SN_qiya2_png,	/* qiya2.png - S323 */
	SN_set_1_01_png,	/* set_1_01.png - S324 */
	SN_set_1_02_png,	/* set_1_02.png - S325 */
	SN_set_1_03_png,	/* set_1_03.png - S326 */
	SN_set_1_04_png,	/* set_1_04.png - S327 */
	SN_set_1_05_png,	/* set_1_05.png - S328 */
	SN_Set_2_01_png,	/* Set_2_01.png - S329 */
	SN_Set_2_02_png,	/* Set_2_02.png - S330 */
	SN_Set_2_03_png,	/* Set_2_03.png - S331 */
	SN_Set_3_01_png,	/* Set_3_01.png - S332 */
	SN_Set_3_02_png,	/* Set_3_02.png - S333 */
	SN_Set_3_03_png,	/* Set_3_03.png - S334 */
	SN_Set_3_04_png,	/* Set_3_04.png - S335 */
	SN_Set_3_05_png,	/* Set_3_05.png - S336 */
	SN_Tire_Pressure_BAR_png,	/* Tire_Pressure_BAR.png - S337 */
	SN_Tire_Pressure_BARhong_png,	/* Tire_Pressure_BARhong.png - S338 */
	SN_Tire_Pressure___png,	/* Tire_Pressure_℃.png - S339 */
	SN_Tire_Pressure_cheti_png,	/* Tire_Pressure_cheti.png - S340 */
	SN_Vehicle_Information_Display_uint_png,	/* Vehicle_Information_Display_uint.png - S341 */
	SN_Vehicle_Information_Display1_png,	/* Vehicle_Information_Display1.png - S342 */
	SN_Vehicle_Information_Display2_png,	/* Vehicle_Information_Display2.png - S343 */
	SN_Vehicle_Information_Display3_png,	/* Vehicle_Information_Display3.png - S344 */
	SN_Vehicle_Information_Display3_uint_png,	/* Vehicle_Information_Display3_uint.png - S345 */
	SN_w40y45_png,	/* w40y45.png - S346 */
	SN_w45y45_png,	/* w45y45.png - S347 */
	SN_youqiya_00_png,	/* youqiya-00.png - S348 */
	SN_youqiya_01_png,	/* youqiya-01.png - S349 */
	SN_youqiya_02_png,	/* youqiya-02.png - S350 */
	SN_youqiya_03_png,	/* youqiya-03.png - S351 */
	SN_youqiya_04_png,	/* youqiya-04.png - S352 */
	SN_youqiya_05_png,	/* youqiya-05.png - S353 */
	SN_youqiya_06_png,	/* youqiya-06.png - S354 */
	SN_youqiya_07_png,	/* youqiya-07.png - S355 */
	SN_youqiya_08_png,	/* youqiya-08.png - S356 */
	SN_youqiya_09_png,	/* youqiya-09.png - S357 */
	SN_youqiya_10_png,	/* youqiya-10.png - S358 */
	SN_youqiya_11_png,	/* youqiya-11.png - S359 */
	SN_youqiya_12_png,	/* youqiya-12.png - S360 */
	SN_youqiya_13_png,	/* youqiya-13.png - S361 */
	SN_youqiya_14_png,	/* youqiya-14.png - S362 */
	SN_youqiya_15_png,	/* youqiya-15.png - S363 */
	SN_youqiyashuzi_png,	/* youqiyashuzi.png - S364 */
	SN_zhishideng_01_png,	/* zhishideng-01.png - S365 */
	SN_zhishideng_01_1_png,	/* zhishideng-01-1.png - S366 */
	SN_zhishideng_02_png,	/* zhishideng-02.png - S367 */
	SN_zhishideng_03_png,	/* zhishideng-03.png - S368 */
	SN_zhishideng_04_png,	/* zhishideng-04.png - S369 */
	SN_zhishideng_05_png,	/* zhishideng-05.png - S370 */
	SN_zhishideng_06_png,	/* zhishideng-06.png - S371 */
	SN_zhishideng_07_png,	/* zhishideng-07.png - S372 */
	SN_zhishideng_08_png,	/* zhishideng-08.png - S373 */
	SN_zhishideng_09_png,	/* zhishideng-09.png - S374 */
	SN_zhishideng_10_png,	/* zhishideng-10.png - S375 */
	SN_zhishideng_11_png,	/* zhishideng-11.png - S376 */
	SN_zhishideng_12_png,	/* zhishideng-12.png - S377 */
	SN_zhishideng_13_png,	/* zhishideng-13.png - S378 */
	SN_zhishideng_14_png,	/* zhishideng-14.png - S379 */
	SN_zhishideng_15_png,	/* zhishideng-15.png - S380 */
	SN_zhishideng_16_png,	/* zhishideng-16.png - S381 */
	SN_zhishideng_17_png,	/* zhishideng-17.png - S382 */
	SN_zhishideng_18_png,	/* zhishideng-18.png - S383 */
	SN_zhishideng_19_png,	/* zhishideng-19.png - S384 */
	SN_zhishideng_20_png,	/* zhishideng-20.png - S385 */
	SN_zhishideng_21_png,	/* zhishideng-21.png - S386 */
	SN_zhishideng_22_png,	/* zhishideng-22.png - S387 */
	SN_zhishideng_23_png,	/* zhishideng-23.png - S388 */
	SN_zhishideng_23_1_png,	/* zhishideng-23-1.png - S389 */
	SN_zhishideng_24_png,	/* zhishideng-24.png - S390 */
	SN_zhishideng_25_png,	/* zhishideng-25.png - S391 */
	SN_zhishideng_26_png,	/* zhishideng-26.png - S392 */
	SN_zhishideng_27_png,	/* zhishideng-27.png - S393 */
	SN_zhishideng_28_png,	/* zhishideng-28.png - S394 */
	SN_zhuansu_1_00_png,	/* zhuansu-1-00.png - S395 */
	SN_zhuansu_1_01_png,	/* zhuansu-1-01.png - S396 */
	SN_zhuansu_1_02_png,	/* zhuansu-1-02.png - S397 */
	SN_zhuansu_1_03_png,	/* zhuansu-1-03.png - S398 */
	SN_zhuansu_1_04_png,	/* zhuansu-1-04.png - S399 */
	SN_zhuansu_1_05_png,	/* zhuansu-1-05.png - S400 */
	SN_zhuansu_1_06_png,	/* zhuansu-1-06.png - S401 */
	SN_zhuansu_2_05_png,	/* zhuansu-2-05.png - S402 */
	SN_zhuansu_2_06_png,	/* zhuansu-2-06.png - S403 */
	SN_zhuansu_2_07_png,	/* zhuansu-2-07.png - S404 */
	SN_zhuansu_2_08_png,	/* zhuansu-2-08.png - S405 */
	SN_zhuansu_2_09_png,	/* zhuansu-2-09.png - S406 */
	SN_zhuansu_2_10_png,	/* zhuansu-2-10.png - S407 */
	SN_zuoqiya_00_png,	/* zuoqiya-00.png - S408 */
	SN_zuoqiya_01_png,	/* zuoqiya-01.png - S409 */
	SN_zuoqiya_02_png,	/* zuoqiya-02.png - S410 */
	SN_zuoqiya_03_png,	/* zuoqiya-03.png - S411 */
	SN_zuoqiya_04_png,	/* zuoqiya-04.png - S412 */
	SN_zuoqiya_05_png,	/* zuoqiya-05.png - S413 */
	SN_zuoqiya_06_png,	/* zuoqiya-06.png - S414 */
	SN_zuoqiya_07_png,	/* zuoqiya-07.png - S415 */
	SN_zuoqiya_08_png,	/* zuoqiya-08.png - S416 */
	SN_zuoqiya_09_png,	/* zuoqiya-09.png - S417 */
	SN_zuoqiya_10_png,	/* zuoqiya-10.png - S418 */
	SN_zuoqiya_11_png,	/* zuoqiya-11.png - S419 */
	SN_zuoqiya_12_png,	/* zuoqiya-12.png - S420 */
	SN_zuoqiya_13_png,	/* zuoqiya-13.png - S421 */
	SN_zuoqiya_14_png,	/* zuoqiya-14.png - S422 */
	SN_zuoqiya_15_png,	/* zuoqiya-15.png - S423 */
	SN_zuoqiyashuzi_png	/* zuoqiyashuzi.png - S424 */
};
#pragma CONST_SEG __GPAGE_SEG MAPDATA_ROM
static const T_VC1H_PATTERNDATA tVc1hPatternData[] = {
	/* SpriteAttributeData[12], PaletteID */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x00,0x00,0x40,0x40}, -1},	/* ALARM_01.png - S1 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x03,0x07,0x40,0x40}, -1},	/* ALARM_02.png - S2 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x06,0xBF,0x40,0x40}, -1},	/* ALARM_03.png - S3 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x0A,0xFB,0x40,0x40}, -1},	/* ALARM_04.png - S4 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x0F,0x2F,0x40,0x40}, -1},	/* ALARM_05.png - S5 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x13,0x68,0x40,0x40}, -1},	/* ALARM_06.png - S6 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x1A,0xA0,0x40,0x40}, -1},	/* ALARM_07.png - S7 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x30,0x00,0x1D,0x84,0x40,0x40}, -1},	/* ALARM_08.png - S8 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x21,0xEB,0x40,0x40}, -1},	/* ALARM_09.png - S9 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x23,0xFF,0x40,0x40}, -1},	/* ALARM_10.png - S10 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x26,0xBE,0x40,0x40}, -1},	/* ALARM_11.png - S11 */
	{{0xA0,0x00,0x00,0x00,0x51,0x61,0x20,0x00,0x29,0x19,0x40,0x40}, -1},	/* ALARM_12.png - S12 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x2B,0x32,0x40,0x40}, -1},	/* AnimationLeft_00000.png - S13 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x2B,0xBE,0x40,0x40}, -1},	/* AnimationLeft_00001.png - S14 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x2D,0x74,0x40,0x40}, -1},	/* AnimationLeft_00002.png - S15 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x30,0x0A,0x40,0x40}, -1},	/* AnimationLeft_00003.png - S16 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x33,0x52,0x40,0x40}, -1},	/* AnimationLeft_00004.png - S17 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x37,0x4F,0x40,0x40}, -1},	/* AnimationLeft_00005.png - S18 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x3B,0xC0,0x40,0x40}, -1},	/* AnimationLeft_00006.png - S19 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x40,0xB0,0x40,0x40}, -1},	/* AnimationLeft_00007.png - S20 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x45,0xFB,0x40,0x40}, -1},	/* AnimationLeft_00008.png - S21 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x4B,0x97,0x40,0x40}, -1},	/* AnimationLeft_00009.png - S22 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x51,0x8F,0x40,0x40}, -1},	/* AnimationLeft_00010.png - S23 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x57,0xCD,0x40,0x40}, -1},	/* AnimationLeft_00011.png - S24 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x5E,0x40,0x40,0x40}, -1},	/* AnimationLeft_00012.png - S25 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x64,0xB3,0x40,0x40}, -1},	/* AnimationLeft_00013.png - S26 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x6B,0x26,0x40,0x40}, -1},	/* AnimationLeft_00014.png - S27 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x71,0x99,0x40,0x40}, -1},	/* AnimationLeft_00015.png - S28 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x78,0x0C,0x40,0x40}, -1},	/* AnimationLeft_00016.png - S29 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x7E,0x7F,0x40,0x40}, -1},	/* AnimationLeft_00017.png - S30 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x84,0xF2,0x40,0x40}, -1},	/* AnimationLeft_00018.png - S31 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x8B,0x65,0x40,0x40}, -1},	/* AnimationLeft_00019.png - S32 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x91,0xD8,0x40,0x40}, -1},	/* AnimationLeft_00020.png - S33 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x00,0x98,0x4B,0x40,0x40}, -1},	/* AnimationLeft_00021.png - S34 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x00,0x9E,0xBE,0x40,0x40}, -1},	/* AnimationLeft_00022.png - S35 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x00,0xAA,0xCD,0x40,0x40}, -1},	/* AnimationLeft_00023.png - S36 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x00,0xB9,0xBB,0x40,0x40}, -1},	/* AnimationLeft_00024.png - S37 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x00,0xCA,0xB6,0x40,0x40}, -1},	/* AnimationLeft_00025.png - S38 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x00,0xDD,0xB9,0x40,0x40}, -1},	/* AnimationLeft_00026.png - S39 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x00,0xF2,0x3F,0x40,0x40}, -1},	/* AnimationLeft_00027.png - S40 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x08,0x02,0x40,0x40}, -1},	/* AnimationLeft_00028.png - S41 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x1E,0xF8,0x40,0x40}, -1},	/* AnimationLeft_00029.png - S42 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x36,0xDD,0x40,0x40}, -1},	/* AnimationLeft_00030.png - S43 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x4F,0xB4,0x40,0x40}, -1},	/* AnimationLeft_00031.png - S44 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x69,0x18,0x40,0x40}, -1},	/* AnimationLeft_00032.png - S45 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x83,0x06,0x40,0x40}, -1},	/* AnimationLeft_00033.png - S46 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0x9D,0x27,0x40,0x40}, -1},	/* AnimationLeft_00034.png - S47 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0xB7,0xA3,0x40,0x40}, -1},	/* AnimationLeft_00035.png - S48 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0xD2,0x45,0x40,0x40}, -1},	/* AnimationLeft_00036.png - S49 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x01,0xED,0x1F,0x40,0x40}, -1},	/* AnimationLeft_00037.png - S50 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0x07,0xF9,0x40,0x40}, -1},	/* AnimationLeft_00038.png - S51 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0x24,0x3B,0x40,0x40}, -1},	/* AnimationLeft_00039.png - S52 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0x40,0xBE,0x40,0x40}, -1},	/* AnimationLeft_00040.png - S53 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0x5D,0x55,0x40,0x40}, -1},	/* AnimationLeft_00041.png - S54 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0x7A,0x14,0x40,0x40}, -1},	/* AnimationLeft_00042.png - S55 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0x96,0xDC,0x40,0x40}, -1},	/* AnimationLeft_00043.png - S56 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0xB3,0xC4,0x40,0x40}, -1},	/* AnimationLeft_00044.png - S57 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0xD0,0x9D,0x40,0x40}, -1},	/* AnimationLeft_00045.png - S58 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x02,0xED,0x7D,0x40,0x40}, -1},	/* AnimationLeft_00046.png - S59 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0x0A,0x43,0x40,0x40}, -1},	/* AnimationLeft_00047.png - S60 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0x27,0x06,0x40,0x40}, -1},	/* AnimationLeft_00048.png - S61 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0x43,0xAD,0x40,0x40}, -1},	/* AnimationLeft_00049.png - S62 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0x60,0x42,0x40,0x40}, -1},	/* AnimationLeft_00050.png - S63 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0x7C,0xE8,0x40,0x40}, -1},	/* AnimationLeft_00051.png - S64 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0x99,0x5C,0x40,0x40}, -1},	/* AnimationLeft_00052.png - S65 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0xB5,0xB4,0x40,0x40}, -1},	/* AnimationLeft_00053.png - S66 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0xD1,0xF7,0x40,0x40}, -1},	/* AnimationLeft_00054.png - S67 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x03,0xEE,0x16,0x40,0x40}, -1},	/* AnimationLeft_00055.png - S68 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0x0A,0x02,0x40,0x40}, -1},	/* AnimationLeft_00056.png - S69 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0x25,0xE4,0x40,0x40}, -1},	/* AnimationLeft_00057.png - S70 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0x41,0x7F,0x40,0x40}, -1},	/* AnimationLeft_00058.png - S71 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0x5D,0x32,0x40,0x40}, -1},	/* AnimationLeft_00059.png - S72 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0x78,0x92,0x40,0x40}, -1},	/* AnimationLeft_00060.png - S73 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0x93,0xC3,0x40,0x40}, -1},	/* AnimationLeft_00061.png - S74 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0xAE,0xEA,0x40,0x40}, -1},	/* AnimationLeft_00062.png - S75 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0xC9,0x97,0x40,0x40}, -1},	/* AnimationLeft_00063.png - S76 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0xE4,0x03,0x40,0x40}, -1},	/* AnimationLeft_00064.png - S77 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x04,0xFE,0x40,0x40,0x40}, -1},	/* AnimationLeft_00065.png - S78 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0x18,0x1F,0x40,0x40}, -1},	/* AnimationLeft_00066.png - S79 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0x31,0xC8,0x40,0x40}, -1},	/* AnimationLeft_00067.png - S80 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0x4B,0x2A,0x40,0x40}, -1},	/* AnimationLeft_00068.png - S81 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0x64,0x00,0x40,0x40}, -1},	/* AnimationLeft_00069.png - S82 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0x7C,0x84,0x40,0x40}, -1},	/* AnimationLeft_00070.png - S83 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0x93,0xF1,0x40,0x40}, -1},	/* AnimationLeft_00071.png - S84 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0xAB,0x5E,0x40,0x40}, -1},	/* AnimationLeft_00072.png - S85 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0xC2,0xCB,0x40,0x40}, -1},	/* AnimationLeft_00073.png - S86 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0xDA,0x38,0x40,0x40}, -1},	/* AnimationLeft_00074.png - S87 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x05,0xF1,0xA5,0x40,0x40}, -1},	/* AnimationLeft_00075.png - S88 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x09,0x12,0x40,0x40}, -1},	/* AnimationLeft_00076.png - S89 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x20,0x7F,0x40,0x40}, -1},	/* AnimationLeft_00077.png - S90 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x37,0xEC,0x40,0x40}, -1},	/* AnimationLeft_00078.png - S91 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x4F,0x59,0x40,0x40}, -1},	/* AnimationLeft_00079.png - S92 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x66,0xC6,0x40,0x40}, -1},	/* AnimationLeft_00080.png - S93 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x7E,0x33,0x40,0x40}, -1},	/* AnimationLeft_00081.png - S94 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0x95,0xA0,0x40,0x40}, -1},	/* AnimationLeft_00082.png - S95 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0xAD,0x0D,0x40,0x40}, -1},	/* AnimationLeft_00083.png - S96 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0xC4,0x7A,0x40,0x40}, -1},	/* AnimationLeft_00084.png - S97 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0xDB,0xE7,0x40,0x40}, -1},	/* AnimationLeft_00085.png - S98 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x06,0xF3,0x54,0x40,0x40}, -1},	/* AnimationLeft_00086.png - S99 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0x0A,0xC1,0x40,0x40}, -1},	/* AnimationLeft_00087.png - S100 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0x22,0x2E,0x40,0x40}, -1},	/* AnimationLeft_00088.png - S101 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x39,0x9B,0x40,0x40}, -1},	/* AnimationRight_00000.png - S102 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x3A,0x27,0x40,0x40}, -1},	/* AnimationRight_00001.png - S103 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x3C,0x0E,0x40,0x40}, -1},	/* AnimationRight_00002.png - S104 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x3F,0x05,0x40,0x40}, -1},	/* AnimationRight_00003.png - S105 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x42,0xC5,0x40,0x40}, -1},	/* AnimationRight_00004.png - S106 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x47,0x51,0x40,0x40}, -1},	/* AnimationRight_00005.png - S107 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x4C,0x5A,0x40,0x40}, -1},	/* AnimationRight_00006.png - S108 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x51,0xE0,0x40,0x40}, -1},	/* AnimationRight_00007.png - S109 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x57,0xC0,0x40,0x40}, -1},	/* AnimationRight_00008.png - S110 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x5D,0xF3,0x40,0x40}, -1},	/* AnimationRight_00009.png - S111 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x64,0x6F,0x40,0x40}, -1},	/* AnimationRight_00010.png - S112 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x6B,0x49,0x40,0x40}, -1},	/* AnimationRight_00011.png - S113 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x72,0x51,0x40,0x40}, -1},	/* AnimationRight_00012.png - S114 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x79,0x59,0x40,0x40}, -1},	/* AnimationRight_00013.png - S115 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x80,0x61,0x40,0x40}, -1},	/* AnimationRight_00014.png - S116 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x87,0x69,0x40,0x40}, -1},	/* AnimationRight_00015.png - S117 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x8E,0x71,0x40,0x40}, -1},	/* AnimationRight_00016.png - S118 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x95,0x79,0x40,0x40}, -1},	/* AnimationRight_00017.png - S119 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0x9C,0x81,0x40,0x40}, -1},	/* AnimationRight_00018.png - S120 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0xA3,0x89,0x40,0x40}, -1},	/* AnimationRight_00019.png - S121 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0xAA,0x91,0x40,0x40}, -1},	/* AnimationRight_00020.png - S122 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x00,0x07,0xB1,0x99,0x40,0x40}, -1},	/* AnimationRight_00021.png - S123 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0xB8,0xA1,0x40,0x40}, -1},	/* AnimationRight_00022.png - S124 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0xC5,0x2A,0x40,0x40}, -1},	/* AnimationRight_00023.png - S125 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0xD4,0x6F,0x40,0x40}, -1},	/* AnimationRight_00024.png - S126 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0xE5,0xB9,0x40,0x40}, -1},	/* AnimationRight_00025.png - S127 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x07,0xF9,0x19,0x40,0x40}, -1},	/* AnimationRight_00026.png - S128 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0x0D,0xF2,0x40,0x40}, -1},	/* AnimationRight_00027.png - S129 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0x23,0xE5,0x40,0x40}, -1},	/* AnimationRight_00028.png - S130 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0x3B,0x17,0x40,0x40}, -1},	/* AnimationRight_00029.png - S131 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0x53,0x55,0x40,0x40}, -1},	/* AnimationRight_00030.png - S132 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0x6C,0x5E,0x40,0x40}, -1},	/* AnimationRight_00031.png - S133 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0x86,0x08,0x40,0x40}, -1},	/* AnimationRight_00032.png - S134 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0xA0,0x37,0x40,0x40}, -1},	/* AnimationRight_00033.png - S135 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0xBA,0x84,0x40,0x40}, -1},	/* AnimationRight_00034.png - S136 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0xD4,0xF5,0x40,0x40}, -1},	/* AnimationRight_00035.png - S137 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x08,0xEF,0x6D,0x40,0x40}, -1},	/* AnimationRight_00036.png - S138 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0x09,0xBA,0x40,0x40}, -1},	/* AnimationRight_00037.png - S139 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0x24,0x07,0x40,0x40}, -1},	/* AnimationRight_00038.png - S140 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0x40,0x1B,0x40,0x40}, -1},	/* AnimationRight_00039.png - S141 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0x5C,0x8E,0x40,0x40}, -1},	/* AnimationRight_00040.png - S142 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0x79,0x37,0x40,0x40}, -1},	/* AnimationRight_00041.png - S143 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0x96,0x0C,0x40,0x40}, -1},	/* AnimationRight_00042.png - S144 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0xB2,0xF6,0x40,0x40}, -1},	/* AnimationRight_00043.png - S145 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0xCF,0xFC,0x40,0x40}, -1},	/* AnimationRight_00044.png - S146 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x09,0xED,0x07,0x40,0x40}, -1},	/* AnimationRight_00045.png - S147 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0x0A,0x24,0x40,0x40}, -1},	/* AnimationRight_00046.png - S148 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0x27,0x3D,0x40,0x40}, -1},	/* AnimationRight_00047.png - S149 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0x44,0x58,0x40,0x40}, -1},	/* AnimationRight_00048.png - S150 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0x61,0x58,0x40,0x40}, -1},	/* AnimationRight_00049.png - S151 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0x7E,0x5A,0x40,0x40}, -1},	/* AnimationRight_00050.png - S152 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0x9B,0x77,0x40,0x40}, -1},	/* AnimationRight_00051.png - S153 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0xB8,0x53,0x40,0x40}, -1},	/* AnimationRight_00052.png - S154 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0xD5,0x32,0x40,0x40}, -1},	/* AnimationRight_00053.png - S155 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0A,0xF1,0xF3,0x40,0x40}, -1},	/* AnimationRight_00054.png - S156 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0x0E,0xA1,0x40,0x40}, -1},	/* AnimationRight_00055.png - S157 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0x2B,0x20,0x40,0x40}, -1},	/* AnimationRight_00056.png - S158 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0x47,0x86,0x40,0x40}, -1},	/* AnimationRight_00057.png - S159 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0x63,0xA7,0x40,0x40}, -1},	/* AnimationRight_00058.png - S160 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0x7F,0xCE,0x40,0x40}, -1},	/* AnimationRight_00059.png - S161 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0x9B,0xCB,0x40,0x40}, -1},	/* AnimationRight_00060.png - S162 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0xB7,0xA0,0x40,0x40}, -1},	/* AnimationRight_00061.png - S163 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0xD3,0x4A,0x40,0x40}, -1},	/* AnimationRight_00062.png - S164 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0B,0xEE,0xB7,0x40,0x40}, -1},	/* AnimationRight_00063.png - S165 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0x09,0xE2,0x40,0x40}, -1},	/* AnimationRight_00064.png - S166 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0x24,0xE9,0x40,0x40}, -1},	/* AnimationRight_00065.png - S167 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0x3F,0xA2,0x40,0x40}, -1},	/* AnimationRight_00066.png - S168 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0x59,0xF2,0x40,0x40}, -1},	/* AnimationRight_00067.png - S169 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0x73,0xED,0x40,0x40}, -1},	/* AnimationRight_00068.png - S170 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0x8D,0x7D,0x40,0x40}, -1},	/* AnimationRight_00069.png - S171 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0xA6,0xAD,0x40,0x40}, -1},	/* AnimationRight_00070.png - S172 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0xBE,0xAE,0x40,0x40}, -1},	/* AnimationRight_00071.png - S173 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0xD6,0xAF,0x40,0x40}, -1},	/* AnimationRight_00072.png - S174 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0C,0xEE,0xB0,0x40,0x40}, -1},	/* AnimationRight_00073.png - S175 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x06,0xB1,0x40,0x40}, -1},	/* AnimationRight_00074.png - S176 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x1E,0xB2,0x40,0x40}, -1},	/* AnimationRight_00075.png - S177 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x36,0xB3,0x40,0x40}, -1},	/* AnimationRight_00076.png - S178 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x4E,0xB4,0x40,0x40}, -1},	/* AnimationRight_00077.png - S179 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x66,0xB5,0x40,0x40}, -1},	/* AnimationRight_00078.png - S180 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x7E,0xB6,0x40,0x40}, -1},	/* AnimationRight_00079.png - S181 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0x96,0xB7,0x40,0x40}, -1},	/* AnimationRight_00080.png - S182 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0xAE,0xB8,0x40,0x40}, -1},	/* AnimationRight_00081.png - S183 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0xC6,0xB9,0x40,0x40}, -1},	/* AnimationRight_00082.png - S184 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0xDE,0xBA,0x40,0x40}, -1},	/* AnimationRight_00083.png - S185 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0D,0xF6,0xBB,0x40,0x40}, -1},	/* AnimationRight_00084.png - S186 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0E,0x0E,0xBC,0x40,0x40}, -1},	/* AnimationRight_00085.png - S187 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0E,0x26,0xBD,0x40,0x40}, -1},	/* AnimationRight_00086.png - S188 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0E,0x3E,0xBE,0x40,0x40}, -1},	/* AnimationRight_00087.png - S189 */
	{{0xA0,0x00,0x00,0x00,0x3B,0x71,0x30,0x0E,0x56,0xBF,0x40,0x40}, -1},	/* AnimationRight_00088.png - S190 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0x6E,0xC0,0x40,0x40}, -1},	/* chesu-16-1-00.png - S191 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0x77,0x03,0x40,0x40}, -1},	/* chesu-16-1-01.png - S192 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0x7F,0xBD,0x40,0x40}, -1},	/* chesu-16-1-02.png - S193 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0x88,0xD2,0x40,0x40}, -1},	/* chesu-16-1-03.png - S194 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0x92,0x34,0x40,0x40}, -1},	/* chesu-16-1-04.png - S195 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0x9B,0xD8,0x40,0x40}, -1},	/* chesu-16-1-05.png - S196 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xA5,0xB7,0x40,0x40}, -1},	/* chesu-16-1-06.png - S197 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xAF,0xBE,0x40,0x40}, -1},	/* chesu-16-1-07.png - S198 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xB9,0xEC,0x40,0x40}, -1},	/* chesu-16-1-08.png - S199 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xC4,0x1C,0x40,0x40}, -1},	/* chesu-16-2-07.png - S200 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xCD,0x53,0x40,0x40}, -1},	/* chesu-16-2-08.png - S201 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xD6,0x90,0x40,0x40}, -1},	/* chesu-16-2-09.png - S202 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xDF,0xEB,0x40,0x40}, -1},	/* chesu-16-2-10.png - S203 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xE9,0x72,0x40,0x40}, -1},	/* chesu-16-2-11.png - S204 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xF3,0x26,0x40,0x40}, -1},	/* chesu-16-2-12.png - S205 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0E,0xFD,0x15,0x40,0x40}, -1},	/* chesu-16-2-13.png - S206 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0F,0x07,0x3F,0x40,0x40}, -1},	/* chesu-16-2-14.png - S207 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0F,0x11,0xB4,0x40,0x40}, -1},	/* chesu-16-2-15.png - S208 */
	{{0xA0,0x00,0x00,0x00,0x50,0x63,0x30,0x0F,0x1C,0x93,0x40,0x40}, -1},	/* chesu-16-2-16.png - S209 */
	{{0xA0,0x00,0x00,0x00,0x47,0x71,0x30,0x0F,0x27,0xC8,0x40,0x40}, -1},	/* daxiaoji-01.png - S210 */
	{{0xA0,0x00,0x00,0x00,0x47,0x71,0x30,0x0F,0x29,0xA4,0x40,0x40}, -1},	/* daxiaoji-02.png - S211 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x8F,0x2B,0x59,0x40,0x40}, -1},	/* GEAR_D.png - S212 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x2B,0xF5,0x40,0x40}, -1},	/* GEAR_H.png - S213 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x30,0x8F,0x2C,0x35,0x40,0x40}, -1},	/* GEAR_L.png - S214 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x8F,0x2C,0x5A,0x40,0x40}, -1},	/* GEAR_M.png - S215 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x8F,0x2D,0x93,0x40,0x40}, -1},	/* GEAR_N.png - S216 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x20,0x8F,0x2E,0xA4,0x40,0x40}, -1},	/* GEAR_R.png - S217 */
	{{0xA0,0x00,0x00,0x00,0x51,0x52,0x00,0x0F,0x2F,0x7D,0x40,0x40}, -1},	/* heiqu.png - S218 */
	{{0xA0,0x00,0x00,0x00,0x41,0x71,0x00,0x0F,0x2F,0xA8,0x40,0x40}, -1},	/* heisequyu.png - S219 */
	{{0xA0,0x00,0x00,0x00,0x03,0x56,0x00,0x8F,0x2F,0xAD,0x40,0x40}, -1},	/* menu00.png - S220 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x8F,0x30,0xA0,0x40,0x40}, -1},	/* menu01.png - S221 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x8F,0x31,0xB7,0x40,0x40}, -1},	/* menu02.png - S222 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x8F,0x32,0xC8,0x40,0x40}, -1},	/* menu03.png - S223 */
	{{0xA0,0x00,0x00,0x00,0x02,0x51,0x10,0x8F,0x33,0x71,0x40,0x40}, -1},	/* menu04.png - S224 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x34,0x13,0x40,0x40}, -1},	/* NB_16.8_00.png - S225 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x30,0x8F,0x34,0x75,0x40,0x40}, -1},	/* NB_16.8_01.png - S226 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x34,0xA3,0x40,0x40}, -1},	/* NB_16.8_02.png - S227 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x35,0x06,0x40,0x40}, -1},	/* NB_16.8_03.png - S228 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x35,0x69,0x40,0x40}, -1},	/* NB_16.8_04.png - S229 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x35,0xC1,0x40,0x40}, -1},	/* NB_16.8_05.png - S230 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x36,0x1E,0x40,0x40}, -1},	/* NB_16.8_06.png - S231 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x36,0x8D,0x40,0x40}, -1},	/* NB_16.8_07.png - S232 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x36,0xC9,0x40,0x40}, -1},	/* NB_16.8_08.png - S233 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x20,0x8F,0x37,0x3D,0x40,0x40}, -1},	/* NB_16.8_09.png - S234 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x37,0xAD,0x40,0x40}, -1},	/* NB_16_00.png - S235 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x37,0xD7,0x40,0x40}, -1},	/* NB_16_01.png - S236 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x37,0xE9,0x40,0x40}, -1},	/* NB_16_02.png - S237 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0x0E,0x40,0x40}, -1},	/* NB_16_03.png - S238 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0x39,0x40,0x40}, -1},	/* NB_16_04.png - S239 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0x52,0x40,0x40}, -1},	/* NB_16_05.png - S240 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0x79,0x40,0x40}, -1},	/* NB_16_06.png - S241 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0xA9,0x40,0x40}, -1},	/* NB_16_07.png - S242 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0xC4,0x40,0x40}, -1},	/* NB_16_08.png - S243 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x38,0xF4,0x40,0x40}, -1},	/* NB_16_09.png - S244 */
	{{0xA0,0x00,0x00,0x00,0x01,0x40,0x00,0x8F,0x39,0x24,0x40,0x40}, -1},	/* NB_16_dian.png - S245 */
	{{0xA0,0x00,0x00,0x00,0x01,0x40,0x10,0x8F,0x39,0x2C,0x40,0x40}, -1},	/* NB_16_maohao.png - S246 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x39,0x37,0x40,0x40}, -1},	/* NB_17_00.png - S247 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x8F,0x39,0x74,0x40,0x40}, -1},	/* NB_17_01.png - S248 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x39,0x8C,0x40,0x40}, -1},	/* NB_17_02.png - S249 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x39,0xC1,0x40,0x40}, -1},	/* NB_17_03.png - S250 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3A,0x01,0x40,0x40}, -1},	/* NB_17_04.png - S251 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3A,0x26,0x40,0x40}, -1},	/* NB_17_05.png - S252 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3A,0x5C,0x40,0x40}, -1},	/* NB_17_06.png - S253 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x8F,0x3A,0xA2,0x40,0x40}, -1},	/* NB_17_07.png - S254 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3A,0xC4,0x40,0x40}, -1},	/* NB_17_08.png - S255 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3B,0x0D,0x40,0x40}, -1},	/* NB_17_09.png - S256 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x8F,0x3B,0x52,0x40,0x40}, -1},	/* NB_17_point.png - S257 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3B,0x62,0x40,0x40}, -1},	/* NB_22_00.png - S258 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3B,0x82,0x40,0x40}, -1},	/* NB_22_01.png - S259 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3B,0x93,0x40,0x40}, -1},	/* NB_22_02.png - S260 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3B,0xB2,0x40,0x40}, -1},	/* NB_22_03.png - S261 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3B,0xD4,0x40,0x40}, -1},	/* NB_22_04.png - S262 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3B,0xED,0x40,0x40}, -1},	/* NB_22_05.png - S263 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0x0D,0x40,0x40}, -1},	/* NB_22_06.png - S264 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0x31,0x40,0x40}, -1},	/* NB_22_07.png - S265 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0x49,0x40,0x40}, -1},	/* NB_22_08.png - S266 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0x6D,0x40,0x40}, -1},	/* NB_22_09.png - S267 */
	{{0xA0,0x00,0x00,0x00,0x02,0x40,0x00,0x8F,0x3C,0x91,0x40,0x40}, -1},	/* NB_22_dian.png - S268 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0x9D,0x40,0x40}, -1},	/* NB_22_henggang.png - S269 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0xA9,0x40,0x40}, -1},	/* NB_22_red_00.png - S270 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0xD0,0x40,0x40}, -1},	/* NB_22_red_01.png - S271 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3C,0xE4,0x40,0x40}, -1},	/* NB_22_red_02.png - S272 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3D,0x0A,0x40,0x40}, -1},	/* NB_22_red_03.png - S273 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3D,0x34,0x40,0x40}, -1},	/* NB_22_red_04.png - S274 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x10,0x8F,0x3D,0x51,0x40,0x40}, -1},	/* NB_22_red_05.png - S275 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3D,0x77,0x40,0x40}, -1},	/* NB_22_red_06.png - S276 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3D,0xA4,0x40,0x40}, -1},	/* NB_22_red_07.png - S277 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3D,0xC0,0x40,0x40}, -1},	/* NB_22_red_08.png - S278 */
	{{0xA0,0x00,0x00,0x00,0x02,0x41,0x00,0x8F,0x3D,0xED,0x40,0x40}, -1},	/* NB_22_red_09.png - S279 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3E,0x19,0x40,0x40}, -1},	/* NB_23_00.png - S280 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x00,0x8F,0x3E,0x5B,0x40,0x40}, -1},	/* NB_23_01.png - S281 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3E,0x6E,0x40,0x40}, -1},	/* NB_23_02.png - S282 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3E,0xA8,0x40,0x40}, -1},	/* NB_23_03.png - S283 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3E,0xED,0x40,0x40}, -1},	/* NB_23_04.png - S284 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3F,0x12,0x40,0x40}, -1},	/* NB_23_05.png - S285 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3F,0x4B,0x40,0x40}, -1},	/* NB_23_06.png - S286 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3F,0x97,0x40,0x40}, -1},	/* NB_23_07.png - S287 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x3F,0xC0,0x40,0x40}, -1},	/* NB_23_08.png - S288 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x10,0x8F,0x40,0x0A,0x40,0x40}, -1},	/* NB_23_09.png - S289 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x8F,0x40,0x57,0x40,0x40}, -1},	/* NB_23_black_00.png - S290 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x8F,0x40,0xCA,0x40,0x40}, -1},	/* NB_23_black_01.png - S291 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x8F,0x41,0x18,0x40,0x40}, -1},	/* NB_23_black_02.png - S292 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x8F,0x41,0x77,0x40,0x40}, -1},	/* NB_23_black_03.png - S293 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x8F,0x41,0xE4,0x40,0x40}, -1},	/* NB_23_black_04.png - S294 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x8F,0x42,0x38,0x40,0x40}, -1},	/* NB_23_black_05.png - S295 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x8F,0x42,0x9D,0x40,0x40}, -1},	/* NB_23_black_06.png - S296 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x8F,0x43,0x18,0x40,0x40}, -1},	/* NB_23_black_07.png - S297 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x20,0x8F,0x43,0x69,0x40,0x40}, -1},	/* NB_23_black_08.png - S298 */
	{{0xA0,0x00,0x00,0x00,0x03,0x42,0x30,0x8F,0x43,0xDB,0x40,0x40}, -1},	/* NB_23_black_09.png - S299 */
	{{0xA0,0x00,0x00,0x00,0x02,0x40,0x00,0x8F,0x44,0x53,0x40,0x40}, -1},	/* NB_23_maohao.png - S300 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x44,0x6F,0x40,0x40}, -1},	/* NB_32.5_00.png - S301 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x30,0x8F,0x45,0x60,0x40,0x40}, -1},	/* NB_32.5_01.png - S302 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x45,0xE4,0x40,0x40}, -1},	/* NB_32.5_02.png - S303 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x46,0xB2,0x40,0x40}, -1},	/* NB_32.5_03.png - S304 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x47,0xA1,0x40,0x40}, -1},	/* NB_32.5_04.png - S305 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x48,0x5D,0x40,0x40}, -1},	/* NB_32.5_05.png - S306 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x49,0x32,0x40,0x40}, -1},	/* NB_32.5_06.png - S307 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x4A,0x26,0x40,0x40}, -1},	/* NB_32.5_07.png - S308 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x4A,0xCA,0x40,0x40}, -1},	/* NB_32.5_08.png - S309 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x20,0x8F,0x4B,0xCA,0x40,0x40}, -1},	/* NB_32.5_09.png - S310 */
	{{0xA0,0x00,0x00,0x00,0x01,0x41,0x20,0x8F,0x4C,0xCD,0x40,0x40}, -1},	/* NB_32.5_dian.png - S311 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x4C,0xE2,0x40,0x40}, -1},	/* NB_55_00.png - S312 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x4E,0xAF,0x40,0x40}, -1},	/* NB_55_01.png - S313 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x4F,0x9B,0x40,0x40}, -1},	/* NB_55_02.png - S314 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x51,0x2D,0x40,0x40}, -1},	/* NB_55_03.png - S315 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x52,0xFA,0x40,0x40}, -1},	/* NB_55_04.png - S316 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x54,0x6D,0x40,0x40}, -1},	/* NB_55_05.png - S317 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x55,0xFB,0x40,0x40}, -1},	/* NB_55_06.png - S318 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x30,0x8F,0x57,0xF4,0x40,0x40}, -1},	/* NB_55_07.png - S319 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x59,0x2B,0x40,0x40}, -1},	/* NB_55_08.png - S320 */
	{{0xA0,0x00,0x00,0x00,0x08,0x46,0x20,0x8F,0x5B,0x36,0x40,0x40}, -1},	/* NB_55_09.png - S321 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x30,0x8F,0x5D,0x36,0x40,0x40}, -1},	/* qiya1.png - S322 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x30,0x8F,0x5E,0x99,0x40,0x40}, -1},	/* qiya2.png - S323 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x8F,0x60,0x0C,0x40,0x40}, -1},	/* set_1_01.png - S324 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x8F,0x60,0xB3,0x40,0x40}, -1},	/* set_1_02.png - S325 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x8F,0x61,0xC7,0x40,0x40}, -1},	/* set_1_03.png - S326 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x8F,0x62,0x6E,0x40,0x40}, -1},	/* set_1_04.png - S327 */
	{{0xA0,0x00,0x00,0x00,0x02,0x50,0x10,0x8F,0x63,0x8F,0x40,0x40}, -1},	/* set_1_05.png - S328 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x8F,0x63,0xED,0x40,0x40}, -1},	/* Set_2_01.png - S329 */
	{{0xA0,0x00,0x00,0x00,0x03,0x51,0x10,0x8F,0x64,0x9F,0x40,0x40}, -1},	/* Set_2_02.png - S330 */
	{{0xA0,0x00,0x00,0x00,0x02,0x50,0x10,0x8F,0x65,0xB5,0x40,0x40}, -1},	/* Set_2_03.png - S331 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x8F,0x66,0x16,0x40,0x40}, -1},	/* Set_3_01.png - S332 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x8F,0x66,0xDD,0x40,0x40}, -1},	/* Set_3_02.png - S333 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x8F,0x67,0x50,0x40,0x40}, -1},	/* Set_3_03.png - S334 */
	{{0xA0,0x00,0x00,0x00,0x02,0x4B,0x10,0x8F,0x67,0xAD,0x40,0x40}, -1},	/* Set_3_04.png - S335 */
	{{0xA0,0x00,0x00,0x00,0x05,0x43,0x00,0x8F,0x68,0x4B,0x40,0x40}, -1},	/* Set_3_05.png - S336 */
	{{0xA0,0x00,0x00,0x00,0x02,0x44,0x10,0x8F,0x68,0x5F,0x40,0x40}, -1},	/* Tire_Pressure_BAR.png - S337 */
	{{0xA0,0x00,0x00,0x00,0x02,0x44,0x00,0x8F,0x68,0x9E,0x40,0x40}, -1},	/* Tire_Pressure_BARhong.png - S338 */
	{{0xA0,0x00,0x00,0x00,0x02,0x42,0x10,0x8F,0x68,0xD6,0x40,0x40}, -1},	/* Tire_Pressure_℃.png - S339 */
	{{0xA0,0x00,0x00,0x00,0x0C,0x5D,0x10,0x8F,0x69,0x09,0x40,0x40}, -1},	/* Tire_Pressure_cheti.png - S340 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x10,0x8F,0x6B,0x47,0x40,0x40}, -1},	/* Vehicle_Information_Display_uint.png - S341 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x20,0x8F,0x6B,0xA4,0x40,0x40}, -1},	/* Vehicle_Information_Display1.png - S342 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x20,0x8F,0x6C,0x5B,0x40,0x40}, -1},	/* Vehicle_Information_Display2.png - S343 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x20,0x8F,0x6D,0x19,0x40,0x40}, -1},	/* Vehicle_Information_Display3.png - S344 */
	{{0xA0,0x00,0x00,0x00,0x01,0x47,0x10,0x8F,0x6D,0xB7,0x40,0x40}, -1},	/* Vehicle_Information_Display3_uint.png - S345 */
	{{0xA0,0x00,0x00,0x00,0x45,0x44,0x00,0x0F,0x6D,0xE1,0x40,0x40}, -1},	/* w40y45.png - S346 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0x6D,0xF0,0x40,0x40}, -1},	/* w45y45.png - S347 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x6E,0x00,0x40,0x40}, -1},	/* youqiya-00.png - S348 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x72,0x87,0x40,0x40}, -1},	/* youqiya-01.png - S349 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x77,0x6A,0x40,0x40}, -1},	/* youqiya-02.png - S350 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x7C,0x8F,0x40,0x40}, -1},	/* youqiya-03.png - S351 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x81,0xF6,0x40,0x40}, -1},	/* youqiya-04.png - S352 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x87,0x90,0x40,0x40}, -1},	/* youqiya-05.png - S353 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x8D,0x41,0x40,0x40}, -1},	/* youqiya-06.png - S354 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x93,0x04,0x40,0x40}, -1},	/* youqiya-07.png - S355 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x98,0xD6,0x40,0x40}, -1},	/* youqiya-08.png - S356 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0x9E,0xD8,0x40,0x40}, -1},	/* youqiya-09.png - S357 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0xA5,0x16,0x40,0x40}, -1},	/* youqiya-10.png - S358 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0xAB,0x8F,0x40,0x40}, -1},	/* youqiya-11.png - S359 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0xB2,0x4C,0x40,0x40}, -1},	/* youqiya-12.png - S360 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0xB9,0x5A,0x40,0x40}, -1},	/* youqiya-13.png - S361 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0xC0,0xDC,0x40,0x40}, -1},	/* youqiya-14.png - S362 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x0F,0xC8,0xD2,0x40,0x40}, -1},	/* youqiya-15.png - S363 */
	{{0xA0,0x00,0x00,0x00,0x24,0x46,0x30,0x8F,0xD1,0x27,0x40,0x40}, -1},	/* youqiyashuzi.png - S364 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x20,0x0F,0xD3,0x76,0x40,0x40}, -1},	/* zhishideng-01.png - S365 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD4,0x40,0x40,0x40}, -1},	/* zhishideng-01-1.png - S366 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD5,0x05,0x40,0x40}, -1},	/* zhishideng-02.png - S367 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD6,0x0F,0x40,0x40}, -1},	/* zhishideng-03.png - S368 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD6,0xBD,0x40,0x40}, -1},	/* zhishideng-04.png - S369 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD8,0x0E,0x40,0x40}, -1},	/* zhishideng-05.png - S370 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD8,0xF8,0x40,0x40}, -1},	/* zhishideng-06.png - S371 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD9,0x54,0x40,0x40}, -1},	/* zhishideng-07.png - S372 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xD9,0xF3,0x40,0x40}, -1},	/* zhishideng-08.png - S373 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDA,0xDB,0x40,0x40}, -1},	/* zhishideng-09.png - S374 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDB,0xB0,0x40,0x40}, -1},	/* zhishideng-10.png - S375 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDC,0x6A,0x40,0x40}, -1},	/* zhishideng-11.png - S376 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDC,0xFA,0x40,0x40}, -1},	/* zhishideng-12.png - S377 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDD,0xDB,0x40,0x40}, -1},	/* zhishideng-13.png - S378 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDE,0x49,0x40,0x40}, -1},	/* zhishideng-14.png - S379 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x30,0x0F,0xDE,0xF5,0x40,0x40}, -1},	/* zhishideng-15.png - S380 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xDF,0xB4,0x40,0x40}, -1},	/* zhishideng-16.png - S381 */
	{{0xA0,0x00,0x00,0x00,0x45,0x45,0x00,0x0F,0xE0,0xD0,0x40,0x40}, -1},	/* zhishideng-17.png - S382 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE1,0xBA,0x40,0x40}, -1},	/* zhishideng-18.png - S383 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE2,0x0F,0x40,0x40}, -1},	/* zhishideng-19.png - S384 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x30,0x8F,0xE3,0xC7,0x40,0x40}, -1},	/* zhishideng-20.png - S385 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE4,0x65,0x40,0x40}, -1},	/* zhishideng-21.png - S386 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE5,0x6C,0x40,0x40}, -1},	/* zhishideng-22.png - S387 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE5,0xB8,0x40,0x40}, -1},	/* zhishideng-23.png - S388 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE6,0x64,0x40,0x40}, -1},	/* zhishideng-23-1.png - S389 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE7,0x2A,0x40,0x40}, -1},	/* zhishideng-24.png - S390 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE7,0xB7,0x40,0x40}, -1},	/* zhishideng-25.png - S391 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE8,0x40,0x40,0x40}, -1},	/* zhishideng-26.png - S392 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE8,0xE2,0x40,0x40}, -1},	/* zhishideng-27.png - S393 */
	{{0xA0,0x00,0x00,0x00,0x05,0x45,0x00,0x8F,0xE9,0x55,0x40,0x40}, -1},	/* zhishideng-28.png - S394 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x0F,0xE9,0xB7,0x40,0x40}, -1},	/* zhuansu-1-00.png - S395 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x0F,0xEF,0xBB,0x40,0x40}, -1},	/* zhuansu-1-01.png - S396 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x0F,0xF6,0x5D,0x40,0x40}, -1},	/* zhuansu-1-02.png - S397 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x0F,0xFD,0x87,0x40,0x40}, -1},	/* zhuansu-1-03.png - S398 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x05,0x0D,0x40,0x40}, -1},	/* zhuansu-1-04.png - S399 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x0C,0xDF,0x40,0x40}, -1},	/* zhuansu-1-05.png - S400 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x14,0xEE,0x40,0x40}, -1},	/* zhuansu-1-06.png - S401 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x1C,0xF0,0x40,0x40}, -1},	/* zhuansu-2-05.png - S402 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x22,0x3C,0x40,0x40}, -1},	/* zhuansu-2-06.png - S403 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x27,0xB8,0x40,0x40}, -1},	/* zhuansu-2-07.png - S404 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x2D,0x84,0x40,0x40}, -1},	/* zhuansu-2-08.png - S405 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x33,0xAC,0x40,0x40}, -1},	/* zhuansu-2-09.png - S406 */
	{{0xA0,0x00,0x00,0x00,0x4A,0x63,0x30,0x10,0x3A,0x2F,0x40,0x40}, -1},	/* zhuansu-2-10.png - S407 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x41,0x0D,0x40,0x40}, -1},	/* zuoqiya-00.png - S408 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x45,0xB8,0x40,0x40}, -1},	/* zuoqiya-01.png - S409 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x4A,0xD1,0x40,0x40}, -1},	/* zuoqiya-02.png - S410 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x50,0x47,0x40,0x40}, -1},	/* zuoqiya-03.png - S411 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x56,0x1A,0x40,0x40}, -1},	/* zuoqiya-04.png - S412 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x5C,0x2E,0x40,0x40}, -1},	/* zuoqiya-05.png - S413 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x62,0x5D,0x40,0x40}, -1},	/* zuoqiya-06.png - S414 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x68,0xA0,0x40,0x40}, -1},	/* zuoqiya-07.png - S415 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x6E,0xEE,0x40,0x40}, -1},	/* zuoqiya-08.png - S416 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x75,0x4B,0x40,0x40}, -1},	/* zuoqiya-09.png - S417 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x7B,0xDF,0x40,0x40}, -1},	/* zuoqiya-10.png - S418 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x82,0xB0,0x40,0x40}, -1},	/* zuoqiya-11.png - S419 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x89,0xC4,0x40,0x40}, -1},	/* zuoqiya-12.png - S420 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x91,0x1F,0x40,0x40}, -1},	/* zuoqiya-13.png - S421 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0x98,0xD2,0x40,0x40}, -1},	/* zuoqiya-14.png - S422 */
	{{0xA0,0x00,0x00,0x00,0x6D,0x4E,0x30,0x10,0xA0,0xCA,0x40,0x40}, -1},	/* zuoqiya-15.png - S423 */
	{{0xA0,0x00,0x00,0x00,0x24,0x46,0x30,0x90,0xA9,0x13,0x40,0x40}, -1}	/* zuoqiyashuzi.png - S424 */
};

#pragma CONST_SEG DEFAULT 

#define PALETTE_DATA_NUMBER	(0)

#define FONTTYPE_DATA_NUMBER	(0)

#define FONT_DATA_NUMBER	(0)

#endif